/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElement;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElements;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.XMLSchemaFileInfo;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl.WSDLExtensibilityElementImpl;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl.XMLSchemaFileInfoImpl;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WSDLExtensibilityElementsImpl
implements WSDLExtensibilityElements {
    private static final Logger mLogger = Logger.getLogger(WSDLExtensibilityElementsImpl.class.getName());
    private DataFolder mRootFolder = null;
    private String rootFolderNamePrefix;
    private Map<String, WSDLExtensibilityElement> elementsMap = new HashMap<String, WSDLExtensibilityElement>();
    private Map<String, XMLSchemaFileInfo> schemasMap = new HashMap<String, XMLSchemaFileInfo>();

    public WSDLExtensibilityElementsImpl(DataFolder dataFolder) {
        this.mRootFolder = dataFolder;
        this.rootFolderNamePrefix = this.mRootFolder.getName() + "/";
        this.readAllSchemas();
        this.mRootFolder.getPrimaryFile().addFileChangeListener((FileChangeListener)new WSDLEditorFolderChangeListener());
    }

    public WSDLExtensibilityElement getWSDLExtensibilityElement(String string) {
        DataFolder dataFolder;
        WSDLExtensibilityElement wSDLExtensibilityElement = this.elementsMap.get(string);
        if (wSDLExtensibilityElement != null) {
            return wSDLExtensibilityElement;
        }
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(this.rootFolderNamePrefix + string);
        if (fileObject != null && (dataFolder = DataFolder.findFolder((FileObject)fileObject)) != null && dataFolder.getName().equals(string)) {
            wSDLExtensibilityElement = new WSDLExtensibilityElementImpl(dataFolder, this);
            this.elementsMap.put(string, wSDLExtensibilityElement);
        }
        return wSDLExtensibilityElement;
    }

    public InputStream[] getAllExtensionSchemas() {
        DataObject[] dataObjectArray;
        ArrayList<InputStream> arrayList = new ArrayList<InputStream>();
        for (DataObject dataObject : dataObjectArray = this.mRootFolder.getChildren()) {
            if (dataObject instanceof DataFolder || !dataObject.getPrimaryFile().hasExt("xsd")) continue;
            InputStream inputStream = null;
            try {
                inputStream = dataObject.getPrimaryFile().getInputStream();
            }
            catch (Throwable throwable) {
                mLogger.log(Level.SEVERE, NbBundle.getMessage(WSDLExtensibilityElementsImpl.class, (String)"ERR_MSG_FAILED_TO_GET_SCHEMA", (Object)dataObject.getPrimaryFile().getPath()));
            }
            if (inputStream == null) continue;
            arrayList.add(inputStream);
        }
        return arrayList.toArray(new InputStream[arrayList.size()]);
    }

    public XMLSchemaFileInfo getXMLSchemaFileInfoMatchingFileName(String string) {
        XMLSchemaFileInfo xMLSchemaFileInfo = this.schemasMap.get(string);
        return xMLSchemaFileInfo;
    }

    public XMLSchemaFileInfo getXMLSchemaFileInfo(String string) {
        XMLSchemaFileInfo xMLSchemaFileInfo = null;
        for (XMLSchemaFileInfo xMLSchemaFileInfo2 : this.schemasMap.values()) {
            String string2 = xMLSchemaFileInfo2.getSchema().getTargetNamespace();
            if (string2 == null || !string2.equals(string)) continue;
            xMLSchemaFileInfo = xMLSchemaFileInfo2;
            break;
        }
        return xMLSchemaFileInfo;
    }

    private void addToSchemaMap(DataObject dataObject) {
        XMLSchemaFileInfoImpl xMLSchemaFileInfoImpl = new XMLSchemaFileInfoImpl(dataObject);
        this.schemasMap.put(dataObject.getName(), xMLSchemaFileInfoImpl);
    }

    private void readAllSchemas() {
        DataObject[] dataObjectArray;
        for (DataObject dataObject : dataObjectArray = this.mRootFolder.getChildren()) {
            if (dataObject instanceof DataFolder || !dataObject.getPrimaryFile().hasExt("xsd")) continue;
            this.addToSchemaMap(dataObject);
        }
    }

    public XMLSchemaFileInfo[] getAllXMLSchemaFileInfos() {
        Collection<XMLSchemaFileInfo> collection = this.schemasMap.values();
        return collection.toArray(new XMLSchemaFileInfo[collection.size()]);
    }

    class WSDLEditorFolderChangeListener
    extends FileChangeAdapter {
        WSDLEditorFolderChangeListener() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (fileObject != null && fileObject.isData() && fileObject.hasExt("xsd")) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (dataObject != null) {
                        WSDLExtensibilityElementsImpl.this.addToSchemaMap(dataObject);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
        }
    }
}

