/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl;

import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElementInfo;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.XMLSchemaFileInfo;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl.ExtensibilityUtils;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class WSDLExtensibilityElementInfoImpl
implements WSDLExtensibilityElementInfo {
    private static final Logger mLogger = Logger.getLogger(WSDLExtensibilityElementInfoImpl.class.getName());
    private DataObject mDataObject;
    private Schema mSchema;
    private XMLSchemaFileInfo mSchemaFileInfo = null;

    public WSDLExtensibilityElementInfoImpl(DataObject dataObject, XMLSchemaFileInfo xMLSchemaFileInfo) {
        this.mDataObject = dataObject;
        if (dataObject instanceof DataFolder && dataObject.getPrimaryFile().hasExt("xsd")) {
            this.mSchema = ExtensibilityUtils.readSchema(dataObject);
        }
        this.mSchemaFileInfo = xMLSchemaFileInfo;
    }

    public String getElementName() {
        Object object = this.mDataObject.getPrimaryFile().getAttribute("element");
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public GlobalElement getElement() {
        String string = this.getElementName();
        if (string != null && this.getSchema() != null) {
            Collection collection = this.getSchema().getElements();
            for (GlobalElement globalElement : collection) {
                if (!globalElement.getName().equals(string)) continue;
                return globalElement;
            }
        }
        return null;
    }

    public DataObject getDataObject() {
        return this.mDataObject;
    }

    public Schema getSchema() {
        if (this.mSchema != null) {
            return this.mSchema;
        }
        if (this.mSchemaFileInfo != null) {
            return this.mSchemaFileInfo.getSchema();
        }
        return null;
    }

    public String getPrefix() {
        Object object = this.mDataObject.getPrimaryFile().getAttribute("prefix");
        if (object instanceof String) {
            return (String)object;
        }
        if (this.mSchemaFileInfo != null) {
            return this.mSchemaFileInfo.getPrefix();
        }
        return null;
    }

    public ResourceBundle getBundle() {
        String string = (String)this.mDataObject.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle");
        if (string != null) {
            return NbBundle.getBundle((String)string);
        }
        return null;
    }
}

