/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.api.property;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.xml.xam.Component;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChooserHelper<T extends Component> {
    public abstract void populateNodes(Node var1);

    public abstract Node selectNode(T var1);

    protected File[] recursiveListFiles(File file, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file != null && file.isDirectory()) {
            File[] fileArray;
            File[] fileArray2 = file.listFiles(fileFilter);
            if (fileArray2 != null) {
                arrayList.addAll(Arrays.asList(fileArray2));
            }
            if ((fileArray = file.listFiles(new DirFileFilter())) != null) {
                for (File file2 : fileArray) {
                    File[] fileArray3 = this.recursiveListFiles(file2, fileFilter);
                    if (fileArray3 == null || fileArray3.length <= 0) continue;
                    arrayList.addAll(Arrays.asList(fileArray3));
                }
            }
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    static class ChildLessNode
    extends FilterNode {
        public ChildLessNode(Node node) {
            super(node, FilterNode.Children.LEAF);
        }
    }

    static class CategoryFilterChildren
    extends FilterNode.Children {
        private final int level;

        public CategoryFilterChildren(Node node, int n) {
            super(node);
            this.level = n;
        }

        protected Node copyNode(Node node) {
            if (this.level <= 0) {
                return new ChildLessNode(node);
            }
            return new CategoryFilterNode(node, this.level - 1);
        }
    }

    static class CategoryFilterNode
    extends FilterNode {
        public CategoryFilterNode(Node node, int n) {
            super(node, (Children)new CategoryFilterChildren(node, n));
        }
    }

    static class FileNodeChildren
    extends FilterNode.Children {
        int level = 1;

        public FileNodeChildren(Node node) {
            super(node);
        }

        public FileNodeChildren(Node node, int n) {
            super(node);
            this.level = n;
        }

        protected Node copyNode(Node node) {
            return new CategoryFilterNode(node, this.level - 1);
        }
    }

    class FileNode
    extends FilterNode {
        String displayName;

        public FileNode(Node node, String string, int n) {
            super(node, (Children)new FileNodeChildren(node, n));
            this.displayName = string;
        }

        public FileNode(Node node, String string) {
            this(node, string, 1);
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    static class DirFileFilter
    implements FileFilter {
        DirFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private static class EnabledChildren
    extends FilterNode.Children {
        public EnabledChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            return new EnabledNode(node);
        }
    }

    public static class EnabledNode
    extends FilterNode {
        private static Pattern pattern = Pattern.compile("(^<font.*>)(.*)(<.*>$)");

        public EnabledNode(Node node) {
            super(node, (Children)new EnabledChildren(node));
        }

        public String getHtmlDisplayName() {
            Matcher matcher;
            String string = super.getHtmlDisplayName();
            if (string == null) {
                string = this.getDisplayName();
            }
            if (string != null && (matcher = pattern.matcher(string)).find()) {
                return matcher.group(2);
            }
            return string;
        }
    }
}

