/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLDataObject;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameGenerator {
    private static NameGenerator mInstance;
    private static final String MESSAGE_NAME_PREFIX;
    private static final String MESSAGE_PART_NAME_PREFIX;
    private static final String PORTTYPE_NAME_PREFIX;
    private static final String OPERATION_NAME_PREFIX;
    private static final String OPERATION_INPUT_NAME_PREFIX;
    private static final String OPERATION_OUTPUT_NAME_PREFIX;
    private static final String OPERATION_FAULT_NAME_PREFIX;
    private static final String BINDING_NAME_PREFIX;
    private static final String BINDING_OPERATION_FAULT_NAME_PREFIX;
    private static final String SERVICE_NAME_PREFIX;
    private static final String PORT_NAME_PREFIX;
    private static int counterStart;

    private NameGenerator() {
    }

    public static NameGenerator getInstance() {
        if (mInstance == null) {
            mInstance = new NameGenerator();
        }
        return mInstance;
    }

    public String generateUniqueMessageName(WSDLModel wSDLModel) {
        int n = counterStart;
        String string = MESSAGE_NAME_PREFIX + n;
        while (this.isMessageExists(string, wSDLModel)) {
            string = MESSAGE_NAME_PREFIX + ++n;
        }
        return string;
    }

    public String generateUniqueInputMessageName(String string, WSDLModel wSDLModel) {
        String string2;
        int n = counterStart;
        String string3 = string2 = string + "Request";
        while (this.isMessageExists(string3, wSDLModel)) {
            string3 = string2 + n;
            ++n;
        }
        return string3;
    }

    public String generateUniqueOutputMessageName(String string, WSDLModel wSDLModel) {
        String string2;
        int n = counterStart;
        String string3 = string2 = string + "Response";
        while (this.isMessageExists(string3, wSDLModel)) {
            string3 = string2 + n;
            ++n;
        }
        return string3;
    }

    public String generateUniqueFaultMessageName(String string, WSDLModel wSDLModel) {
        String string2;
        int n = counterStart;
        String string3 = string2 = string + "Fault";
        while (this.isMessageExists(string3, wSDLModel)) {
            string3 = string2 + n;
            ++n;
        }
        return string3;
    }

    public boolean isMessageExists(String string, WSDLModel wSDLModel) {
        boolean bl = false;
        Collection collection = wSDLModel.getDefinitions().getMessages();
        for (Message message : collection) {
            if (!string.equals(message.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String generateUniqueMessagePartName(Message message) {
        int n = counterStart;
        String string = MESSAGE_PART_NAME_PREFIX + n;
        while (this.isMessagePartExists(string, message)) {
            string = MESSAGE_PART_NAME_PREFIX + ++n;
        }
        return string;
    }

    public boolean isMessagePartExists(String string, Message message) {
        boolean bl = false;
        Collection collection = message.getParts();
        for (Part part : collection) {
            if (!string.equals(part.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String generateUniquePortTypeName(WSDLModel wSDLModel) {
        int n = counterStart;
        String string = PORTTYPE_NAME_PREFIX + n;
        while (this.isPortTypeExists(string, wSDLModel)) {
            string = PORTTYPE_NAME_PREFIX + ++n;
        }
        return string;
    }

    public String generateUniquePortTypeName(WSDLModel wSDLModel, String string) {
        int n = counterStart;
        String string2 = string;
        while (this.isPortTypeExists(string2, wSDLModel)) {
            string2 = string + n;
            ++n;
        }
        return string2;
    }

    public boolean isPortTypeExists(String string, WSDLModel wSDLModel) {
        boolean bl = false;
        Collection collection = wSDLModel.getDefinitions().getPortTypes();
        for (PortType portType : collection) {
            if (!string.equals(portType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String generateUniqueOperationName(String string, PortType portType) {
        int n = counterStart;
        String string2 = string;
        while (this.isOperationExists(string2, portType)) {
            string2 = string + n;
            ++n;
        }
        return string2;
    }

    public String generateUniqueOperationName(PortType portType) {
        int n = counterStart;
        String string = OPERATION_NAME_PREFIX + n;
        while (this.isOperationExists(string, portType)) {
            string = OPERATION_NAME_PREFIX + ++n;
        }
        return string;
    }

    public boolean isOperationExists(String string, PortType portType) {
        boolean bl = false;
        Collection collection = portType.getOperations();
        for (Operation operation : collection) {
            if (!string.equals(operation.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String generateUniqueOperationInputName(Operation operation) {
        Set<String> set = this.getAllInputs(operation);
        int n = counterStart;
        String string = OPERATION_INPUT_NAME_PREFIX + n;
        while (set.contains(string)) {
            string = OPERATION_INPUT_NAME_PREFIX + ++n;
        }
        return string;
    }

    public Set<String> getAllInputs(Operation operation) {
        HashSet<String> hashSet = new HashSet<String>();
        PortType portType = (PortType)operation.getParent();
        Collection collection = portType.getOperations();
        if (collection != null) {
            for (Operation operation2 : collection) {
                if (operation2.getInput() == null) continue;
                hashSet.add(operation2.getInput().getName());
            }
        }
        return hashSet;
    }

    public boolean isOperationInputExists(Operation operation) {
        boolean bl = false;
        Input input = operation.getInput();
        if (input != null) {
            bl = true;
        }
        return bl;
    }

    public String generateUniqueOperationOutputName(Operation operation) {
        Set<String> set = this.getAllOutputs(operation);
        int n = counterStart;
        String string = OPERATION_OUTPUT_NAME_PREFIX + n;
        while (set.contains(string)) {
            string = OPERATION_OUTPUT_NAME_PREFIX + ++n;
        }
        return string;
    }

    public Set<String> getAllOutputs(Operation operation) {
        HashSet<String> hashSet = new HashSet<String>();
        PortType portType = (PortType)operation.getParent();
        Collection collection = portType.getOperations();
        if (collection != null) {
            for (Operation operation2 : collection) {
                if (operation2.getOutput() == null) continue;
                hashSet.add(operation2.getOutput().getName());
            }
        }
        return hashSet;
    }

    public boolean isOperationOutputExists(Operation operation) {
        boolean bl = false;
        Output output = operation.getOutput();
        if (output != null) {
            bl = true;
        }
        return bl;
    }

    public String generateUniqueOperationFaultName(Operation operation) {
        int n = counterStart;
        String string = OPERATION_FAULT_NAME_PREFIX + n;
        while (this.isOperationFaultExists(string, operation)) {
            string = OPERATION_FAULT_NAME_PREFIX + ++n;
        }
        return string;
    }

    private boolean isOperationFaultExists(String string, Operation operation) {
        boolean bl = false;
        Collection collection = operation.getFaults();
        for (Fault fault : collection) {
            if (!string.equals(fault.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String generateUniqueBindingName(WSDLModel wSDLModel) {
        int n = counterStart;
        String string = BINDING_NAME_PREFIX + n;
        while (this.isBindingExists(string, wSDLModel)) {
            string = BINDING_NAME_PREFIX + ++n;
        }
        return string;
    }

    public String generateUniqueBindingName(WSDLModel wSDLModel, String string) {
        int n = counterStart;
        String string2 = BINDING_NAME_PREFIX + "_" + string;
        String string3 = string2 + n;
        while (this.isBindingExists(string3, wSDLModel)) {
            string3 = BINDING_NAME_PREFIX + ++n;
        }
        return string3;
    }

    public String generateUniqueBindingName(String string, WSDLModel wSDLModel) {
        if (string == null) {
            return this.generateUniqueBindingName(wSDLModel);
        }
        int n = counterStart;
        String string2 = string + n;
        while (this.isBindingExists(string2, wSDLModel)) {
            string2 = string + ++n;
        }
        return string2;
    }

    public boolean isBindingExists(String string, WSDLModel wSDLModel) {
        boolean bl = false;
        Collection collection = wSDLModel.getDefinitions().getBindings();
        for (Binding binding : collection) {
            if (!string.equals(binding.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String generateUniqueBindingOperationFaultName(BindingOperation bindingOperation) {
        int n = counterStart;
        String string = BINDING_OPERATION_FAULT_NAME_PREFIX + n;
        while (this.isBindingOperationFaultExists(string, bindingOperation)) {
            string = BINDING_OPERATION_FAULT_NAME_PREFIX + ++n;
        }
        return string;
    }

    public boolean isBindingOperationFaultExists(String string, BindingOperation bindingOperation) {
        boolean bl = false;
        Collection collection = bindingOperation.getBindingFaults();
        for (BindingFault bindingFault : collection) {
            if (!string.equals(bindingFault.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String generateUniqueServiceName(WSDLModel wSDLModel) {
        int n = counterStart;
        String string = SERVICE_NAME_PREFIX + n;
        while (this.isServiceExists(string, wSDLModel)) {
            string = SERVICE_NAME_PREFIX + ++n;
        }
        return string;
    }

    public boolean isServiceExists(String string, WSDLModel wSDLModel) {
        boolean bl = false;
        Collection collection = wSDLModel.getDefinitions().getServices();
        for (Service service : collection) {
            if (!string.equals(service.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String generateUniqueServicePortName(Service service) {
        int n = counterStart;
        String string = PORT_NAME_PREFIX + n;
        while (this.isServicePortExists(string, service)) {
            string = PORT_NAME_PREFIX + ++n;
        }
        return string;
    }

    public String generateUniqueServicePortName(String string, Service service) {
        int n = counterStart;
        String string2 = string + n;
        while (this.isServicePortExists(string2, service)) {
            string2 = string + ++n;
        }
        return string2;
    }

    public boolean isServicePortExists(String string, Service service) {
        boolean bl = false;
        Collection collection = service.getPorts();
        for (Port port : collection) {
            if (!string.equals(port.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String generateNamespacePrefix(String string, WSDLComponent wSDLComponent) {
        return this.generateNamespacePrefix(string, wSDLComponent.getModel());
    }

    public String generateNamespacePrefix(String string, WSDLModel wSDLModel) {
        return this.generateNamespacePrefix(string, wSDLModel, 0);
    }

    public String generateNamespacePrefix(String string, WSDLModel wSDLModel, int n) {
        if (string == null) {
            string = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_DEFAULT_PREFIX");
        }
        String string2 = string + n;
        while (this.isPrefixExist(string2, wSDLModel)) {
            string2 = string + ++n;
        }
        return string2;
    }

    public boolean isPrefixExist(String string, WSDLModel wSDLModel) {
        return Utility.getNamespaceURI(string, wSDLModel) != null;
    }

    public boolean isAttributeExists(String string, WSDLComponent wSDLComponent) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        NamedNodeMap namedNodeMap = ((AbstractDocumentComponent)wSDLComponent).getPeer().getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!string.equals(attr.getName())) continue;
                return true;
            }
        }
        return bl;
    }

    public static String createNewTargetNamespace(WSDLModel wSDLModel, WSDLDataObject wSDLDataObject) {
        ProjectInformation projectInformation;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer("http://localhost/");
        Project project = FileOwnerQuery.getOwner((FileObject)wSDLDataObject.getPrimaryFile());
        if (project != null && (projectInformation = ProjectUtils.getInformation((Project)project)) != null) {
            stringBuffer.append(projectInformation.getDisplayName());
            stringBuffer.append("/");
        }
        stringBuffer.append(wSDLDataObject.getName());
        string = stringBuffer.toString();
        return string;
    }

    public static String generateUniqueValueForKeyAttribute(WSDLComponent wSDLComponent, String string, QName qName, String string2) {
        Object object2;
        WSDLComponent wSDLComponent2 = (WSDLComponent)wSDLComponent.getParent();
        HashSet<String> hashSet = new HashSet<String>();
        List list = wSDLComponent2.getExtensibilityElements();
        if (list != null) {
            for (Object object2 : list) {
                if (!object2.getQName().equals(qName) || object2 == wSDLComponent || object2.getAttribute(string) == null) continue;
                hashSet.add(object2.getAttribute(string));
            }
        }
        int n = counterStart;
        object2 = string2 + n;
        while (hashSet.contains(object2)) {
            object2 = string2 + ++n;
        }
        return object2;
    }

    public static String generateUniquePartnerLinkType(String string, QName qName, WSDLModel wSDLModel) {
        int n = counterStart;
        String string2 = null;
        String string3 = "partnerlinktype";
        string2 = string == null ? string3 + n : (string3 = string);
        while (NameGenerator.isParterLinkTypeExists(string2, qName, wSDLModel)) {
            string2 = string3 + ++n;
        }
        return string2;
    }

    private static boolean isParterLinkTypeExists(String string, QName qName, WSDLModel wSDLModel) {
        return NameGenerator.findExtensibilityElementByQName(string, qName, (WSDLComponent)wSDLModel.getDefinitions()) != null;
    }

    private static WSDLComponent findExtensibilityElementByQName(String string, QName qName, WSDLComponent wSDLComponent) {
        if (string == null || qName == null || qName.getNamespaceURI() == null || qName.getLocalPart() == null || wSDLComponent == null) {
            return null;
        }
        List list = wSDLComponent.getExtensibilityElements();
        for (ExtensibilityElement extensibilityElement : list) {
            String string2;
            QName qName2 = extensibilityElement.getQName();
            String string3 = qName2.getNamespaceURI();
            String string4 = qName2.getLocalPart();
            if (!qName.getNamespaceURI().equals(string3) || !qName.getLocalPart().equals(string4) || (string2 = extensibilityElement.getAttribute("name")) == null || !string2.equals(string)) continue;
            return extensibilityElement;
        }
        return null;
    }

    static {
        MESSAGE_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_MESSAGE_PREFIX");
        MESSAGE_PART_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_PART_PREFIX");
        PORTTYPE_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_PORTTYPE_PREFIX");
        OPERATION_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_OPERATION_PREFIX");
        OPERATION_INPUT_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_INPUT");
        OPERATION_OUTPUT_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_OUTPUT");
        OPERATION_FAULT_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_FAULT_PREFIX");
        BINDING_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_BINDING_PREFIX");
        BINDING_OPERATION_FAULT_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_BINDING_OPERATION_FAULT_PREFIX");
        SERVICE_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_SERVICE_PREFIX");
        PORT_NAME_PREFIX = NbBundle.getMessage(NameGenerator.class, (String)"NameGenerator_PORT_PREFIX");
        counterStart = 1;
    }
}

