/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import antlr.Token;
import java.io.Serializable;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.apt.impl.structure.APTTokenBasedNode;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.support.APTTokenAbstact;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public abstract class APTMacroBaseNode
extends APTTokenBasedNode
implements Serializable {
    private static final long serialVersionUID = 1315417078059538898L;
    private Token macroName = EMPTY_NAME;
    private static final NotHandledMacroName EMPTY_NAME = new NotHandledMacroName();

    APTMacroBaseNode(APTMacroBaseNode aPTMacroBaseNode) {
        super(aPTMacroBaseNode);
        this.macroName = aPTMacroBaseNode.macroName;
    }

    protected APTMacroBaseNode() {
    }

    public APTMacroBaseNode(Token token) {
        super(token);
    }

    public APT getFirstChild() {
        return null;
    }

    public void setFirstChild(APT aPT) {
        assert (false) : "define/undef doesn't support children";
    }

    public boolean accept(Token token) {
        if (APTUtils.isID(token)) {
            if (this.macroName != EMPTY_NAME) {
                if (DebugUtils.STANDALONE) {
                    System.err.printf("line %d: warning: extra tokens at end of %s directive\n", this.getToken().getLine(), this.getToken().getText().trim());
                } else {
                    APTUtils.LOG.log(Level.WARNING, "line {0}: warning: extra tokens at end of {1} directive", new Object[]{this.getToken().getLine(), this.getToken().getText().trim()});
                }
            } else {
                this.macroName = token;
            }
        }
        return !APTUtils.isEndDirectiveToken(token.getType());
    }

    public String getText() {
        assert (this.getToken() != null) : "must have valid preproc directive";
        assert (this.getName() != null) : "must have valid macro";
        String string = super.getText();
        if (this.getName() != null) {
            string = string + " MACRO{" + this.getName() + "}";
        }
        return string;
    }

    public Token getName() {
        return this.macroName;
    }

    private static class NotHandledMacroName
    extends APTTokenAbstact {
        public String getText() {
            return "<<DUMMY>>";
        }
    }
}

