/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.preview;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.openide.util.NbBundle;

public class SequenceTimeSpinner
extends JSpinner {
    private Sequence sequence;

    public SequenceTimeSpinner(Sequence sequence) {
        this.sequence = sequence;
        this.sequence.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("sequence.prop.frames.ms")) {
                    SequenceTimeSpinner.this.setValue(SequenceTimeSpinner.this.sequence.getFrameMs());
                }
            }
        });
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.sequence.getFrameMs(), 10, Integer.MAX_VALUE, 10);
        this.setModel(spinnerNumberModel);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SpinnerModel spinnerModel = SequenceTimeSpinner.this.getModel();
                if (spinnerModel instanceof SpinnerNumberModel) {
                    int n = ((SpinnerNumberModel)spinnerModel).getNumber().intValue();
                    SequenceTimeSpinner.this.sequence.setFrameMs(n);
                }
            }
        });
        this.setEditor(new SpinnerMSEditor(this));
    }

    public static class SpinnerMSEditor
    extends JTextField
    implements ChangeListener,
    ActionListener {
        private JSpinner spinner;

        public SpinnerMSEditor(JSpinner jSpinner) {
            this.spinner = jSpinner;
            this.spinner.addChangeListener(this);
            this.setToolTipText(NbBundle.getMessage(SequenceTimeSpinner.class, (String)"SequenceTimeSpinner.tooltip"));
            this.setText(((SpinnerNumberModel)this.spinner.getModel()).getValue() + " ms");
            this.setHorizontalAlignment(11);
            this.addActionListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.setText(((SpinnerNumberModel)this.spinner.getModel()).getValue() + " ms");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getText();
            if (string.endsWith(" ms")) {
                string = string.substring(0, string.lastIndexOf(" ms"));
            }
            try {
                int n = Integer.parseInt(string);
                this.spinner.getModel().setValue(n);
                this.setForeground(Color.BLACK);
            }
            catch (NumberFormatException numberFormatException) {
                this.setForeground(Color.RED);
            }
        }
    }
}

