/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import javax.swing.AbstractListModel;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.openide.util.NbBundle;

public class GlobalRepositoryListAdapter
extends AbstractListModel
implements GlobalRepositoryListener {
    private static final int ADDITIONAL_LIST_ITEM_COUNT = 4;
    private static final String ADDITIONAL_LIST_ITEM_SCENES_LABEL = NbBundle.getMessage(GlobalRepositoryListAdapter.class, (String)"GlobalRepositoryListAdapter.labelScenes");
    private static final String ADDITIONAL_LIST_ITEM_TILEDLAYERS_LABEL = NbBundle.getMessage(GlobalRepositoryListAdapter.class, (String)"GlobalRepositoryListAdapter.labelTiledLayers");
    private static final String ADDITIONAL_LIST_ITEM_SPRITES_LABEL = NbBundle.getMessage(GlobalRepositoryListAdapter.class, (String)"GlobalRepositoryListAdapter.labelSprites");
    private GlobalRepository gameDesign;

    public void setGameDesign(GlobalRepository globalRepository) {
        this.gameDesign = globalRepository;
        this.gameDesign.addGlobalRepositoryListener(this);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public int getSize() {
        if (this.gameDesign == null) {
            return 0;
        }
        int n = this.gameDesign.getScenes().size();
        int n2 = this.gameDesign.getTiledLayers().size();
        int n3 = this.gameDesign.getSprites().size();
        return n + n2 + n3 + 4;
    }

    public Object getElementAt(int n) {
        int n2 = this.gameDesign.getScenes().size();
        int n3 = this.gameDesign.getTiledLayers().size();
        int n4 = this.gameDesign.getSprites().size();
        int n5 = 0;
        if (n == 0) {
            return this.gameDesign;
        }
        ++n5;
        if (n == 1) {
            return ADDITIONAL_LIST_ITEM_SCENES_LABEL;
        }
        if (n < n2 + ++n5) {
            return this.gameDesign.getScenes().get(n - n5);
        }
        if (n == (n5 += n2)) {
            return ADDITIONAL_LIST_ITEM_TILEDLAYERS_LABEL;
        }
        if (n < n3 + ++n5) {
            return this.gameDesign.getTiledLayers().get(n - n5);
        }
        if (n == (n5 += n3)) {
            return ADDITIONAL_LIST_ITEM_SPRITES_LABEL;
        }
        if (n < n4 + ++n5) {
            return this.gameDesign.getSprites().get(n - n5);
        }
        return null;
    }

    public void sceneAdded(Scene scene, int n) {
        int n2 = 2;
        this.fireIntervalAdded(this, n + n2, n + n2);
    }

    public void sceneRemoved(Scene scene, int n) {
        int n2 = 2;
        this.fireIntervalRemoved(this, n + n2, n + n2);
    }

    public void tiledLayerAdded(TiledLayer tiledLayer, int n) {
        int n2 = 2 + this.gameDesign.getScenes().size() + 1;
        this.fireIntervalAdded(this, n + n2, n + n2);
    }

    public void tiledLayerRemoved(TiledLayer tiledLayer, int n) {
        int n2 = 2 + this.gameDesign.getScenes().size() + 1;
        this.fireIntervalRemoved(this, n + n2, n + n2);
    }

    public void spriteAdded(Sprite sprite, int n) {
        int n2 = 2 + this.gameDesign.getScenes().size() + 1 + this.gameDesign.getTiledLayers().size() + 1;
        this.fireIntervalAdded(this, n + n2, n + n2);
    }

    public void spriteRemoved(Sprite sprite, int n) {
        int n2 = 2 + this.gameDesign.getScenes().size() + 1 + this.gameDesign.getTiledLayers().size() + 1;
        this.fireIntervalRemoved(this, n + n2, n + n2);
    }

    public void imageResourceAdded(ImageResource imageResource) {
    }
}

