/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.dialog.RenameTiledLayerDialog;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerEditor;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerNavigator;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerPreviewPanel;
import org.netbeans.modules.vmd.game.model.AnimatedTile;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.ImageResourceListener;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Position;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiledLayer
extends Layer
implements ImageResourceListener {
    private TiledLayerPreviewPanel preview;
    private TiledLayerNavigator navigator;
    public static final boolean DEBUG = false;
    EventListenerList listenerList = new EventListenerList();
    private JComponent editor;
    private int[][] grid;

    TiledLayer(GlobalRepository globalRepository, String string, ImageResource imageResource, int n, int n2, int n3, int n4) {
        super(globalRepository, string, imageResource, n3, n4);
        this.getImageResource().addImageResourceListener(this);
        this.grid = new int[n][n2];
    }

    TiledLayer(GlobalRepository globalRepository, String string, ImageResource imageResource, int[][] nArray, int n, int n2) {
        super(globalRepository, string, imageResource, n, n2);
        this.getImageResource().addImageResourceListener(this);
        this.grid = nArray;
    }

    TiledLayer(GlobalRepository globalRepository, String string, TiledLayer tiledLayer) {
        super(globalRepository, string, tiledLayer.getImageResource(), tiledLayer.getTileWidth(), tiledLayer.getTileHeight());
        this.getImageResource().addImageResourceListener(this);
        this.grid = new int[tiledLayer.grid.length][];
        for (int i = 0; i < this.grid.length; ++i) {
            int[] nArray = new int[tiledLayer.grid[i].length];
            System.arraycopy(tiledLayer.grid[i], 0, nArray, 0, tiledLayer.grid[i].length);
            this.grid[i] = nArray;
        }
    }

    @Override
    public Editable.ImageResourceInfo getImageResourceInfo() {
        return new Editable.ImageResourceInfo(this.getImageResource(), this.getTileWidth(), this.getTileHeight(), false);
    }

    public void addTiledLayerListener(TiledLayerListener tiledLayerListener) {
        this.listenerList.add(TiledLayerListener.class, tiledLayerListener);
    }

    public void removeTiledLayerListener(TiledLayerListener tiledLayerListener) {
        this.listenerList.remove(TiledLayerListener.class, tiledLayerListener);
    }

    @Override
    public JComponent getEditor() {
        return this.editor == null ? (this.editor = new TiledLayerEditor(this)) : this.editor;
    }

    public int getRowCount() {
        return this.grid.length;
    }

    public int getColumnCount() {
        return this.grid[0].length;
    }

    public int getTileIndexAt(Position position) {
        return this.getTileIndexAt(position.getRow(), position.getCol());
    }

    public int getTileIndexAt(int n, int n2) {
        if (n >= this.grid.length || n2 >= this.grid[0].length) {
            return 0;
        }
        return this.grid[n][n2];
    }

    public Tile getTileAt(Position position) {
        return this.getTileAt(position.getRow(), position.getCol());
    }

    public Tile getTileAt(int n, int n2) {
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return this.getImageResource().getTile(0, this.getTileWidth(), this.getTileHeight(), false);
        }
        Tile tile = null;
        int n3 = this.grid[n][n2];
        tile = this.getImageResource().getTile(n3, this.getTileWidth(), this.getTileHeight(), false);
        return tile;
    }

    public void setTileAtPositions(int n, Set set) {
        for (Position position : set) {
            this.updateIndexGrid(n, position.getRow(), position.getCol());
        }
        this.fireTilesChanged(set);
    }

    private void fireTilesChanged(Set set) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)objectArray[i + 1]).tilesChanged(this, set);
        }
    }

    private void fireTilesChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)objectArray[i + 1]).tilesStructureChanged(this);
        }
    }

    private Set getAnimatedTiles() {
        HashSet<Tile> hashSet = new HashSet<Tile>();
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[i].length; ++j) {
                Tile tile = this.getImageResource().getTile(this.grid[i][j], this.getTileWidth(), this.getTileHeight(), false);
                if (!(tile instanceof AnimatedTile)) continue;
                hashSet.add(tile);
            }
        }
        return hashSet;
    }

    public void setTileAt(int n, Position position) {
        this.setTileAt(n, position.getRow(), position.getCol());
    }

    public void setTileAt(int n, int n2, int n3) {
        if (this.updateIndexGrid(n, n2, n3)) {
            this.fireTileChanged(n2, n3);
        }
    }

    private void fireTileChanged(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)objectArray[i + 1]).tileChanged(this, n, n2);
        }
    }

    private boolean updateIndexGrid(int n, int n2, int n3) {
        while (n2 < 0) {
            this.insertRows(0, 1);
            ++n2;
        }
        while (n3 < 0) {
            this.insertColumns(0, 1);
            ++n3;
        }
        boolean bl = false;
        if (n2 >= this.getRowCount() || n3 >= this.getColumnCount()) {
            this.growLayerToSize(n2, n3);
            bl = true;
        }
        if (this.grid[n2][n3] == n && !bl) {
            return false;
        }
        this.grid[n2][n3] = n;
        return true;
    }

    public void growLayerToSize(int n, int n2) {
        int n3;
        int n4 = this.getRowCount();
        int n5 = this.getColumnCount();
        if (n >= this.getRowCount()) {
            n3 = n + 1;
            int[][] nArrayArray = new int[n3][];
            System.arraycopy(this.grid, 0, nArrayArray, 0, this.grid.length);
            for (int i = this.grid.length; i < n3; ++i) {
                nArrayArray[i] = new int[this.getColumnCount()];
            }
            this.grid = nArrayArray;
        }
        if (n2 >= this.getColumnCount()) {
            n3 = n2 + 1;
            for (int i = 0; i < this.getRowCount(); ++i) {
                int[] nArray = this.grid[i];
                int[] nArray2 = new int[n3];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                this.grid[i] = nArray2;
            }
        }
        n3 = this.getRowCount();
        int n6 = this.getColumnCount();
        if (n4 < n3) {
            this.fireRowsInserted(n4 - 1, n3 - n4);
        }
        if (n5 < n6) {
            this.fireColumnsInserted(n5 - 1, n6 - n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int[][] nArray = this.grid;
        synchronized (this.grid) {
            for (int i = 0; i < this.grid.length; ++i) {
                for (int j = 0; j < this.grid[i].length; ++j) {
                    if (this.grid[i][j] == 0) continue;
                    n = Math.min(n, j);
                    n2 = Math.max(n2, j);
                    n3 = Math.min(n3, i);
                    n4 = Math.max(n4, i);
                }
            }
            this.deleteColumns(n2 + 1, this.grid[0].length - n2 - 1);
            this.deleteRows(n4 + 1, this.grid.length - n4 - 1);
            this.deleteColumns(0, n);
            this.deleteRows(0, n3);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private void fireRowsInserted(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)objectArray[i + 1]).rowsInserted(this, n, n2);
        }
    }

    private void fireRowsRemoved(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)objectArray[i + 1]).rowsRemoved(this, n, n2);
        }
    }

    private void fireColumnsInserted(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)objectArray[i + 1]).columnsInserted(this, n, n2);
        }
    }

    private void fireColumnsRemoved(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TiledLayerListener.class) continue;
            ((TiledLayerListener)objectArray[i + 1]).columnsRemoved(this, n, n2);
        }
    }

    public void insertRows(int n, int n2) {
        int[][] nArrayArray = new int[this.grid.length + n2][];
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArrayArray.length) {
            if (n4 < n) {
                nArrayArray[n4] = this.grid[n3];
            } else if (n4 == n) {
                for (int i = 0; i < n2; ++i) {
                    nArrayArray[n4] = new int[this.grid[0].length];
                    ++n4;
                }
                if (n3 < this.grid.length) {
                    nArrayArray[n4] = this.grid[n3];
                }
            } else {
                nArrayArray[n4] = this.grid[n3];
            }
            ++n4;
            ++n3;
        }
        this.grid = nArrayArray;
        this.fireRowsInserted(n, n2);
    }

    public void deleteRows(int n, int n2) {
        int n3 = n + n2 - 1;
        int[][] nArrayArray = new int[this.grid.length - n2][];
        int n4 = 0;
        for (int i = 0; i < this.grid.length; ++i) {
            if (i >= n && i <= n3) continue;
            nArrayArray[n4] = this.grid[i];
            ++n4;
        }
        this.grid = nArrayArray;
        this.fireRowsRemoved(n, n2);
    }

    public void insertColumns(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < this.grid.length; ++i) {
            int[] nArray2 = this.grid[i];
            int[] nArray3 = new int[nArray2.length + n2];
            System.arraycopy(nArray2, 0, nArray3, 0, n);
            System.arraycopy(nArray, 0, nArray3, n, n2);
            System.arraycopy(nArray2, n, nArray3, n + n2, nArray2.length - n);
            this.grid[i] = nArray3;
        }
        this.fireColumnsInserted(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteColumns(int n, int n2) {
        int n3 = n + n2;
        int[][] nArray = this.grid;
        synchronized (this.grid) {
            for (int i = 0; i < this.grid.length; ++i) {
                int[] nArray2 = new int[this.grid[i].length - n2];
                System.arraycopy(this.grid[i], 0, nArray2, 0, n);
                System.arraycopy(this.grid[i], n3, nArray2, n, this.grid[i].length - n3);
                this.grid[i] = nArray2;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.fireColumnsRemoved(n, n2);
            return;
        }
    }

    @Override
    public int getHeight() {
        return this.grid.length * this.getTileHeight();
    }

    @Override
    public int getWidth() {
        return this.grid[0].length * this.getTileWidth();
    }

    @Override
    public List<Action> getActions() {
        List<Action> list = super.getActions();
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(list);
        arrayList.add(new RenameAction());
        return arrayList;
    }

    @Override
    public String getDisplayableTypeName() {
        return NbBundle.getMessage(TiledLayer.class, (String)"TiledLayer.text");
    }

    public int[][] getTiles() {
        return TiledLayer.cloneTiles(this.grid);
    }

    public void setTiles(int[][] nArray) {
        this.grid = TiledLayer.cloneTiles(nArray);
        this.fireTilesChanged();
    }

    public static int[][] cloneTiles(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            nArrayArray[i] = new int[nArray[i].length];
            System.arraycopy(nArray[i], 0, nArrayArray[i], 0, nArray[i].length);
        }
        return nArrayArray;
    }

    @Override
    public void paint(Graphics2D graphics2D, int n, int n2) {
    }

    @Override
    public JComponent getPreview() {
        if (this.preview == null) {
            this.preview = new TiledLayerPreviewPanel(this, true);
            return this.preview;
        }
        return this.preview;
    }

    @Override
    public JComponent getNavigator() {
        if (this.navigator == null) {
            this.navigator = new TiledLayerNavigator(this);
            return this.navigator;
        }
        return this.navigator;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        int n = super.getTileWidth();
        int n2 = super.getTileHeight();
        int n3 = rectangle.y / n2;
        int n4 = (rectangle.y + rectangle.height) / n2 + 1;
        int n5 = rectangle.x / n;
        int n6 = (rectangle.x + rectangle.width) / n + 1;
        for (int i = n3; i < this.getRowCount() && i < n4; ++i) {
            for (int j = n5; j < this.getColumnCount() && j < n6; ++j) {
                this.getImageResource().paint(this.grid[i][j], graphics2D, j * n, i * n2, n, n2, false);
            }
        }
    }

    @Override
    public void animatedTileAdded(ImageResource imageResource, AnimatedTile animatedTile) {
    }

    @Override
    public void animatedTileRemoved(ImageResource imageResource, AnimatedTile animatedTile) {
        HashSet<Position> hashSet = new HashSet<Position>();
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[i].length; ++j) {
                if (animatedTile.getIndex() != this.grid[i][j]) continue;
                this.grid[i][j] = 0;
                hashSet.add(new Position(i, j));
            }
        }
        if (!hashSet.isEmpty()) {
            this.fireTilesChanged(hashSet);
        }
    }

    @Override
    public void sequenceAdded(ImageResource imageResource, Sequence sequence) {
    }

    @Override
    public void sequenceRemoved(ImageResource imageResource, Sequence sequence) {
    }

    public class RenameAction
    extends AbstractAction {
        public RenameAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayer.class, (String)"TiledLayer.RenameAction.text"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RenameTiledLayerDialog renameTiledLayerDialog = new RenameTiledLayerDialog(TiledLayer.this);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)renameTiledLayerDialog, NbBundle.getMessage(TiledLayer.class, (String)"TiledLayer.RenameAction.text"));
            dialogDescriptor.setButtonListener((ActionListener)renameTiledLayerDialog);
            dialogDescriptor.setValid(false);
            renameTiledLayerDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }
}

