/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.integration.components;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.game.integration.components.GameTypes;
import org.netbeans.modules.vmd.game.model.SpriteCD;
import org.netbeans.modules.vmd.game.model.TiledLayerCD;

public class GameDocumentSupport {
    public static DesignComponent addSprite(DesignDocument designDocument) {
        DesignComponent designComponent = designDocument.getRootComponent();
        DesignComponent designComponent2 = designDocument.createComponent(SpriteCD.TYPEID);
        designComponent.addComponent(designComponent2);
        return designComponent2;
    }

    public static DesignComponent addTiledLayer(DesignDocument designDocument) {
        DesignComponent designComponent = designDocument.getRootComponent();
        DesignComponent designComponent2 = designDocument.createComponent(TiledLayerCD.TYPEID);
        designComponent.addComponent(designComponent2);
        return designComponent2;
    }

    public static int getRowCount(PropertyValue propertyValue) {
        if (propertyValue == null) {
            return 0;
        }
        return GameTypes.getTiles(propertyValue).length;
    }

    public static int getColumnCount(PropertyValue propertyValue) {
        if (propertyValue == null) {
            return 0;
        }
        int[][] nArray = GameTypes.getTiles(propertyValue);
        if (nArray.length < 1) {
            return 0;
        }
        return nArray[0].length;
    }

    public static void setSingleTile(DesignComponent designComponent, int n, int n2, int n3) {
        PropertyValue propertyValue = designComponent.readProperty("tiledlayercd.prop.tiles");
        int[][] nArray = GameTypes.getTiles(propertyValue);
        int n4 = nArray[n][n2];
        nArray[n][n2] = n3;
        TilesChangeUndoableEdit tilesChangeUndoableEdit = new TilesChangeUndoableEdit(designComponent, n, n2, n4, n3);
        designComponent.getDocument().getTransactionManager().undoableEditHappened((UndoableEdit)tilesChangeUndoableEdit);
        designComponent.writeProperty("tiledlayercd.prop.tiles", GameTypes.createTilesProperty(nArray));
    }

    private static class TilesChangeUndoableEdit
    extends AbstractUndoableEdit {
        private DesignComponent tiledLayer;
        private int y;
        private int x;
        private int oldValue;
        private int newValue;

        public TilesChangeUndoableEdit(DesignComponent designComponent, int n, int n2, int n3, int n4) {
            this.tiledLayer = designComponent;
            this.y = n;
            this.x = n2;
            this.oldValue = n3;
            this.newValue = n4;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            PropertyValue propertyValue = this.tiledLayer.readProperty("tiledlayercd.prop.tiles");
            int[][] nArray = GameTypes.getTiles(propertyValue);
            nArray[this.y][this.x] = this.oldValue;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            PropertyValue propertyValue = this.tiledLayer.readProperty("tiledlayercd.prop.tiles");
            int[][] nArray = GameTypes.getTiles(propertyValue);
            nArray[this.y][this.x] = this.newValue;
        }

        public boolean isSignificant() {
            return false;
        }
    }
}

