/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.scene;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.editor.scene.ScenePanel;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.SceneListener;

public class ScenePreviewPanel
extends JComponent
implements SceneListener {
    private Scene scene;
    private ScenePanel scenePanel;

    public ScenePreviewPanel(Scene scene) {
        this.scene = scene;
        this.scenePanel = new ScenePanel(scene);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ScenePreviewPanel.this.repaint();
            }
        });
        this.scene.addSceneListener(this);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        Rectangle rectangle = this.scene.getAllLayersBounds();
        double d = (double)this.getWidth() / rectangle.getWidth();
        double d2 = (double)this.getHeight() / rectangle.getHeight();
        double d3 = Math.min(d, d2);
        double d4 = 0.0;
        double d5 = 0.0;
        if (d3 == d) {
            double d6 = rectangle.getHeight() * d3;
            d5 = ((double)this.getHeight() - d6) / 2.0;
        } else {
            double d7 = rectangle.getWidth() * d3;
            d4 = ((double)this.getWidth() - d7) / 2.0;
        }
        graphics2D.translate(d4, d5);
        graphics2D.scale(d3, d3);
        this.scenePanel.drawLayers(graphics2D);
    }

    public void layerAdded(Scene scene, Layer layer, int n) {
        this.sceneChangedVisualy();
    }

    public void layerRemoved(Scene scene, Layer layer, Scene.LayerInfo layerInfo, int n) {
        this.sceneChangedVisualy();
    }

    public void layerMoved(Scene scene, Layer layer, int n, int n2) {
        this.sceneChangedVisualy();
    }

    public void layerPositionChanged(Scene scene, Layer layer, Point point, Point point2, boolean bl) {
        if (bl) {
            return;
        }
        this.sceneChangedVisualy();
    }

    public void layerLockChanged(Scene scene, Layer layer, boolean bl) {
        this.sceneChangedVisualy();
    }

    public void layerVisibilityChanged(Scene scene, Layer layer, boolean bl) {
        this.sceneChangedVisualy();
    }

    private void sceneChangedVisualy() {
        this.repaint();
    }
}

