/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.watch;

import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.variables.SimpleValue;
import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.netbeans.modules.bpel.debugger.api.variables.Variable;
import org.netbeans.modules.bpel.debugger.api.variables.WsdlMessageValue;
import org.netbeans.modules.bpel.debugger.api.variables.XmlElementValue;
import org.netbeans.modules.bpel.debugger.ui.util.VariablesUtil;
import org.netbeans.modules.bpel.debugger.ui.util.XmlUtil;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Util {
    private BpelDebugger myDebugger;
    private VariablesUtil myHelper;

    public Util(BpelDebugger bpelDebugger) {
        this.myDebugger = bpelDebugger;
        this.myHelper = new VariablesUtil(bpelDebugger);
    }

    public String toString(Node node) {
        if (node instanceof Element) {
            Element element = (Element)node;
            NodeList nodeList = element.getChildNodes();
            if (XmlUtil.isTextOnlyNode(element)) {
                return nodeList.item(0).getNodeValue();
            }
            return XmlUtil.toString(element);
        }
        String string = node.getNodeValue();
        return string != null ? string : "";
    }

    public Object toString(Value value) throws UnknownTypeException {
        if (value instanceof SimpleValue) {
            return ((SimpleValue)value).getValueAsString();
        }
        if (value instanceof XmlElementValue) {
            return this.toString(((XmlElementValue)value).getElement());
        }
        return "";
    }

    public Variable getVariable(String string) {
        ProcessInstance processInstance = this.myDebugger.getCurrentProcessInstance();
        if (processInstance == null) {
            return null;
        }
        for (Variable variable : processInstance.getVariables()) {
            if (!variable.getName().equals(string)) continue;
            return variable;
        }
        return null;
    }

    public Object getValue(String string) {
        int n = string.indexOf(".");
        String string2 = n > -1 ? string.substring(1, n) : string.substring(1);
        String string3 = n > -1 ? string.substring(n + 1) : null;
        Variable variable = this.getVariable(string2);
        if (variable == null) {
            return null;
        }
        if (string3 == null) {
            return this.myHelper.getValue(variable);
        }
        Value value = variable.getValue();
        if (value instanceof WsdlMessageValue) {
            WsdlMessageValue wsdlMessageValue = (WsdlMessageValue)value;
            int n2 = string3.indexOf("/");
            if (n2 == -1) {
                return null;
            }
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n2 + 1);
            WsdlMessageValue.Part part = null;
            for (WsdlMessageValue.Part part2 : wsdlMessageValue.getParts()) {
                if (!part2.getName().equals(string4)) continue;
                part = part2;
                break;
            }
            if (part == null) {
                return null;
            }
            if (part.getValue() instanceof XmlElementValue) {
                return this.getValue((XmlElementValue)part.getValue(), string5);
            }
            return null;
        }
        if (value instanceof XmlElementValue) {
            return this.getValue((XmlElementValue)value, string3);
        }
        return null;
    }

    public Object getValue(XmlElementValue xmlElementValue, String string) {
        Element element = xmlElementValue.getElement();
        try {
            return XPathFactory.newInstance().newXPath().evaluate(string, element);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public Object[] getChildren(String string) {
        int n = string.indexOf(".");
        String string2 = n > -1 ? string.substring(1, n) : string.substring(1);
        String string3 = n > -1 ? string.substring(n + 1) : null;
        Variable variable = this.getVariable(string2);
        if (variable == null) {
            return new Object[0];
        }
        if (string3 == null) {
            return this.myHelper.getChildren(variable);
        }
        Value value = variable.getValue();
        if (value instanceof WsdlMessageValue) {
            WsdlMessageValue wsdlMessageValue = (WsdlMessageValue)value;
            int n2 = string3.indexOf("/");
            if (n2 == -1) {
                return null;
            }
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n2 + 1);
            WsdlMessageValue.Part part = null;
            for (WsdlMessageValue.Part part2 : wsdlMessageValue.getParts()) {
                if (!part2.getName().equals(string4)) continue;
                part = part2;
                break;
            }
            if (part == null) {
                return new Object[0];
            }
            if (part.getValue() instanceof XmlElementValue) {
                return this.myHelper.getChildren(this.getValue((XmlElementValue)part.getValue(), string5));
            }
            return new Object[0];
        }
        if (value instanceof XmlElementValue) {
            return this.myHelper.getChildren(this.getValue((XmlElementValue)value, string3));
        }
        return new Object[0];
    }

    public Object[] getChildren(XmlElementValue xmlElementValue) {
        return this.myHelper.getChildren((Object)xmlElementValue.getElement());
    }

    public VariablesUtil getVariablesUtil() {
        return this.myHelper;
    }
}

