/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.plinks;

import java.util.Vector;
import javax.swing.JToolTip;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.ui.plinks.PLinksNodeModel;
import org.netbeans.modules.bpel.debugger.ui.plinks.PLinksTreeModel;
import org.netbeans.modules.bpel.debugger.ui.plinks.models.EndpointWrapper;
import org.netbeans.modules.bpel.debugger.ui.plinks.models.PartnerLinkWrapper;
import org.netbeans.modules.bpel.debugger.ui.plinks.models.RoleRefWrapper;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PLinksTableModel
implements TableModel,
Constants {
    public static final String NAME_COLUMN_ID = "NameColumn";
    public static final String TYPE_COLUMN_ID = "TypeColumn";
    public static final String VALUE_COLUMN_ID = "ValueColumn";
    private BpelDebugger myDebugger;
    private Vector myListeners = new Vector();

    public PLinksTableModel(ContextProvider contextProvider) {
        this.myDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object == "Root") {
            return "";
        }
        if (object instanceof PLinksTreeModel.Dummy) {
            return "";
        }
        if (object instanceof JToolTip) {
            Object object2 = ((JToolTip)object).getClientProperty("getShortDescription");
            return this.getValueAt(object2, string);
        }
        if (string.equals(TYPE_COLUMN_ID)) {
            if (object instanceof PartnerLinkWrapper) {
                PartnerLinkWrapper partnerLinkWrapper = (PartnerLinkWrapper)object;
                QName qName = partnerLinkWrapper.getPartnerLinkTypeRef().getQName();
                return qName.getPrefix() + ":" + qName.getLocalPart();
            }
            if (object instanceof RoleRefWrapper) {
                RoleRefWrapper roleRefWrapper = (RoleRefWrapper)object;
                QName qName = ((Role)roleRefWrapper.getRoleRef().get()).getPortType().getQName();
                return qName.getPrefix() + ":" + qName.getLocalPart();
            }
            if (object instanceof EndpointWrapper) {
                EndpointWrapper endpointWrapper = (EndpointWrapper)object;
                String string2 = endpointWrapper.getSerializedValue();
                if (string2 != null) {
                    return "";
                }
                return NbBundle.getMessage(PLinksNodeModel.class, (String)"CTL_EndpointMissing");
            }
            if (object instanceof Node) {
                return "";
            }
        }
        if (string.equals(VALUE_COLUMN_ID)) {
            if (object instanceof PartnerLinkWrapper) {
                return ((PartnerLinkWrapper)object).isDynamic() ? NbBundle.getMessage(PLinksNodeModel.class, (String)"CTL_DynamicPL") : NbBundle.getMessage(PLinksNodeModel.class, (String)"CTL_StaticPL");
            }
            if (object instanceof RoleRefWrapper) {
                RoleRefWrapper roleRefWrapper = (RoleRefWrapper)object;
                QName qName = roleRefWrapper.getRoleRef().getQName();
                return qName.getLocalPart();
            }
            if (object instanceof EndpointWrapper) {
                EndpointWrapper endpointWrapper = (EndpointWrapper)object;
                String string3 = endpointWrapper.getSerializedValue();
                if (string3 != null) {
                    return string3;
                }
                return NbBundle.getMessage(PLinksNodeModel.class, (String)"CTL_EndpointMissing");
            }
            if (object instanceof Node) {
                Node node = (Node)object;
                if (object instanceof Element) {
                    Element element = (Element)object;
                    NodeList nodeList = element.getChildNodes();
                    if (nodeList.getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                        return nodeList.item(0).getNodeValue();
                    }
                    return "";
                }
                return node.getNodeValue();
            }
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (string.equals(TYPE_COLUMN_ID)) {
            return true;
        }
        if (string.equals(VALUE_COLUMN_ID)) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.myListeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.myListeners.remove(modelListener);
    }
}

