/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.execution;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Vector;
import org.netbeans.modules.bpel.debugger.api.BpelDebugger;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.api.pem.PemEntity;
import org.netbeans.modules.bpel.debugger.api.pem.ProcessExecutionModel;
import org.netbeans.modules.bpel.debugger.api.psm.PsmEntity;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ProcessExecutionTreeModel
implements TreeModel {
    private BpelDebugger myDebugger;
    private ProcessExecutionModel myPem;
    private Listener myListener;
    private Vector myListeners = new Vector();

    public ProcessExecutionTreeModel(ContextProvider contextProvider) {
        this.myDebugger = (BpelDebugger)contextProvider.lookupFirst(null, BpelDebugger.class);
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (this.myPem == null) {
            if (object.equals("Root")) {
                return new Object[]{new Dummy()};
            }
            if (object instanceof Dummy) {
                return new Object[0];
            }
            throw new UnknownTypeException(object);
        }
        if (object.equals("Root")) {
            Object[] objectArray;
            Object object2 = this.getPemRoot();
            if (object2 != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object2;
            } else {
                objectArray = new Object[]{};
            }
            return objectArray;
        }
        if (object instanceof PsmEntity) {
            return ((PsmEntity)object).getChildren();
        }
        if (object instanceof PemEntity) {
            return this.getPemEntityChildren((PemEntity)object);
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (this.myPem == null) {
            if (object.equals("Root")) {
                return 1;
            }
            if (object instanceof Dummy) {
                return 0;
            }
            throw new UnknownTypeException(object);
        }
        if (object.equals("Root")) {
            return this.getPemRoot() != null ? 1 : 0;
        }
        if (object instanceof PsmEntity) {
            return ((PsmEntity)object).getChildrenCount();
        }
        if (object instanceof PemEntity) {
            return this.getPemEntityChildrenCount((PemEntity)object);
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (this.myPem == null) {
            if (object.equals("Root")) {
                return false;
            }
            if (object instanceof Dummy) {
                return true;
            }
            throw new UnknownTypeException(object);
        }
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof PsmEntity) {
            return !((PsmEntity)object).hasChildren();
        }
        if (object instanceof PemEntity) {
            return this.isPemEntityLeaf((PemEntity)object);
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.myListeners.add(modelListener);
        if (this.myListener == null && this.myDebugger != null) {
            this.myListener = new Listener(this, this.myDebugger);
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        this.myListeners.remove(modelListener);
        if (this.myListeners.size() == 0 && this.myListener != null) {
            this.myListener.destroy();
            this.myListener = null;
        }
    }

    void setProcessExecutionModel(ProcessExecutionModel processExecutionModel) {
        this.myPem = processExecutionModel;
    }

    void fireTreeChanged() {
        Vector vector = (Vector)this.myListeners.clone();
        for (int i = 0; i < vector.size(); ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private Object getPemRoot() {
        if (this.myPem != null) {
            return this.myPem.getRoot();
        }
        return null;
    }

    private Object[] getPemEntityChildren(PemEntity pemEntity) {
        PsmEntity psmEntity = pemEntity.getPsmEntity();
        if (!pemEntity.hasChildren()) {
            return psmEntity.getChildren();
        }
        if (psmEntity.isLoop()) {
            return pemEntity.getChildren();
        }
        Object[] objectArray = new Object[psmEntity.getChildrenCount()];
        int n = 0;
        for (PsmEntity psmEntity2 : psmEntity.getChildren()) {
            PemEntity[] pemEntityArray = pemEntity.getChildren(psmEntity2);
            objectArray[n++] = pemEntityArray.length > 0 ? pemEntityArray[0] : psmEntity2;
        }
        return objectArray;
    }

    private int getPemEntityChildrenCount(PemEntity pemEntity) {
        PsmEntity psmEntity = pemEntity.getPsmEntity();
        if (!pemEntity.hasChildren()) {
            return psmEntity.getChildrenCount();
        }
        if (psmEntity.isLoop()) {
            return pemEntity.getChildrenCount();
        }
        return psmEntity.getChildrenCount();
    }

    private boolean isPemEntityLeaf(PemEntity pemEntity) {
        return !pemEntity.hasChildren() && !pemEntity.getPsmEntity().hasChildren();
    }

    static class Dummy {
        Dummy() {
        }
    }

    private static class Listener
    implements ProcessExecutionModel.Listener,
    PropertyChangeListener {
        private BpelDebugger myDebugger;
        private WeakReference<ProcessExecutionTreeModel> myModel;
        private ProcessExecutionModel myPem;
        private RequestProcessor.Task myTask;

        private Listener(ProcessExecutionTreeModel processExecutionTreeModel, BpelDebugger bpelDebugger) {
            this.myDebugger = bpelDebugger;
            this.myModel = new WeakReference<ProcessExecutionTreeModel>(processExecutionTreeModel);
            this.myDebugger.addPropertyChangeListener((PropertyChangeListener)this);
            this.init();
        }

        private void init() {
            ProcessInstance processInstance;
            ProcessExecutionTreeModel processExecutionTreeModel = this.getModel();
            if (processExecutionTreeModel == null) {
                return;
            }
            if (this.myPem != null) {
                this.myPem.removeListener((ProcessExecutionModel.Listener)this);
                this.myPem = null;
            }
            if ((processInstance = this.myDebugger.getCurrentProcessInstance()) != null) {
                this.myPem = processInstance.getProcessExecutionModel();
                if (this.myPem != null) {
                    this.myPem.addListener((ProcessExecutionModel.Listener)this);
                }
            }
            processExecutionTreeModel.setProcessExecutionModel(this.myPem);
        }

        private void destroy() {
            this.myDebugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.myPem != null) {
                this.myPem.removeListener((ProcessExecutionModel.Listener)this);
                this.myPem = null;
            }
            if (this.myTask != null) {
                this.myTask.cancel();
                this.myTask = null;
            }
        }

        private ProcessExecutionTreeModel getModel() {
            ProcessExecutionTreeModel processExecutionTreeModel = (ProcessExecutionTreeModel)this.myModel.get();
            if (processExecutionTreeModel == null) {
                this.destroy();
            }
            return processExecutionTreeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("currentProcessInstance".equals(propertyChangeEvent.getPropertyName())) {
                if (this.myTask != null) {
                    this.myTask.cancel();
                    this.myTask = null;
                }
                this.init();
                this.modelUpdated();
            } else if ("state".equals(propertyChangeEvent.getPropertyName()) && this.myDebugger.getState() == 4) {
                this.destroy();
                this.modelUpdated();
            }
        }

        public void modelUpdated() {
            final ProcessExecutionTreeModel processExecutionTreeModel = this.getModel();
            if (processExecutionTreeModel == null) {
                return;
            }
            if (this.myTask != null) {
                this.myTask.cancel();
                this.myTask = null;
            }
            this.myTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    processExecutionTreeModel.fireTreeChanged();
                }
            }, 500);
        }
    }
}

