/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.ui.execution;

import org.netbeans.modules.bpel.debugger.api.pem.PemEntity;
import org.netbeans.modules.bpel.debugger.api.psm.PsmEntity;
import org.netbeans.modules.bpel.debugger.ui.execution.Constants;
import org.netbeans.modules.bpel.debugger.ui.util.HtmlUtil;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public final class Helper {
    private Helper() {
    }

    public static String getDisplayName(Object object, boolean bl) throws UnknownTypeException {
        if (object instanceof PsmEntity) {
            PsmEntity psmEntity = (PsmEntity)object;
            String string = Constants.makeLabel(psmEntity.getTag(), psmEntity.getName());
            if (bl) {
                return HtmlUtil.toHtml(string, false, false, Constants.NOT_YET_EXECUTED);
            }
            return string;
        }
        if (object instanceof PemEntity) {
            PemEntity pemEntity = (PemEntity)object;
            PsmEntity psmEntity = pemEntity.getPsmEntity();
            String string = Constants.makeLabel(psmEntity.getTag(), psmEntity.getName());
            if (psmEntity.getParent() != null && psmEntity.getParent().isLoop()) {
                string = string + " [" + pemEntity.getIndex() + "]";
            }
            if (bl) {
                string = HtmlUtil.highlight(string, Constants.isBold(pemEntity), false, Constants.getColor(pemEntity));
                return HtmlUtil.html(string);
            }
            return string;
        }
        throw new UnknownTypeException(object);
    }

    public static String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof PsmEntity) {
            PsmEntity psmEntity = (PsmEntity)object;
            String string = psmEntity.getTag();
            String string2 = Constants.myIconByTag.get(string);
            if (string2 == null) {
                string2 = "DEFAULT_BPEL_ENTITY_NODE";
            }
            return "org/netbeans/modules/bpel/debugger/ui/resources/image/execution/grayed-out/" + string2;
        }
        if (object instanceof PemEntity) {
            PemEntity pemEntity = (PemEntity)object;
            String string = pemEntity.getPsmEntity().getTag();
            String string3 = Constants.myIconByTag.get(string);
            if (string3 == null) {
                string3 = "DEFAULT_BPEL_ENTITY_NODE";
            }
            return "org/netbeans/modules/bpel/debugger/ui/resources/image/execution/" + string3;
        }
        throw new UnknownTypeException(object);
    }
}

