/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.xml.graph;

import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.xml.TSTopLevelXMLWriter;
import com.tomsawyer.xml.TSXMLUtilities;
import com.tomsawyer.xml.graph.TSEdgeXMLWriter;
import com.tomsawyer.xml.graph.TSGraphXMLWriter;
import com.tomsawyer.xml.graph.fe;
import com.tomsawyer.xml.template.ia;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Writer;
import java.util.Iterator;
import org.w3c.dom.Element;

public class TSGraphManagerXMLWriter
extends TSTopLevelXMLWriter {
    private TSGraphXMLWriter graphWriter;
    private TSEdgeXMLWriter edgeWriter;
    private TSGraphManager graphManager;
    protected boolean okToWriteTemplates = true;

    public TSGraphManagerXMLWriter() {
        this.init();
    }

    public TSGraphManagerXMLWriter(Writer writer) {
        super(writer);
        this.init();
    }

    public TSGraphManagerXMLWriter(File file, boolean bl, boolean bl2) throws FileNotFoundException {
        super(file, bl, bl2);
        this.init();
    }

    public TSGraphManagerXMLWriter(File file) throws FileNotFoundException {
        super(file);
        this.init();
    }

    public TSGraphManagerXMLWriter(String string, boolean bl, boolean bl2) throws FileNotFoundException {
        super(string, bl, bl2);
        this.init();
    }

    public TSGraphManagerXMLWriter(String string) throws FileNotFoundException {
        super(string);
        this.init();
    }

    private void init() {
        this.setGraphWriter(this.newGraphXMLWriter());
        this.setEdgeWriter(this.newEdgeXMLWriter());
        this.setTagName("graphManager");
    }

    protected TSGraphXMLWriter newGraphXMLWriter() {
        return new TSGraphXMLWriter();
    }

    protected TSEdgeXMLWriter newEdgeXMLWriter() {
        return new TSEdgeXMLWriter();
    }

    public TSGraphXMLWriter getGraphWriter() {
        return this.graphWriter;
    }

    public void setGraphWriter(TSGraphXMLWriter tSGraphXMLWriter) {
        this.graphWriter = tSGraphXMLWriter;
        this.graphWriter.setParent(this);
    }

    public TSGraphManager getGraphManager() {
        return this.graphManager;
    }

    public void setGraphManager(TSGraphManager tSGraphManager) {
        this.graphManager = tSGraphManager;
    }

    public TSEdgeXMLWriter getEdgeWriter() {
        return this.edgeWriter;
    }

    public void setEdgeWriter(TSEdgeXMLWriter tSEdgeXMLWriter) {
        this.edgeWriter = tSEdgeXMLWriter;
        this.edgeWriter.setParent(this);
    }

    protected void setObjectToWrite(Object object) {
        if (object instanceof TSGraphManager) {
            this.setGraphManager((TSGraphManager)object);
        }
    }

    public void populateDOMElement(Element element) {
        fe.a(this.getID(this.getGraphManager()), element);
        Element element2 = TSXMLUtilities.createElement("instances", element);
        this.writeGraphs(element2);
        this.writeIntergraphEdges(element2);
        this.writeChildGraphRelations(element2);
        if (this.isUsingTemplates() && this.okToWriteTemplates) {
            ia.a(element);
        }
    }

    private void writeGraphs(Element element) {
        if (this.getGraphManager().numberOfGraphs() > 0) {
            Element element2 = TSXMLUtilities.createElement("graphs", element);
            Iterator iterator = this.getGraphManager().graphs(false).iterator();
            while (iterator.hasNext()) {
                TSGraph tSGraph = (TSGraph)iterator.next();
                Element element3 = TSXMLUtilities.createElement(this.getGraphWriter().getTagName(), element2);
                fe.a(this.getID(tSGraph), element3);
                this.getGraphWriter().setGraph(tSGraph);
                this.getGraphWriter().populateDOMElement(element3);
            }
        }
    }

    private void writeIntergraphEdges(Element element) {
        if (this.getGraphManager().numberOfIntergraphEdges() > 0) {
            Element element2 = TSXMLUtilities.createElement("edges", element);
            Iterator iterator = this.getGraphManager().intergraphEdges().iterator();
            while (iterator.hasNext()) {
                TSEdge tSEdge = (TSEdge)iterator.next();
                if (!tSEdge.getSourceNode().isOwned() || !tSEdge.getTargetNode().isOwned() || !tSEdge.getSourceNode().getOwnerGraph().isOwned() || !tSEdge.getTargetNode().getOwnerGraph().isOwned()) continue;
                Element element3 = TSXMLUtilities.createElement(this.getEdgeWriter().getTagName(), element2);
                fe.a(this.getID(tSEdge), element3);
                TSXMLUtilities.writeStringAttribute("source", this.getID(tSEdge.getSourceNode()), element3);
                TSXMLUtilities.writeStringAttribute("target", this.getID(tSEdge.getTargetNode()), element3);
                if (tSEdge.getType() != 0) {
                    TSXMLUtilities.writeIntAttribute("type", tSEdge.getType(), element3);
                }
                this.getEdgeWriter().setEdge(tSEdge);
                this.getEdgeWriter().populateDOMElement(element3);
            }
        }
    }

    private void writeChildGraphRelations(Element element) {
        if (this.getGraphManager().getChildGraphForest().numberOfEdges() > 0) {
            Element element2 = TSXMLUtilities.createElement("childGraphRelations", element);
            Iterator iterator = this.getGraphManager().graphs(false).iterator();
            while (iterator.hasNext()) {
                TSGraph tSGraph = (TSGraph)iterator.next();
                TSGraphMember tSGraphMember = tSGraph.getParent();
                if (tSGraphMember == null) continue;
                Element element3 = TSXMLUtilities.createElement("childGraphRelation", element2);
                fe.a(this.getID(tSGraphMember.getChildGraphForestEdge()), element3);
                TSXMLUtilities.writeStringAttribute("parent", this.getID(tSGraphMember), element3);
                TSXMLUtilities.writeStringAttribute("graph", this.getID(tSGraph), element3);
            }
        }
    }
}

