/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.xml.graph;

import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSLicenseRuntimeException;
import com.tomsawyer.xml.TSTopLevelXMLReader;
import com.tomsawyer.xml.TSXMLUtilities;
import com.tomsawyer.xml.graph.TSEdgeXMLReader;
import com.tomsawyer.xml.graph.TSGraphXMLReader;
import com.tomsawyer.xml.graph.fe;
import com.tomsawyer.xml.template.h8;
import com.tomsawyer.xml.util.TSObjectNotFoundException;
import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import org.w3c.dom.Element;

public class TSGraphManagerXMLReader
extends TSTopLevelXMLReader {
    private TSGraphManager graphManager;
    private TSGraphXMLReader graphReader;
    private TSEdgeXMLReader edgeReader;
    private h8 templateReader;

    public TSGraphManagerXMLReader() {
        this.init();
    }

    public TSGraphManagerXMLReader(Reader reader) {
        super(reader);
        this.init();
    }

    public TSGraphManagerXMLReader(File file) {
        super(file);
        this.init();
    }

    public TSGraphManagerXMLReader(String string) {
        super(string);
        this.init();
    }

    public TSGraphManagerXMLReader(URL uRL) {
        super(uRL);
        this.init();
    }

    private void init() {
        this.setTagName("graphManager");
        this.setGraphReader(this.newGraphXMLReader());
        this.setEdgeReader(this.newEdgeXMLReader());
    }

    protected TSGraphXMLReader newGraphXMLReader() {
        return new TSGraphXMLReader();
    }

    protected TSEdgeXMLReader newEdgeXMLReader() {
        return new TSEdgeXMLReader();
    }

    public TSGraphManager getGraphManager() {
        return this.graphManager;
    }

    public void setGraphManager(TSGraphManager tSGraphManager) {
        this.graphManager = tSGraphManager;
    }

    public TSGraphXMLReader getGraphReader() {
        return this.graphReader;
    }

    public void setGraphReader(TSGraphXMLReader tSGraphXMLReader) {
        this.graphReader = tSGraphXMLReader;
        this.graphReader.setParent(this);
    }

    public TSEdgeXMLReader getEdgeReader() {
        return this.edgeReader;
    }

    public void setEdgeReader(TSEdgeXMLReader tSEdgeXMLReader) {
        this.edgeReader = tSEdgeXMLReader;
        this.edgeReader.setParent(this);
    }

    protected void setObjectToRead(Object object) {
        if (object instanceof TSGraphManager) {
            this.setGraphManager((TSGraphManager)object);
        }
    }

    public void processDOMElement(Element element) throws TSObjectNotFoundException {
        this.templateReader = new h8(element);
        this.setID(fe.c(element), this.getGraphManager());
        Element element2 = TSXMLUtilities.findElement(element, "instances");
        if (element2 != null) {
            Element element3 = TSXMLUtilities.findElement(element2, "graphs");
            this.processGraphs(element3);
            Element element4 = TSXMLUtilities.findElement(element2, "childGraphRelations");
            this.processChildGraphRelations(element4, false);
            Element element5 = TSXMLUtilities.findElement(element2, "edges");
            this.processIntergraphEdges(element5);
            this.processChildGraphRelations(element4, true);
        }
    }

    private void processGraphs(Element element) {
        if (element != null) {
            Iterator iterator = TSXMLUtilities.getChildrenByName("graph", element).iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                this.processGraph(element2);
            }
        }
    }

    private void processGraph(Element element) {
        String string = fe.c(element);
        TSGraph tSGraph = (TSGraph)this.getObject(string);
        if (tSGraph == null) {
            tSGraph = this.getGraphManager().addGraph();
            this.setID(string, tSGraph);
        }
        this.getGraphReader().setGraph(tSGraph);
        this.getGraphReader().processDOMElement(element);
    }

    private void processChildGraphRelations(Element element, boolean bl) {
        if (element != null) {
            Iterator iterator = TSXMLUtilities.getChildrenByName("childGraphRelation", element).iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                this.processChildGraphRelation(element2, bl);
            }
        }
    }

    private void processChildGraphRelation(Element element, boolean bl) {
        String string = fe.c(element);
        String string2 = TSXMLUtilities.parseStringAttribute("parent", element);
        TSGraphMember tSGraphMember = (TSGraphMember)this.getObject(string2);
        if (tSGraphMember == null && bl) {
            throw new TSObjectNotFoundException(string2);
        }
        if (tSGraphMember != null) {
            String string3 = TSXMLUtilities.parseStringAttribute("graph", element);
            TSGraph tSGraph = (TSGraph)this.getObject(string3);
            if (tSGraph == null) {
                throw new TSObjectNotFoundException(string3);
            }
            TSEdge tSEdge = (TSEdge)this.getObject(string);
            if (tSEdge == null) {
                try {
                    tSGraphMember.setChildGraph(tSGraph);
                }
                catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
                    // empty catch block
                }
                this.setID(string, tSGraphMember.getChildGraphForestEdge());
            }
        }
    }

    private void processIntergraphEdges(Element element) {
        if (element != null) {
            Iterator iterator = TSXMLUtilities.getChildrenByName("edge", element).iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                this.processIntergraphEdge(element2);
            }
        }
    }

    private void processIntergraphEdge(Element element) {
        String string = fe.c(element);
        int n = fe.a(element, 0);
        String string2 = TSXMLUtilities.parseStringAttribute("source", element);
        TSNode tSNode = (TSNode)this.getObject(string2);
        if (tSNode == null) {
            throw new TSObjectNotFoundException(string2);
        }
        String string3 = TSXMLUtilities.parseStringAttribute("target", element);
        TSNode tSNode2 = (TSNode)this.getObject(string3);
        if (tSNode2 == null) {
            throw new TSObjectNotFoundException(string3);
        }
        TSEdge tSEdge = (TSEdge)this.getObject(string);
        if (tSEdge == null) {
            tSEdge = n == 0 ? this.getGraphManager().addEdge(tSNode, tSNode2) : this.getGraphManager().addEdge(n, tSNode, tSNode2);
            this.setID(string, tSEdge);
        }
        this.getEdgeReader().setEdge(tSEdge);
        this.getEdgeReader().processDOMElement(element);
    }

    public h8 getTemplateReader() {
        return this.templateReader;
    }
}

