/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.xml.drawing;

import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.xml.TSXMLUtilities;
import com.tomsawyer.xml.drawing.TSDEdgeXMLWriter;
import com.tomsawyer.xml.drawing.TSDNodeXMLWriter;
import com.tomsawyer.xml.graph.TSEdgeXMLWriter;
import com.tomsawyer.xml.graph.TSGraphXMLWriter;
import com.tomsawyer.xml.graph.TSNodeXMLWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Writer;
import java.util.List;
import org.w3c.dom.Element;

public class TSDGraphXMLWriter
extends TSGraphXMLWriter {
    public TSDGraphXMLWriter() {
    }

    public TSDGraphXMLWriter(Writer writer) {
        super(writer);
    }

    public TSDGraphXMLWriter(File file, boolean bl, boolean bl2) throws FileNotFoundException {
        super(file, bl, bl2);
    }

    public TSDGraphXMLWriter(File file) throws FileNotFoundException {
        super(file);
    }

    public TSDGraphXMLWriter(String string, boolean bl, boolean bl2) throws FileNotFoundException {
        super(string, bl, bl2);
    }

    public TSDGraphXMLWriter(String string) throws FileNotFoundException {
        super(string);
    }

    protected TSNodeXMLWriter newNodeXMLWriter() {
        return new TSDNodeXMLWriter();
    }

    protected TSEdgeXMLWriter newEdgeXMLWriter() {
        return new TSDEdgeXMLWriter();
    }

    public void populateDOMElement(Element element) {
        super.populateDOMElement(element);
        if (this.getGraph() instanceof TSDGraph) {
            this.createMargins(element);
        }
    }

    protected void writeNodes(Element element, TSGraph tSGraph) {
        super.writeNodes(element, tSGraph);
        if (tSGraph instanceof TSDGraph) {
            TSDGraph tSDGraph = (TSDGraph)tSGraph;
            TSHidingManager.getManager((TSDGraphManager)tSDGraph.getOwnerGraphManager());
            if (TSHidingManager.hasHiddenNodes(tSDGraph)) {
                this.writeNodes(element, tSDGraph.hideGraph());
            }
        }
    }

    protected void writeEdges(Element element, TSGraph tSGraph, List list) {
        super.writeEdges(element, tSGraph, list);
        if (tSGraph instanceof TSDGraph) {
            TSDGraph tSDGraph = (TSDGraph)tSGraph;
            TSHidingManager.getManager((TSDGraphManager)tSDGraph.getOwnerGraphManager());
            if (TSHidingManager.hasHiddenEdges(tSDGraph)) {
                TSDGraph tSDGraph2 = tSDGraph.hideGraph();
                this.writeEdges(element, tSDGraph2, tSDGraph2.edges());
                this.writeEdges(element, tSDGraph2, tSDGraph2.disconnectedEdges());
            }
        }
    }

    private void createMargins(Element element) {
        Element element2 = TSXMLUtilities.createElement("margins", element);
        TSDGraph tSDGraph = (TSDGraph)this.getGraph();
        TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
        Element element3 = TSXMLUtilities.createElement("proportional", element2);
        TSXMLUtilities.writeDoubleAttribute("left", tSGraphTailor.getLeftProportionalMargin(), element3);
        TSXMLUtilities.writeDoubleAttribute("right", tSGraphTailor.getRightProportionalMargin(), element3);
        TSXMLUtilities.writeDoubleAttribute("top", tSGraphTailor.getTopProportionalMargin(), element3);
        TSXMLUtilities.writeDoubleAttribute("bottom", tSGraphTailor.getBottomProportionalMargin(), element3);
        Element element4 = TSXMLUtilities.createElement("constant", element2);
        if (tSDGraph.getParent() != null && tSDGraph.getParent() instanceof TSDNode && tSDGraph.getParent().isExpanded()) {
            TSXMLUtilities.writeDoubleAttribute("left", tSGraphTailor.getOriginalLeftConstantMargin(), element4);
            TSXMLUtilities.writeDoubleAttribute("right", tSGraphTailor.getOriginalRightConstantMargin(), element4);
            TSXMLUtilities.writeDoubleAttribute("top", tSGraphTailor.getOriginalTopConstantMargin(), element4);
            TSXMLUtilities.writeDoubleAttribute("bottom", tSGraphTailor.getOriginalBottomConstantMargin(), element4);
        } else {
            TSXMLUtilities.writeDoubleAttribute("left", tSGraphTailor.getLeftConstantMargin(), element4);
            TSXMLUtilities.writeDoubleAttribute("right", tSGraphTailor.getRightConstantMargin(), element4);
            TSXMLUtilities.writeDoubleAttribute("top", tSGraphTailor.getTopConstantMargin(), element4);
            TSXMLUtilities.writeDoubleAttribute("bottom", tSGraphTailor.getBottomConstantMargin(), element4);
        }
    }
}

