/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.util.command;

import com.tomsawyer.util.command.TSCommandState;
import com.tomsawyer.util.command.fc;
import java.util.List;

public class TSCommand {
    public static final TSCommandState CREATED = new TSCommandState("created");
    public static final TSCommandState DONE = new TSCommandState("done");
    public static final TSCommandState UNDONE = new TSCommandState("undone");
    public static final TSCommandState FINALIZED = new TSCommandState("finalized");
    TSCommandState state = CREATED;
    boolean addToUndoStack = this.isAddToUndoStackByDefault();
    boolean coalesced;

    public final void execute() throws RuntimeException {
        if (this.state != CREATED) {
            throw new IllegalStateException(this.toString());
        }
        this.init();
        try {
            this.doAction();
            this.state = DONE;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new fc(throwable, this.toString());
        }
    }

    public final void undo() throws RuntimeException {
        if (this.state != DONE) {
            throw new IllegalStateException(this.toString());
        }
        try {
            this.undoAction();
            this.state = UNDONE;
        }
        catch (Throwable throwable) {
            throw new fc(throwable, this.toString());
        }
    }

    public final void redo() throws RuntimeException {
        if (this.state != UNDONE) {
            throw new IllegalStateException(this.toString());
        }
        try {
            this.redoAction();
            this.state = DONE;
        }
        catch (Throwable throwable) {
            throw new fc(throwable, this.toString());
        }
    }

    protected void doAction() throws Throwable {
    }

    protected void undoAction() throws Throwable {
    }

    protected void redoAction() throws Throwable {
        this.doAction();
    }

    protected void init() {
    }

    public TSCommandState getState() {
        return this.state;
    }

    void setState(TSCommandState tSCommandState) {
        this.state = tSCommandState;
    }

    public List getAffectedObjects() {
        return null;
    }

    public boolean isAddToUndoStack() {
        return this.addToUndoStack;
    }

    public void setAddToUndoStack(boolean bl) {
        this.addToUndoStack = bl;
    }

    public boolean isAddToUndoStackByDefault() {
        return true;
    }

    public boolean isCoalesced() {
        return this.coalesced;
    }

    public void setCoalesced(boolean bl) {
        this.coalesced = bl;
    }

    public boolean isOrderPreservedInCoalescing() {
        return false;
    }

    protected void doCleanup() {
    }

    protected void undoCleanup() {
    }

    public void internalDoCleanup() {
        this.doCleanup();
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.state + "]";
    }
}

