/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.util;

import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class TSSystem {
    public static String eol = System.getProperty("line.separator");
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_ERROR = 1;
    public static final int DEBUG_STATUS = 2;
    public static final int DEBUG = 3;
    public static final int DEBUG_TEMP = 4;
    public static final String[] VALID_PROTOCOLS = new String[]{"http", "https", "ftp", "chrome", "gopher", "about", "file"};
    static String defaultURLProtocol = "http://";
    public static String TOOLTIP_PLACEHOLDER = "%TOOLTIP%";
    static String tooltipFormat = "<html>" + TOOLTIP_PLACEHOLDER + "</html>";
    private static int level = 0;
    static boolean isApplet = false;
    private static int maxGMFFileSize = 18000000;
    private static boolean licenseCheckVerbose = false;

    public static void setDebugLevel(int n) {
        level = n;
    }

    public static int getDebugLevel() {
        return level;
    }

    public static void debug(Object object, int n, String string) {
        TSSystem.debug(n, object.getClass().getName() + ": " + string);
    }

    public static void debug(String string) {
        TSSystem.debug(4, string);
    }

    public static void debug(int n, String string) {
        if (n <= level) {
            System.out.println(string);
        }
    }

    public static void fail(String string) {
        Throwable throwable = new Throwable(string);
        throwable.printStackTrace();
        System.exit(1);
    }

    public static void tsAssert(boolean bl) {
        if (!bl) {
            throw new RuntimeException("assertion failed");
        }
    }

    public static void tsAssert(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException(string);
        }
    }

    public static void check(boolean bl) {
        if (!bl) {
            TSSystem.fail("Checkpoint failed");
        }
    }

    public static void check(boolean bl, String string) {
        if (!bl) {
            TSSystem.fail(string);
        }
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        String string4 = new String(string);
        if (string2 == null) {
            return string4;
        }
        if (string3 == null) {
            string3 = "";
        }
        int n = string3.length();
        int n2 = string2.length();
        int n3 = 0;
        while ((n3 = string4.indexOf(string2, n3)) != -1) {
            string4 = string4.substring(0, n3) + string3 + string4.substring(n3 + n2);
            n3 += n;
        }
        return string4;
    }

    public static boolean isJava2() {
        return System.getProperty("java.version").charAt(2) >= '2';
    }

    public static boolean isJVM13() {
        return System.getProperty("java.version").charAt(2) == '3';
    }

    public static boolean isJVM13orAbove() {
        return System.getProperty("java.version").charAt(2) >= '3';
    }

    public static boolean isJVM14() {
        return System.getProperty("java.version").charAt(2) == '4';
    }

    public static boolean isJVM14orAbove() {
        return System.getProperty("java.version").charAt(2) >= '4';
    }

    public static String getToolTipFormat() {
        return tooltipFormat;
    }

    public static void setToolTipFormat(String string) {
        tooltipFormat = string;
    }

    public static boolean isApplet() {
        try {
            System.getProperty("java.class.path");
            System.getProperty("java.home");
            System.getProperty("user.dir");
            System.getProperty("user.home");
            System.getProperty("user.name");
        }
        catch (Throwable throwable) {
            return true;
        }
        return isApplet;
    }

    public static void setApplet(boolean bl) {
        isApplet = bl;
    }

    public static boolean hasFileReadAccess() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    public static boolean hasFileWriteAccess() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    public static boolean hasClipboardAccess() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkSystemClipboardAccess();
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    public static boolean hasPrinterAccess() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPrintJobAccess();
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    public static int getMaxGMFFileSize() {
        return maxGMFFileSize;
    }

    public static void setMaxGMFFileSize(int n) {
        maxGMFFileSize = n;
    }

    public static void setLicenseCheckVerbose(boolean bl) {
        licenseCheckVerbose = bl;
    }

    public static boolean isLicenseCheckVerbose() {
        return licenseCheckVerbose;
    }

    public static URL getValidatedURL(String string) {
        URL uRL = null;
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            for (int i = 0; i < VALID_PROTOCOLS.length; ++i) {
                if (!string.startsWith(VALID_PROTOCOLS[i])) continue;
                bl = true;
                break;
            }
            String string2 = !bl && string.indexOf("://") == -1 ? TSSystem.getDefaultURLProtocol() + string : new String(string);
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static void setDefaultURLProtocol(String string) {
        defaultURLProtocol = string;
    }

    public static String getDefaultURLProtocol() {
        return defaultURLProtocol;
    }

    public static boolean equals(Object object, Object object2) {
        boolean bl = false;
        if (object == null && object2 == null) {
            bl = true;
        } else if (object != null) {
            bl = object.equals(object2);
        } else if (object2 != null) {
            bl = object2.equals(object);
        }
        return bl;
    }
}

