/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.graph;

import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSFindChildParent;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.de;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.graph.h7;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f0;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSNode
extends TSGraphMember {
    public static final int IN_EDGES = 1;
    public static final int OUT_EDGES = 2;
    public static final int IN_AND_OUT_EDGES = 3;
    public static final int CONNECTED_EDGES = 1;
    public static final int DISCONNECTED_EDGES = 2;
    public static final int ALL_EDGES = 3;
    List incoming;
    List outgoing;
    List disconnected;
    boolean visited;
    f0 listLocation = null;
    public static final int TYPE = 0;

    protected TSNode() {
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.incoming = new Vector();
        this.outgoing = new Vector();
        this.disconnected = new Vector();
        this.visited = false;
    }

    public Object clone(boolean bl) {
        TSNode tSNode = (TSNode)super.clone(bl);
        tSNode.setNodeListLocation(null);
        return tSNode;
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        TSNode tSNode = (TSNode)object;
        this.visited = tSNode.visited;
    }

    protected void createMapping(Map map, Map map2) {
        if (this.getUtilityObject() instanceof TSNode) {
            TSNode tSNode = (TSNode)this.getUtilityObject();
            TSGraph.map(this, tSNode, map, map2);
        }
    }

    public int degree() {
        return this.inDegree() + this.outDegree();
    }

    public List disconnectedEdges() {
        return this.disconnected;
    }

    public List inEdges() {
        return this.incoming;
    }

    public int inDegree() {
        int n = 0;
        if (this.incoming != null) {
            n = this.incoming.size();
        }
        return n;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public boolean isRoot() {
        return this.inDegree() == 0;
    }

    public List outEdges() {
        return this.outgoing;
    }

    public int outDegree() {
        int n = 0;
        if (this.outgoing != null) {
            n = this.outgoing.size();
        }
        return n;
    }

    public void setVisited(boolean bl) {
        this.visited = bl;
    }

    protected String getAttributeString() {
        return super.getAttributeString() + TSSystem.eol + "\tindegree = " + this.inDegree() + TSSystem.eol + "\toutdegree = " + this.outDegree() + TSSystem.eol + "\tdisconnecteddegree = " + this.disconnected.size();
    }

    void setNodeListLocation(f0 f02) {
        this.listLocation = f02;
    }

    f0 getNodeListLocation() {
        return this.listLocation;
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        TSSystem.tsAssert(!this.isOwned());
        TSSystem.tsAssert(this.degree() == 0);
        this.detachDisconnected();
        if (tSGraphObject instanceof TSGraph) {
            ((TSGraph)tSGraphObject).fireEvent(new TSGraphChangeEvent(128L, new TSGraphChangeEventData(this, tSGraphObject, null)));
        }
        super.onDiscard(tSGraphObject);
    }

    void detachDisconnected() {
        if (this.disconnected != null) {
            Vector vector = new Vector();
            vector.addAll(this.disconnected);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                TSEdge tSEdge = (TSEdge)iterator.next();
                tSEdge.dispose();
            }
        }
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        TSSystem.tsAssert(!this.isOwned());
        TSSystem.tsAssert(tSGraphObject != null);
        TSSystem.tsAssert(this.degree() == 0);
        super.onInsert(tSGraphObject);
        this.connectEdges(tSGraphObject);
        if (tSGraphObject instanceof TSGraph) {
            TSGraph tSGraph = (TSGraph)tSGraphObject;
            TSGraphManager tSGraphManager = tSGraph.getOwnerGraphManager();
            if (tSGraphManager != null && !tSGraph.isHideGraph()) {
                Vector<TSGraph> vector = new Vector<TSGraph>();
                TSGraph tSGraph2 = this.getChildGraph();
                if (tSGraph2 != null) {
                    tSGraph2.buildAllChildGraphList(vector);
                    vector.add(tSGraph2);
                }
                Iterator iterator = vector.iterator();
                List list = tSGraphManager.graphs(true);
                while (iterator.hasNext()) {
                    TSGraph tSGraph3 = (TSGraph)iterator.next();
                    if (list.contains(tSGraph3)) continue;
                    if (tSGraph3.getOwner() != null && tSGraph3.isOwned()) {
                        TSGraphManager tSGraphManager2 = (TSGraphManager)tSGraph3.getOwner();
                        tSGraphManager2.remove(tSGraph3);
                    }
                    tSGraphManager.insert(tSGraph3);
                }
            }
            ((TSGraph)tSGraphObject).fireEvent(new TSGraphChangeEvent(2L, new TSGraphChangeEventData(this, null, tSGraphObject)));
        }
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        TSSystem.tsAssert(this.isOwned());
        TSSystem.tsAssert(tSGraphObject != null);
        TSSystem.tsAssert(tSGraphObject == this.getOwner());
        this.disconnectEdges();
        if (tSGraphObject instanceof TSGraph) {
            ((TSGraph)tSGraphObject).fireEvent(new TSGraphChangeEvent(16L, new TSGraphChangeEventData(this, tSGraphObject, null)));
        }
        super.onRemove(tSGraphObject);
    }

    void disconnectEdges() {
        this.disconnectIntergraphEdges();
        this.disconnectInEdges();
        this.disconnectOutEdges();
    }

    void disconnectInEdges() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.incoming);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            TSEdge tSEdge = (TSEdge)iterator.next();
            tSEdge.disconnect();
        }
    }

    void disconnectOutEdges() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.outgoing);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            TSEdge tSEdge = (TSEdge)iterator.next();
            tSEdge.disconnect();
        }
    }

    void disconnectIntergraphEdges() {
        if (this.disconnected.size() > 0) {
            Vector vector = new Vector();
            vector.addAll(this.disconnected);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                TSEdge tSEdge = (TSEdge)iterator.next();
                if (tSEdge.isIntergraphEdge()) continue;
                iterator.remove();
            }
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                ((TSEdge)iterator.next()).disconnect();
            }
        }
    }

    void connectEdges(TSGraphObject tSGraphObject) {
        if (!this.disconnected.isEmpty()) {
            Vector vector = new Vector();
            vector.addAll(this.disconnected);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                TSEdge tSEdge = (TSEdge)iterator.next();
                if (!tSEdge.isIntergraphEdge() && !tSEdge.isAttachableTo(tSGraphObject)) continue;
                tSEdge.connect();
            }
        }
    }

    public List buildIncidentIntergraphEdgeList(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Vector<TSEdge> vector = new Vector<TSEdge>();
        TSGraphManager tSGraphManager = null;
        if (this.getOwnerGraph() != null) {
            tSGraphManager = this.getOwnerGraph().getOwnerGraphManager();
        } else if (this.getChildGraph() != null) {
            tSGraphManager = this.getChildGraph().getOwnerGraphManager();
        } else {
            if (bl) {
                Iterator iterator = this.disconnected.iterator();
                while (iterator.hasNext()) {
                    TSEdge tSEdge = (TSEdge)iterator.next();
                    if (!bl2 && !tSEdge.isViewable() || !bl4 && tSEdge.isMetaEdge()) continue;
                    vector.add(tSEdge);
                }
            }
            return vector;
        }
        if (tSGraphManager != null && !tSGraphManager.intergraphEdges().isEmpty()) {
            Iterator iterator = tSGraphManager.intergraphEdges().iterator();
            while (iterator.hasNext()) {
                TSEdge tSEdge = (TSEdge)iterator.next();
                if (!tSEdge.isValid() || !bl2 && !tSEdge.isViewable() || !bl4 && tSEdge.isMetaEdge()) continue;
                TSNode tSNode = tSEdge.getSourceNode();
                TSNode tSNode2 = tSEdge.getTargetNode();
                boolean bl5 = tSNode == this;
                boolean bl6 = tSNode2 == this;
                boolean bl7 = this.isAncestorOf(tSNode);
                boolean bl8 = this.isAncestorOf(tSNode2);
                if (bl5 || bl6) {
                    if (!bl) continue;
                    vector.add(tSEdge);
                    continue;
                }
                if (!bl7 && !bl8) continue;
                if (bl7 && bl8) {
                    if (!bl3) continue;
                    vector.add(tSEdge);
                    continue;
                }
                vector.add(tSEdge);
            }
        }
        return vector;
    }

    public List buildInEdges(int n) {
        Object object;
        Object object2;
        de de2 = new de();
        de2.addAll(this.inEdges());
        if (this.getOwnerGraph().getOwnerGraphManager() != null) {
            object2 = this.getOwnerGraph().getOwnerGraphManager().intergraphEdges().iterator();
            while (object2.hasNext()) {
                object = (TSEdge)object2.next();
                if (((TSEdge)object).getTargetNode() != this) continue;
                de2.add(object);
            }
        }
        object2 = new de();
        object = de2.iterator();
        while (object.hasNext()) {
            TSEdge tSEdge = (TSEdge)object.next();
            if ((n & 2) != 0 && tSEdge.isIntergraphEdge()) {
                object2.add(tSEdge);
            }
            if ((n & 1) != 0 && !tSEdge.isIntergraphEdge()) {
                object2.add(tSEdge);
            }
            if ((n & 2) != 0 || (n & 1) != 0) continue;
            object2.add(tSEdge);
        }
        return object2;
    }

    public List buildOutEdges(int n) {
        Object object;
        Object object2;
        de de2 = new de();
        de2.addAll(this.outEdges());
        if (this.getOwnerGraph().getOwnerGraphManager() != null) {
            object2 = this.getOwnerGraph().getOwnerGraphManager().intergraphEdges().iterator();
            while (object2.hasNext()) {
                object = (TSEdge)object2.next();
                if (((TSEdge)object).getSourceNode() != this) continue;
                de2.add(object);
            }
        }
        object2 = new de();
        object = de2.iterator();
        while (object.hasNext()) {
            TSEdge tSEdge = (TSEdge)object.next();
            if ((n & 2) != 0 && tSEdge.isIntergraphEdge()) {
                object2.add(tSEdge);
            }
            if ((n & 1) != 0 && !tSEdge.isIntergraphEdge()) {
                object2.add(tSEdge);
            }
            if ((n & 2) != 0 || (n & 1) != 0) continue;
            object2.add(tSEdge);
        }
        return object2;
    }

    public List buildInOutEdges(int n) {
        de de2 = new de();
        de2.addAll(this.buildInEdges(n));
        de2.addAll(this.buildOutEdges(n));
        return de2;
    }

    public void onEdgeBecomesDisconnected(TSEdge tSEdge) {
        TSSystem.tsAssert(tSEdge != null);
        if (tSEdge.isPathEdge() == this.isPathNode()) {
            TSSystem.tsAssert(tSEdge.isConnected());
            TSSystem.tsAssert(tSEdge.getSourceNode() == this && this.outgoing.contains(tSEdge) || tSEdge.getTargetNode() == this && this.incoming.contains(tSEdge));
            if (tSEdge.getSourceNode() == this) {
                this.outgoing.remove(tSEdge);
            }
            if (tSEdge.getTargetNode() == this) {
                this.incoming.remove(tSEdge);
            }
            this.disconnected.add(tSEdge);
        }
    }

    public void onEdgeBecomesConnected(TSEdge tSEdge) {
        TSSystem.tsAssert(tSEdge != null);
        TSSystem.tsAssert(tSEdge.getSourceNode() == this || tSEdge.getTargetNode() == this);
        if (tSEdge.isPathEdge() == this.isPathNode()) {
            TSSystem.tsAssert(!tSEdge.isConnected());
            TSSystem.tsAssert(this.disconnected.contains(tSEdge));
            this.disconnected.remove(tSEdge);
            if (tSEdge.getSourceNode() == this) {
                this.outgoing.add(tSEdge);
            }
            if (tSEdge.getTargetNode() == this) {
                this.incoming.add(tSEdge);
            }
        }
    }

    void onAttachIncomingEdge(TSEdge tSEdge) {
        TSSystem.tsAssert(tSEdge != null);
        TSSystem.tsAssert(tSEdge.getSourceNode() == this || tSEdge.getTargetNode() == this);
        if (tSEdge.isPathEdge() == this.isPathNode()) {
            if (tSEdge.isConnected()) {
                TSSystem.tsAssert(tSEdge.getTargetNode() == this, "Wrong target node");
                TSSystem.tsAssert(!this.incoming.contains(tSEdge), "Multiple in-attachment");
                this.incoming.add(tSEdge);
            } else if (!this.disconnected.contains(tSEdge)) {
                this.disconnected.add(tSEdge);
            }
        }
    }

    void onAttachOutgoingEdge(TSEdge tSEdge) {
        TSSystem.tsAssert(tSEdge != null);
        TSSystem.tsAssert(tSEdge.getSourceNode() == this || tSEdge.getTargetNode() == this);
        if (tSEdge.isPathEdge() == this.isPathNode()) {
            if (tSEdge.isConnected()) {
                TSSystem.tsAssert(tSEdge.getSourceNode() == this, "Wrong source node");
                this.outgoing.add(tSEdge);
            } else if (!this.disconnected.contains(tSEdge)) {
                this.disconnected.add(tSEdge);
            }
        }
    }

    void onDetachIncomingEdge(TSEdge tSEdge) {
        TSSystem.tsAssert(tSEdge != null);
        TSSystem.tsAssert(tSEdge.getTargetNode() == this);
        if (tSEdge.isPathEdge() == this.isPathNode()) {
            if (tSEdge.isConnected()) {
                TSSystem.tsAssert(this.incoming.contains(tSEdge));
                this.incoming.remove(tSEdge);
            } else if (tSEdge.getSourceNode() != this) {
                this.disconnected.remove(tSEdge);
            }
        }
    }

    void onDetachOutgoingEdge(TSEdge tSEdge) {
        TSSystem.tsAssert(tSEdge != null);
        TSSystem.tsAssert(tSEdge.getSourceNode() == this);
        if (tSEdge.isPathEdge() == this.isPathNode()) {
            if (tSEdge.isConnected()) {
                TSSystem.tsAssert(this.outgoing.contains(tSEdge));
                this.outgoing.remove(tSEdge);
            } else if (tSEdge.getTargetNode() != this) {
                this.disconnected.remove(tSEdge);
            }
        }
    }

    public int findType(int n) {
        return n;
    }

    public void findChildren(List list, List list2, long l) {
        if (this.getOwnerGraph() != null && (list != null || list2 != null)) {
            this.findChildrenAndOrParents(this.findType(1), list, list2, l);
        }
    }

    public void findParents(List list, List list2, long l) {
        if (this.getOwnerGraph() != null && (list != null || list2 != null)) {
            this.findChildrenAndOrParents(this.findType(2), list, list2, l);
        }
    }

    public void findNeighbors(List list, List list2, long l) {
        if (this.getOwnerGraph() != null && (list != null || list2 != null)) {
            this.findChildrenAndOrParents(this.findType(3), list, list2, l);
        }
    }

    void findChildrenAndOrParents(int n, List list, List list2, long l) {
        TSGraph tSGraph = (TSGraph)this.getOwner();
        if (tSGraph != null && (list != null || list2 != null)) {
            TSFindChildParent tSFindChildParent = new TSFindChildParent(tSGraph, this, list, list2, l, null, n);
            tSFindChildParent.run();
        }
    }

    public void setChildGraph(TSGraph tSGraph) {
        TSGraph tSGraph2 = this.getChildGraph();
        super.setChildGraph(tSGraph);
        long l = 8192L;
        if (this.getChildGraph() == null) {
            l = 32768L;
        }
        if (this.getOwnerGraph() != null && tSGraph2 != this.getChildGraph()) {
            this.getOwnerGraph().fireEvent(new TSGraphChangeEvent(l, new TSGraphChangeEventData(this, tSGraph2, this.getChildGraph())));
        }
    }

    public boolean isPathNode() {
        return false;
    }

    protected void finalize() {
        if (!this.isOwned()) {
            this.detachDisconnected();
        }
        super.finalize();
    }

    public void dispose() {
        if (this.isOwned()) {
            ((TSGraph)this.getOwner()).discard(this);
        } else if (!this.isDiscarded()) {
            this.onDiscard(this.getOwner());
        }
    }

    public long assignIDs(TSGraphObjectTable tSGraphObjectTable, long l) {
        if (l >= 0L) {
            tSGraphObjectTable.put(l++, this);
        } else {
            tSGraphObjectTable.put(this.getID(), this);
        }
        return l;
    }

    public int getType() {
        return 0;
    }

    void duplicateTopology(TSNode tSNode) {
    }

    public TSEdge inEdge() {
        if (this.inDegree() == 0) {
            return null;
        }
        return (TSEdge)this.inEdges().get(0);
    }

    public TSEdge outEdge() {
        if (this.outDegree() == 0) {
            return null;
        }
        return (TSEdge)this.outEdges().get(0);
    }

    public TSEdge disconnectedInEdge() {
        TSEdge tSEdge = null;
        Iterator iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext() && tSEdge == null) {
            tSEdge = (TSEdge)iterator.next();
            if (tSEdge.getTargetNode() == this) continue;
            tSEdge = null;
        }
        return tSEdge;
    }

    public TSEdge disconnectedOutEdge() {
        TSEdge tSEdge = null;
        Iterator iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext() && tSEdge == null) {
            tSEdge = (TSEdge)iterator.next();
            if (tSEdge.getSourceNode() == this) continue;
            tSEdge = null;
        }
        return tSEdge;
    }

    public TSGraph getOwnerGraph() {
        if (this.owner == null) {
            return null;
        }
        if (this.owner instanceof TSGraph) {
            return (TSGraph)this.owner;
        }
        return (TSGraph)this.owner.getOwner();
    }

    public void setTag(Object object) {
        Object object2 = this.getTag();
        super.setTag(object);
        if (!TSSystem.equals(object2, object) && this.getOwnerGraph() != null && !this.isPathNode()) {
            this.getOwnerGraph().fireEvent(new TSGraphChangeEvent(1024L, new TSGraphChangeEventData(this, object2, this.getTag())));
        }
    }

    public void markIncidentEdgesTraversed(boolean bl, int n, int n2) {
        Iterator iterator;
        boolean bl2;
        boolean bl3 = n == 1 || n == 3;
        boolean bl4 = bl2 = n == 2 || n == 3;
        if (n2 == 1 || n2 == 3) {
            if (bl3) {
                iterator = this.incoming.iterator();
                while (iterator.hasNext()) {
                    ((TSEdge)iterator.next()).setTraversed(bl);
                }
            }
            if (bl2) {
                iterator = this.outgoing.iterator();
                while (iterator.hasNext()) {
                    ((TSEdge)iterator.next()).setTraversed(bl);
                }
            }
        }
        if (n2 == 2 || n2 == 3) {
            iterator = this.disconnected.iterator();
            while (iterator.hasNext()) {
                TSEdge tSEdge = (TSEdge)iterator.next();
                if (tSEdge.getTargetNode() == this && bl3) {
                    tSEdge.setTraversed(bl);
                }
                if (tSEdge.getSourceNode() != this || !bl2) continue;
                tSEdge.setTraversed(bl);
            }
        }
    }

    public Iterator inOutEdgeIterator() {
        return new h7(this);
    }
}

