/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.graph;

import com.tomsawyer.graph.TSChildGraphForest;
import com.tomsawyer.graph.TSChildGraphForestEdge;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.cw;
import com.tomsawyer.graph.de;
import com.tomsawyer.graph.event.TSEventManager;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.df;
import com.tomsawyer.util.f0;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSGraphManager
extends TSGraphObject {
    static final int MODIFIED = 16;
    private de graphSet;
    private TSGraph intergraph;
    private TSChildGraphForest childGraphForest;
    public static final int NORMAL_EDGES = 1;
    public static final int INTERGRAPH_EDGES = 2;
    TSEventManager eventManager;

    protected void initGraphObject() {
        super.initGraphObject();
        this.graphSet = new de();
        this.intergraph = null;
        this.childGraphForest = null;
        this.setModified(false);
        this.eventManager = this.newEventManager();
        this.eventManager.registerDiscardableEventSource(this);
    }

    public TSEventManager newEventManager() {
        return new TSEventManager();
    }

    public Object getParentEventSource() {
        return null;
    }

    public void dispose() {
        this.checkInvariants();
        if (!this.isDiscarded()) {
            this.emptyTopology();
            this.setDiscarded(true);
        }
    }

    public Object clone(boolean bl) {
        TSGraphManager tSGraphManager = (TSGraphManager)super.clone(true);
        tSGraphManager.copy(this, true, null, null);
        return tSGraphManager;
    }

    public void copy(Object object, boolean bl, Map map, Map map2) {
        TSSystem.tsAssert(this != object);
        TSGraphManager tSGraphManager = (TSGraphManager)object;
        if (!bl) {
            this.initGraphObject();
        }
        this.copy(tSGraphManager, bl);
        TSSystem.tsAssert(!tSGraphManager.utilityObjectInUse());
        tSGraphManager.setUtilityObject(this);
        TSSystem.tsAssert(tSGraphManager.levelNumber() == this.levelNumber() || !bl);
        this.duplicateTopology(tSGraphManager, bl, map, map2);
        tSGraphManager.setUtilityObject(null);
        this.checkInvariants();
    }

    protected void postTopologyDuplicate(TSGraphManager tSGraphManager) {
    }

    void createMapping(Map map, Map map2) {
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            tSGraph.createMapping(map, map2);
        }
    }

    void duplicateTopology(TSGraphManager tSGraphManager, boolean bl, Map map, Map map2) {
        TSSystem.tsAssert(this != tSGraphManager);
        TSSystem.tsAssert(tSGraphManager.levelNumber() == this.levelNumber() || !bl);
        Iterator iterator = tSGraphManager.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            this.duplicateGraph(tSGraph, bl);
        }
        this.duplicateChildGraphForest(tSGraphManager);
        if (tSGraphManager.queryIntergraph() != null) {
            this.duplicateGraph(tSGraphManager.queryIntergraph(), bl);
        }
        this.duplicateChildGraphForest(tSGraphManager);
        if (map != null || map2 != null) {
            tSGraphManager.createMapping(map, map2);
        }
        this.postTopologyDuplicate(tSGraphManager);
        tSGraphManager.nullifyUtilityObject();
    }

    protected TSGraph duplicateGraph(TSGraph tSGraph, boolean bl) {
        TSGraph tSGraph2;
        if (tSGraph.isIntergraph()) {
            tSGraph2 = this.intergraph();
            tSGraph2.copy(tSGraph, bl, null, null, false, true);
            tSGraph.setUtilityObject(tSGraph2);
        } else {
            tSGraph2 = (TSGraph)tSGraph.getUtilityObject();
            if (tSGraph2 == null) {
                tSGraph2 = this.getDuplicateClonedGraph(tSGraph, bl);
            }
            if (!tSGraph2.isOwned() && this.insert(tSGraph2) != null && !bl) {
                tSGraph2.duplicateTopology(tSGraph, bl, true, false);
            }
        }
        if (tSGraph2.getOwnerGraphManager() == this && !bl) {
            tSGraph2.duplicateTopology(tSGraph, bl, false, true);
            tSGraph2.copy(tSGraph, bl);
        }
        return tSGraph2;
    }

    public TSGraph getDuplicateClonedGraph(TSGraph tSGraph, boolean bl) {
        TSGraph tSGraph2 = null;
        if (tSGraph != null) {
            if (tSGraph.getUtilityObject() != null) {
                tSGraph2 = (TSGraph)tSGraph.getUtilityObject();
            } else {
                tSGraph2 = !bl ? this.newGraph(tSGraph.getType()) : (TSGraph)tSGraph.clone(true);
                tSGraph.setUtilityObject(tSGraph2);
            }
        }
        return tSGraph2;
    }

    public void duplicateChildGraphForest(TSGraphManager tSGraphManager) {
        Iterator iterator = tSGraphManager.getChildGraphForest().edges().iterator();
        while (iterator.hasNext()) {
            this.duplicateChildGraphForestEdge((TSChildGraphForestEdge)iterator.next());
        }
    }

    protected void duplicateChildGraphForestEdge(TSChildGraphForestEdge tSChildGraphForestEdge) {
        TSGraphMember tSGraphMember = tSChildGraphForestEdge.getGraphMember();
        TSGraph tSGraph = tSGraphMember.getChildGraph();
        TSGraphMember tSGraphMember2 = (TSGraphMember)tSGraphMember.getUtilityObject();
        if (tSGraphMember2 != null && tSGraphMember2.getChildGraph() == null) {
            TSGraph tSGraph2 = (TSGraph)tSGraph.getUtilityObject();
            tSGraphMember2.setChildGraph(tSGraph2);
        }
    }

    protected TSGraph newGraph() {
        return new TSGraph();
    }

    protected TSGraph newGraph(int n) {
        return new TSGraph();
    }

    protected TSGraph newIntergraph() {
        return new TSGraph();
    }

    protected TSGraph newIntergraph(int n) {
        return new TSGraph();
    }

    protected TSEdge newEdge() {
        return new TSEdge();
    }

    protected TSEdge newEdge(int n) {
        return new TSEdge();
    }

    protected TSChildGraphForest newChildGraphForest() {
        return new TSChildGraphForest();
    }

    public boolean canInsert(TSGraph tSGraph) {
        return tSGraph != null && !tSGraph.isOwned() && tSGraph.levelNumber() == this.levelNumber() && !tSGraph.isIntergraph();
    }

    public TSGraph addGraph() {
        TSGraph tSGraph = this.newGraph();
        return this.insert(tSGraph);
    }

    public TSGraph addGraph(int n) {
        TSGraph tSGraph = this.newGraph(n);
        return this.insert(tSGraph);
    }

    public TSGraph insert(TSGraph tSGraph) {
        TSSystem.tsAssert(this.canInsert(tSGraph));
        if (this.canInsert(tSGraph)) {
            tSGraph.setGraphListLocation(this.graphSet.b(tSGraph));
            tSGraph.onInsert(this);
            tSGraph.checkInvariants();
            this.checkInvariants();
            this.getChildGraphForest().actOnInsertGraph(tSGraph);
        } else {
            tSGraph = null;
        }
        return tSGraph;
    }

    public TSGraph remove(TSGraph tSGraph) {
        if (tSGraph != null && tSGraph.getOwnerGraphManager() == this && !tSGraph.isIntergraph()) {
            this.getChildGraphForest().actOnRemoveGraph(tSGraph);
            this.graphSet.c(tSGraph.getGraphListLocation());
            tSGraph.setGraphListLocation(null);
            tSGraph.onRemove(this);
            tSGraph.checkInvariants();
            this.checkInvariants();
        } else {
            tSGraph = null;
        }
        return tSGraph;
    }

    public void discard(TSGraph tSGraph) {
        if (tSGraph != null && tSGraph.getOwnerGraphManager() == this && !tSGraph.isIntergraph()) {
            tSGraph.emptyTopology();
            boolean bl = this.getEventManager().isFiringEvents();
            this.getEventManager().setFireEvents(false);
            this.remove(tSGraph);
            this.getEventManager().setFireEvents(bl);
            tSGraph.onDiscard(this);
            this.getChildGraphForest().actOnDiscardGraph(tSGraph);
            this.checkInvariants();
        }
    }

    public TSEdge addEdge(TSNode tSNode, TSNode tSNode2) {
        return this.addEdge(0, tSNode, tSNode2);
    }

    public TSEdge addEdge(int n, TSNode tSNode, TSNode tSNode2) {
        TSEdge tSEdge = null;
        if (tSNode != null && tSNode2 != null) {
            TSGraph tSGraph = tSNode.getOwnerGraph();
            TSGraph tSGraph2 = tSNode2.getOwnerGraph();
            if (tSGraph != null && tSGraph2 != null && tSGraph.getOwnerGraphManager() == this && tSGraph2.getOwnerGraphManager() == this) {
                if (tSGraph == tSGraph2 && !tSGraph.isIntergraph()) {
                    tSEdge = n == 0 ? tSGraph.addEdge(tSNode, tSNode2) : tSGraph.addEdge(n, tSNode, tSNode2);
                } else {
                    tSEdge = n == 0 ? this.newEdge() : this.newEdge(n);
                    tSEdge.setSourceNode(tSNode);
                    tSEdge.setTargetNode(tSNode2);
                    this.insert(tSEdge, tSNode, tSNode2);
                }
                this.checkInvariants();
            }
        }
        return tSEdge;
    }

    public void insert(TSEdge tSEdge) {
        this.insert(tSEdge, tSEdge.getSourceNode(), tSEdge.getTargetNode());
    }

    public void insert(TSEdge tSEdge, TSNode tSNode, TSNode tSNode2) {
        TSSystem.tsAssert(tSEdge != null && !tSEdge.isOwned() && tSNode != null && tSNode2 != null);
        if (tSEdge != null && tSNode != null && tSNode2 != null && !tSEdge.isOwned()) {
            TSGraph tSGraph = tSNode.getOwnerGraph();
            TSGraph tSGraph2 = tSNode2.getOwnerGraph();
            if (tSGraph != null && tSGraph2 != null) {
                if (tSGraph.getOwnerGraphManager() == this && tSGraph2.getOwnerGraphManager() == this) {
                    tSEdge.setSourceNode(tSNode);
                    tSEdge.setTargetNode(tSNode2);
                    if (tSGraph != tSGraph2) {
                        this.intergraph().insert(tSEdge);
                        this.checkInvariants();
                    } else {
                        tSGraph.insert(tSEdge);
                        this.checkInvariants();
                    }
                } else {
                    tSEdge = null;
                }
            } else {
                tSEdge = null;
            }
        } else {
            tSEdge = null;
        }
    }

    public void discard(TSEdge tSEdge) {
        if (tSEdge != null && tSEdge.isOwned() && tSEdge.getOwnerGraph().getOwnerGraphManager() == this) {
            TSSystem.tsAssert(tSEdge.getOwnerGraph().isIntergraph() == tSEdge.isIntergraphEdge());
            tSEdge.getOwnerGraph().discard(tSEdge);
            this.checkInvariants();
        }
    }

    public TSEdge remove(TSEdge tSEdge) {
        if (tSEdge != null && tSEdge.isOwned() && tSEdge.getOwnerGraph().getOwnerGraphManager() == this) {
            TSSystem.tsAssert(tSEdge.getOwnerGraph().isIntergraph() == tSEdge.isIntergraphEdge());
            tSEdge.getOwnerGraph().remove(tSEdge);
            this.checkInvariants();
        } else {
            tSEdge = null;
        }
        return tSEdge;
    }

    public void emptyTopology() {
        TSGraph tSGraph;
        if (this.queryIntergraph() != null) {
            this.queryIntergraph().emptyTopology();
            this.intergraph.setOwned(false);
            this.intergraph = null;
        }
        while ((tSGraph = this.firstGraph()) != null) {
            this.discard(tSGraph);
        }
        this.getChildGraphForest().emptyTopology();
    }

    public TSGraph getCommonOwnerGraph(TSEdge tSEdge) {
        TSNode tSNode = tSEdge.getSourceNode();
        TSNode tSNode2 = tSEdge.getTargetNode();
        if (tSNode != null && tSNode.isOwned() && tSNode2 != null && tSNode2.isOwned()) {
            return this.getCommonOwnerGraph(tSNode.getOwnerGraph(), tSNode2.getOwnerGraph());
        }
        return null;
    }

    public TSGraph getCommonOwnerGraph(TSGraph tSGraph, TSGraph tSGraph2) {
        TSGraph tSGraph3;
        if (tSGraph == null || tSGraph2 == null) {
            return null;
        }
        if (tSGraph == tSGraph2) {
            return tSGraph;
        }
        Vector vector = new Vector();
        if (tSGraph.getOwnerGraphManager() != tSGraph2.getOwnerGraphManager()) {
            if (tSGraph.getOwnerGraphManager() != null) {
                vector.addAll(tSGraph.getOwnerGraphManager().graphSet);
            }
            if (tSGraph2.getOwnerGraphManager() != null) {
                vector.addAll(tSGraph2.getOwnerGraphManager().graphSet);
            }
        } else if (tSGraph.getOwnerGraphManager() != null) {
            vector.addAll(tSGraph.getOwnerGraphManager().graphSet);
        }
        boolean[] blArray = new boolean[vector.size()];
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            tSGraph3 = (TSGraph)iterator.next();
            blArray[n++] = tSGraph3.isMarked();
            tSGraph3.setMarked(false);
        }
        tSGraph3 = tSGraph;
        while (tSGraph3 != null) {
            tSGraph3.setMarked(true);
            if (tSGraph3.getParent() != null && tSGraph3.getParent().isOwned()) {
                tSGraph3 = tSGraph3.getParent().getTransformGraph();
                continue;
            }
            tSGraph3 = null;
        }
        TSGraph tSGraph4 = tSGraph2;
        while (tSGraph4 != null && !tSGraph4.isMarked()) {
            if (tSGraph4.getParent() != null && tSGraph4.getParent().isOwned()) {
                tSGraph4 = tSGraph4.getParent().getTransformGraph();
                continue;
            }
            tSGraph4 = null;
        }
        iterator = vector.iterator();
        n = 0;
        while (iterator.hasNext()) {
            TSGraph tSGraph5 = (TSGraph)iterator.next();
            tSGraph5.setMarked(blArray[n++]);
        }
        return tSGraph4;
    }

    public TSGraph getCommonOwnerGraph(TSGraphMember tSGraphMember, TSGraphMember tSGraphMember2) {
        TSGraph tSGraph;
        if (tSGraphMember == null || !tSGraphMember.isOwned() || tSGraphMember2 == null || !tSGraphMember2.isOwned()) {
            return null;
        }
        TSGraphMember tSGraphMember3 = tSGraphMember;
        df df2 = new df();
        while ((tSGraph = tSGraphMember3.getTransformGraph()) != null) {
            df2.add(tSGraph);
            tSGraphMember3 = tSGraph.getParent();
            if (tSGraphMember3 != null && tSGraphMember3.isOwned()) continue;
        }
        tSGraphMember3 = tSGraphMember2;
        while (tSGraphMember3 != null && tSGraphMember3.isOwned() && !df2.contains(tSGraphMember3.getTransformGraph())) {
            tSGraph = tSGraphMember3.getTransformGraph();
            if (tSGraph != null) {
                tSGraphMember3 = tSGraph.getParent();
                continue;
            }
            return null;
        }
        if (tSGraphMember3 == null || !tSGraphMember3.isOwned()) {
            return null;
        }
        return tSGraphMember3.getTransformGraph();
    }

    public TSGraph firstGraph() {
        f0 f02 = this.graphSet.a();
        TSGraph tSGraph = f02 != null ? (TSGraph)f02.b() : null;
        return tSGraph;
    }

    public TSGraph lastGraph() {
        f0 f02 = this.graphSet.b();
        TSGraph tSGraph = f02 != null ? (TSGraph)f02.b() : null;
        return tSGraph;
    }

    public boolean utilityObjectInUse() {
        boolean bl = super.utilityObjectInUse();
        Iterator iterator = this.graphSet.iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSGraph)iterator.next()).utilityObjectInUse();
        }
        if (!bl && this.queryIntergraph() != null) {
            bl = this.queryIntergraph().utilityObjectInUse();
        }
        return bl;
    }

    public void nullifyUtilityObject() {
        super.nullifyUtilityObject();
        Iterator iterator = this.graphSet.iterator();
        while (iterator.hasNext()) {
            ((TSGraph)iterator.next()).nullifyUtilityObject();
        }
        if (this.queryIntergraph() != null) {
            this.queryIntergraph().nullifyUtilityObject();
        }
    }

    public void setAllMarked(boolean bl) {
        super.setAllMarked(bl);
        Iterator iterator = this.graphSet.iterator();
        while (iterator.hasNext()) {
            ((TSGraph)iterator.next()).setAllMarked(bl);
        }
        if (this.queryIntergraph() != null) {
            this.queryIntergraph().setAllMarked(bl);
        }
    }

    public boolean hasMarkedObject() {
        Iterator iterator = this.graphSet.iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            if (!tSGraph.hasMarkedObject()) continue;
            return true;
        }
        return this.queryIntergraph() != null && this.queryIntergraph().hasMarkedObject();
    }

    public void setAllNodesVisited(boolean bl) {
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            tSGraph.setAllNodesVisited(bl);
        }
    }

    public boolean hasVisitedNodes() {
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            if (!tSGraph.hasVisitedNodes()) continue;
            return true;
        }
        return false;
    }

    public void setAllEdgesTraversed(boolean bl) {
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            tSGraph.setAllEdgesTraversed(bl);
        }
    }

    public boolean hasTraversedEdges() {
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            if (!tSGraph.hasTraversedEdges()) continue;
            return true;
        }
        return false;
    }

    public boolean userObjectInUse() {
        boolean bl = super.userObjectInUse();
        Iterator iterator = this.graphSet.iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSGraph)iterator.next()).userObjectInUse();
        }
        if (!bl && this.queryIntergraph() != null) {
            bl = this.queryIntergraph().userObjectInUse();
        }
        return bl;
    }

    public void nullifyUserObject() {
        super.nullifyUserObject();
        Iterator iterator = this.graphSet.iterator();
        while (iterator.hasNext()) {
            ((TSGraph)iterator.next()).nullifyUserObject();
        }
        if (this.queryIntergraph() != null) {
            this.queryIntergraph().nullifyUserObject();
        }
    }

    public boolean contains(TSGraph tSGraph) {
        TSSystem.tsAssert(tSGraph == null || tSGraph.isOwned());
        return tSGraph != null && tSGraph.isOwned() && tSGraph.getOwnerGraphManager() == this && !tSGraph.isIntergraph();
    }

    public long assignIDs(TSGraphObjectTable tSGraphObjectTable, long l) {
        if (l >= 0L) {
            tSGraphObjectTable.put(l++, this);
        } else {
            tSGraphObjectTable.put(this.getID(), this);
        }
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            l = tSGraph.assignIDs(tSGraphObjectTable, l);
        }
        if (this.queryIntergraph() != null) {
            l = this.queryIntergraph().assignIDs(tSGraphObjectTable, l);
        }
        return l;
    }

    protected List reachableGraphList() {
        return this.graphSet;
    }

    protected List reachableIntergraphEdgeList() {
        List list = new LinkedList();
        if (this.queryIntergraph() != null) {
            list = this.queryIntergraph().disconnectedEdges();
        }
        return list;
    }

    public void readGMF(Reader reader) throws IOException {
        this.readGMF(reader, true);
    }

    public void readGMF(Reader reader, boolean bl) throws IOException {
        this.emptyTopology();
        this.newGMFReader(reader).a(this, bl);
    }

    protected cw newGMFReader(Reader reader) {
        return new cw(reader);
    }

    public void checkInvariants() {
        super.checkInvariants();
        for (f0 f02 = this.graphSet.a(); f02 != null; f02 = f02.a()) {
            TSGraph tSGraph = (TSGraph)f02.b();
            tSGraph.checkInvariants();
            TSSystem.tsAssert(tSGraph.getOwnerGraphManager() == this);
            TSSystem.tsAssert(tSGraph.isOwned());
            TSSystem.tsAssert(!tSGraph.isIntergraph());
            TSSystem.tsAssert(tSGraph.getGraphListLocation() == f02);
        }
        if (this.queryIntergraph() != null) {
            this.queryIntergraph().checkInvariants();
            TSSystem.tsAssert(this.queryIntergraph().isIntergraph());
            TSSystem.tsAssert(this.queryIntergraph().isOwned());
            TSSystem.tsAssert(this.queryIntergraph().getOwnerGraphManager() == this);
            TSSystem.tsAssert(this.queryIntergraph().getGraphListLocation() == null);
        }
    }

    public TSGraph intergraph() {
        if (this.intergraph == null) {
            this.intergraph = this.newIntergraph();
            this.intergraph.setOwner(this);
            this.intergraph.setOwned(true);
            this.intergraph.setIntergraph(true);
        }
        return this.intergraph;
    }

    public List intergraphEdges() {
        List list = this.queryIntergraph() != null ? this.queryIntergraph().disconnectedEdges() : new de();
        return list;
    }

    public TSGraph queryIntergraph() {
        return this.intergraph;
    }

    public List graphs() {
        return this.graphs(false);
    }

    public List graphs(boolean bl) {
        Vector<TSGraph> vector = new Vector<TSGraph>();
        if (bl && this.queryIntergraph() != null) {
            vector.add(this.queryIntergraph());
        }
        vector.addAll(this.graphSet);
        return vector;
    }

    public List buildEdges(int n) {
        de de2 = new de();
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            de2.addAll(tSGraph.buildEdges(n));
        }
        return de2;
    }

    public int numberOfEdges() {
        int n = 0;
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            n += tSGraph.numberOfEdges();
        }
        return n;
    }

    public int numberOfIntergraphEdges() {
        TSGraph tSGraph = this.queryIntergraph();
        if (tSGraph == null) {
            return 0;
        }
        return tSGraph.numberOfDisconnectedEdges();
    }

    public int numberOfNodes() {
        int n = 0;
        Iterator iterator = this.graphs(false).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            n += tSGraph.numberOfNodes();
        }
        return n;
    }

    public int numberOfDisconnectedEdges() {
        int n = 0;
        Iterator iterator = this.graphs(true).iterator();
        while (iterator.hasNext()) {
            TSGraph tSGraph = (TSGraph)iterator.next();
            n += tSGraph.numberOfDisconnectedEdges();
        }
        return n;
    }

    public int numberOfGraphs() {
        return this.graphSet.size();
    }

    boolean isModified() {
        return (this.flags & 0x10) != 0;
    }

    void setModified(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public TSEventManager getEventManager() {
        return this.eventManager;
    }

    public TSChildGraphForest getChildGraphForest() {
        if (this.childGraphForest == null) {
            this.childGraphForest = this.newChildGraphForest();
            this.childGraphForest.setOwner(this);
            this.childGraphForest.setOwned(true);
        }
        return this.childGraphForest;
    }
}

