/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.event;

import com.tomsawyer.event.TSChildEventSource;
import com.tomsawyer.event.TSEvent;
import com.tomsawyer.event.TSEventData;
import com.tomsawyer.event.TSGroupEventData;
import com.tomsawyer.event.TSVetoableChangeListener;
import com.tomsawyer.event.dd;
import com.tomsawyer.event.gg;
import com.tomsawyer.event.gh;
import com.tomsawyer.event.gs;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class TSBaseEventManager {
    private Hashtable mainTable;
    private int context = 0;
    private boolean fireEvents;
    private boolean fireVetoableEvents;
    private boolean coalesceEvents;
    private boolean coalescingDisabled;
    private boolean coalescingPreservesOrder;
    private Hashtable coalescedEvents;
    private Comparator comparator;
    private boolean modifyListeners = true;
    private List removedListeners = new LinkedList();
    private List addedListeners = new LinkedList();
    private Hashtable modules;

    public TSBaseEventManager() {
        this.mainTable = new Hashtable();
        this.modules = new Hashtable();
        this.coalescedEvents = new Hashtable();
        this.coalescingPreservesOrder = this.isCoalescingPreservesOrderByDefault();
        this.comparator = new gs();
        this.registerDefaultEventClasses();
    }

    protected abstract void registerDefaultEventClasses();

    public void registerEventClass(Class clazz) {
        if (clazz != null && !this.isEventClassRegistered(clazz)) {
            this.mainTable.put(clazz, new Hashtable());
        }
    }

    public void registerModule(String string, dd dd2) {
        this.modules.put(string, dd2);
        dd2.a(this);
    }

    public dd getModule(String string) {
        return (dd)this.modules.get(string);
    }

    private boolean isEventClassRegistered(Class clazz) {
        boolean bl = false;
        if (clazz != null) {
            boolean bl2 = bl = this.mainTable.get(clazz) != null;
        }
        if (!bl && !this.modules.isEmpty()) {
            Iterator iterator = this.modules.values().iterator();
            while (iterator.hasNext() && !bl) {
                TSBaseEventManager tSBaseEventManager = (TSBaseEventManager)iterator.next();
                if (!tSBaseEventManager.isEventClassRegistered(clazz)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void registerDiscardableEventSource(Object object) {
    }

    public void addListener(Object object, EventListener eventListener, long l, Class clazz) {
        if (clazz != null) {
            if (!this.isEventClassRegistered(clazz)) {
                throw new IllegalArgumentException("Unknown event class");
            }
            Hashtable hashtable = (Hashtable)this.mainTable.get(clazz);
            if (hashtable == null) {
                Iterator iterator = this.modules.values().iterator();
                while (iterator.hasNext()) {
                    TSBaseEventManager tSBaseEventManager = (TSBaseEventManager)iterator.next();
                    tSBaseEventManager.addListener(object, eventListener, l, clazz);
                }
            } else {
                Object v = hashtable.get(object);
                if (v != null) {
                    gg gg2;
                    List list = (List)v;
                    Iterator iterator = list.iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        gg2 = (gg)iterator.next();
                        if (gg2.a() != eventListener) continue;
                        gg2.a = gg2.b() | l;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        if (eventListener instanceof TSVetoableChangeListener) {
                            if (!list.isEmpty() && ((gg)list.get(0)).a() instanceof TSVetoableChangeListener) {
                                throw new IllegalArgumentException("Too many vetoable listeners");
                            }
                            gg2 = new gg(eventListener, l);
                            if (this.isModifyingListenersAllowed()) {
                                list.add(0, gg2);
                            } else {
                                this.addedListeners.add(new gh(list, gg2));
                            }
                        } else {
                            gg2 = new gg(eventListener, l);
                            if (this.isModifyingListenersAllowed()) {
                                list.add(gg2);
                            } else {
                                this.addedListeners.add(new gh(list, gg2));
                            }
                        }
                    }
                } else {
                    LinkedList<gg> linkedList = new LinkedList<gg>();
                    hashtable.put(object, linkedList);
                    linkedList.add(new gg(eventListener, l));
                }
            }
        }
    }

    public void removeListener(EventListener eventListener) {
        Object object;
        Map.Entry entry;
        Iterator iterator = this.mainTable.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            object = (Hashtable)entry.getValue();
            Iterator iterator2 = ((Hashtable)object).entrySet().iterator();
            block1: while (iterator2.hasNext()) {
                entry = iterator2.next();
                List list = (List)entry.getValue();
                Iterator iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    gg gg2 = (gg)iterator3.next();
                    if (eventListener != gg2.a()) continue;
                    if (this.isModifyingListenersAllowed()) {
                        iterator3.remove();
                        continue block1;
                    }
                    this.removedListeners.add(new gh(list, gg2));
                    continue block1;
                }
            }
        }
        entry = this.modules.values().iterator();
        while (entry.hasNext()) {
            object = (TSBaseEventManager)entry.next();
            ((TSBaseEventManager)object).removeListener(eventListener);
        }
    }

    public void removeListener(Object object, EventListener eventListener, long l, Class clazz) {
        this.removeListenerImp(object, false, eventListener, l, clazz);
    }

    public void removeAllListeners(Object object) {
        Enumeration enumeration = this.mainTable.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            this.removeAllListeners(object, -1L, clazz);
        }
    }

    public void removeAllListeners(Object object, long l, Class clazz) {
        this.removeListenerImp(object, true, null, l, clazz);
    }

    private void removeListenerImp(Object object, boolean bl, EventListener eventListener, long l, Class clazz) {
        if (clazz != null && object != null) {
            if (!this.isEventClassRegistered(clazz)) {
                throw new IllegalArgumentException("Unknown event class");
            }
            Hashtable hashtable = (Hashtable)this.mainTable.get(clazz);
            if (hashtable == null) {
                Iterator iterator = this.modules.values().iterator();
                while (iterator.hasNext()) {
                    TSBaseEventManager tSBaseEventManager = (TSBaseEventManager)iterator.next();
                    tSBaseEventManager.removeListenerImp(object, bl, eventListener, l, clazz);
                }
            } else {
                Object v = hashtable.get(object);
                if (v != null) {
                    List list = (List)v;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        gg gg2 = (gg)iterator.next();
                        if (!bl && gg2.a() != eventListener) continue;
                        gg2.a = gg2.b() & (l ^ 0xFFFFFFFFFFFFFFFFL);
                        if (gg2.b() == 0L) {
                            if (this.isModifyingListenersAllowed()) {
                                iterator.remove();
                            } else {
                                this.removedListeners.add(new gh(list, gg2));
                            }
                        }
                        if (bl) continue;
                    }
                    if (list.size() == 0) {
                        hashtable.remove(object);
                    }
                }
            }
        }
    }

    public void removeAllListeners(Class clazz) {
        if (clazz != null) {
            if (!this.isEventClassRegistered(clazz)) {
                throw new IllegalArgumentException("Unknown event class");
            }
            Hashtable hashtable = (Hashtable)this.mainTable.get(clazz);
            if (hashtable == null) {
                Iterator iterator = this.modules.values().iterator();
                while (iterator.hasNext()) {
                    TSBaseEventManager tSBaseEventManager = (TSBaseEventManager)iterator.next();
                    tSBaseEventManager.removeAllListeners(clazz);
                }
            } else {
                hashtable.clear();
            }
        }
    }

    public List getAllListeners(Object object, Class clazz, boolean bl) {
        return this.getAllListeners(object, clazz, bl, -1L);
    }

    private List getAllListeners(Object object, Class clazz, boolean bl, long l) {
        List<EventListener> list;
        block4: {
            Hashtable hashtable;
            block5: {
                list = new LinkedList();
                if (clazz == null || object == null) break block4;
                if (!this.isEventClassRegistered(clazz)) {
                    throw new IllegalArgumentException("Unknown event class");
                }
                hashtable = (Hashtable)this.mainTable.get(clazz);
                if (hashtable != null) break block5;
                Iterator iterator = this.modules.values().iterator();
                while (iterator.hasNext()) {
                    TSBaseEventManager tSBaseEventManager = (TSBaseEventManager)iterator.next();
                    if (!tSBaseEventManager.isEventClassRegistered(clazz)) continue;
                    list = tSBaseEventManager.getAllListeners(object, clazz, bl, l);
                }
                break block4;
            }
            Object v = hashtable.get(object);
            if (v == null) break block4;
            List list2 = (List)v;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                gg gg2 = (gg)iterator.next();
                if ((gg2.b() & l) == 0L) continue;
                if (gg2.a() instanceof TSVetoableChangeListener) {
                    if (!bl) continue;
                    list.add(gg2.a());
                    continue;
                }
                if (bl) continue;
                list.add(gg2.a());
            }
        }
        return list;
    }

    public long getTypeForListener(Object object, EventListener eventListener, Class clazz) {
        block3: {
            Hashtable hashtable;
            block4: {
                if (clazz == null || object == null) break block3;
                if (!this.isEventClassRegistered(clazz)) {
                    throw new IllegalArgumentException("Unknown event class");
                }
                hashtable = (Hashtable)this.mainTable.get(clazz);
                if (hashtable != null) break block4;
                Iterator iterator = this.modules.values().iterator();
                while (iterator.hasNext()) {
                    TSBaseEventManager tSBaseEventManager = (TSBaseEventManager)iterator.next();
                    if (!tSBaseEventManager.isEventClassRegistered(clazz)) continue;
                    return tSBaseEventManager.getTypeForListener(object, eventListener, clazz);
                }
                break block3;
            }
            Object v = hashtable.get(object);
            if (v == null) break block3;
            List list = (List)v;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                gg gg2 = (gg)iterator.next();
                if (gg2.a() != eventListener) continue;
                return gg2.b();
            }
        }
        return -1L;
    }

    public boolean fireEvent(TSEvent tSEvent) {
        return this.fireEvent(tSEvent, false);
    }

    public boolean fireEvent(TSEvent tSEvent, boolean bl) {
        Iterator<Object> iterator;
        if (!this.isFiringEvents() || bl && !this.isFiringVetoableEvents()) {
            return true;
        }
        boolean bl2 = true;
        boolean bl3 = this.isModifyingListenersAllowed();
        this.modifyListeners = false;
        if (!this.isEventClassRegistered(tSEvent.getClass())) {
            throw new IllegalArgumentException("Invalid event fired");
        }
        Hashtable hashtable = (Hashtable)this.mainTable.get(tSEvent.getClass());
        if (hashtable == null) {
            iterator = this.modules.values().iterator();
            while (iterator.hasNext()) {
                TSBaseEventManager tSBaseEventManager = (TSBaseEventManager)iterator.next();
                if (!tSBaseEventManager.isEventClassRegistered(tSEvent.getClass())) continue;
                bl2 = tSBaseEventManager.fireEvent(tSEvent, bl);
                break;
            }
        } else if (!tSEvent.isGroupEvent()) {
            bl2 = this.notifyListeners(tSEvent.getSource(), tSEvent, hashtable, bl);
        }
        if (bl3) {
            this.modifyListeners = bl3;
            if (!this.addedListeners.isEmpty()) {
                iterator = this.addedListeners.iterator();
                while (iterator.hasNext()) {
                    ((gh)iterator.next()).a();
                }
                this.addedListeners.clear();
            }
            if (!this.removedListeners.isEmpty()) {
                iterator = this.removedListeners.iterator();
                while (iterator.hasNext()) {
                    ((gh)iterator.next()).b();
                }
                this.removedListeners.clear();
            }
        }
        return bl2;
    }

    private boolean notifyListeners(Object object, TSEvent tSEvent, Hashtable hashtable, boolean bl) {
        Iterator iterator;
        List list;
        Object v = hashtable.get(object);
        boolean bl2 = true;
        if (v != null && !(list = (List)v).isEmpty()) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                gg gg2 = (gg)iterator.next();
                if ((gg2.b() & tSEvent.getType()) == 0L) continue;
                tSEvent.setContext(this.getContext());
                if (bl) {
                    if (!(gg2.a() instanceof TSVetoableChangeListener)) break;
                    bl2 = this.maybeFireNotification(gg2.a(), tSEvent);
                    break;
                }
                if (gg2.a() instanceof TSVetoableChangeListener) continue;
                bl2 = bl2 && this.maybeFireNotification(gg2.a(), tSEvent);
            }
        }
        if (object instanceof TSChildEventSource && (iterator = ((TSChildEventSource)object).getParentEventSource()) != null) {
            bl2 = bl2 && this.notifyListeners(iterator, tSEvent, hashtable, bl);
        }
        return bl2;
    }

    private boolean maybeFireNotification(EventListener eventListener, TSEvent tSEvent) {
        if (eventListener instanceof TSVetoableChangeListener) {
            return this.fireVeto((TSVetoableChangeListener)eventListener, tSEvent);
        }
        if (!this.isCoalesce()) {
            this.fireNotification(eventListener, tSEvent);
        } else {
            this.coalesceEvent(eventListener, tSEvent);
        }
        return true;
    }

    protected abstract void fireNotification(EventListener var1, TSEvent var2);

    protected abstract boolean fireVeto(TSVetoableChangeListener var1, TSEvent var2);

    public void setContext(int n) {
        this.context = n;
    }

    public int getContext() {
        return this.context;
    }

    public void setFireEvents(boolean bl) {
        this.fireEvents = bl;
    }

    public boolean isFiringEvents() {
        return this.fireEvents;
    }

    public void setFireVetoableEvents(boolean bl) {
        this.fireVetoableEvents = bl;
    }

    public boolean isFiringVetoableEvents() {
        return this.fireVetoableEvents;
    }

    public void setCoalescingPreservesOrder(boolean bl) {
        this.coalescingPreservesOrder = bl;
    }

    public boolean isCoalescingPreservesOrder() {
        return this.coalescingPreservesOrder;
    }

    private boolean isCoalescingPreservesOrderByDefault() {
        return false;
    }

    public void setCoalescingPermanentlyDisabled(boolean bl) {
        if (this.coalesceEvents && bl) {
            this.setCoalesce(false);
        }
        this.coalescingDisabled = bl;
    }

    public boolean isCoalescingDisabled() {
        return this.coalescingDisabled;
    }

    public void setCoalesce(boolean bl) {
        if (!this.coalescingDisabled) {
            if (this.coalesceEvents && !bl) {
                this.coalesceEvents = false;
                this.fireCoalescedEvents();
            } else {
                this.coalesceEvents = true;
            }
        }
        Iterator iterator = this.modules.values().iterator();
        while (iterator.hasNext()) {
            TSBaseEventManager tSBaseEventManager = (TSBaseEventManager)iterator.next();
            tSBaseEventManager.setCoalesce(bl);
        }
    }

    public boolean isCoalesce() {
        return this.coalesceEvents && !this.coalescingDisabled;
    }

    private void coalesceEvent(EventListener eventListener, TSEvent tSEvent) {
        LinkedList<Object> linkedList = (LinkedList<Object>)this.coalescedEvents.get(eventListener);
        if (linkedList == null) {
            linkedList = new LinkedList<Object>();
            linkedList.add(tSEvent.clone());
            this.coalescedEvents.put(eventListener, linkedList);
        } else {
            linkedList.add(tSEvent.clone());
        }
    }

    private void fireCoalescedEvents() {
        Iterator iterator = this.coalescedEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = null;
            Map.Entry entry = iterator.next();
            EventListener eventListener = (EventListener)entry.getKey();
            List list = (List)entry.getValue();
            if (!this.isCoalescingPreservesOrder()) {
                Collections.sort(list, this.comparator);
            }
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                TSEvent tSEvent = (TSEvent)iterator2.next();
                if (object != null && object.getClass().equals(tSEvent.getClass()) && ((TSEvent)object).getType() == tSEvent.getType()) {
                    ((TSGroupEventData)((TSEvent)object).getData()).addData(tSEvent.getData());
                    continue;
                }
                this.processAndFirePossibleGroupEvent(eventListener, (TSEvent)object);
                object = tSEvent;
                TSGroupEventData tSGroupEventData = new TSGroupEventData();
                TSEventData tSEventData = tSEvent.getData();
                ((TSEvent)object).setData(tSGroupEventData);
                tSGroupEventData.addData(tSEventData);
            }
            this.processAndFirePossibleGroupEvent(eventListener, (TSEvent)object);
        }
        this.coalescedEvents.clear();
    }

    private void processAndFirePossibleGroupEvent(EventListener eventListener, TSEvent tSEvent) {
        if (tSEvent != null) {
            List list;
            if (tSEvent.isGroupEvent() && (list = ((TSGroupEventData)tSEvent.getData()).getDataList()).size() == 1) {
                tSEvent.setData((TSEventData)list.get(0));
            }
            this.fireNotification(eventListener, tSEvent);
        }
    }

    public static String getFullType(TSEvent tSEvent) {
        return TSBaseEventManager.getFullType(tSEvent.getClass(), tSEvent.getType());
    }

    public static String getFullType(Class clazz, long l) {
        String string = "";
        try {
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                long l2 = field.getLong(null);
                if (l2 == l) {
                    string = field.getName().replace('_', ' ');
                    break;
                }
                if ((l2 & l2 - 1L) != 0L || (l & l2) == 0L) continue;
                string = string + field.getName().replace('_', ' ') + ", ";
            }
            if (string.endsWith(", ")) {
                string = string.substring(0, string.length() - 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String toString() {
        String string = super.toString() + '\n';
        Enumeration enumeration = this.mainTable.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            Hashtable hashtable = (Hashtable)this.mainTable.get(clazz);
            if (hashtable.isEmpty()) continue;
            string = string + "_______________________________________________________________________\n\n";
            string = string + "Listeners of class " + clazz.getName() + ":\n\n";
            Iterator iterator = hashtable.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                string = string + "Listeners for event source " + entry.getKey() + ":\n\n";
                Iterator iterator2 = ((List)entry.getValue()).iterator();
                while (iterator2.hasNext()) {
                    gg gg2 = (gg)iterator2.next();
                    string = string + gg2.a() + ": " + TSBaseEventManager.getFullType(clazz, gg2.b()) + "\n\n";
                }
            }
        }
        return string;
    }

    protected void eventSourceDiscarded(Object object) {
        this.removeAllListeners(object);
    }

    boolean isModifyingListenersAllowed() {
        return this.modifyListeners;
    }
}

