/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editorx.ui;

import com.tomsawyer.drawing.TSPolygonShape;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSShape;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.ui.TSEConnectorUI;
import com.tomsawyer.util.TSProperty;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSEPolygonConnectorUI
extends TSEConnectorUI {
    public static final String SHAPE = "polygon";
    public static final String SHAPE_TYPE = "polygonType";
    TSPolygonShape shape;
    int[] xCoords;
    int[] yCoords;
    double scaleX;
    double scaleY;
    double shiftX;
    double shiftY;
    String shapeType;

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSEPolygonConnectorUI tSEPolygonConnectorUI = (TSEPolygonConnectorUI)tSEObjectUI;
        this.setPolygon(tSEPolygonConnectorUI.shape.toString());
    }

    public void draw(TSEGraphics tSEGraphics) {
        this.validateShape(tSEGraphics.getTSTransform());
        if (!this.isTransparent()) {
            tSEGraphics.setColor(this.getFillColor());
            tSEGraphics.fillPolygon(this.xCoords, this.yCoords, this.xCoords.length);
        }
        if (this.isBorderDrawn()) {
            tSEGraphics.setColor(this.getBorderColor());
            tSEGraphics.drawPolygon(this.xCoords, this.yCoords, this.xCoords.length);
        }
    }

    public void drawSelected(TSEGraphics tSEGraphics) {
        this.validateShape(tSEGraphics.getTSTransform());
        if (!this.isTransparent()) {
            tSEGraphics.setColor(this.getSelectedColor());
            tSEGraphics.fillPolygon(this.xCoords, this.yCoords, this.xCoords.length);
        }
        if (this.isBorderDrawn()) {
            tSEGraphics.setColor(this.getBorderColor());
            tSEGraphics.drawPolygon(this.xCoords, this.yCoords, this.xCoords.length);
        }
    }

    public void drawOutline(TSEGraphics tSEGraphics) {
        this.validateShape(tSEGraphics.getTSTransform());
        tSEGraphics.drawPolygon(this.xCoords, this.yCoords, this.xCoords.length);
    }

    public void drawSelectedOutline(TSEGraphics tSEGraphics) {
        tSEGraphics.setColor(this.getSelectedColor());
        this.drawOutline(tSEGraphics);
    }

    public void setPolygon(Polygon polygon) {
        if (polygon == null || polygon.npoints < 2) {
            throw new IllegalArgumentException();
        }
        Vector<TSConstPoint> vector = new Vector<TSConstPoint>();
        for (int i = 0; i < polygon.npoints; ++i) {
            vector.add(new TSConstPoint(polygon.xpoints[i], polygon.ypoints[i]));
        }
        this.setShape(new TSPolygonShape(vector));
    }

    public void setPolygon(List list) {
        this.setShape(new TSPolygonShape(list));
    }

    public void setPolygon(String string) {
        this.setShape(TSPolygonShape.fromString(string));
    }

    void setShape(TSPolygonShape tSPolygonShape) {
        TSPolygonShape tSPolygonShape2 = this.shape;
        this.shape = tSPolygonShape;
        this.invalidateShape();
        if (this.getOwnerConnector() != null) {
            this.getOwnerConnector().setShape(tSPolygonShape);
        }
        this.firePropertyChangedEvent(SHAPE, tSPolygonShape2, this.shape);
    }

    public TSShape getShape() {
        return this.shape;
    }

    public void invalidateShape() {
        this.scaleX = Double.NaN;
        this.scaleY = Double.NaN;
        this.shiftX = Double.NaN;
        this.shiftY = Double.NaN;
        this.xCoords = new int[this.shape.points().size()];
        this.yCoords = new int[this.shape.points().size()];
    }

    public void validateShape(TSTransform tSTransform) {
        if (this.shape == null && this.getOwnerConnector().getShape() instanceof TSPolygonShape) {
            this.shape = (TSPolygonShape)this.getOwnerConnector().getShape();
        }
        if (this.xCoords == null || this.xCoords.length != this.shape.points().size()) {
            this.xCoords = new int[this.shape.points().size()];
        }
        if (this.yCoords == null || this.yCoords.length != this.shape.points().size()) {
            this.yCoords = new int[this.shape.points().size()];
        }
        Rectangle rectangle = tSTransform.boundsToDevice(this.getOwnerConnector().getLocalBounds());
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        int n3 = (int)rectangle.getX();
        int n4 = (int)rectangle.getY() + n2;
        double d = (double)n / 100.0;
        double d2 = (double)n2 / 100.0;
        if (d != this.scaleX || d2 != this.scaleY || (double)n3 != this.shiftX || (double)n4 != this.shiftY) {
            int n5 = 0;
            Iterator iterator = this.shape.points().iterator();
            while (iterator.hasNext()) {
                TSConstPoint tSConstPoint = (TSConstPoint)iterator.next();
                this.xCoords[n5] = (int)Math.round(d * tSConstPoint.getX() + (double)n3);
                this.yCoords[n5] = (int)Math.round((double)n4 - d2 * tSConstPoint.getY());
                ++n5;
            }
            this.scaleX = d;
            this.scaleY = d2;
            this.shiftX = n3;
            this.shiftY = n4;
        }
    }

    public String getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(String string) {
        this.shapeType = string;
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(SHAPE, this.shape));
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        list.add(new TSProperty(SHAPE, this.shape));
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (SHAPE.equals(tSProperty.getName()) || "polygonShape".equals(tSProperty.getName())) {
            this.setPolygon(tSProperty.getValue().toString());
        } else if (SHAPE_TYPE.equals(tSProperty.getName())) {
            this.setShapeType(tSProperty.getValue().toString());
        } else {
            super.setProperty(tSProperty);
        }
    }

    public TSEColor getDefaultFillColor() {
        return TSEColor.cyan;
    }
}

