/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editorx.ui;

import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorPropertyEditor;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorPropertyRenderer;
import com.tomsawyer.editor.ui.TSECurvedEdgeUI;
import com.tomsawyer.editor.ui.h0;
import com.tomsawyer.editorx.ui.h4;
import com.tomsawyer.util.TSProperty;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.List;

public class TSECurvedDashedEdgeUI
extends TSECurvedEdgeUI {
    public static TSEInspectorPropertyID WIDTH_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Width"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSECurvedDashedEdgeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID STYLE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Style"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSECurvedDashedEdgeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final String LINE_STYLE = "style";
    public static final String LINE_WIDTH = "width";
    public static final int[] LINE_WIDTHS = new int[]{1, 2, 3, 4, 5};
    static TSEKeyValueInspectorPropertyEditor widthEditor = null;
    static TSEKeyValueInspectorPropertyRenderer widthRenderer = null;
    static TSEKeyValueInspectorPropertyEditor styleEditor = null;
    static TSEKeyValueInspectorPropertyRenderer styleRenderer = null;
    int lineWidth;
    float dashPhase;
    int lineStyle;
    float[] zoomedArray;
    static /* synthetic */ Class class$java$lang$Integer;

    public void reset() {
        super.reset();
        this.setLineWidth(this.getDefaultLineWidth());
        this.setLineStyle(this.getDefaultLineStyle());
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSECurvedDashedEdgeUI tSECurvedDashedEdgeUI = (TSECurvedDashedEdgeUI)tSEObjectUI;
        this.setLineWidth(tSECurvedDashedEdgeUI.getLineWidth());
        this.setLineStyle(tSECurvedDashedEdgeUI.getLineStyle());
    }

    public TSEGraphics convertGraphics(TSEGraphics tSEGraphics) {
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        int n = Math.max(1, tSTransform.widthToDevice(this.getLineWidth()));
        BasicStroke basicStroke = null;
        int n2 = this.getLineStyle();
        if (n2 < 0 || n2 >= TSECurvedEdgeUI.LINE_STYLES.length || TSECurvedEdgeUI.LINE_STYLES[n2] == null) {
            basicStroke = new BasicStroke(n, 1, 1);
        } else {
            if (this.zoomedArray == null || this.zoomedArray.length != TSECurvedEdgeUI.LINE_STYLES[n2].length) {
                this.zoomedArray = new float[TSECurvedEdgeUI.LINE_STYLES[n2].length];
            }
            float f = 0.0f;
            for (int i = 0; i < TSECurvedEdgeUI.LINE_STYLES[n2].length; ++i) {
                this.zoomedArray[i] = (float)Math.max(0.1, (double)tSTransform.widthToDevice(TSECurvedEdgeUI.LINE_STYLES[n2][i]));
                f += this.zoomedArray[i];
            }
            basicStroke = new BasicStroke(n, 1, 1, 0.0f, this.zoomedArray, f * this.getDashPhase());
        }
        tSEGraphics.setStroke(basicStroke);
        return tSEGraphics;
    }

    public void drawPath(TSEGraphics tSEGraphics) {
        Stroke stroke = tSEGraphics.getStroke();
        super.drawPath(this.convertGraphics(tSEGraphics));
        tSEGraphics.setStroke(stroke);
    }

    public void setLineWidth(int n) {
        Integer n2 = new Integer(this.lineWidth);
        this.lineWidth = n;
        this.firePropertyChangedEvent(LINE_WIDTH, n2, new Integer(n));
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setDashPhase(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.dashPhase = f;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public void setLineStyle(int n) {
        if (n < 0 || n >= TSECurvedEdgeUI.LINE_STYLES.length) {
            n = 0;
        }
        Integer n2 = new Integer(this.lineStyle);
        this.lineStyle = n;
        this.firePropertyChangedEvent(LINE_STYLE, n2, new Integer(n));
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(LINE_WIDTH, new Integer(this.getLineWidth())));
        list.add(new TSProperty(LINE_STYLE, new Integer(this.getLineStyle())));
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.getDefaultLineWidth() != this.getLineWidth()) {
            list.add(new TSProperty(LINE_WIDTH, new Integer(this.getLineWidth())));
        }
        if (this.getDefaultLineStyle() != this.getLineStyle()) {
            list.add(new TSProperty(LINE_STYLE, new Integer(this.getLineStyle())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (LINE_WIDTH.equals(tSProperty.getName())) {
            this.setLineWidth(Integer.parseInt(tSProperty.getValue().toString()));
        } else if (LINE_STYLE.equals(tSProperty.getName())) {
            this.setLineStyle(Integer.parseInt(tSProperty.getValue().toString()));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(STYLE_ID);
        list.add(WIDTH_ID);
        super.getInspectorPropertyIDs(list);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty;
        block9: {
            block10: {
                block12: {
                    block11: {
                        block6: {
                            block8: {
                                block7: {
                                    if (!tSEInspectorPropertyID.equals(WIDTH_ID)) break block6;
                                    if (widthEditor == null) break block7;
                                    if (widthRenderer != null) break block8;
                                }
                                widthEditor = new TSEKeyValueInspectorPropertyEditor();
                                widthEditor.getComboBox().setRenderer(new h4());
                                widthRenderer = new TSEKeyValueInspectorPropertyRenderer();
                                widthRenderer.getComboBox().setRenderer(new h4());
                            }
                            TSEKeyValueInspectorProperty tSEKeyValueInspectorProperty = new TSEKeyValueInspectorProperty(new Integer(this.getLineWidth()), true, widthRenderer, widthEditor);
                            for (int i = 0; i < LINE_WIDTHS.length; ++i) {
                                tSEKeyValueInspectorProperty.put(new Integer(LINE_WIDTHS[i]), new Integer(LINE_WIDTHS[i]));
                            }
                            tSEInspectorProperty = tSEKeyValueInspectorProperty;
                            break block9;
                        }
                        if (!tSEInspectorPropertyID.equals(STYLE_ID)) break block10;
                        if (styleEditor == null) break block11;
                        if (styleRenderer != null) break block12;
                    }
                    styleEditor = new TSEKeyValueInspectorPropertyEditor();
                    styleEditor.getComboBox().setRenderer(new h0());
                    styleRenderer = new TSEKeyValueInspectorPropertyRenderer();
                    styleRenderer.getComboBox().setRenderer(new h0());
                }
                TSEKeyValueInspectorProperty tSEKeyValueInspectorProperty = new TSEKeyValueInspectorProperty(new Integer(this.getLineStyle()), true, styleRenderer, styleEditor);
                for (int i = 0; i < TSECurvedEdgeUI.LINE_STYLES.length; ++i) {
                    tSEKeyValueInspectorProperty.put(new Integer(i), new Integer(i));
                }
                tSEInspectorProperty = tSEKeyValueInspectorProperty;
                break block9;
            }
            tSEInspectorProperty = super.getInspectorProperty(tSEInspectorPropertyID);
        }
        return tSEInspectorProperty;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        int n;
        if (tSEInspectorPropertyID.equals(WIDTH_ID)) {
            this.setLineWidth((Integer)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(STYLE_ID)) {
            this.setLineStyle((Integer)tSEInspectorProperty.getValue());
            n = 1;
        } else {
            n = super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
        }
        return n;
    }

    public int getDefaultLineWidth() {
        return 1;
    }

    public int getDefaultLineStyle() {
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

