/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editorx;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.net.URL;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.ImageRendererFactory;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.apache.batik.gvt.renderer.StaticRendererFactory;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class TSESVGImage {
    GraphicsNode gvtRoot;
    String resourceString;
    double imageWidth;
    double imageHeight;
    static UserAgent userAgent;
    static ImageRendererFactory rendererFactory;
    static DocumentLoader documentLoader;
    static GVTBuilder builder;
    static ImageRenderer renderer;
    static Class loaderClass;
    static Rectangle lastAreaOfInterest;
    static /* synthetic */ Class class$com$tomsawyer$editorx$TSESVGImage;

    protected TSESVGImage() {
    }

    public TSESVGImage(TSESVGImage tSESVGImage) {
        if (tSESVGImage == null) {
            throw new IllegalArgumentException("null image");
        }
        this.resourceString = tSESVGImage.resourceString;
        this.gvtRoot = tSESVGImage.gvtRoot;
        this.imageWidth = tSESVGImage.imageWidth;
        this.imageHeight = tSESVGImage.imageHeight;
    }

    protected static void initRenderer() {
        if (renderer instanceof StaticRenderer) {
            StaticRenderer staticRenderer = (StaticRenderer)renderer;
            staticRenderer.getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            staticRenderer.getRenderingHints().put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            staticRenderer.getRenderingHints().put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            staticRenderer.getRenderingHints().put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            staticRenderer.getRenderingHints().put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            staticRenderer.getRenderingHints().put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            staticRenderer.getRenderingHints().put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            staticRenderer.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        renderer.setDoubleBuffered(false);
    }

    public static void initBatik() {
        if (userAgent != null) {
            throw new IllegalStateException("Batik already initialized.");
        }
        userAgent = new UserAgentAdapter();
        documentLoader = new DocumentLoader(userAgent);
        builder = new GVTBuilder();
        rendererFactory = new StaticRendererFactory();
        renderer = rendererFactory.createImageRenderer();
        TSESVGImage.initRenderer();
        lastAreaOfInterest = null;
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.draw(graphics2D, n, n2, n3, n4, null);
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        if (rectangle != null) {
            rectangle2 = rectangle2.intersection(rectangle);
        }
        if (rectangle2.width < 1 || rectangle2.height < 1) {
            return;
        }
        AffineTransform affineTransform = new AffineTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        if (n < rectangle2.x) {
            affineTransform.translate(n - rectangle2.x, 0.0);
            affineTransform2.translate(rectangle2.x, 0.0);
        } else {
            affineTransform2.translate(n, 0.0);
        }
        if (n2 < rectangle2.y) {
            affineTransform.translate(0.0, n2 - rectangle2.y);
            affineTransform2.translate(0.0, rectangle2.y);
        } else {
            affineTransform2.translate(0.0, n2);
        }
        affineTransform.scale((double)n3 / this.imageWidth, (double)n4 / this.imageHeight);
        try {
            if (renderer.getTree() != this.gvtRoot || !affineTransform.equals(renderer.getTransform()) || !rectangle2.equals(lastAreaOfInterest)) {
                if (renderer.getTree() != this.gvtRoot) {
                    renderer.setTree(this.gvtRoot);
                }
                renderer.setTransform(affineTransform);
                if (renderer.getOffScreen() == null || renderer.getOffScreen().getWidth() < rectangle2.width || renderer.getOffScreen().getHeight() < rectangle2.height) {
                    renderer.updateOffScreen(rectangle2.width, rectangle2.height);
                }
                renderer.clearOffScreen();
                renderer.repaint((Shape)rectangle2);
                lastAreaOfInterest = rectangle2;
            }
            graphics2D.drawRenderedImage(renderer.getOffScreen(), affineTransform2);
        }
        catch (Exception exception) {
            System.err.println("Unable to draw resource \"" + this.resourceString + "\": \"" + exception.getMessage() + "\".");
        }
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale((double)n3 / this.imageWidth, (double)n4 / this.imageHeight);
        renderer.setTree(this.gvtRoot);
        renderer.setTransform(affineTransform);
        renderer.updateOffScreen(n3, n4);
        renderer.clearOffScreen();
        graphics2D.translate(n, n2);
        Rectangle rectangle = new Rectangle(0, 0, n3, n4);
        try {
            renderer.repaint((Shape)rectangle.intersection(new Rectangle(n5, n6, n7, n8)));
            graphics2D.drawRenderedImage(renderer.getOffScreen(), null);
        }
        catch (Exception exception) {
            System.err.println("Unable to draw resource \"" + this.resourceString + "\": \"" + exception.getMessage() + "\".");
        }
        graphics2D.translate(-n, -n2);
    }

    public static TSESVGImage loadImage(String string) {
        return TSESVGImage.loadImage(TSESVGImage.getLoaderClass(), string);
    }

    public static TSESVGImage loadImage(Class clazz, String string) {
        if (userAgent == null) {
            throw new IllegalStateException("Batik not initialized.");
        }
        TSESVGImage tSESVGImage = new TSESVGImage();
        try {
            GraphicsNode graphicsNode;
            URL uRL = TSESVGImage.getLoaderClass().getResource(string);
            if (uRL == null) {
                uRL = new File(string).toURL();
            }
            String string2 = uRL.toString();
            SVGDocument sVGDocument = (SVGDocument)documentLoader.loadDocument(string2);
            BridgeContext bridgeContext = new BridgeContext(userAgent, documentLoader);
            tSESVGImage.gvtRoot = graphicsNode = builder.build(bridgeContext, (Document)sVGDocument);
            tSESVGImage.imageWidth = bridgeContext.getDocumentSize().getWidth();
            tSESVGImage.imageHeight = bridgeContext.getDocumentSize().getHeight();
            tSESVGImage.resourceString = string;
        }
        catch (Exception exception) {
            System.err.println("Unable to load resource \"" + string + "\": \"" + exception.getMessage() + "\".");
            return null;
        }
        return tSESVGImage;
    }

    public String getResource() {
        return this.resourceString;
    }

    public static Class getLoaderClass() {
        return loaderClass;
    }

    public static void setLoaderClass(Class clazz) {
        loaderClass = clazz;
    }

    public double getWidth() {
        return this.imageWidth;
    }

    public double getHeight() {
        return this.imageHeight;
    }

    public String toString() {
        return this.getResource();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        loaderClass = class$com$tomsawyer$editorx$TSESVGImage == null ? (class$com$tomsawyer$editorx$TSESVGImage = TSESVGImage.class$("com.tomsawyer.editorx.TSESVGImage")) : class$com$tomsawyer$editorx$TSESVGImage;
    }
}

