/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editorx;

import com.tomsawyer.editor.TSEDockableDialog;
import com.tomsawyer.editorx.TSENodePaletteItem;
import com.tomsawyer.editorx.h3;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.dnd.DragSource;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class TSENodePalette
extends TSEDockableDialog {
    protected JPanel nodePanel;
    protected JPanel mainPanel;
    protected int numberOfItems;
    protected TSENodePaletteItem[] items;
    protected DragSource dragSource = null;
    protected Dimension size;
    protected h3 listener;
    protected Insets insets = new Insets(5, 5, 5, 10);
    int numberOfRows;
    int numberOfColumns;
    int itemWidth;
    int itemHeight;

    public TSENodePalette(Frame frame, String string, TSENodePaletteItem[] tSENodePaletteItemArray, int n, int n2, int n3, int n4) {
        super(frame, string);
        this.items = tSENodePaletteItemArray;
        this.numberOfItems = tSENodePaletteItemArray.length;
        this.numberOfRows = n;
        this.numberOfColumns = n2;
        this.itemWidth = n3;
        this.itemHeight = n4;
        int n5 = 0;
        if (TSEDockableDialog.heightCompensatedInApplet()) {
            n5 = 25;
            String string2 = System.getProperty("os.name");
            String string3 = System.getProperty("os.version");
            if (string2.endsWith("XP") || string2.endsWith("2000") && string3.endsWith("5.1")) {
                n5 = 35;
            }
        }
        this.size = new Dimension(n3 * n2 + this.insets.left + this.insets.right, n4 * n + this.insets.top + this.insets.bottom + 25 + n5);
        this.init();
    }

    public TSENodePalette(Dialog dialog, String string, TSENodePaletteItem[] tSENodePaletteItemArray, int n, int n2, int n3, int n4) {
        super(dialog, string);
        this.items = tSENodePaletteItemArray;
        this.numberOfItems = tSENodePaletteItemArray.length;
        this.numberOfRows = n;
        this.numberOfColumns = n2;
        this.itemWidth = n3;
        this.itemHeight = n4;
        int n5 = 0;
        if (TSEDockableDialog.heightCompensatedInApplet()) {
            n5 = 25;
            String string2 = System.getProperty("os.name");
            String string3 = System.getProperty("os.version");
            if (string2.endsWith("XP") || string2.endsWith("2000") && string3.endsWith("5.1")) {
                n5 = 35;
            }
        }
        this.size = new Dimension(n3 * n2 + this.insets.left + this.insets.right, n4 * n + this.insets.top + this.insets.bottom + 25 + n5);
        this.init();
    }

    protected void init() {
        this.dragSource = new DragSource();
        this.listener = new h3(this);
        Container container = this.getContentPane();
        this.nodePanel = this.createNodePanel();
        container.setLayout(null);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        int n = (int)this.size.getWidth();
        int n2 = (int)this.size.getHeight();
        this.mainPanel.setBounds(0, 0, n, n2 - 25);
        container.add(this.mainPanel);
        this.nodePanel.setBounds(this.insets.left, this.insets.top, n - this.insets.right, n2 - this.insets.bottom);
        this.mainPanel.add(this.nodePanel);
        ((Component)this).setSize(this.size);
        this.setDefaultCloseOperation(1);
    }

    public JPanel createNodePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        int n = 0;
        for (int i = 0; i < this.numberOfRows; ++i) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setAlignmentX(0.0f);
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createRigidArea(new Dimension(this.getCustomInsets().left, 0)));
            for (int j = 0; j < this.numberOfColumns && n < this.numberOfItems; ++n, ++j) {
                TSENodePaletteItem tSENodePaletteItem = this.items[n];
                String string = tSENodePaletteItem.getNodeType();
                tSENodePaletteItem.setToolTipText(tSENodePaletteItem.getToolTip());
                tSENodePaletteItem.setPreferredSize(new Dimension(this.itemWidth, this.itemHeight));
                tSENodePaletteItem.setMinimumSize(tSENodePaletteItem.getPreferredSize());
                tSENodePaletteItem.setMaximumSize(tSENodePaletteItem.getPreferredSize());
                this.dragSource.createDefaultDragGestureRecognizer(tSENodePaletteItem, this.getAcceptableDragActions(), this.listener);
                jPanel2.add(tSENodePaletteItem);
            }
            jPanel2.add(Box.createRigidArea(new Dimension(this.getCustomInsets().right, 0)));
            jPanel.add(jPanel2);
        }
        return jPanel;
    }

    public void setCustomInsets(Insets insets) {
        this.insets = insets;
    }

    public Insets getCustomInsets() {
        return this.insets;
    }

    public int getAcceptableDragActions() {
        return 3;
    }
}

