/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.ui;

import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSShape;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.complexity.TSEHidingManager;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.ui.TSEAnnotatedUI;
import com.tomsawyer.util.TSProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Iterator;
import java.util.List;

public abstract class TSENodeUI
extends TSEAnnotatedUI {
    public static final TSEColor DEFAULT_CHILD_GRAPH_MARK_COLOR = new TSEColor(new Color(160, 160, 164));
    public static final TSEColor DEFAULT_HIDE_MARK_COLOR = new TSEColor(new Color(0, 0, 0));
    public static final TSEColor DEFAULT_CONSTRAINT_BADGE_COLOR = new TSEColor(new Color(207, 207, 207));
    private TSENode ownerNode;
    boolean drawChildGraphMark = true;
    boolean drawHideMark = false;
    int constraintType;
    public static int CHECKMARK_BADGE = 0;
    private static final int MARK_SIZE = 15;
    private static final int MARK_GAP = 3;
    public static final String DRAW_CHILD_GRAPH_MARK = "childGraphMark";
    public static final String DRAW_HIDE_MARK = "hideMark";

    public TSEObject getOwner() {
        return this.ownerNode;
    }

    public TSENode getOwnerNode() {
        return this.ownerNode;
    }

    public void setOwner(TSENode tSENode) {
        this.ownerNode = tSENode;
        if (this.ownerNode != null) {
            if (this.getDefaultText() != null && tSENode.getTag() == null && this.ownerNode.getOriginalUI() == null) {
                this.ownerNode.setTag(this.getDefaultText());
            }
            this.onTextChanged(this.ownerNode.getText());
            this.updateHideMark();
        }
    }

    protected void nullifyOwner() {
        this.ownerNode = null;
    }

    public void drawConnectors(TSEGraphics tSEGraphics, boolean bl, boolean bl2) {
        if (this.getOwnerNode().numberOfConnectors() > 0) {
            Iterator iterator = this.getOwnerNode().connectors().iterator();
            while (iterator.hasNext()) {
                TSEConnector tSEConnector = (TSEConnector)iterator.next();
                if (!tSEConnector.isVisible()) continue;
                if (tSEConnector.isSelected() || !bl2) {
                    if (tSEConnector.isSelected() && bl) {
                        tSEConnector.getUI().drawSelected(tSEGraphics);
                    } else {
                        tSEConnector.getUI().draw(tSEGraphics);
                    }
                }
                if (tSEConnector.numberOfLabels() <= 0) continue;
                Iterator iterator2 = tSEConnector.labels().iterator();
                while (iterator2.hasNext()) {
                    TSEConnectorLabel tSEConnectorLabel = (TSEConnectorLabel)iterator2.next();
                    if (!tSEConnectorLabel.isVisible()) continue;
                    if (tSEConnectorLabel.isSelected() && bl) {
                        tSEConnectorLabel.getUI().drawSelected(tSEGraphics);
                        continue;
                    }
                    tSEConnectorLabel.getUI().draw(tSEGraphics);
                }
            }
        }
    }

    public void drawConnectors(TSEGraphics tSEGraphics) {
        this.drawConnectors(tSEGraphics, true, false);
    }

    public void drawConnectorOutlines(TSEGraphics tSEGraphics, boolean bl, boolean bl2) {
        if (this.getOwnerNode().numberOfConnectors() > 0) {
            Iterator iterator = this.getOwnerNode().connectors().iterator();
            while (iterator.hasNext()) {
                TSEConnector tSEConnector = (TSEConnector)iterator.next();
                if (!tSEConnector.isVisible()) continue;
                if (tSEConnector.isSelected() || !bl2) {
                    if (tSEConnector.isSelected() && bl) {
                        tSEConnector.getUI().drawSelectedOutline(tSEGraphics);
                    } else {
                        tSEConnector.getUI().drawOutline(tSEGraphics);
                    }
                }
                if (tSEConnector.numberOfLabels() <= 0) continue;
                Iterator iterator2 = tSEConnector.labels().iterator();
                while (iterator2.hasNext()) {
                    TSEConnectorLabel tSEConnectorLabel = (TSEConnectorLabel)iterator2.next();
                    if (!tSEConnectorLabel.isVisible()) continue;
                    if (tSEConnectorLabel.isSelected()) {
                        tSEConnectorLabel.getUI().drawSelectedOutline(tSEGraphics);
                        continue;
                    }
                    tSEConnectorLabel.getUI().drawOutline(tSEGraphics);
                }
            }
        }
    }

    public void drawConnectorOutlines(TSEGraphics tSEGraphics) {
        this.drawConnectorOutlines(tSEGraphics, true, false);
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        this.constraintType = 0;
        this.drawChildGraphMark = ((TSENodeUI)tSEObjectUI).drawChildGraphMark;
        this.drawHideMark = ((TSENodeUI)tSEObjectUI).drawHideMark;
    }

    public void drawConstraintBadge(TSEGraphics tSEGraphics) {
        if (this.getOwnerNode().isHighlighted()) {
            Shape shape = tSEGraphics.getClip();
            TSTransform tSTransform = tSEGraphics.getTSTransform();
            int n = tSTransform.xToDevice(this.getOwnerNode().getLocalLeft());
            int n2 = tSTransform.yToDevice(this.getOwnerNode().getLocalTop());
            int n3 = 12;
            int n4 = 12;
            Color color = tSEGraphics.getColor();
            Stroke stroke = tSEGraphics.getStroke();
            tSEGraphics.setColor(DEFAULT_CONSTRAINT_BADGE_COLOR.getColor());
            if (this.constraintType == CHECKMARK_BADGE) {
                tSEGraphics.clipRect(n, n2, n3, n4);
                tSEGraphics.fillRect(n, n2, n3, n4);
                tSEGraphics.setColor(Color.black);
                tSEGraphics.setStroke(new BasicStroke(2.0f, 1, 1));
                tSEGraphics.drawLine(n, n2 + n4 / 2, n + n3 / 3, n2 + n4);
                tSEGraphics.drawLine(n + n3 / 3, n2 + n4, n + n3, n2);
            } else if (this.constraintType > 0) {
                String string = String.valueOf(this.constraintType);
                n3 = string.length() * 7;
                tSEGraphics.clipRect(n, n2, n3, n4);
                tSEGraphics.fillRect(n, n2, n3, n4);
                tSEGraphics.setColor(Color.black);
                Font font = tSEGraphics.getFont();
                tSEGraphics.setFont(new Font("Dialog", 0, 12));
                tSEGraphics.drawString(string, n, n2 + n4);
                tSEGraphics.setFont(font);
            }
            tSEGraphics.setColor(color);
            tSEGraphics.setStroke(stroke);
            tSEGraphics.setClip(shape);
        }
    }

    public void setConstraintBadge(int n) {
        this.constraintType = n;
    }

    public TSConstRect getInvalidRegion() {
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerNode().getOwnerGraph();
        TSTransform tSTransform = ((TSEGraph)tSDGraph.getMainDisplayGraph()).getGraphWindow().getTransform();
        TSExpTransform tSExpTransform = tSDGraph.getLocalToMainDisplayGraphTransform();
        return this.getInvalidRegion(tSTransform, tSExpTransform);
    }

    public TSConstRect getInvalidRegion(TSTransform tSTransform, TSExpTransform tSExpTransform) {
        TSRect tSRect = (TSRect)super.getInvalidRegion(tSTransform, tSExpTransform);
        if (this.getOwnerNode().numberOfConnectors() > 0) {
            Iterator iterator = this.getOwnerNode().connectors().iterator();
            tSRect = new TSRect(tSRect);
            while (iterator.hasNext()) {
                TSEConnector tSEConnector = (TSEConnector)iterator.next();
                if (tSEConnector.getUI() == null) continue;
                TSConstRect tSConstRect = tSEConnector.getUI().getInvalidRegion(tSTransform, tSExpTransform);
                tSRect.merge(tSConstRect);
            }
        }
        return tSRect;
    }

    private void drawMark(TSEGraphics tSEGraphics, TSEColor tSEColor, TSEColor tSEColor2, TSRect tSRect) {
        Shape shape = tSEGraphics.getClip();
        tSEGraphics.clipRect(this.getOwnerNode().getLocalBounds());
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        int n = tSTransform.widthToDevice(tSRect.getWidth());
        int n2 = tSTransform.heightToDevice(tSRect.getHeight());
        int n3 = n / 5;
        int n4 = n2 / 5;
        int n5 = n * 2 / 5;
        int n6 = n2 * 2 / 5;
        int n7 = n - n5 * 2;
        int n8 = n2 - n6 * 2;
        int n9 = tSTransform.xToDevice(tSRect.getLeft());
        int n10 = tSTransform.yToDevice(tSRect.getTop());
        tSEGraphics.setColor(tSEColor);
        tSEGraphics.fillRect(n9, n10, n, n2);
        tSEGraphics.setColor(tSEColor2);
        tSEGraphics.fillRect(n9 + n3, n10 + n6, n - 2 * n3, n8);
        tSEGraphics.fillRect(n9 + n5, n10 + n4, n7, n2 - 2 * n4);
        tSEGraphics.setClip(shape);
    }

    public boolean hasChildGraphMark() {
        return this.getOwnerNode().hasChildGraph() && this.drawChildGraphMark;
    }

    public void setDrawChildGraphMark(boolean bl) {
        this.drawChildGraphMark = bl;
    }

    public TSRect getLocalChildGraphMarkBounds() {
        TSConstRect tSConstRect = this.getOwnerNode().getLocalBounds();
        TSRect tSRect = new TSRect();
        tSRect.setLeft(tSConstRect.getLeft() + 3.0);
        tSRect.setTop(tSConstRect.getTop() - 3.0);
        tSRect.setRight(tSRect.getLeft() + 15.0);
        tSRect.setBottom(tSRect.getTop() - 15.0);
        return tSRect;
    }

    public TSRect getChildGraphMarkBounds() {
        TSRect tSRect = this.getLocalChildGraphMarkBounds();
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerNode().getOwnerGraph();
        TSExpTransform tSExpTransform = tSDGraph.getLocalToMainDisplayGraphTransform();
        if (tSExpTransform != null) {
            tSExpTransform.transformRect(tSRect, tSRect);
        }
        return tSRect;
    }

    public void drawChildGraphMark(TSEGraphics tSEGraphics) {
        if (this.drawChildGraphMark) {
            this.drawMark(tSEGraphics, DEFAULT_CHILD_GRAPH_MARK_COLOR, TSEColor.white, this.getLocalChildGraphMarkBounds());
        }
    }

    public boolean hasHideMark() {
        return this.drawHideMark;
    }

    public void updateHideMark() {
        TSENode tSENode = this.getOwnerNode();
        if (tSENode != null && tSENode.isOwned() && tSENode.getOwnerGraph().getOwnerGraphManager() != null) {
            TSEHidingManager tSEHidingManager = (TSEHidingManager)TSEHidingManager.getManager((TSEGraphManager)tSENode.getOwnerGraph().getOwnerGraphManager());
            this.drawHideMark = !TSHidingManager.isHidden(tSENode) && (tSEHidingManager.hasHiddenNeighbors(tSENode, 1L) || tSEHidingManager.hasHiddenIncidentEdges(tSENode));
        }
    }

    public TSRect getLocalHideMarkBounds() {
        TSConstRect tSConstRect = this.getOwnerNode().getLocalBounds();
        TSRect tSRect = new TSRect();
        tSRect.setRight(tSConstRect.getRight() - 3.0);
        tSRect.setTop(tSConstRect.getTop() - 3.0);
        tSRect.setLeft(tSRect.getRight() - 15.0);
        tSRect.setBottom(tSRect.getTop() - 15.0);
        return tSRect;
    }

    public TSRect getHideMarkBounds() {
        TSRect tSRect = this.getLocalHideMarkBounds();
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerNode().getOwnerGraph();
        TSExpTransform tSExpTransform = tSDGraph.getLocalToMainDisplayGraphTransform();
        if (tSExpTransform != null) {
            tSExpTransform.transformRect(tSRect, tSRect);
        }
        return tSRect;
    }

    public void drawHideMark(TSEGraphics tSEGraphics) {
        if (this.hasHideMark()) {
            this.drawMark(tSEGraphics, DEFAULT_HIDE_MARK_COLOR, TSEColor.white, this.getLocalHideMarkBounds());
        }
    }

    public void onOwnerInserted() {
        this.updateHideMark();
    }

    public void onOwnerRemoved() {
        this.updateHideMark();
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(DRAW_CHILD_GRAPH_MARK, new Boolean(this.drawChildGraphMark)));
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (DRAW_CHILD_GRAPH_MARK.equals(tSProperty.getName())) {
            Boolean bl = new Boolean(this.drawChildGraphMark);
            this.drawChildGraphMark = Boolean.valueOf(tSProperty.getValue().toString());
            this.firePropertyChangedEvent(DRAW_CHILD_GRAPH_MARK, bl, new Boolean(this.drawChildGraphMark));
        } else if (DRAW_HIDE_MARK.equals(tSProperty.getName())) {
            Boolean bl = new Boolean(this.drawHideMark);
            this.drawHideMark = Boolean.valueOf(tSProperty.getValue().toString());
            this.firePropertyChangedEvent(DRAW_HIDE_MARK, bl, new Boolean(this.drawHideMark));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (!this.drawChildGraphMark) {
            list.add(new TSProperty(DRAW_CHILD_GRAPH_MARK, Boolean.FALSE));
        }
        if (this.drawHideMark) {
            list.add(new TSProperty(DRAW_HIDE_MARK, Boolean.TRUE));
        }
        return list;
    }

    public TSShape getShape() {
        return null;
    }
}

