/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.ui;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEImage;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.dialog.TSFileFilter;
import com.tomsawyer.editor.event.TSEPropertyChangeEvent;
import com.tomsawyer.editor.event.TSEPropertyChangeEventData;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEFilenameInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectable;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty;
import com.tomsawyer.util.TSProperty;
import com.tomsawyer.util.TSSystem;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public abstract class TSEGraphUI
extends TSEObjectUI
implements TSEInspectable {
    public static TSEInspectorPropertyID COLOR_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Background_Color"), class$com$tomsawyer$editor$TSEColor == null ? (class$com$tomsawyer$editor$TSEColor = TSEGraphUI.class$("com.tomsawyer.editor.TSEColor")) : class$com$tomsawyer$editor$TSEColor);
    public static TSEInspectorPropertyID PICTURE_FILENAME_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Picture_Filename"), class$java$lang$String == null ? (class$java$lang$String = TSEGraphUI.class$("java.lang.String")) : class$java$lang$String);
    public static TSEInspectorPropertyID PICTURE_X_WORLD_OFFSET_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Picture_X_Offset"), class$java$lang$Double == null ? (class$java$lang$Double = TSEGraphUI.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID PICTURE_Y_WORLD_OFFSET_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Picture_Y_Offset"), class$java$lang$Double == null ? (class$java$lang$Double = TSEGraphUI.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID PICTURE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Picture"), class$java$lang$Boolean == null ? (class$java$lang$Boolean = TSEGraphUI.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static TSEInspectorPropertyID PICTURE_STYLE_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Picture_Style"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSEGraphUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID PICTURE_TILED_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Tile_Picture"), class$java$lang$Boolean == null ? (class$java$lang$Boolean = TSEGraphUI.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    public static String WORLD_OFFSET_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("World_Offset");
    public static String DEVICE_OFFSET_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Device_Offset");
    public static String DEVICE_FIT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Device_Fit");
    public static final String GIF_FILTER_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("GIF_Image_(*.gif)");
    public static final String JPEG_FILTER_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("JPEG_Image_(*.jpg)");
    public static final int WORLD_OFFSET = 0;
    public static final int DEVICE_OFFSET = 2;
    public static final int DEVICE_FIT = 3;
    public static final String BACKGROUND_COLOR = "backgroundColor";
    public static final String IMAGE = "imageUsed";
    public static final String IMAGE_URL = "imageURL";
    public static final String IMAGE_X = "imageX";
    public static final String IMAGE_Y = "imageY";
    public static final String IMAGE_TILED = "imageTiled";
    public static final String IMAGE_STYLE = "imageStyle";
    public static final String IMAGE_MINIMUM_TILE_STEP = "imageMinTileStep";
    public static final String DRAW_NODES_BEFORE_EDGES = "drawNodesBeforeEdges";
    TSEColor backgroundColor;
    TSEImage backgroundImage;
    String backgroundImageName;
    double backgroundOffsetX;
    double backgroundOffsetY;
    int backgroundImageStyle;
    int backgroundImageMinimumTileStep;
    boolean backgroundImageTiled;
    boolean drawNodesBeforeEdges;
    private TSEGraph ownerGraph;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEColor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;

    public void reset() {
        super.reset();
        this.setBackgroundColor(this.getDefaultBackgroundColor());
        this.setBackgroundImage(this.getDefaultBackgroundImage());
        this.setBackgroundImageX(this.getDefaultBackgroundImageX());
        this.setBackgroundImageY(this.getDefaultBackgroundImageY());
        this.setBackgroundImageStyle(this.getDefaultBackgroundImageStyle());
        this.setBackgroundImageTiled(this.isBackgroundImageTiledByDefault());
        this.setBackgroundImageMinimumTileStep(this.getDefaultBackgroundImageMinimumTileStep());
        this.setDrawNodesBeforeEdges(this.isDrawNodesBeforeEdgesByDefault());
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        TSEGraphUI tSEGraphUI = (TSEGraphUI)tSEObjectUI;
        this.setBackgroundImage(tSEGraphUI.getBackgroundImage());
        this.setBackgroundImageX(tSEGraphUI.getBackgroundImageX());
        this.setBackgroundImageY(tSEGraphUI.getBackgroundImageY());
        this.setBackgroundColor(tSEGraphUI.getBackgroundColor());
        this.setBackgroundImageStyle(tSEGraphUI.getBackgroundImageStyle());
        this.setBackgroundImageTiled(tSEGraphUI.isBackgroundImageTiled());
        this.setBackgroundImageMinimumTileStep(tSEGraphUI.getBackgroundImageMinimumTileStep());
        this.setDrawNodesBeforeEdges(tSEGraphUI.isDrawNodesBeforeEdges());
    }

    public void draw(TSEGraphics tSEGraphics) {
        this.draw(tSEGraphics, true);
    }

    public abstract void draw(TSEGraphics var1, boolean var2);

    public abstract void drawAll(TSEGraphics var1, TSConstRect var2);

    public abstract void drawAll(TSEGraphics var1, TSConstRect var2, boolean var3);

    public abstract void draw(TSEGraphics var1, boolean var2, TSConstRect var3);

    public abstract void draw(TSEGraphics var1, boolean var2, boolean var3, TSConstRect var4, boolean var5);

    public void drawSelected(TSEGraphics tSEGraphics) {
        throw new RuntimeException("Not implemented");
    }

    public abstract void drawOutline(TSEGraphics var1);

    public void drawSelectedOutline(TSEGraphics tSEGraphics) {
        throw new RuntimeException("Not implemented");
    }

    public double getLeft() {
        return this.getOwnerGraph().getLocalLeft();
    }

    public double getRight() {
        return this.getOwnerGraph().getLocalRight();
    }

    public double getTop() {
        return this.getOwnerGraph().getLocalTop();
    }

    public double getBottom() {
        return this.getOwnerGraph().getLocalBottom();
    }

    public TSConstRect getInvalidRegion(TSTransform tSTransform, TSExpTransform tSExpTransform) {
        TSRect tSRect = new TSRect();
        tSExpTransform.transformRect(this.getBounds(), tSRect);
        return tSRect;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.getOwnerGraph().locallyIntersects(d, d2, d3, d4);
    }

    public TSEObject getOwner() {
        return this.ownerGraph;
    }

    public TSEGraph getOwnerGraph() {
        return this.ownerGraph;
    }

    public void setOwner(TSEGraph tSEGraph) {
        this.ownerGraph = tSEGraph;
    }

    protected void nullifyOwner() {
        this.ownerGraph = null;
    }

    public void drawBackground(TSEGraphics tSEGraphics, TSConstRect tSConstRect) {
        this.drawBackground(tSEGraphics, tSConstRect, true, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBackground(TSEGraphics tSEGraphics, TSConstRect tSConstRect, boolean bl, boolean bl2) {
        Shape shape;
        block12: {
            int n;
            int n2;
            int n3;
            int n4;
            Image image;
            int n5;
            int n6;
            int n7;
            int n8;
            block14: {
                int n9;
                int n10;
                block13: {
                    if (tSEGraphics == null || tSConstRect == null) {
                        throw new IllegalArgumentException("null graphics or clipBounds");
                    }
                    TSTransform tSTransform = tSEGraphics.getTSTransform();
                    tSConstRect = tSTransform.getWorldBounds().intersection(tSConstRect);
                    if (tSConstRect == null) {
                        return;
                    }
                    n8 = tSTransform.xToDevice(tSConstRect.getLeft());
                    n7 = tSTransform.yToDevice(tSConstRect.getTop());
                    n6 = tSTransform.widthToDevice(tSConstRect.getWidth());
                    n5 = tSTransform.heightToDevice(tSConstRect.getHeight());
                    if (bl) {
                        tSEGraphics.setColor(this.getBackgroundColor().getColor());
                    } else {
                        tSEGraphics.setColor(Color.white);
                    }
                    shape = tSEGraphics.getClip();
                    tSEGraphics.clipRect(n8, n7, n6 + 1, n5 + 1);
                    tSEGraphics.fillRect(n8, n7, n6, n5);
                    if (this.getBackgroundImage() == null || this.getBackgroundImage().getImage() == null || !bl2) break block12;
                    image = this.getBackgroundImage().getImage();
                    n4 = image.getWidth(null);
                    n3 = image.getHeight(null);
                    Rectangle rectangle = tSTransform.getDeviceBounds();
                    if (this.getBackgroundImageStyle() == 2) {
                        n10 = (int)this.backgroundOffsetX + rectangle.x + (rectangle.width - n4) / 2;
                        n9 = (int)this.backgroundOffsetY + rectangle.y + (rectangle.height - n3) / 2;
                    } else if (this.getBackgroundImageStyle() == 3) {
                        n10 = 0;
                        n9 = 0;
                        n4 = (int)tSTransform.getDeviceBounds().getWidth();
                        n3 = (int)tSTransform.getDeviceBounds().getHeight();
                    } else {
                        n10 = tSTransform.xToDevice(this.backgroundOffsetX - (double)(n4 / 2));
                        n9 = tSTransform.yToDevice(this.backgroundOffsetY + (double)(n3 / 2));
                        n4 = tSTransform.widthToDevice(n4);
                        n3 = tSTransform.heightToDevice(n3);
                    }
                    if (!this.isBackgroundImageTiled()) break block13;
                    if (this.getBackgroundImageStyle() == 3) break block13;
                    n2 = Math.max(n4, this.getBackgroundImageMinimumTileStep());
                    n = Math.max(n3, this.getBackgroundImageMinimumTileStep());
                    while (n10 > n8) {
                        n10 -= n2;
                    }
                    while (n9 > n7) {
                        n9 -= n;
                    }
                    break block14;
                }
                tSEGraphics.drawImage(image, n10, n9, n4, n3, null);
                break block12;
            }
            for (int i = n9; i < n7 + n5; i += n) {
                for (int j = n10; j < n8 + n6; j += n2) {
                    tSEGraphics.drawImage(image, j, i, n4, n3, null);
                }
            }
        }
        tSEGraphics.setClip(shape);
    }

    public TSEColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(TSEColor tSEColor) {
        TSEColor tSEColor2 = this.backgroundColor;
        this.backgroundColor = tSEColor;
        this.firePropertyChangedEvent(BACKGROUND_COLOR, tSEColor2, tSEColor);
    }

    public TSEImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(TSEImage tSEImage) {
        TSEImage tSEImage2 = this.backgroundImage;
        this.backgroundImage = tSEImage;
        String string = IMAGE;
        if (tSEImage != null) {
            if (tSEImage.getResource() != null) {
                this.backgroundImageName = tSEImage.getResource();
            } else if (tSEImage.getURL() != null) {
                string = IMAGE_URL;
                this.backgroundImageName = tSEImage.getURL().toString();
            }
        }
        this.firePropertyChangedEvent(string, tSEImage2, tSEImage);
    }

    public void setBackgroundImageX(double d) {
        Double d2 = new Double(this.backgroundOffsetX);
        this.backgroundOffsetX = d;
        this.firePropertyChangedEvent(IMAGE_X, d2, new Double(d));
    }

    public void setBackgroundImageY(double d) {
        Double d2 = new Double(this.backgroundOffsetY);
        this.backgroundOffsetY = d;
        this.firePropertyChangedEvent(IMAGE_Y, d2, new Double(d));
    }

    public void setBackgroundImageCenter(double d, double d2) {
        this.setBackgroundImageX(d);
        this.setBackgroundImageY(d2);
    }

    public double getBackgroundImageX() {
        return this.backgroundOffsetX;
    }

    public double getBackgroundImageY() {
        return this.backgroundOffsetY;
    }

    public TSConstPoint getBackgroundImageCenter() {
        return new TSConstPoint(this.getBackgroundImageX(), this.getBackgroundImageY());
    }

    public void setBackgroundImageStyle(int n) {
        Integer n2 = new Integer(this.backgroundImageStyle);
        this.backgroundImageStyle = n;
        this.firePropertyChangedEvent(IMAGE_STYLE, n2, new Integer(this.backgroundImageStyle));
    }

    public int getBackgroundImageStyle() {
        return this.backgroundImageStyle;
    }

    public void setBackgroundImageTiled(boolean bl) {
        Boolean bl2 = new Boolean(this.backgroundImageTiled);
        this.backgroundImageTiled = bl;
        this.firePropertyChangedEvent(IMAGE_TILED, bl2, new Boolean(bl));
    }

    public boolean isBackgroundImageTiled() {
        return this.backgroundImageTiled;
    }

    public TSEColor getDefaultBackgroundColor() {
        return TSEColor.white;
    }

    public TSEImage getDefaultBackgroundImage() {
        return null;
    }

    public double getDefaultBackgroundImageX() {
        return 0.0;
    }

    public double getDefaultBackgroundImageY() {
        return 0.0;
    }

    public int getDefaultBackgroundImageStyle() {
        return 0;
    }

    public boolean isBackgroundImageTiledByDefault() {
        return false;
    }

    public int getBackgroundImageMinimumTileStep() {
        return this.backgroundImageMinimumTileStep;
    }

    public void setBackgroundImageMinimumTileStep(int n) {
        Integer n2 = new Integer(this.backgroundImageMinimumTileStep);
        this.backgroundImageMinimumTileStep = n;
        this.firePropertyChangedEvent(IMAGE_MINIMUM_TILE_STEP, n2, new Integer(n));
    }

    public int getDefaultBackgroundImageMinimumTileStep() {
        return 25;
    }

    public void setDrawNodesBeforeEdges(boolean bl) {
        this.drawNodesBeforeEdges = bl;
    }

    public boolean isDrawNodesBeforeEdges() {
        return this.drawNodesBeforeEdges;
    }

    public boolean isDrawNodesBeforeEdgesByDefault() {
        return true;
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(BACKGROUND_COLOR, this.getBackgroundColor()));
        list.add(new TSProperty(IMAGE, this.getBackgroundImage()));
        list.add(new TSProperty(IMAGE_TILED, new Boolean(this.isBackgroundImageTiled())));
        list.add(new TSProperty(IMAGE_STYLE, new Integer(this.getBackgroundImageStyle())));
        list.add(new TSProperty(IMAGE_MINIMUM_TILE_STEP, new Integer(this.getBackgroundImageMinimumTileStep())));
        list.add(new TSProperty(IMAGE_X, new Double(this.getBackgroundImageX())));
        list.add(new TSProperty(IMAGE_Y, new Double(this.getBackgroundImageY())));
        list.add(new TSProperty(DRAW_NODES_BEFORE_EDGES, new Boolean(this.isDrawNodesBeforeEdges())));
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.getBackgroundColor() != this.getDefaultBackgroundColor()) {
            list.add(new TSProperty(BACKGROUND_COLOR, this.getBackgroundColor()));
        }
        if (this.getBackgroundImage() != null && this.getBackgroundImage() != this.getDefaultBackgroundImage()) {
            if (this.getBackgroundImage().getResource() != null) {
                list.add(new TSProperty(IMAGE, TSEImage.checkPath(this.getBackgroundImage().getResource())));
            } else if (this.getBackgroundImage().getURL() != null) {
                list.add(new TSProperty(IMAGE_URL, this.getBackgroundImage().getURL()));
            }
        }
        if (this.isBackgroundImageTiledByDefault() != this.isBackgroundImageTiled()) {
            list.add(new TSProperty(IMAGE_TILED, new Boolean(this.isBackgroundImageTiled())));
        }
        if (this.getDefaultBackgroundImageStyle() != this.getBackgroundImageStyle()) {
            list.add(new TSProperty(IMAGE_STYLE, new Integer(this.getBackgroundImageStyle())));
        }
        if (this.getDefaultBackgroundImageMinimumTileStep() != this.getBackgroundImageMinimumTileStep()) {
            list.add(new TSProperty(IMAGE_MINIMUM_TILE_STEP, new Integer(this.getBackgroundImageMinimumTileStep())));
        }
        if (this.getDefaultBackgroundImageX() != this.getBackgroundImageX()) {
            list.add(new TSProperty(IMAGE_X, new Double(this.getBackgroundImageX())));
        }
        if (this.getDefaultBackgroundImageY() != this.getBackgroundImageY()) {
            list.add(new TSProperty(IMAGE_Y, new Double(this.getBackgroundImageY())));
        }
        if (this.isDrawNodesBeforeEdgesByDefault() != this.isDrawNodesBeforeEdges()) {
            list.add(new TSProperty(DRAW_NODES_BEFORE_EDGES, new Boolean(this.isDrawNodesBeforeEdges())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (BACKGROUND_COLOR.equals(tSProperty.getName())) {
            if (tSProperty.getValue() instanceof TSEColor) {
                this.setBackgroundColor((TSEColor)tSProperty.getValue());
            } else {
                this.setBackgroundColor(new TSEColor(tSProperty.getValue().toString()));
            }
        } else if (IMAGE.equals(tSProperty.getName())) {
            if (tSProperty.getValue() == null || tSProperty.getValue() instanceof TSEImage) {
                this.setBackgroundImage((TSEImage)tSProperty.getValue());
            } else {
                this.setBackgroundImage(new TSEImage(tSProperty.getValue().toString()));
            }
        } else if (IMAGE_URL.equals(tSProperty.getName())) {
            try {
                this.setBackgroundImage(new TSEImage(new URL(tSProperty.getValue().toString())));
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        } else if (IMAGE_X.equals(tSProperty.getName())) {
            this.setBackgroundImageX(Double.valueOf(tSProperty.getValue().toString()));
        } else if (IMAGE_Y.equals(tSProperty.getName())) {
            this.setBackgroundImageY(Double.valueOf(tSProperty.getValue().toString()));
        } else if (IMAGE_TILED.equals(tSProperty.getName())) {
            this.setBackgroundImageTiled(Boolean.valueOf(tSProperty.getValue().toString()));
        } else if (IMAGE_STYLE.equals(tSProperty.getName())) {
            this.setBackgroundImageStyle(Integer.valueOf(tSProperty.getValue().toString()));
        } else if (IMAGE_MINIMUM_TILE_STEP.equals(tSProperty.getName())) {
            this.setBackgroundImageMinimumTileStep(Integer.valueOf(tSProperty.getValue().toString()));
        } else if (DRAW_NODES_BEFORE_EDGES.equals(tSProperty.getName())) {
            this.setDrawNodesBeforeEdges(Boolean.valueOf(tSProperty.getValue().toString()));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public void firePropertyChangedEvent(String string, Object object, Object object2) {
        if (!TSSystem.equals(object, object2) && this.getOwnerGraph() != null) {
            this.getOwnerGraph().fireEvent(new TSEPropertyChangeEvent(1L, new TSEPropertyChangeEventData(this, new TSProperty(string, object), new TSProperty(string, object2))));
        }
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(COLOR_ID);
        list.add(PICTURE_ID);
        list.add(PICTURE_FILENAME_ID);
        list.add(PICTURE_STYLE_ID);
        list.add(PICTURE_TILED_ID);
        list.add(PICTURE_X_WORLD_OFFSET_ID);
        list.add(PICTURE_Y_WORLD_OFFSET_ID);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty;
        if (tSEInspectorPropertyID.equals(COLOR_ID)) {
            tSEInspectorProperty = new TSEInspectorProperty(this.getBackgroundColor());
        } else if (tSEInspectorPropertyID.equals(PICTURE_ID)) {
            tSEInspectorProperty = new TSEInspectorProperty(new Boolean(this.backgroundImage != null));
        } else {
            if (tSEInspectorPropertyID.equals(PICTURE_FILENAME_ID)) {
                String string = this.backgroundImageName;
                if (string == null) {
                    string = new String();
                }
                TSEFilenameInspectorProperty tSEFilenameInspectorProperty = new TSEFilenameInspectorProperty(string, !string.startsWith("http"));
                tSEFilenameInspectorProperty.addFilter(new TSFileFilter("gif", GIF_FILTER_STRING));
                tSEFilenameInspectorProperty.addFilter(new TSFileFilter("jpg", JPEG_FILTER_STRING));
                return tSEFilenameInspectorProperty;
            }
            if (tSEInspectorPropertyID.equals(PICTURE_STYLE_ID)) {
                TSEKeyValueInspectorProperty tSEKeyValueInspectorProperty = new TSEKeyValueInspectorProperty(new Integer(this.getBackgroundImageStyle()));
                tSEKeyValueInspectorProperty.put(WORLD_OFFSET_STRING, new Integer(0));
                tSEKeyValueInspectorProperty.put(DEVICE_OFFSET_STRING, new Integer(2));
                if (this.getOwnerGraph().isMainDisplayGraph()) {
                    tSEKeyValueInspectorProperty.put(DEVICE_FIT_STRING, new Integer(3));
                }
                tSEInspectorProperty = tSEKeyValueInspectorProperty;
            } else {
                tSEInspectorProperty = tSEInspectorPropertyID.equals(PICTURE_X_WORLD_OFFSET_ID) ? new TSEInspectorProperty((Object)new Double(this.getBackgroundImageX()), this.getBackgroundImageStyle() != 3) : (tSEInspectorPropertyID.equals(PICTURE_Y_WORLD_OFFSET_ID) ? new TSEInspectorProperty((Object)new Double(this.getBackgroundImageY()), this.getBackgroundImageStyle() != 3) : (tSEInspectorPropertyID.equals(PICTURE_TILED_ID) ? new TSEInspectorProperty((Object)new Boolean(this.isBackgroundImageTiled()), this.getBackgroundImageStyle() != 3) : null));
            }
        }
        return tSEInspectorProperty;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        int n;
        if (tSEInspectorPropertyID.equals(COLOR_ID)) {
            this.setBackgroundColor((TSEColor)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(PICTURE_ID)) {
            boolean bl = (Boolean)tSEInspectorProperty.getValue();
            if (bl && this.backgroundImageName != null) {
                this.setBackgroundImage(new TSEImage(this.backgroundImageName));
            } else if (!bl) {
                this.setBackgroundImage(null);
            }
            n = 2;
        } else if (tSEInspectorPropertyID.equals(PICTURE_FILENAME_ID)) {
            this.backgroundImageName = (String)tSEInspectorProperty.getValue();
            if (this.getBackgroundImage() != null) {
                this.setBackgroundImage(new TSEImage(this.backgroundImageName));
            }
            n = 1;
        } else if (tSEInspectorPropertyID.equals(PICTURE_X_WORLD_OFFSET_ID)) {
            this.setBackgroundImageX((Double)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(PICTURE_Y_WORLD_OFFSET_ID)) {
            this.setBackgroundImageY((Double)tSEInspectorProperty.getValue());
            n = 1;
        } else if (tSEInspectorPropertyID.equals(PICTURE_STYLE_ID)) {
            this.setBackgroundImageStyle((Integer)tSEInspectorProperty.getValue());
            n = 2;
        } else if (tSEInspectorPropertyID.equals(PICTURE_TILED_ID)) {
            this.setBackgroundImageTiled((Boolean)tSEInspectorProperty.getValue());
            n = 1;
        } else {
            n = 0;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

