/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.ui;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.ui.TSEGraphUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import java.awt.Font;
import java.awt.Rectangle;

public class TSEChildGraphUI
extends TSENodeUI {
    public void reset() {
        super.reset();
        this.setBorderDrawn(true);
        this.setBorderColor(this.getFillColor());
    }

    public void drawOutline(TSEGraphics tSEGraphics) {
        super.drawOutline(tSEGraphics);
        TSEGraph tSEGraph = (TSEGraph)this.getOwnerNode().getChildGraph();
        if (tSEGraph != null) {
            TSTransform tSTransform = TSTransform.compose(tSEGraphics.getTSTransform(), tSEGraph.getClonedTransform());
            TSEGraphics tSEGraphics2 = tSEGraphics.deriveGraphics(tSTransform);
            tSEGraph.getUI().drawOutline(tSEGraphics2);
            TSRect tSRect = (TSRect)tSEGraph.getLocalFrameBounds();
            Rectangle rectangle = tSTransform.boundsToDevice(tSRect);
            tSEGraphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void draw(TSEGraphics tSEGraphics, boolean bl, boolean bl2) {
        if (this.getOwnerNode() != null) {
            TSENode tSENode = this.getOwnerNode();
            TSConstRect tSConstRect = tSENode.getLocalBounds();
            TSEGraph tSEGraph = (TSEGraph)tSENode.getChildGraph();
            if (tSEGraph != null) {
                TSConstRect tSConstRect2 = tSEGraph.getLocalFrameBounds();
                TSTransform tSTransform = TSTransform.compose(tSEGraphics.getTSTransform(), tSEGraph.getClonedTransform());
                TSEGraphics tSEGraphics2 = tSEGraphics.deriveGraphics(tSTransform);
                if (!(bl2 && !tSENode.isSelected() || this.isTransparent())) {
                    tSEGraphics.setColor(this.getFillColor());
                    tSEGraphics.fillRect(tSConstRect);
                    ((TSEGraphUI)tSEGraph.getUI()).drawBackground(tSEGraphics2, tSConstRect2, true, true);
                }
                ((TSEGraphUI)tSEGraph.getUI()).draw(tSEGraphics2, bl, false, tSConstRect2, bl2);
                if (!bl2 || tSENode.isSelected()) {
                    if (this.isBorderDrawn()) {
                        tSEGraphics.setColor(this.getBorderColor());
                        tSEGraphics.drawRect(tSConstRect);
                        tSEGraphics2.drawRect(tSConstRect2);
                    }
                    if (this.getOwner().getText() != null) {
                        this.drawText(tSEGraphics);
                    }
                    if (this.hasHideMark()) {
                        this.drawHideMark(tSEGraphics);
                    }
                    this.drawConstraintBadge(tSEGraphics);
                }
            }
        }
    }

    public void draw(TSEGraphics tSEGraphics) {
        this.draw(tSEGraphics, true, false);
    }

    public void drawSelected(TSEGraphics tSEGraphics, boolean bl, boolean bl2) {
        this.draw(tSEGraphics, bl, bl2);
        tSEGraphics.setColor(this.getSelectedColor());
        this.drawGrapples(tSEGraphics);
    }

    public double getTextOffsetY() {
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerNode().getChildGraph();
        double d = tSDGraph.getTailor().getBottomNestedViewSpacing().getCombinedSpacing(this.getOwnerNode().getTightHeight());
        return -(this.getOwnerNode().getLocalHeight() - d) / 2.0;
    }

    public void onTextChanged(String string) {
        super.onTextChanged(string);
        TSENode tSENode = this.getOwnerNode();
        TSDGraph tSDGraph = (TSDGraph)tSENode.getChildGraph();
        if (tSDGraph != null) {
            TSExpTransform tSExpTransform = tSDGraph.getClonedTransform();
            TSRect tSRect = new TSRect(tSDGraph.getLocalBounds());
            tSExpTransform.transformRect(tSRect, tSRect);
            TSRect tSRect2 = TSNestingManager.expandRectWithMargins(tSENode, tSRect);
            tSENode.setLocalBounds(tSRect2);
        }
    }

    protected double getBottomHeight() {
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerNode().getChildGraph();
        TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
        return (double)this.getTextHeight() + tSGraphTailor.getTopNestedViewConstant();
    }

    protected void updateTextSize() {
        super.updateTextSize();
        if (this.getOwnerNode() != null && this.getOwnerNode().isExpanded()) {
            TSDGraph tSDGraph = (TSDGraph)this.getOwnerNode().getChildGraph();
            TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
            tSGraphTailor.setBottomNestedViewConstant(this.getBottomHeight());
        }
    }

    protected double getMaximumBorderGrowthAmount() {
        return 10.0;
    }

    public TSEFont getDefaultFont() {
        return new TSEFont(new Font("SansSerif", 1, 10));
    }

    public TSEColor getDefaultTextColor() {
        return TSEColor.white;
    }

    public TSEColor getDefaultFillColor() {
        return TSENodeUI.DEFAULT_CHILD_GRAPH_MARK_COLOR;
    }

    public double getDefaultMarginSize() {
        return 10.0;
    }
}

