/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.diagramming.TSCutCopyPasteControl;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.command.TSEPasteCommand;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSOptionData;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f2;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;

public class TSEPasteTool
extends TSEWindowInputTool {
    private TSPoint lastPosition;
    private TSGraphObject selectedObject;
    private TSCutCopyPasteControl cutCopyPasteControl;
    private TSOptionData serviceInputData;
    private boolean canceled;

    public TSEPasteTool() {
        this((TSOptionData)null);
    }

    public TSEPasteTool(TSOptionData tSOptionData) {
        f2.a(f2.bx);
        this.setDefaultCursor(TSECursorManager.getCursor("Paste.32x32", 12));
        this.setActionCursor(TSECursorManager.getCursor("Paste.32x32", 12));
        this.cutCopyPasteControl = null;
        this.serviceInputData = tSOptionData;
        this.selectedObject = null;
        this.lastPosition = new TSPoint();
        this.canceled = false;
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            if (!this.canceled) {
                TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
                this.lastPosition.setLocation(tSConstPoint);
                this.cutCopyPasteControl = this.getGraphWindow().getCutCopyPasteControl();
                try {
                    this.cutCopyPasteControl.fetchClipboardGraphManager(this.serviceInputData);
                }
                catch (IOException iOException) {
                    System.err.println("Can not fetch Clipboard Graph Manager");
                    this.cancelAction();
                }
                TSEHitTesting tSEHitTesting = this.getHitTesting();
                TSEGraph tSEGraph = this.getGraph();
                if (this.getGraphWindow().isNestedGraphEditingEnabled()) {
                    tSEGraph = tSEHitTesting.getGraphAt(tSConstPoint, this.getGraph());
                }
                this.selectedObject = (TSGraphObject)((Object)tSEHitTesting.getGraphObjectAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled()));
                if (this.selectedObject == null) {
                    this.selectedObject = tSEGraph;
                }
                this.getGraphWindow().fastRepaint();
            }
        } else {
            super.onMousePressed(mouseEvent);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        if (!this.canceled) {
            TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
            this.lastPosition.setLocation(tSConstPoint);
            if (!this.updateVisibleArea(tSConstPoint, true)) {
                this.getGraphWindow().fastRepaint();
            }
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            if (!this.canceled && this.cutCopyPasteControl != null) {
                TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
                this.lastPosition.setLocation(tSConstPoint);
                this.commitPasteOperation();
                this.getGraphWindow().switchTool(this.getGraphWindow().getDefaultTool());
                this.cancelAction();
            }
        } else {
            super.onMouseReleased(mouseEvent);
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
    }

    public void cancelAction() {
        if (!this.canceled) {
            this.canceled = true;
            this.getGraphWindow().switchTool(this.getGraphWindow().getDefaultTool());
            this.getGraphWindow().repaint();
        }
    }

    public void resetTool() {
        this.canceled = false;
        super.resetTool();
    }

    protected void commitPasteOperation() {
        TSSystem.tsAssert(this.cutCopyPasteControl != null);
        TSSystem.tsAssert(this.selectedObject != null);
        TSSystem.tsAssert(this.lastPosition != null);
        int n = this.getEventManager().getContext();
        this.getEventManager().setContext(this.getEventContext());
        TSEGraphWindow tSEGraphWindow = this.getGraphWindow();
        Cursor cursor = tSEGraphWindow.showWaitCursorOnCanvas();
        tSEGraphWindow.transmit(new TSEPasteCommand(this.selectedObject, this.cutCopyPasteControl, this.lastPosition, this.serviceInputData));
        tSEGraphWindow.setCursorOnCanvas(cursor);
        this.getEventManager().setContext(n);
    }

    public void paint(TSEGraphics tSEGraphics) {
        block12: {
            TSEGraphics tSEGraphics2;
            block14: {
                block13: {
                    block11: {
                        if (this.canceled || this.cutCopyPasteControl == null) {
                            return;
                        }
                        TSPoint tSPoint = new TSPoint();
                        if (this.selectedObject instanceof TSEGraph) {
                            tSPoint = this.cutCopyPasteControl.getCenterOfClipboardGraph(true, false, false, false);
                        } else if (this.selectedObject instanceof TSEEdge) {
                            tSPoint = this.cutCopyPasteControl.getCenterOfClipboardGraph(false, true, false, false);
                        } else if (this.selectedObject instanceof TSENode) {
                            tSPoint = this.cutCopyPasteControl.getCenterOfClipboardGraph(false, false, true, false);
                        } else if (this.selectedObject instanceof TSEConnector) {
                            tSPoint = this.cutCopyPasteControl.getCenterOfClipboardGraph(false, false, false, true);
                        }
                        TSTransform tSTransform = new TSTransform(0, 0, 1, 1);
                        tSTransform.copy(tSEGraphics.getTSTransform());
                        tSTransform.moveWorldBy(tSPoint.getX() - this.lastPosition.getX(), tSPoint.getY() - this.lastPosition.getY());
                        tSEGraphics2 = tSEGraphics.deriveGraphics(tSTransform);
                        if (!(this.selectedObject instanceof TSEGraph)) break block11;
                        TSEGraph tSEGraph = (TSEGraph)this.cutCopyPasteControl.getClipboardGraph();
                        this.drawUI(tSEGraph.getUI(), tSEGraphics2);
                        break block12;
                    }
                    if (!(this.selectedObject instanceof TSEEdge)) break block13;
                    Iterator iterator = this.cutCopyPasteControl.getDemoEdge().labels().iterator();
                    while (iterator.hasNext()) {
                        TSEEdgeLabel tSEEdgeLabel = (TSEEdgeLabel)iterator.next();
                        this.drawUI(tSEEdgeLabel.getUI(), tSEGraphics2);
                    }
                    break block12;
                }
                if (!(this.selectedObject instanceof TSENode)) break block14;
                Iterator iterator = this.cutCopyPasteControl.getDemoNode().labels().iterator();
                while (iterator.hasNext()) {
                    TSENodeLabel tSENodeLabel = (TSENodeLabel)iterator.next();
                    this.drawUI(tSENodeLabel.getUI(), tSEGraphics2);
                }
                break block12;
            }
            if (!(this.selectedObject instanceof TSEConnector)) break block12;
            Iterator iterator = this.cutCopyPasteControl.getDemoConnector().labels().iterator();
            while (iterator.hasNext()) {
                TSEConnectorLabel tSEConnectorLabel = (TSEConnectorLabel)iterator.next();
                this.drawUI(tSEConnectorLabel.getUI(), tSEGraphics2);
            }
        }
    }

    private void drawUI(TSEObjectUI tSEObjectUI, TSEGraphics tSEGraphics) {
        if (this.getGraphWindow().isDrawFullUIOnDragging()) {
            tSEObjectUI.draw(tSEGraphics);
        } else {
            tSEObjectUI.drawOutline(tSEGraphics);
        }
    }

    public TSCutCopyPasteControl getCutCopyPasteControl() {
        return this.cutCopyPasteControl;
    }

    public TSPoint getLastPosition() {
        return this.lastPosition;
    }

    public TSGraphObject getTargetObject() {
        return this.selectedObject;
    }

    public int getEventContext() {
        return 8;
    }
}

