/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.diagramming.TSMoveControl;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSNodeLabel;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.command.TSEMoveGroupCommand;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;

public class TSEMoveSelectedTool
extends TSEWindowInputTool
implements ActionListener {
    TSConstPoint startPoint;
    private TSConstPoint oldPoint;
    private TSConstPoint offsetFromReference;
    private TSSolidGeometricObject referenceObject;
    TSMoveControl moveController;
    List graphsWithMovingObjects;
    List movingNodes;
    List movingPathNodes;
    List movingEdgeLabels;
    List movingNodeLabels;
    List movingConnectorLabels;
    Vector visibleDraggedEdges;
    Vector visibleDraggedNodes;
    Vector visibleDraggedEdgeLabels;
    Vector visibleDraggedNodeLabels;
    Vector visibleDraggedConnectorLabels;
    boolean needsGridCorrection;
    MouseEvent event;
    Timer timer;
    TSEWindowTool parentTool;
    List graphs;
    List margins;

    public TSEMoveSelectedTool(TSEWindowTool tSEWindowTool, TSConstPoint tSConstPoint, boolean bl) {
        super(tSEWindowTool);
        f2.a(f2.bs);
        this.parentTool = tSEWindowTool;
        TSSystem.tsAssert(tSEWindowTool != null);
        TSSystem.tsAssert(tSConstPoint != null);
        this.startPoint = tSConstPoint;
        this.offsetFromReference = new TSConstPoint(0.0, 0.0);
        this.referenceObject = null;
        this.needsGridCorrection = bl;
        this.setDefaultCursor(TSECursorManager.getCursor("MoveSelected.32x32", 13));
        this.setActionCursor(TSECursorManager.getCursor("MoveSelected.32x32", 13));
    }

    protected TSConstRect getMoveBounds() {
        List list = this.movingNodes;
        if (list != null && !list.isEmpty()) {
            TSRect tSRect = new TSRect(((TSDNode)list.get(0)).getBounds());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                tSRect.merge(((TSDNode)iterator.next()).getBounds());
            }
            return tSRect;
        }
        List list2 = this.movingPathNodes;
        if (list2 != null && !list2.isEmpty()) {
            TSRect tSRect = new TSRect(((TSPNode)list2.get(0)).getCenter(), ((TSPNode)list2.get(0)).getCenter());
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                tSRect.merge(((TSPNode)iterator.next()).getCenter());
            }
            return tSRect;
        }
        List list3 = this.movingEdgeLabels;
        if (list3 != null && !list3.isEmpty()) {
            TSRect tSRect = new TSRect(((TSEdgeLabel)list3.get(0)).getBounds());
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                tSRect.merge(((TSEdgeLabel)iterator.next()).getBounds());
            }
            return tSRect;
        }
        List list4 = this.movingNodeLabels;
        if (list4 != null && !list4.isEmpty()) {
            TSRect tSRect = new TSRect(((TSNodeLabel)list4.get(0)).getBounds());
            Iterator iterator = list4.iterator();
            while (iterator.hasNext()) {
                tSRect.merge(((TSNodeLabel)iterator.next()).getBounds());
            }
            return tSRect;
        }
        List list5 = this.movingConnectorLabels;
        if (list5 != null && !list5.isEmpty()) {
            TSRect tSRect = new TSRect(((TSConnectorLabel)list5.get(0)).getBounds());
            Iterator iterator = list5.iterator();
            while (iterator.hasNext()) {
                tSRect.merge(((TSConnectorLabel)iterator.next()).getBounds());
            }
            return tSRect;
        }
        return null;
    }

    public TSConstSize getSnapShift() {
        TSConstRect tSConstRect = this.getMoveBounds();
        double d = 0.0;
        double d2 = 0.0;
        if (tSConstRect != null) {
            d = this.getGraphWindow().getGrid().getNearestGridX(tSConstRect.getCenterX()) - tSConstRect.getCenterX();
            d2 = this.getGraphWindow().getGrid().getNearestGridY(tSConstRect.getCenterY()) - tSConstRect.getCenterY();
        }
        return new TSConstSize(d, d2);
    }

    protected void init() {
        Object object;
        Object object2;
        Cloneable cloneable;
        Object object3;
        Object object4;
        super.init();
        this.storeOldMargins();
        if (this.needsGridCorrection) {
            object4 = this.getHitTesting();
            object3 = ((TSEHitTesting)object4).getGraphObjectAt(this.startPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            if (object3 != null && object3 instanceof TSSolidGeometricObject) {
                this.referenceObject = (TSSolidGeometricObject)object3;
                cloneable = this.referenceObject.getCenter();
                double d = ((TSConstPoint)cloneable).getX() - this.startPoint.getX();
                double d2 = ((TSConstPoint)cloneable).getY() - this.startPoint.getY();
                this.offsetFromReference = new TSConstPoint(d, d2);
                this.startPoint = new TSConstPoint(this.startPoint.getX() + this.offsetFromReference.getX(), this.startPoint.getY() + this.offsetFromReference.getY());
            } else {
                this.startPoint = this.getGraphWindow().getGrid().getNearestGridPoint(this.startPoint);
            }
        }
        object4 = this.getGraphWindow().getGraphManager();
        this.moveController = this.newMoveControl();
        this.graphsWithMovingObjects = ((TSEGraphManager)object4).graphsWithSelectedObjects();
        this.movingNodes = ((TSEGraphManager)object4).selectedNodes();
        this.movingPathNodes = ((TSEGraphManager)object4).selectedPathNodes(true);
        this.movingEdgeLabels = ((TSEGraphManager)object4).selectedEdgeLabels(true);
        this.movingNodeLabels = ((TSEGraphManager)object4).selectedNodeLabels();
        this.movingConnectorLabels = ((TSEGraphManager)object4).selectedConnectorLabels();
        this.moveController.init(this.graphsWithMovingObjects, this.movingNodes, this.movingPathNodes, this.movingEdgeLabels, this.movingNodeLabels, this.movingConnectorLabels);
        this.moveController.onStartAt(this.startPoint.getX(), this.startPoint.getY());
        this.visibleDraggedEdges = new Vector();
        this.visibleDraggedNodes = new Vector();
        this.visibleDraggedEdgeLabels = new Vector();
        this.visibleDraggedNodeLabels = new Vector();
        this.visibleDraggedConnectorLabels = new Vector();
        object3 = ((TSEGraphManager)object4).graphsWithSelectedObjects().iterator();
        while (object3.hasNext()) {
            Object object5;
            cloneable = (TSDGraph)object3.next();
            Iterator iterator = ((TSGraph)cloneable).nodes().iterator();
            while (iterator.hasNext()) {
                object2 = (TSDNode)iterator.next();
                if (this.moveController.draggedNodes().contains(object2) && ((TSDNode)object2).isVisible()) {
                    this.visibleDraggedNodes.add(object2);
                }
                if (((TSDNode)object2).numberOfLabels() > 0) {
                    Iterator iterator2 = ((TSDNode)object2).labels().iterator();
                    while (iterator2.hasNext()) {
                        object = (TSNodeLabel)iterator2.next();
                        if (!this.moveController.draggedNodeLabels().contains(object) || !((TSLabel)object).isVisible()) continue;
                        this.visibleDraggedNodeLabels.add(object);
                    }
                }
                Iterator iterator3 = ((TSDNode)object2).connectors().iterator();
                while (iterator3.hasNext()) {
                    object = (TSEConnector)iterator3.next();
                    object5 = ((TSConnector)object).labels().iterator();
                    while (object5.hasNext()) {
                        TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)object5.next();
                        if (!this.moveController.draggedConnectorLabels().contains(tSConnectorLabel) || !tSConnectorLabel.isVisible()) continue;
                        this.visibleDraggedConnectorLabels.add(tSConnectorLabel);
                    }
                }
            }
            object2 = ((TSGraph)cloneable).edges().iterator();
            while (object2.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)object2.next();
                if (this.moveController.draggedEdges().contains(tSDEdge) && tSDEdge.isVisible()) {
                    this.visibleDraggedEdges.add(tSDEdge);
                }
                if (tSDEdge.numberOfLabels() <= 0) continue;
                object = tSDEdge.labels().iterator();
                while (object.hasNext()) {
                    object5 = (TSEdgeLabel)object.next();
                    if (!this.moveController.draggedEdgeLabels().contains(object5) || !((TSLabel)object5).isVisible()) continue;
                    this.visibleDraggedEdgeLabels.add(object5);
                }
            }
        }
        Iterator iterator = ((TSGraphManager)object4).intergraphEdges().iterator();
        while (iterator.hasNext()) {
            object2 = (TSDEdge)iterator.next();
            if (this.moveController.draggedEdges().contains(object2) && ((TSDEdge)object2).isVisible()) {
                this.visibleDraggedEdges.add(object2);
            }
            if (((TSDEdge)object2).numberOfLabels() <= 0) continue;
            Iterator iterator4 = ((TSDEdge)object2).labels().iterator();
            while (iterator4.hasNext()) {
                object = (TSEdgeLabel)iterator4.next();
                if (!this.moveController.draggedEdgeLabels().contains(object) || !((TSLabel)object).isVisible()) continue;
                this.visibleDraggedEdgeLabels.add(object);
            }
        }
        this.setObjectsVisible(false);
        this.invalidateMoving();
    }

    protected TSMoveControl newMoveControl() {
        return new TSMoveControl();
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
        this.event = mouseEvent;
        if (!this.getGraphWindow().getTransform().getWorldBounds().contains(tSConstPoint) && this.timer == null) {
            this.timer = new Timer(50, this);
            this.timer.setCoalesce(true);
            this.timer.start();
        }
        this.drag();
    }

    public void drag() {
        TSConstPoint tSConstPoint = new TSConstPoint(this.getNonalignedWorldX(this.event) + this.offsetFromReference.getX(), this.getNonalignedWorldY(this.event) + this.offsetFromReference.getY());
        if (this.needsGridCorrection) {
            tSConstPoint = this.getGraphWindow().getGrid().getNearestGridPoint(tSConstPoint);
        }
        if (tSConstPoint.equals(this.oldPoint)) {
            return;
        }
        this.oldPoint = tSConstPoint;
        this.updateDirtyRegion();
        this.moveController.onDragTo(tSConstPoint.getX(), tSConstPoint.getY());
        this.updateDirtyRegion();
        if (!this.updateVisibleArea(tSConstPoint, true)) {
            this.paintDirtyRegion(true);
        }
    }

    void updateDirtyRegion() {
        TSGraphMember tSGraphMember;
        this.addDirtyRegion(this.moveController.draggedEdges());
        this.addDirtyRegion(this.moveController.draggedNodes());
        this.addDirtyRegion(this.moveController.draggedEdgeLabels());
        this.addDirtyRegion(this.moveController.draggedNodeLabels());
        this.addDirtyRegion(this.moveController.draggedConnectorLabels());
        this.addDirtyRegion(this.moveController.draggedPathNodes());
        Iterator iterator = this.moveController.draggedEdges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEEdge)iterator.next();
            this.addDirtyRegion(((TSDEdge)tSGraphMember).labels());
        }
        iterator = this.moveController.draggedNodes().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSENode)iterator.next();
            this.addDirtyRegion(((TSDNode)tSGraphMember).labels());
            List list = ((TSDNode)tSGraphMember).connectors();
            if (list.isEmpty()) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                TSEConnector tSEConnector = (TSEConnector)iterator2.next();
                this.addDirtyRegion(tSEConnector.labels());
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.event != null) {
            this.drag();
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if (this.timer != null) {
            this.timer.stop();
            this.event = null;
            this.timer = null;
        }
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            this.moveController.onCancel();
            this.finalizeTool();
            this.parentTool.setCursor(TSECursorManager.getCursor("MoveSelected.32x32", 13));
            this.setObjectsVisible(true);
            TSConstPoint tSConstPoint = new TSConstPoint(this.getNonalignedWorldX(mouseEvent) + this.offsetFromReference.getX(), this.getNonalignedWorldY(mouseEvent) + this.offsetFromReference.getY());
            if (this.needsGridCorrection) {
                tSConstPoint = this.getGraphWindow().getGrid().getNearestGridPoint(tSConstPoint);
            }
            this.commitMove(tSConstPoint);
            this.needsGridCorrection = false;
        }
        super.onMouseReleased(mouseEvent);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.cancelAction();
        }
        super.onMousePressed(mouseEvent);
    }

    public void paint(TSEGraphics tSEGraphics) {
        block36: {
            Vector vector;
            Vector vector2;
            Vector vector3;
            Vector vector4;
            Vector vector5;
            if (this.moveController.getState() != 200) break block36;
            if (this.getGraphWindow().isDrawInvisibleOnDragging()) {
                vector5 = (Vector)this.moveController.draggedEdges();
                vector4 = (Vector)this.moveController.draggedNodes();
                vector3 = (Vector)this.moveController.draggedEdgeLabels();
                vector2 = (Vector)this.moveController.draggedNodeLabels();
                vector = (Vector)this.moveController.draggedConnectorLabels();
            } else {
                vector5 = this.visibleDraggedEdges;
                vector4 = this.visibleDraggedNodes;
                vector3 = this.visibleDraggedEdgeLabels;
                vector2 = this.visibleDraggedNodeLabels;
                vector = this.visibleDraggedConnectorLabels;
            }
            if (this.getGraphWindow().isDrawFullUIOnDragging()) {
                TSLabel tSLabel;
                Iterator iterator;
                TSEGraphics tSEGraphics2;
                TSGraphObject tSGraphObject;
                Iterator iterator2 = vector4.iterator();
                while (iterator2.hasNext()) {
                    tSGraphObject = (TSENode)iterator2.next();
                    tSEGraphics2 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSEGraph)((TSNode)tSGraphObject).getOwnerGraph()).getLocalToMainDisplayGraphTransform()));
                    if (((TSENode)tSGraphObject).isSelected()) {
                        ((TSENode)tSGraphObject).getUI().drawSelected(tSEGraphics2);
                    } else {
                        ((TSENode)tSGraphObject).getUI().draw(tSEGraphics2);
                    }
                    ((TSENode)tSGraphObject).getNodeUI().drawConnectors(tSEGraphics2);
                    iterator = ((TSDNode)tSGraphObject).labels().iterator();
                    while (iterator.hasNext()) {
                        tSLabel = (TSENodeLabel)iterator.next();
                        if (!this.getGraphWindow().isDrawInvisibleOnDragging() && !tSLabel.isVisible()) continue;
                        if (((TSENodeLabel)tSLabel).isSelected()) {
                            ((TSENodeLabel)tSLabel).getUI().drawSelected(tSEGraphics2);
                            continue;
                        }
                        ((TSENodeLabel)tSLabel).getUI().draw(tSEGraphics2);
                    }
                }
                iterator2 = vector5.iterator();
                while (iterator2.hasNext()) {
                    tSGraphObject = (TSEEdge)iterator2.next();
                    tSEGraphics2 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSDEdge)tSGraphObject).getLocalToMainDisplayGraphTransform()));
                    if (((TSEEdge)tSGraphObject).isSelected()) {
                        ((TSEEdge)tSGraphObject).getUI().drawSelected(tSEGraphics2);
                    } else {
                        ((TSEEdge)tSGraphObject).getUI().draw(tSEGraphics2);
                    }
                    ((TSEEdge)tSGraphObject).getEdgeUI().drawBends(tSEGraphics2);
                    iterator = ((TSDEdge)tSGraphObject).labels().iterator();
                    while (iterator.hasNext()) {
                        tSLabel = (TSEEdgeLabel)iterator.next();
                        if (!this.getGraphWindow().isDrawInvisibleOnDragging() && !tSLabel.isVisible()) continue;
                        if (((TSEEdgeLabel)tSLabel).isSelected()) {
                            ((TSEEdgeLabel)tSLabel).getUI().drawSelected(tSEGraphics2);
                            continue;
                        }
                        ((TSEEdgeLabel)tSLabel).getUI().draw(tSEGraphics2);
                    }
                }
                iterator2 = vector3.iterator();
                while (iterator2.hasNext()) {
                    tSGraphObject = (TSEEdgeLabel)iterator2.next();
                    tSEGraphics2 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSEEdge)tSGraphObject.getOwner()).getLocalToMainDisplayGraphTransform()));
                    if (((TSEEdgeLabel)tSGraphObject).isSelected()) {
                        ((TSEEdgeLabel)tSGraphObject).getUI().drawSelected(tSEGraphics2);
                        continue;
                    }
                    ((TSEEdgeLabel)tSGraphObject).getUI().draw(tSEGraphics2);
                }
                iterator2 = vector.iterator();
                while (iterator2.hasNext()) {
                    tSGraphObject = (TSEConnectorLabel)iterator2.next();
                    tSEGraphics2 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSEGraph)((TSConnectorLabel)tSGraphObject).getOwnerGraph()).getLocalToMainDisplayGraphTransform()));
                    if (((TSEConnectorLabel)tSGraphObject).isSelected()) {
                        ((TSEConnectorLabel)tSGraphObject).getUI().drawSelected(tSEGraphics2);
                        continue;
                    }
                    ((TSEConnectorLabel)tSGraphObject).getUI().draw(tSEGraphics2);
                }
                iterator2 = vector2.iterator();
                while (iterator2.hasNext()) {
                    tSGraphObject = (TSENodeLabel)iterator2.next();
                    tSEGraphics2 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSEGraph)((TSLabel)tSGraphObject).getOwnerGraph()).getLocalToMainDisplayGraphTransform()));
                    if (((TSENodeLabel)tSGraphObject).isSelected()) {
                        ((TSENodeLabel)tSGraphObject).getUI().drawSelected(tSEGraphics2);
                        continue;
                    }
                    ((TSENodeLabel)tSGraphObject).getUI().draw(tSEGraphics2);
                }
            } else {
                TSLabel tSLabel;
                Iterator iterator;
                TSEGraphics tSEGraphics3;
                TSGraphObject tSGraphObject;
                Iterator iterator3 = vector4.iterator();
                while (iterator3.hasNext()) {
                    tSGraphObject = (TSENode)iterator3.next();
                    tSEGraphics3 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSEGraph)((TSNode)tSGraphObject).getOwnerGraph()).getLocalToMainDisplayGraphTransform()));
                    if (((TSENode)tSGraphObject).isSelected()) {
                        ((TSENode)tSGraphObject).getUI().drawSelectedOutline(tSEGraphics3);
                    } else {
                        ((TSENode)tSGraphObject).getUI().drawOutline(tSEGraphics3);
                    }
                    ((TSENode)tSGraphObject).getNodeUI().drawConnectorOutlines(tSEGraphics3);
                    iterator = ((TSDNode)tSGraphObject).labels().iterator();
                    while (iterator.hasNext()) {
                        tSLabel = (TSENodeLabel)iterator.next();
                        if (!this.getGraphWindow().isDrawInvisibleOnDragging() && !tSLabel.isVisible()) continue;
                        if (((TSENodeLabel)tSLabel).isSelected()) {
                            ((TSENodeLabel)tSLabel).getUI().drawSelectedOutline(tSEGraphics3);
                            continue;
                        }
                        ((TSENodeLabel)tSLabel).getUI().drawOutline(tSEGraphics3);
                    }
                }
                iterator3 = vector5.iterator();
                while (iterator3.hasNext()) {
                    tSGraphObject = (TSEEdge)iterator3.next();
                    tSEGraphics3 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSDEdge)tSGraphObject).getLocalToMainDisplayGraphTransform()));
                    if (((TSEEdge)tSGraphObject).isSelected()) {
                        ((TSEEdge)tSGraphObject).getUI().drawSelectedOutline(tSEGraphics3);
                    } else {
                        ((TSEEdge)tSGraphObject).getUI().drawOutline(tSEGraphics3);
                    }
                    ((TSEEdge)tSGraphObject).getEdgeUI().drawBendOutlines(tSEGraphics3);
                    iterator = ((TSDEdge)tSGraphObject).labels().iterator();
                    while (iterator.hasNext()) {
                        tSLabel = (TSEEdgeLabel)iterator.next();
                        if (!this.getGraphWindow().isDrawInvisibleOnDragging() && !tSLabel.isVisible()) continue;
                        if (((TSEEdgeLabel)tSLabel).isSelected()) {
                            ((TSEEdgeLabel)tSLabel).getUI().drawSelectedOutline(tSEGraphics3);
                            continue;
                        }
                        ((TSEEdgeLabel)tSLabel).getUI().drawOutline(tSEGraphics3);
                    }
                }
                iterator3 = vector3.iterator();
                while (iterator3.hasNext()) {
                    tSGraphObject = (TSEEdgeLabel)iterator3.next();
                    tSEGraphics3 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSEEdge)tSGraphObject.getOwner()).getLocalToMainDisplayGraphTransform()));
                    if (((TSEEdgeLabel)tSGraphObject).isSelected()) {
                        ((TSEEdgeLabel)tSGraphObject).getUI().drawSelectedOutline(tSEGraphics3);
                        continue;
                    }
                    ((TSEEdgeLabel)tSGraphObject).getUI().drawOutline(tSEGraphics3);
                }
                iterator3 = vector.iterator();
                while (iterator3.hasNext()) {
                    tSGraphObject = (TSEConnectorLabel)iterator3.next();
                    tSEGraphics3 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSEGraph)((TSConnectorLabel)tSGraphObject).getOwnerGraph()).getLocalToMainDisplayGraphTransform()));
                    if (((TSEConnectorLabel)tSGraphObject).isSelected()) {
                        ((TSEConnectorLabel)tSGraphObject).getUI().drawSelectedOutline(tSEGraphics3);
                        continue;
                    }
                    ((TSEConnectorLabel)tSGraphObject).getUI().drawOutline(tSEGraphics3);
                }
                iterator3 = vector2.iterator();
                while (iterator3.hasNext()) {
                    tSGraphObject = (TSENodeLabel)iterator3.next();
                    tSEGraphics3 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSEGraph)((TSLabel)tSGraphObject).getOwnerGraph()).getLocalToMainDisplayGraphTransform()));
                    if (((TSENodeLabel)tSGraphObject).isSelected()) {
                        ((TSENodeLabel)tSGraphObject).getUI().drawSelectedOutline(tSEGraphics3);
                        continue;
                    }
                    ((TSENodeLabel)tSGraphObject).getUI().drawOutline(tSEGraphics3);
                }
            }
        }
    }

    public void cancelAction() {
        if (this.timer != null) {
            this.timer.stop();
            this.event = null;
            this.timer = null;
        }
        this.setObjectsVisible(true);
        this.moveController.onCancel();
        this.invalidateMoving();
        this.getGraphWindow().fastRepaint();
        this.finalizeTool();
    }

    void invalidateMoving() {
        TSGraphMember tSGraphMember;
        this.getGraphWindow().addInvalidRegion(this.moveController.draggedEdges());
        this.getGraphWindow().addInvalidRegion(this.moveController.draggedNodes());
        this.getGraphWindow().addInvalidRegion(this.moveController.draggedEdgeLabels());
        this.getGraphWindow().addInvalidRegion(this.moveController.draggedNodeLabels());
        this.getGraphWindow().addInvalidRegion(this.moveController.draggedConnectorLabels());
        this.getGraphWindow().addInvalidRegion(this.moveController.draggedPathNodes());
        Iterator iterator = this.moveController.draggedEdges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSEEdge)iterator.next();
            this.getGraphWindow().addInvalidRegion(((TSDEdge)tSGraphMember).labels());
        }
        iterator = this.moveController.draggedNodes().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSENode)iterator.next();
            this.getGraphWindow().addInvalidRegion(((TSDNode)tSGraphMember).labels());
            Iterator iterator2 = ((TSDNode)tSGraphMember).connectors().iterator();
            while (iterator2.hasNext()) {
                TSEConnector tSEConnector = (TSEConnector)iterator2.next();
                this.getGraphWindow().addInvalidRegion(tSEConnector.labels());
            }
        }
        this.getGraphWindow().updateInvalidRegion();
    }

    void setObjectsVisible(boolean bl) {
        TSGraphObject tSGraphObject;
        Iterator iterator = this.visibleDraggedEdges.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSEEdge)iterator.next();
            ((TSDEdge)tSGraphObject).setVisible(bl);
            ((TSEEdge)tSGraphObject).setDragged(!bl);
        }
        iterator = this.visibleDraggedNodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSENode)iterator.next();
            ((TSDNode)tSGraphObject).setVisible(bl);
            ((TSENode)tSGraphObject).setDragged(!bl);
        }
        iterator = this.visibleDraggedEdgeLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSEEdgeLabel)iterator.next();
            ((TSLabel)tSGraphObject).setVisible(bl);
            ((TSEEdgeLabel)tSGraphObject).setDragged(!bl);
        }
        iterator = this.visibleDraggedNodeLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSENodeLabel)iterator.next();
            ((TSLabel)tSGraphObject).setVisible(bl);
            ((TSENodeLabel)tSGraphObject).setDragged(!bl);
        }
        iterator = this.visibleDraggedConnectorLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSEConnectorLabel)iterator.next();
            ((TSLabel)tSGraphObject).setVisible(bl);
            ((TSEConnectorLabel)tSGraphObject).setDragged(!bl);
        }
    }

    public void commitMove(TSConstPoint tSConstPoint) {
        int n = this.getEventManager().getContext();
        this.getEventManager().setContext(this.getEventContext());
        TSEMoveGroupCommand tSEMoveGroupCommand = this.newMoveCommand(this.graphsWithMovingObjects, this.movingNodes, this.movingPathNodes, this.movingEdgeLabels, this.movingNodeLabels, this.movingConnectorLabels, this.startPoint, tSConstPoint);
        tSEMoveGroupCommand.setMarginLists(this.graphs, this.margins);
        this.getGraphWindow().transmit(tSEMoveGroupCommand);
        this.getEventManager().setContext(n);
    }

    protected TSEMoveGroupCommand newMoveCommand(List list, List list2, List list3, List list4, List list5, List list6, TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        return new TSEMoveGroupCommand(list, list2, list3, list4, list5, list6, tSConstPoint, tSConstPoint2);
    }

    public TSConstPoint getStartPoint() {
        return this.startPoint;
    }

    public List getMovedObjects() {
        Vector vector = new Vector();
        vector.addAll(this.moveController.draggedNodes());
        vector.addAll(this.moveController.draggedEdges());
        vector.addAll(this.moveController.draggedEdgeLabels());
        vector.addAll(this.moveController.draggedNodeLabels());
        vector.addAll(this.moveController.draggedConnectorLabels());
        return vector;
    }

    public TSMoveControl getMoveControl() {
        return this.moveController;
    }

    private void storeOldMargins() {
        TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
        if (tSEGraphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSEGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSEGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    public int getEventContext() {
        return 4;
    }
}

