/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.tool.il;
import com.tomsawyer.editor.tool.im;
import com.tomsawyer.editor.tool.in;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f2;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class TSELinkNavigationTool
extends TSEWindowInputTool
implements ActionListener {
    in scrollListener;
    private im blinkListener;
    private Timer scrollTimer;
    private Timer blinkTimer;
    private il edgeChooser = new il(this);
    private int[] wayPoints;
    int originalHitTolerance;
    boolean blinking = false;
    TSEEdge blinkingEdge;
    boolean forwardDirection;
    TSEEdge lastNavigatedEdge;
    TSEEdge lastHitEdge;
    private boolean movedSinceLastRightClick = true;

    public TSELinkNavigationTool() {
        f2.a(f2.a8);
        this.setDefaultCursor(TSECursorManager.getCursor("LinkNavigation.32x32", 13));
        this.setActionCursor(TSECursorManager.getCursor("LinkNavigation.32x32", 13));
    }

    protected void init() {
        super.init();
        this.originalHitTolerance = this.getGraphWindow().getHitTolerance();
    }

    public void setTripDuration(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Link navigation trip duration has to be greater or equal to 0");
        }
        this.getGraphWindow().getPreferences().setValue((Object)"edgeNavigationTripDuration", n);
    }

    public void setFrameCount(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Link navigation frame count has to be greater than 0");
        }
        this.getGraphWindow().getPreferences().setValue((Object)"edgeNavigationFrameCount", n);
    }

    public void setBlinkDuration(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Link navigation blink duration has to be greater or equal to 0");
        }
        this.getGraphWindow().getPreferences().setValue((Object)"edgeNavigationBlinkDuration", n);
    }

    public int getTripDuration() {
        return this.getGraphWindow().getPreferences().getIntValue("edgeNavigationTripDuration");
    }

    public int getFrameCount() {
        return this.getGraphWindow().getPreferences().getIntValue("edgeNavigationFrameCount");
    }

    public int getBlinkDuration() {
        return this.getGraphWindow().getPreferences().getIntValue("edgeNavigationBlinkDuration");
    }

    public int getDefaultTripDuration() {
        return 300;
    }

    public int getDefaultFrameCount() {
        return 10;
    }

    public int getDefaultBlinkDuration() {
        return 500;
    }

    public void onMouseClicked(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint;
        TSEObject tSEObject;
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) == 0 && (n & 8) == 0 && (n & 4) == 0) {
            n |= 0x10;
        }
        if (System.getProperty("os.name").startsWith("Mac")) {
            n |= 0x10;
            if (mouseEvent.isControlDown() && mouseEvent.isAltDown() && !mouseEvent.isPopupTrigger()) {
                mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), true);
            }
        }
        if ((double)this.getGraphWindow().getHitTolerance() * this.getGraphWindow().getZoomLevel() < 2.0) {
            this.getGraphWindow().setHitTolerance((int)(2.0 / this.getGraphWindow().getZoomLevel()));
        }
        if ((tSEObject = this.nextObjectHitTesting(tSConstPoint = this.getNonalignedWorldPoint(mouseEvent))) != null) {
            this.actOnClick(tSEObject, tSConstPoint, n);
        }
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.mouseMoved(mouseEvent);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) == 0 && (n & 8) == 0 && (n & 4) == 0) {
            n |= 0x10;
        }
        if (System.getProperty("os.name").startsWith("Mac")) {
            n |= 0x10;
            if (mouseEvent.isControlDown() && mouseEvent.isAltDown() && !mouseEvent.isPopupTrigger()) {
                mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), true);
            }
        }
        TSConstPoint tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
        TSEObject tSEObject = this.nextObjectHitTesting(tSConstPoint);
        if (mouseEvent.isPopupTrigger()) {
            if (!(tSEObject instanceof TSENode || tSEObject instanceof TSEEdge || tSEObject instanceof TSEConnector || tSEObject instanceof TSEPNode)) {
                super.onMouseReleased(mouseEvent);
            }
        } else {
            super.onMouseReleased(mouseEvent);
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.mouseMoved(mouseEvent);
        this.movedSinceLastRightClick = true;
    }

    private TSEObject nextObjectHitTesting(TSConstPoint tSConstPoint) {
        TSEHitTesting tSEHitTesting = this.getHitTesting();
        TSEObject tSEObject = tSEHitTesting.getGraphObjectAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
        if (tSEObject == null || tSEObject instanceof TSEEdge) {
            int n = tSEHitTesting.getHitTolerance();
            int n2 = tSEHitTesting.getHitToleranceThreshold();
            boolean bl = this.getGraphWindow().getGraphManager().getEventManager().isFiringEvents();
            this.getGraphWindow().getGraphManager().getEventManager().setFireEvents(false);
            this.getGraphWindow().setHitTolerance(2);
            this.getGraphWindow().setHitToleranceThreshold(Integer.MAX_VALUE);
            TSEConnector tSEConnector = tSEHitTesting.getConnectorAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            if (tSEConnector != null) {
                if (tSEObject != null) {
                    TSEEdge tSEEdge = (TSEEdge)tSEObject;
                    if (tSEEdge.getSourceConnector() == tSEConnector || tSEEdge.getTargetConnector() == tSEConnector) {
                        tSEObject = tSEConnector;
                    }
                } else {
                    tSEObject = tSEConnector;
                }
            } else {
                TSENode tSENode = tSEHitTesting.getNodeAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
                if (tSEObject != null) {
                    TSEEdge tSEEdge = (TSEEdge)tSEObject;
                    if (tSEEdge.getSourceNode() == tSENode || tSEEdge.getTargetNode() == tSENode) {
                        tSEObject = tSENode;
                    }
                } else {
                    tSEObject = tSENode;
                }
            }
            this.getGraphWindow().setHitTolerance(n);
            this.getGraphWindow().setHitToleranceThreshold(n2);
            this.getGraphWindow().getGraphManager().getEventManager().setFireEvents(bl);
        }
        return tSEObject;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.cancelAction();
    }

    public void finalizeTool() {
        this.getGraphWindow().setHitTolerance(this.originalHitTolerance);
        this.stopScrolling();
        this.stopBlinking();
        super.finalizeTool();
    }

    void actOnClick(TSEObject tSEObject, TSConstPoint tSConstPoint, int n) {
        TSEEdge tSEEdge = null;
        boolean bl = false;
        this.forwardDirection = true;
        if ((n & 0x10) != 0 && (n & 2) == 0) {
            if (tSEObject instanceof TSPNode) {
                tSEObject = (TSEEdge)tSEObject.getOwner();
            } else if (tSEObject instanceof TSEConnector) {
                tSEObject = (TSENode)tSEObject.getOwner();
            }
            if (tSEObject instanceof TSENode) {
                TSENode tSENode = (TSENode)tSEObject;
                tSEEdge = this.isEdgeBlinking() && this.blinkingEdge != null && (this.blinkingEdge.getSourceNode() == tSENode || this.blinkingEdge.getTargetNode() == tSENode) ? this.blinkingEdge : this.edgeChooser.a(tSENode, false, tSConstPoint);
                if (tSEEdge != null) {
                    boolean bl2;
                    if (this.edgeChooser.a()) {
                        bl2 = this.edgeChooser.b();
                    } else {
                        boolean bl3 = bl2 = tSEEdge.getSourceNode() == tSENode;
                    }
                    this.forwardDirection = bl2;
                }
            } else if (tSEObject instanceof TSEEdge) {
                double d;
                double d2;
                double d3;
                double d4;
                if (this.isEdgeBlinking()) {
                    TSEHitTesting tSEHitTesting = this.getHitTesting();
                    TSENode tSENode = tSEHitTesting.getNodeAt(tSConstPoint, this.getGraph(), true);
                    if (tSENode == null) {
                        tSENode = tSEHitTesting.getExpandedNodeAt(tSConstPoint, this.getGraph(), true);
                    }
                    if (tSENode != null) {
                        this.actOnClick(tSENode, tSConstPoint, n);
                        return;
                    }
                }
                tSEEdge = (TSEEdge)tSEObject;
                bl = true;
                double d5 = tSConstPoint.getX() - tSEEdge.getSourceClippingPoint().getX();
                double d6 = d5 * d5 + (d4 = tSConstPoint.getY() - tSEEdge.getSourceClippingPoint().getY()) * d4;
                if (d6 >= (d3 = (d2 = tSConstPoint.getX() - tSEEdge.getTargetClippingPoint().getX()) * d2 + (d = tSConstPoint.getY() - tSEEdge.getTargetClippingPoint().getY()) * d)) {
                    this.forwardDirection = false;
                }
            }
            if (tSEEdge != null) {
                this.stopBlinking();
                this.stopScrolling();
                this.scrollAlongEdge(tSConstPoint, tSEEdge, bl);
            }
        } else if ((n & 0x10) != 0 && (n & 2) != 0 || (n & 4) != 0) {
            if (!this.movedSinceLastRightClick && this.edgeChooser.c() != null && this.edgeChooser.c().contains(tSConstPoint)) {
                tSEObject = this.edgeChooser.c();
            } else if (tSEObject instanceof TSPNode) {
                tSEObject = (TSEEdge)tSEObject.getOwner();
            } else if (tSEObject instanceof TSEConnector) {
                tSEObject = (TSENode)tSEObject.getOwner();
            }
            this.movedSinceLastRightClick = false;
            if (tSEObject instanceof TSENode) {
                tSEEdge = this.edgeChooser.a((TSENode)tSEObject, true, tSConstPoint);
                if (tSEEdge != null) {
                    boolean bl4 = this.edgeChooser.b();
                    this.forwardDirection = bl4;
                    this.stopScrolling();
                    this.stopBlinking();
                    this.startBlinking(tSEEdge);
                    this.scrollToEndOfEdge((TSENode)tSEObject, tSEEdge, tSConstPoint, bl4);
                }
            } else if (tSEObject instanceof TSEEdge) {
                TSEHitTesting tSEHitTesting = this.getHitTesting();
                TSENode tSENode = tSEHitTesting.getNodeAt(tSConstPoint, this.getGraph(), true);
                if (tSENode == null) {
                    tSENode = tSEHitTesting.getExpandedNodeAt(tSConstPoint, this.getGraph(), true);
                }
                if (tSENode != null && this.isEdgeBlinking()) {
                    this.actOnClick(tSENode, tSConstPoint, n);
                } else {
                    double d;
                    double d7;
                    double d8;
                    double d9;
                    if (((TSEEdge)tSEObject).getSourceNode() == tSEHitTesting.getNodeAt(tSConstPoint, tSEHitTesting.getGraphAt(tSConstPoint, this.getGraph()), true)) {
                        this.actOnClick((TSENode)((TSEEdge)tSEObject).getSourceNode(), tSConstPoint, n);
                        return;
                    }
                    if (((TSEEdge)tSEObject).getTargetNode() == tSEHitTesting.getNodeAt(tSConstPoint, tSEHitTesting.getGraphAt(tSConstPoint, this.getGraph()), true)) {
                        this.actOnClick((TSENode)((TSEEdge)tSEObject).getTargetNode(), tSConstPoint, n);
                        return;
                    }
                    tSEEdge = (TSEEdge)tSEObject;
                    bl = true;
                    double d10 = tSConstPoint.getX() - tSEEdge.getSourceClippingPoint().getX();
                    double d11 = d10 * d10 + (d9 = tSConstPoint.getY() - tSEEdge.getSourceClippingPoint().getY()) * d9;
                    this.forwardDirection = !(d11 < (d8 = (d7 = tSConstPoint.getX() - tSEEdge.getTargetClippingPoint().getX()) * d7 + (d = tSConstPoint.getY() - tSEEdge.getTargetClippingPoint().getY()) * d));
                    if (tSEEdge != null) {
                        this.stopBlinking();
                        this.stopScrolling();
                        this.startBlinking(tSEEdge);
                        this.scrollAlongEdge(tSConstPoint, tSEEdge, bl);
                    }
                }
            }
        }
    }

    public boolean scrollingInProgress() {
        return this.wayPoints != null;
    }

    private void scrollAlongEdge(TSConstPoint tSConstPoint, TSEEdge tSEEdge, boolean bl) {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        if (this.scrollingInProgress()) {
            this.stopScrolling();
        }
        this.lastNavigatedEdge = tSEEdge;
        Vector<TSConstPoint> vector = new Vector<TSConstPoint>();
        vector.add(tSConstPoint);
        if (bl) {
            object2 = this.getHitTesting();
            object = ((TSEHitTesting)object2).getClosestPathEdge(tSConstPoint, tSEEdge);
            if (object != null) {
                List list = tSEEdge.pathEdges();
                n3 = list.indexOf(object);
                if (this.forwardDirection && n3 > -1) {
                    for (n2 = n3; n2 < list.size(); ++n2) {
                        vector.add(((TSPEdge)list.get(n2)).getTargetPoint());
                    }
                } else {
                    for (n2 = n3; n2 > -1; --n2) {
                        vector.add(((TSPEdge)list.get(n2)).getSourcePoint());
                    }
                }
            }
        } else if (this.forwardDirection) {
            vector.add(tSEEdge.getSourceClippingPoint());
            object2 = tSEEdge.pathNodes().iterator();
            while (object2.hasNext()) {
                vector.add(((TSPNode)object2.next()).getCenter());
            }
        } else {
            object2 = tSEEdge.pathNodes();
            vector.add(tSEEdge.getTargetClippingPoint());
            object = object2.listIterator(object2.size());
            while (object.hasPrevious()) {
                vector.add(((TSPNode)object.previous()).getCenter());
            }
        }
        if (this.forwardDirection) {
            object2 = (TSENode)tSEEdge.getTargetNode();
            object = tSEEdge.getTargetPoint();
            vector.add(new TSConstPoint(((TSDNode)object2).getCenterX() * 0.05 + ((TSConstPoint)object).getX() * 0.95, ((TSDNode)object2).getCenterY() * 0.05 + ((TSConstPoint)object).getY() * 0.95));
            if (!this.blinking) {
                vector.add(((TSENode)tSEEdge.getTargetNode()).getCenter());
            }
        } else {
            object2 = (TSENode)tSEEdge.getSourceNode();
            object = tSEEdge.getSourcePoint();
            vector.add(new TSConstPoint(((TSDNode)object2).getCenterX() * 0.05 + ((TSConstPoint)object).getX() * 0.95, ((TSDNode)object2).getCenterY() * 0.05 + ((TSConstPoint)object).getY() * 0.95));
            if (!this.blinking) {
                vector.add(((TSENode)tSEEdge.getSourceNode()).getCenter());
            }
        }
        object2 = new double[vector.size() - 1];
        double d = 0.0;
        for (n3 = 0; n3 < vector.size() - 1; ++n3) {
            TSConstPoint tSConstPoint2 = (TSConstPoint)vector.get(n3);
            TSConstPoint tSConstPoint3 = (TSConstPoint)vector.get(n3 + 1);
            double d2 = tSConstPoint2.getX() - tSConstPoint3.getX();
            double d3 = tSConstPoint2.getY() - tSConstPoint3.getY();
            object2[n3] = Math.sqrt(d2 * d2 + d3 * d3);
            d += object2[n3];
        }
        int[] nArray = new int[vector.size()];
        n2 = 1;
        for (n = 0; n < ((Object)object2).length; ++n) {
            if (object2[n] <= 0.0) {
                nArray[n] = 0;
                continue;
            }
            nArray[n] = (int)((object2[n] * (double)this.getFrameCount() + 0.5) / d);
            nArray[n] = Math.max(nArray[n], 2);
            n2 += nArray[n];
        }
        n = 0;
        this.wayPoints = new int[n2 * 2];
        TSTransform tSTransform = this.getGraphWindow().getTransform();
        for (int i = 0; i < vector.size() - 1; ++i) {
            TSConstPoint tSConstPoint4 = (TSConstPoint)vector.get(i);
            TSConstPoint tSConstPoint5 = (TSConstPoint)vector.get(i + 1);
            double d4 = tSConstPoint4.getX();
            double d5 = tSConstPoint4.getY();
            double d6 = tSConstPoint5.getX();
            double d7 = tSConstPoint5.getY();
            for (int j = i == 0 ? 0 : 1; j <= nArray[i]; ++j) {
                double d8 = (double)j / (double)nArray[i];
                double d9 = d4 * (1.0 - d8) + d6 * d8;
                double d10 = d5 * (1.0 - d8) + d7 * d8;
                this.wayPoints[n++] = tSTransform.xToDevice(d9);
                this.wayPoints[n++] = tSTransform.yToDevice(d10);
            }
        }
        this.startScrolling();
    }

    private void scrollToEndOfEdge(TSENode tSENode, TSEEdge tSEEdge, TSConstPoint tSConstPoint, boolean bl) {
        this.wayPoints = new int[10];
        TSConstPoint tSConstPoint2 = tSEEdge.getSourcePoint();
        TSTransform tSTransform = this.getGraphWindow().getTransform();
        tSConstPoint2 = bl ? tSEEdge.getSourcePoint() : tSEEdge.getTargetPoint();
        double d = tSConstPoint.getX();
        double d2 = tSConstPoint.getY();
        double d3 = tSENode.getCenterX() * 0.05 + tSConstPoint2.getX() * 0.95;
        double d4 = tSENode.getCenterY() * 0.05 + tSConstPoint2.getY() * 0.95;
        for (int i = 0; i < 5; ++i) {
            double d5 = (double)i / 4.0;
            double d6 = d * (1.0 - d5) + d3 * d5;
            double d7 = d2 * (1.0 - d5) + d4 * d5;
            this.wayPoints[i * 2] = tSTransform.xToDevice(d6);
            this.wayPoints[i * 2 + 1] = tSTransform.yToDevice(d7);
        }
        this.startScrolling();
    }

    private void startScrolling() {
        this.scrollListener = new in(this, this.getGraphWindow());
        if (this.getTripDuration() < 0) {
            throw new IllegalArgumentException("Link navigation trip duration has to be greater or equal to 0");
        }
        if (this.getFrameCount() <= 0) {
            throw new IllegalArgumentException("Link navigation frame count has to be greater than 0");
        }
        this.scrollTimer = new Timer((int)((double)this.getTripDuration() / (double)this.getFrameCount()), this.scrollListener);
        this.scrollTimer.setRepeats(true);
        this.scrollTimer.setInitialDelay(0);
        this.scrollTimer.setCoalesce(true);
        this.scrollTimer.start();
    }

    private void stopScrolling() {
        if (this.scrollTimer != null) {
            this.scrollTimer.stop();
            this.scrollTimer = null;
        }
        this.scrollListener = null;
        this.wayPoints = null;
    }

    private void startBlinking(TSGraphObject tSGraphObject) {
        this.stopBlinking();
        this.blinkListener = new im(this, this.getGraphWindow(), tSGraphObject);
        this.blinkTimer = new Timer(this.getBlinkDuration() / 2, this.blinkListener);
        this.blinking = true;
        this.blinkingEdge = (TSEEdge)tSGraphObject;
        this.blinkingEdge.setVisible(false);
        this.getGraphWindow().addInvalidRegion(this.blinkingEdge);
        this.getGraphWindow().addInvalidRegion(this.blinkingEdge.labels());
        this.getGraphWindow().updateInvalidRegion(true);
        this.blinkListener.a();
        this.blinkTimer.start();
    }

    private void stopBlinking() {
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
            this.blinkTimer = null;
        }
        if (this.blinkListener != null) {
            this.blinkListener.b();
            this.blinkListener = null;
        }
        this.blinking = false;
        if (this.blinkingEdge != null) {
            this.blinkingEdge.setVisible(true);
            this.getGraphWindow().addInvalidRegion(this.blinkingEdge);
            this.getGraphWindow().updateInvalidRegion(true);
        }
    }

    public void paint(TSEGraphics tSEGraphics) {
        if (this.blinking) {
            TSEGraphics tSEGraphics2 = tSEGraphics.deriveGraphics(TSTransform.compose(tSEGraphics.getTSTransform(), ((TSEGraph)this.blinkingEdge.getTransformGraph()).getLocalToMainDisplayGraphTransform()));
            if (this.blinkingEdge.isVisible()) {
                if (this.blinkingEdge.isSelected()) {
                    this.blinkingEdge.getUI().drawSelected(tSEGraphics2);
                } else {
                    this.blinkingEdge.getUI().draw(tSEGraphics2);
                }
            }
            if (this.blinkingEdge.isVisible() && this.blinkingEdge.numberOfLabels() > 0) {
                Iterator iterator = this.blinkingEdge.labels().iterator();
                while (iterator.hasNext()) {
                    TSEEdgeLabel tSEEdgeLabel = (TSEEdgeLabel)iterator.next();
                    if (!tSEEdgeLabel.isVisible()) continue;
                    if (tSEEdgeLabel.isSelected()) {
                        tSEEdgeLabel.getUI().drawSelected(tSEGraphics2);
                        continue;
                    }
                    tSEEdgeLabel.getUI().draw(tSEGraphics2);
                }
            }
        }
    }

    public void cancelAction() {
        if (this.blinking) {
            this.stopBlinking();
        }
        if (this.scrollingInProgress()) {
            this.stopScrolling();
        }
    }

    public boolean isEdgeBlinking() {
        return this.blinking;
    }

    public TSEEdge getBlinkingEdge() {
        return this.blinkingEdge;
    }

    public boolean isForwardDirection() {
        return this.forwardDirection;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TSEEdge tSEEdge;
        TSENode tSENode;
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        TSConstPoint tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
        Object object = null;
        TSEHitTesting tSEHitTesting = this.getHitTesting();
        TSEGraph tSEGraph = this.getGraph();
        if (this.getGraphWindow().isNestedGraphEditingEnabled()) {
            tSEGraph = tSEHitTesting.getGraphAt(tSConstPoint, this.getGraph());
        }
        if ((tSENode = tSEHitTesting.getNodeAt(tSConstPoint, tSEGraph, this.getGraphWindow().isNestedGraphEditingEnabled())) == null) {
            tSENode = tSEHitTesting.getExpandedNodeAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
        }
        if ((tSEEdge = tSEHitTesting.getEdgeAt(tSConstPoint, tSEGraph, this.getGraphWindow().isNestedGraphEditingEnabled())) == null && this.lastHitEdge != null && !this.lastHitEdge.isVisible()) {
            tSEEdge = this.lastHitEdge;
        } else {
            this.lastHitEdge = tSEEdge;
        }
        TSEEdge tSEEdge2 = this.getBlinkingEdge();
        bl = this.isEdgeBlinking();
        bl2 = this.scrollingInProgress();
        if (tSEEdge != null && !bl2) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = tSConstPoint.getX() - tSEEdge.getSourceClippingPoint().getX();
            double d6 = d5 * d5 + (d4 = tSConstPoint.getY() - tSEEdge.getSourceClippingPoint().getY()) * d4;
            object = d6 < (d3 = (d2 = tSConstPoint.getX() - tSEEdge.getTargetClippingPoint().getX()) * d2 + (d = tSConstPoint.getY() - tSEEdge.getTargetClippingPoint().getY()) * d) ? tSEEdge.getTargetNode().getTag() : tSEEdge.getSourceNode().getTag();
        } else if (tSENode != null && bl && tSEEdge2 != null && tSEEdge2.getSourceNode() == tSENode) {
            object = ((TSENode)tSEEdge2.getTargetNode()).getToolTipText();
        } else if (tSENode != null && bl && tSEEdge2 != null && tSEEdge2.getTargetNode() == tSENode) {
            object = ((TSENode)tSEEdge2.getSourceNode()).getToolTipText();
        }
        if (object != null && object instanceof String && ((String)object).length() > 0) {
            string2 = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("To:") + " " + object;
        }
        if (string2 == null && !bl && !bl2) {
            TSEObject tSEObject = tSEHitTesting.getGraphObjectAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            string2 = tSEObject != null ? tSEObject.getToolTipText() : null;
        }
        if (string2 != null && string2.length() > 0) {
            int n;
            boolean bl3 = true;
            for (n = 0; n < string2.length(); ++n) {
                if (string2.charAt(n) == ' ' || string2.charAt(n) == '\n') continue;
                bl3 = false;
                break;
            }
            if (!bl3) {
                n = -1;
                while ((n = string2.indexOf("\n", n)) != -1) {
                    string2 = string2.substring(0, n) + "<br>" + string2.substring(n + 1);
                }
                string = TSSystem.replace(TSEGraphWindow.getToolTipFormat(), TSEGraphWindow.TOOLTIP_PLACEHOLDER, string2);
            }
        }
        return string;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
        TSEHitTesting tSEHitTesting = this.getHitTesting();
        TSEObject tSEObject = tSEHitTesting.getGraphObjectAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
        if ((tSEObject instanceof TSENode && this.isEdgeBlinking() || tSEObject instanceof TSEEdge) && this.getToolTipText(mouseEvent) != null) {
            return new Point(mouseEvent.getX() - 30, mouseEvent.getY() - 30);
        }
        return this.getGraphWindow().getDefaultToolTipLocation(mouseEvent);
    }

    static /* synthetic */ int[] access$000(TSELinkNavigationTool tSELinkNavigationTool) {
        return tSELinkNavigationTool.wayPoints;
    }

    static /* synthetic */ int[] access$002(TSELinkNavigationTool tSELinkNavigationTool, int[] nArray) {
        tSELinkNavigationTool.wayPoints = nArray;
        return nArray;
    }
}

