/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.tool;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSECursorManager;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.util.f2;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class TSEInteractiveZoomTool
extends TSEWindowInputTool {
    Point startPointDevice;
    TSConstPoint startPointWorld;
    TSConstPoint originalCenter;
    TSRect newCenterRect;
    boolean zoomingActive;
    double originalZoomLevel;
    boolean wasHourGlassShown;

    public TSEInteractiveZoomTool() {
        f2.a(f2.a7);
        this.setDefaultCursor(TSECursorManager.getCursor("InteractiveZoom.32x32", 1));
        this.setActionCursor(TSECursorManager.getCursor("InteractiveZoom.32x32", 1));
        this.newCenterRect = new TSRect(-5.0, -5.0, 5.0, 5.0);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        this.wasHourGlassShown = this.getGraphWindow().isWaitCursorShownOnCanvas();
        this.getGraphWindow().setWaitCursorShownOnCanvas(false);
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            this.setCursor(TSECursorManager.getCursor("InteractiveZooming.32x32", 1));
            this.startPointDevice = mouseEvent.getPoint();
            this.startPointWorld = this.getWorldPoint(mouseEvent);
            this.originalCenter = this.getGraphWindow().getTransform().getWorldBounds().getCenter();
            this.originalZoomLevel = this.getGraphWindow().getZoomLevel();
            this.zoomingActive = true;
        } else {
            super.onMousePressed(mouseEvent);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) == 0 && (n & 8) == 0 && (n & 4) == 0) {
            n += 16;
        }
        if ((n & 0x10) != 0 && !mouseEvent.isPopupTrigger() && this.startPointDevice != null) {
            double d = this.startPointDevice.y - mouseEvent.getY();
            double d2 = Math.exp(d / this.getSensitivity());
            double d3 = this.originalZoomLevel / d2;
            if (d3 >= this.getGraphWindow().getMaxZoomLevel()) {
                d3 = this.getGraphWindow().getMaxZoomLevel();
            } else if (d3 < this.getGraphWindow().getMinZoomLevel()) {
                d3 = this.getGraphWindow().getMinZoomLevel();
            }
            int n2 = this.getEventManager().getContext();
            this.getEventManager().setContext(this.getEventContext());
            this.getGraphWindow().setZoomLevel(d3, true);
            if (this.getGraphWindow().getZoomLevel() != this.originalZoomLevel) {
                this.getGraphWindow().setZoomLevel(d3, false);
                this.newCenterRect.setCenterX(this.startPointWorld.getX() - (this.startPointWorld.getX() - this.originalCenter.getX()) * d2);
                this.newCenterRect.setCenterY(this.startPointWorld.getY() - (this.startPointWorld.getY() - this.originalCenter.getY()) * d2);
                this.getGraphWindow().centerRectInWindow(this.newCenterRect, true);
            } else {
                this.getGraphWindow().setZoomLevel(d3, true);
            }
            this.getEventManager().setContext(n2);
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        this.setCursor(TSECursorManager.getCursor("InteractiveZoom.32x32", 1));
        if ((mouseEvent.getModifiers() & 0x10) != 0 && !mouseEvent.isPopupTrigger()) {
            if (this.zoomingActive) {
                this.zoomingActive = false;
            }
        } else {
            super.onMouseReleased(mouseEvent);
        }
        this.getGraphWindow().setWaitCursorShownOnCanvas(this.wasHourGlassShown);
    }

    public void cancelAction() {
        if (this.zoomingActive) {
            this.getGraphWindow().setZoomLevel(this.originalZoomLevel, false);
            this.getGraphWindow().centerPointInWindow(this.originalCenter, true);
            this.zoomingActive = false;
        }
    }

    public double getSensitivity() {
        return this.getGraphWindow().getPreferences().getDoubleValue("interactiveZoomSensitivity");
    }

    public void setSensitivity(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Interactive zoom sensitivity has to be greater than 0");
        }
        this.getGraphWindow().getPreferences().setValue((Object)"interactiveZoomSensitivity", d);
    }

    public double getDefaultSensitivity() {
        return 200.0;
    }

    public int getEventContext() {
        return 11;
    }
}

