/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.inspector;

import com.tomsawyer.editor.dialog.TSIntegerField;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorTable;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;

public class TSEIntegerEditor
extends DefaultCellEditor {
    DecimalFormat format;

    public TSEIntegerEditor() {
        super(new TSIntegerField(0, Integer.MIN_VALUE, Integer.MAX_VALUE));
        this.setFormat(this.getDefaultFormat());
    }

    public Object getCellEditorValue() {
        TSIntegerField tSIntegerField = (TSIntegerField)this.getComponent();
        Integer n = null;
        try {
            n = new Integer(this.getFormat().parse(tSIntegerField.getText()).intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Object object2;
        TSIntegerField tSIntegerField = (TSIntegerField)this.getComponent();
        TSEInspectorTable tSEInspectorTable = (TSEInspectorTable)jTable;
        TSEInspectorProperty tSEInspectorProperty = tSEInspectorTable.getProperty(n);
        if (tSEInspectorProperty instanceof TSENumericInspectorProperty) {
            object2 = (TSENumericInspectorProperty)tSEInspectorProperty;
            if (((TSENumericInspectorProperty)object2).getLowerBound() != null) {
                tSIntegerField.setMinimum(((TSENumericInspectorProperty)object2).getLowerBound().intValue());
            } else {
                tSIntegerField.setMinimum(Integer.MIN_VALUE);
            }
            if (((TSENumericInspectorProperty)object2).getUpperBound() != null) {
                tSIntegerField.setMaximum(((TSENumericInspectorProperty)object2).getUpperBound().intValue());
            } else {
                tSIntegerField.setMaximum(Integer.MAX_VALUE);
            }
        } else {
            tSIntegerField.setMinimum(Integer.MIN_VALUE);
            tSIntegerField.setMaximum(Integer.MAX_VALUE);
        }
        object2 = null;
        if (object != null) {
            try {
                object2 = this.getFormat().format(object);
            }
            catch (Exception exception) {
                object2 = object.toString();
            }
        }
        tSIntegerField.setText((String)object2, this.getFormat());
        return tSIntegerField;
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public void setFormat(DecimalFormat decimalFormat) {
        this.format = decimalFormat;
    }

    public DecimalFormat getDefaultFormat() {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumFractionDigits(0);
        decimalFormat.setMaximumFractionDigits(2);
        return decimalFormat;
    }
}

