/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.inspector;

import com.tomsawyer.editor.TSELocalization;
import com.tomsawyer.editor.dialog.TSFileChooser;
import com.tomsawyer.editor.inspector.TSEFilenameInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorTable;
import com.tomsawyer.editor.inspector.TSETextRenderer;
import com.tomsawyer.util.TSSystem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;

public class TSEFilenameInspectorPropertyEditor
extends DefaultCellEditor
implements ActionListener,
MouseListener {
    TSFileChooser chooser;
    String currentName;
    DefaultTableCellRenderer dummyRenderer;
    Component parentComponent;

    protected TSEFilenameInspectorPropertyEditor() {
        super(new JTextField());
        if (TSSystem.hasFileReadAccess()) {
            this.chooser = new TSFileChooser();
            this.chooser.addActionListener(this);
            TSELocalization.setComponentOrientation(this.chooser);
        }
        this.dummyRenderer = new TSETextRenderer();
        this.dummyRenderer.addMouseListener(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.chooser != null) {
            if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                this.currentName = this.chooser.getSelectedFile().getPath();
                this.stopCellEditing();
                return;
            }
        }
        this.cancelCellEditing();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.chooser != null && mouseEvent.getSource() == this.dummyRenderer) {
            this.chooser.showOpenDialog(this.parentComponent);
        }
    }

    public Object getCellEditorValue() {
        return this.currentName;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (this.chooser != null) {
            this.currentName = (String)object;
            this.chooser.resetChoosableFileFilters();
            if (jTable instanceof TSEInspectorTable) {
                TSEInspectorProperty tSEInspectorProperty = ((TSEInspectorTable)jTable).getProperty(n);
                if (tSEInspectorProperty instanceof TSEFilenameInspectorProperty) {
                    Iterator iterator = ((TSEFilenameInspectorProperty)tSEInspectorProperty).getFilters().iterator();
                    if (iterator.hasNext()) {
                        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
                    }
                    while (iterator.hasNext()) {
                        this.chooser.addChoosableFileFilter((FileFilter)iterator.next());
                    }
                }
                this.parentComponent = ((TSEInspectorTable)jTable).getInspector().getParentWindow();
            } else {
                this.parentComponent = null;
            }
            if (this.currentName != null) {
                this.chooser.setSelectedFileAndFilter(new File(this.currentName));
            } else {
                this.chooser.setSelectedFile(null);
            }
        }
        return this.dummyRenderer.getTableCellRendererComponent(jTable, object, bl, true, n, n2);
    }
}

