/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.inspector;

import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.util.TSSystem;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TSEFilenameInspectorProperty
extends TSEInspectorProperty {
    private List filters;

    public TSEFilenameInspectorProperty(String string) {
        super(string);
        this.init();
    }

    public TSEFilenameInspectorProperty(String string, String string2) {
        super((Object)string, string2);
        this.init();
    }

    public TSEFilenameInspectorProperty(String string, boolean bl) {
        super((Object)string, bl);
        this.init();
    }

    public TSEFilenameInspectorProperty(String string, boolean bl, String string2) {
        super(string, bl, string2);
        this.init();
    }

    public TSEFilenameInspectorProperty(String string, boolean bl, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        super(string, bl, tableCellRenderer, tableCellEditor);
        this.init();
    }

    public TSEFilenameInspectorProperty(String string, boolean bl, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor, String string2) {
        super(string, bl, tableCellRenderer, tableCellEditor, string2);
        this.init();
    }

    private void init() {
        this.filters = new Vector();
    }

    protected boolean validateValue(Object object) {
        boolean bl = true;
        if (!super.validateValue(object)) {
            bl = false;
        } else {
            try {
                File file = new File(object.toString());
                bl = file.exists() && file.isFile() && file.canRead();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isEditable() {
        return super.isEditable() && TSSystem.hasFileReadAccess();
    }

    public boolean isEditableWith(TSEInspectorProperty tSEInspectorProperty) {
        if (!super.isEditableWith(tSEInspectorProperty)) {
            return false;
        }
        TSEFilenameInspectorProperty tSEFilenameInspectorProperty = (TSEFilenameInspectorProperty)tSEInspectorProperty;
        if (tSEFilenameInspectorProperty.getFilters().size() != this.getFilters().size()) {
            return false;
        }
        Iterator iterator = this.getFilters().iterator();
        while (iterator.hasNext()) {
            if (tSEFilenameInspectorProperty.getFilters().contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void addFilter(FileFilter fileFilter) {
        if (!this.getFilters().contains(fileFilter)) {
            this.getFilters().add(fileFilter);
        }
    }

    public void removeFilter(FileFilter fileFilter) {
        this.getFilters().remove(fileFilter);
    }

    public List getFilters() {
        return this.filters;
    }
}

