/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.export;

import com.tomsawyer.drawing.TSDLicenseManager;
import com.tomsawyer.editor.TSEButtonKeyListener;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEFontChooser;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.dialog.TSDialogCallBackListener;
import com.tomsawyer.editor.dialog.TSDialogWithCallBack;
import com.tomsawyer.editor.dialog.TSUnsignedDoubleField;
import com.tomsawyer.editor.dialog.TSUnsignedIntegerField;
import com.tomsawyer.editor.export.TSEPrintSetup;
import com.tomsawyer.util.TSLicenseRuntimeException;
import com.tomsawyer.util.TSSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TSEPrintSetupDialog
extends JDialog
implements ActionListener,
TSDialogWithCallBack {
    TSEPrintSetup printSetup;
    Window owner;
    JRadioButton entireGraph;
    JRadioButton currentWindow;
    JRadioButton currentSelection;
    ButtonGroup rangeGroup;
    JRadioButton byPages;
    JRadioButton byActualSize;
    JRadioButton byZoomLevel;
    ButtonGroup scaleGroup;
    TSUnsignedIntegerField columnField;
    TSUnsignedIntegerField rowField;
    JCheckBox printCaption;
    JButton font;
    ExTextArea captionArea;
    JComboBox positionBox;
    JCheckBox printBorder;
    JButton color;
    JCheckBox pageNumber;
    JCheckBox cropMark;
    JCheckBox background;
    JCheckBox grid;
    JButton cancelButton;
    JButton okButton;
    JButton defaultButton;
    JButton pageSetupButton;
    PageFormat tempPageFormat;
    Color tempColor;
    Font tempFont;
    TSEResourceBundleWrapper labels;
    Font fontType;
    boolean rc;
    TSEPrintSetup tempPrintSetup;
    ExDocumentListener documentListener;
    TSDialogCallBackListener callBackListener;

    public TSEPrintSetupDialog(Frame owner, String title, TSEPrintSetup printSetup) {
        super(owner, title, true);
        this.owner = owner;
        this.printSetup = printSetup;
        this.setResizable(false);
        this.init();
        this.pack();
        this.setLocationRelativeTo(this.owner);
    }

    public TSEPrintSetupDialog(Dialog owner, String title, TSEPrintSetup printSetup) {
        super(owner, title, true);
        this.owner = owner;
        this.printSetup = printSetup;
        this.setResizable(false);
        this.init();
        this.pack();
        this.setLocationRelativeTo(this.owner);
    }

    public void init() {
        this.documentListener = new ExDocumentListener();
        this.addKeyListener(new TSEButtonKeyListener(this, this));
        this.labels = TSEResourceBundleWrapper.getSystemLabelBundle();
        JPanel rangePanel = this.createRangePanel();
        JPanel scaleByPanel = this.createScaleByPanel();
        JPanel captionPanel = this.createCaptionPanel();
        JPanel multipagePrintingPanel = this.createMultipagePrintingPanel();
        JPanel otherPanel = this.createOtherPanel();
        JPanel pageSetupPanel = this.createPageSetupPanel();
        JPanel buttonPanel = this.createButtonPanel();
        this.getRootPane().setDefaultButton(this.okButton);
        JPanel topPanel = this.createBoxLayoutPanel(0);
        JPanel middlePanel = this.createBoxLayoutPanel(0);
        JPanel bottomPanel = this.createBoxLayoutPanel(0);
        JPanel middleLeftPanel = this.createBoxLayoutPanel(1);
        JPanel middleRightPanel = this.createBoxLayoutPanel(1);
        topPanel.add(rangePanel);
        middleLeftPanel.add(scaleByPanel);
        middleLeftPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        middleLeftPanel.add(captionPanel);
        middleRightPanel.add(multipagePrintingPanel);
        middleRightPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        middleRightPanel.add(otherPanel);
        middleRightPanel.add(Box.createVerticalGlue());
        middlePanel.add(middleLeftPanel);
        middlePanel.add(Box.createRigidArea(new Dimension(6, 0)));
        middlePanel.add(middleRightPanel);
        bottomPanel.add(pageSetupPanel);
        bottomPanel.add(buttonPanel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(topPanel);
        contentPane.add(Box.createRigidArea(new Dimension(0, 6)));
        contentPane.add(middlePanel);
        contentPane.add(Box.createRigidArea(new Dimension(0, 12)));
        contentPane.add(bottomPanel);
        this.createBorder(contentPane, null, 12, 12, 12, 12);
        this.setValue(this.printSetup);
        this.setDefaultCloseOperation(1);
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = this.createBoxLayoutPanel(0);
        this.okButton = this.createButton("OK", "ok");
        this.cancelButton = this.createButton("Cancel", "cancel");
        this.defaultButton = this.createButton("Set_Default", "set default");
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.okButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPanel.add(this.defaultButton);
        return buttonPanel;
    }

    protected JPanel createPageSetupPanel() {
        JPanel pageSetupPanel = this.createBoxLayoutPanel(0);
        this.pageSetupButton = this.createButton("Page_Setup...", "page setup");
        this.pageSetupButton.setAlignmentX(0.0f);
        pageSetupPanel.add(this.pageSetupButton);
        return pageSetupPanel;
    }

    protected JPanel createOtherPanel() {
        JPanel otherPanel = this.createBoxLayoutPanel(1);
        this.printBorder = this.createCheckbox("Print_Border", "print border");
        this.color = this.createButton("Color...", "color");
        this.background = this.createCheckbox("Print_Background");
        this.grid = this.createCheckbox("Print_Grid");
        JPanel printBorderPanel = this.createBoxLayoutPanel(0);
        printBorderPanel.add(this.printBorder);
        printBorderPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        printBorderPanel.add(Box.createHorizontalGlue());
        printBorderPanel.add(this.color);
        printBorderPanel.setAlignmentX(0.0f);
        this.background.setAlignmentX(0.0f);
        this.grid.setAlignmentX(0.0f);
        int spacing = (int)((this.color.getPreferredSize().getHeight() - this.printBorder.getPreferredSize().getHeight()) / 2.0);
        otherPanel.add(printBorderPanel);
        otherPanel.add(Box.createRigidArea(new Dimension(0, 7 - spacing)));
        otherPanel.add(this.background);
        otherPanel.add(Box.createRigidArea(new Dimension(0, 7)));
        otherPanel.add(this.grid);
        this.createBorder(otherPanel, "Other", 0, 6, 6, 6);
        return otherPanel;
    }

    protected JPanel createMultipagePrintingPanel() {
        JPanel multiPanel = this.createBoxLayoutPanel(1);
        this.pageNumber = this.createCheckbox("Print_Page_Numbers");
        this.cropMark = this.createCheckbox("Print_Crop_Marks");
        multiPanel.add(this.pageNumber);
        multiPanel.add(Box.createRigidArea(new Dimension(0, 7)));
        multiPanel.add(this.cropMark);
        multiPanel.add(Box.createHorizontalGlue());
        this.createBorder(multiPanel, "Multipage_Printing", 0, 6, 6, 6);
        return multiPanel;
    }

    protected JPanel createCaptionPanel() {
        JPanel captionPanel = this.createBoxLayoutPanel(1);
        this.printCaption = this.createCheckbox("Print_Caption", "print caption");
        this.font = this.createButton("Font...", "font");
        this.captionArea = new ExTextArea();
        this.captionArea.getDocument().addDocumentListener(this.documentListener);
        this.captionArea.getDocument().putProperty("name", "caption area");
        this.setAccessibleProperties(this.captionArea, "Caption_TextArea", "Caption_TextArea");
        JScrollPane captionScrollPane = new JScrollPane(this.captionArea);
        captionScrollPane.setVerticalScrollBarPolicy(22);
        captionScrollPane.setPreferredSize(new Dimension(1, 50));
        String[] positionStrings = new String[]{this.labels.getStringSafely("Top_Left"), this.labels.getStringSafely("Top_Right"), this.labels.getStringSafely("Bottom_Left"), this.labels.getStringSafely("Bottom_Right")};
        this.positionBox = new JComboBox<String>(positionStrings);
        JLabel positionLabel = this.createLabel("Position", this.positionBox);
        positionLabel.setDisplayedMnemonic(this.getMnemonic("Position"));
        this.setAccessibleProperties(this.positionBox, null, "Position");
        JPanel top = this.createBoxLayoutPanel(0);
        top.add(this.printCaption);
        top.add(Box.createRigidArea(new Dimension(6, 0)));
        top.add(Box.createHorizontalGlue());
        top.add(this.font);
        JPanel bottom = this.createBoxLayoutPanel(0);
        bottom.add(positionLabel);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.positionBox);
        captionPanel.add(top);
        captionPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        captionPanel.add(captionScrollPane);
        captionPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        captionPanel.add(bottom);
        this.createBorder(captionPanel, "Caption", 0, 6, 6, 6);
        return captionPanel;
    }

    protected JPanel createScaleByPanel() {
        String labelStr = null;
        JPanel scalePanel = this.createBoxLayoutPanel(0);
        this.byPages = this.createRadioButton("Pages", "by pages");
        this.byActualSize = this.createRadioButton("Actual_Size", "by actual size");
        this.byZoomLevel = this.createRadioButton("Zoom_Level", "by zoom level");
        this.scaleGroup = new ButtonGroup();
        this.scaleGroup.add(this.byPages);
        this.scaleGroup.add(this.byActualSize);
        this.scaleGroup.add(this.byZoomLevel);
        labelStr = this.labels.getStringSafely("Page_Columns");
        int maxValue = 20;
        this.columnField = this.createIntegerField(2, 1, maxValue, "name", "column field");
        JLabel columnLabel = this.createLabel("Page_Columns", this.columnField);
        columnLabel.setDisplayedMnemonic(this.getMnemonic("Page_Columns"));
        this.setAccessibleProperties(this.columnField, null, "Page_Columns");
        labelStr = this.labels.getStringSafely("Page_Rows");
        this.rowField = this.createIntegerField(2, 1, maxValue, "name", "row field");
        JLabel rowLabel = this.createLabel("Page_Rows", this.rowField);
        rowLabel.setDisplayedMnemonic(this.getMnemonic("Page_Rows"));
        this.setAccessibleProperties(this.rowField, null, "Page_Rows");
        JPanel leftPanel = this.createBoxLayoutPanel(1);
        JPanel rightPanel = this.createBoxLayoutPanel(0);
        JPanel pageFieldsPanel = this.createBoxLayoutPanel(1);
        JPanel pageLabelsPanel = this.createBoxLayoutPanel(1);
        leftPanel.add(this.byPages);
        leftPanel.add(this.byActualSize);
        leftPanel.add(this.byZoomLevel);
        columnLabel.setAlignmentX(1.0f);
        rowLabel.setAlignmentX(1.0f);
        pageLabelsPanel.add(columnLabel);
        pageLabelsPanel.add(Box.createRigidArea(new Dimension(0, 9)));
        pageLabelsPanel.add(rowLabel);
        pageFieldsPanel.add(this.columnField);
        pageFieldsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        pageFieldsPanel.add(this.rowField);
        rightPanel.add(pageLabelsPanel);
        rightPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        rightPanel.add(pageFieldsPanel);
        leftPanel.setAlignmentY(0.0f);
        rightPanel.setAlignmentY(0.0f);
        scalePanel.add(leftPanel);
        scalePanel.add(Box.createRigidArea(new Dimension(6, 0)));
        scalePanel.add(Box.createHorizontalGlue());
        scalePanel.add(rightPanel);
        this.createBorder(scalePanel, "Scale_By", 0, 6, 6, 6);
        return scalePanel;
    }

    protected JPanel createRangePanel() {
        JPanel rangePanel = this.createBoxLayoutPanel(0);
        this.entireGraph = this.createRadioButton("Print_Entire_Graph", "update page number");
        this.currentWindow = this.createRadioButton("Print_Current_Window", "update page number");
        this.currentSelection = this.createRadioButton("Print_Current_Selection", "update page number");
        this.rangeGroup = new ButtonGroup();
        this.rangeGroup.add(this.entireGraph);
        this.rangeGroup.add(this.currentWindow);
        this.rangeGroup.add(this.currentSelection);
        rangePanel.add(this.entireGraph);
        rangePanel.add(Box.createHorizontalGlue());
        rangePanel.add(this.currentWindow);
        rangePanel.add(Box.createHorizontalGlue());
        rangePanel.add(this.currentSelection);
        this.createBorder(rangePanel, "", 0, 6, 6, 6);
        return rangePanel;
    }

    public JPanel createBoxLayoutPanel(int axis) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, axis));
        panel.setBorder(null);
        return panel;
    }

    public TSUnsignedIntegerField createIntegerField(int length, int min, int max, String propertyKey, String proprtyValue) {
        TSUnsignedIntegerField field = new TSUnsignedIntegerField(length, min, max);
        field.setMaximumSize(field.getPreferredSize());
        field.getDocument().addDocumentListener(this.documentListener);
        field.getDocument().putProperty(propertyKey, proprtyValue);
        return field;
    }

    public TSUnsignedDoubleField createDoubleField(int length, int maxAftetDecimal) {
        TSUnsignedDoubleField field = new TSUnsignedDoubleField(length);
        field.setMaxAfterDecimal(maxAftetDecimal);
        field.setMaximumSize(field.getPreferredSize());
        return field;
    }

    public JLabel createLabel(String text, Component labelForComp) {
        JLabel label = new JLabel(this.labels.getStringSafely(text));
        label.setForeground(Color.black);
        label.setLabelFor(labelForComp);
        return label;
    }

    public void createBorder(JPanel panel, String text, int top, int left, int bottom, int right) {
        Border border;
        if (text != null && !text.equals("")) {
            text = this.labels.getStringSafely(text);
        }
        Border emptyBorder = BorderFactory.createEmptyBorder(top, left, bottom, right);
        if (text != null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(text);
            titledBorder.setTitleColor(Color.black);
            if (!text.equals("")) {
                border = BorderFactory.createCompoundBorder(titledBorder, emptyBorder);
            } else {
                emptyBorder = BorderFactory.createEmptyBorder(top, left - 2, bottom - 2, right - 2);
                border = BorderFactory.createCompoundBorder(titledBorder, emptyBorder);
                border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2), border);
            }
        } else {
            border = emptyBorder;
        }
        panel.setBorder(border);
    }

    public JCheckBox createCheckbox(String text) {
        return this.createCheckbox(text, text);
    }

    public JCheckBox createCheckbox(String text, String actionCommand) {
        String labelStr = this.labels.getStringSafely(text);
        JCheckBox checkbox = new JCheckBox(" " + this.labels.getStringSafely(text));
        checkbox.setActionCommand(actionCommand);
        checkbox.addActionListener(this);
        checkbox.setBorder(null);
        this.setAccessibleProperties(checkbox, null, text);
        checkbox.setMnemonic(this.getMnemonic(text));
        return checkbox;
    }

    public JRadioButton createRadioButton(String text) {
        return this.createRadioButton(text, text);
    }

    public JRadioButton createRadioButton(String text, String actionCommand) {
        String labelStr = this.labels.getStringSafely(text);
        JRadioButton button = new JRadioButton(" " + labelStr);
        button.setActionCommand(actionCommand);
        button.addActionListener(this);
        this.setAccessibleProperties(button, null, text);
        button.setMnemonic(this.getMnemonic(text));
        return button;
    }

    public JButton createButton(String text, String actionCommand) {
        String labelStr = this.labels.getStringSafely(text);
        JButton button = new JButton(labelStr);
        button.setActionCommand(actionCommand);
        button.addActionListener(this);
        this.setAccessibleProperties(button, null, text);
        button.setMnemonic(this.getMnemonic(text));
        return button;
    }

    public char getMnemonic(String bundleKey) {
        String mnm;
        char mnmChar = '?';
        if (bundleKey != null && (mnm = this.labels.getStringSafely("MNE_" + bundleKey)) != null && mnm.length() > 0) {
            mnmChar = mnm.charAt(0);
        }
        return mnmChar;
    }

    protected void setAccessibleProperties(Component comp, String accsNameKey, String accsDescKey) {
        if (comp != null) {
            String labelStr = null;
            AccessibleContext accsContext = comp.getAccessibleContext();
            if (accsNameKey != null) {
                labelStr = this.labels.getStringSafely("ACSN_" + accsNameKey);
                accsContext.setAccessibleName(labelStr);
            }
            if (accsDescKey != null) {
                labelStr = this.labels.getStringSafely("ACSD_" + accsDescKey);
                accsContext.setAccessibleDescription(labelStr);
            }
        }
    }

    public void setValue(TSEPrintSetup printSetup) {
        if (printSetup == null) {
            return;
        }
        this.tempPrintSetup = (TSEPrintSetup)printSetup.clone();
        if (printSetup.getExportRange() == 1) {
            this.entireGraph.setSelected(true);
        } else if (printSetup.getExportRange() == 2) {
            this.currentWindow.setSelected(true);
        } else if (printSetup.getExportRange() == 3) {
            this.currentSelection.setSelected(true);
        }
        if (printSetup.getExportScale() == 4) {
            this.byPages.setSelected(true);
        } else if (printSetup.getExportScale() == 5) {
            this.byActualSize.setSelected(true);
        } else if (printSetup.getExportScale() == 6) {
            this.byZoomLevel.setSelected(true);
        }
        this.columnField.setEnabled(this.byPages.isSelected());
        this.rowField.setEnabled(this.byPages.isSelected());
        try {
            this.columnField.setText(Integer.toString(printSetup.getPageColumns()));
            this.rowField.setText(Integer.toString(printSetup.getPageRows()));
        }
        catch (TSLicenseRuntimeException exception) {
            this.callBack(exception);
            TSEPrintSetup defaultSetup = this.getDefaultPrintSetup(this.printSetup);
            this.setValue(defaultSetup);
        }
        this.printCaption.setSelected(printSetup.isCaptionExported());
        this.font.setEnabled(this.printCaption.isSelected());
        this.captionArea.setEnabled(this.printCaption.isSelected());
        this.positionBox.setEnabled(this.printCaption.isSelected());
        this.captionArea.setFont(printSetup.getCaptionFont().getFont());
        Vector captionVector = printSetup.getCaption();
        this.captionArea.setText(null);
        Enumeration e = captionVector.elements();
        if (e.hasMoreElements()) {
            this.captionArea.append((String)e.nextElement());
        }
        while (e.hasMoreElements()) {
            this.captionArea.append("\n" + e.nextElement());
        }
        this.documentListener.initializeLineCount(this.captionArea.getLineCount());
        int p = printSetup.getCaptionPosition();
        if (p == 7) {
            this.positionBox.setSelectedIndex(0);
        } else if (p == 8) {
            this.positionBox.setSelectedIndex(1);
        } else if (p == 9) {
            this.positionBox.setSelectedIndex(2);
        } else {
            this.positionBox.setSelectedIndex(3);
        }
        this.pageNumber.setSelected(printSetup.isPageNumberExported());
        this.cropMark.setSelected(printSetup.isCropMarkExported());
        this.printBorder.setSelected(printSetup.isBorderExported());
        this.color.setEnabled(this.printBorder.isSelected());
        this.background.setSelected(printSetup.isBackgroundExported());
        this.grid.setSelected(printSetup.isGridExported());
        this.tempColor = printSetup.getBorderColor();
        this.tempFont = printSetup.getCaptionFont().getFont();
        this.tempPageFormat = printSetup.getPageFormat();
        this.byZoomLevel.setNextFocusableComponent(this.columnField);
        this.columnField.setNextFocusableComponent(this.rowField);
        this.rowField.setNextFocusableComponent(this.printCaption);
        this.font.setNextFocusableComponent(this.captionArea);
        this.captionArea.setNextFocusableComponent(this.positionBox);
        this.cropMark.setNextFocusableComponent(this.printBorder);
    }

    public boolean onApply() {
        boolean success = true;
        int numberOfRows = Integer.parseInt(this.rowField.getText());
        int numberOfColumns = Integer.parseInt(this.columnField.getText());
        if (!(numberOfRows <= 1 && numberOfColumns <= 1 || TSDLicenseManager.checkLicense(TSDLicenseManager.MULTI_PAGE_PRINT))) {
            this.callBack(new TSLicenseRuntimeException());
            this.columnField.setText("1");
            this.rowField.setText("1");
            success = false;
        } else {
            if (this.entireGraph.isSelected()) {
                this.printSetup.setExportRange(1);
            } else if (this.currentWindow.isSelected()) {
                this.printSetup.setExportRange(2);
            } else if (this.currentSelection.isSelected()) {
                this.printSetup.setExportRange(3);
            }
            if (this.byPages.isSelected()) {
                this.printSetup.setExportScale(4);
            } else if (this.byActualSize.isSelected()) {
                this.printSetup.setExportScale(5);
            } else if (this.byZoomLevel.isSelected()) {
                this.printSetup.setExportScale(6);
            }
            if (this.byPages.isSelected()) {
                String s = this.columnField.getText();
                if (s == null || s.equals("")) {
                    this.columnField.setText(Integer.toString(this.printSetup.getPageColumns()));
                } else {
                    this.printSetup.setPageColumns(Integer.parseInt(s));
                }
                s = this.rowField.getText();
                if (s == null || s.equals("")) {
                    this.rowField.setText(Integer.toString(this.printSetup.getPageRows()));
                } else {
                    this.printSetup.setPageRows(Integer.parseInt(s));
                }
            }
            this.printSetup.setCaptionExported(this.printCaption.isSelected());
            Vector<String> captionVector = new Vector<String>();
            try {
                for (int i = 0; i < this.captionArea.getLineCount(); ++i) {
                    int start = this.captionArea.getLineStartOffset(i);
                    int length = TSSystem.isJVM14() && i == this.captionArea.getLineCount() - 1 ? this.captionArea.getLineEndOffset(i) - start : this.captionArea.getLineEndOffset(i) - start - 1;
                    captionVector.addElement(this.captionArea.getText(start, length));
                }
            }
            catch (BadLocationException e) {
                System.err.println("Bad location exception in caption area");
            }
            this.printSetup.setCaption(captionVector);
            int p = this.positionBox.getSelectedIndex();
            if (p == 0) {
                this.printSetup.setCaptionPosition(7);
            } else if (p == 1) {
                this.printSetup.setCaptionPosition(8);
            } else if (p == 2) {
                this.printSetup.setCaptionPosition(9);
            } else {
                this.printSetup.setCaptionPosition(10);
            }
            if (this.tempColor != null) {
                this.printSetup.setBorderColor(this.tempColor);
            }
            if (this.tempFont != null) {
                this.printSetup.setCaptionFont(new TSEFont(this.tempFont));
            }
            if (this.tempPageFormat != null) {
                this.printSetup.setPageFormat(this.tempPageFormat);
            }
            this.printSetup.setPageNumberExported(this.pageNumber.isSelected());
            this.printSetup.setCropMarkExported(this.cropMark.isSelected());
            this.printSetup.setBorderExported(this.printBorder.isSelected());
            this.printSetup.setBackgroundExported(this.background.isSelected());
            this.printSetup.setGridExported(this.grid.isSelected());
        }
        return success;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("by pages")) {
            this.updatePageNumber();
            this.columnField.setEnabled(true);
            this.rowField.setEnabled(true);
        } else if (command.equals("by actual size")) {
            this.columnField.setEnabled(false);
            this.rowField.setEnabled(false);
            this.updatePageNumber();
        } else if (command.equals("by zoom level")) {
            this.columnField.setEnabled(false);
            this.rowField.setEnabled(false);
            this.updatePageNumber();
        } else if (command.equals("print caption")) {
            this.font.setEnabled(this.printCaption.isSelected());
            this.captionArea.setEnabled(this.printCaption.isSelected());
            this.positionBox.setEnabled(this.printCaption.isSelected());
            this.updatePageNumber();
        } else if (command.equals("print border")) {
            this.color.setEnabled(this.printBorder.isSelected());
        } else if (command.equals("color")) {
            this.tempColor = JColorChooser.showDialog(this.owner, "Choose Color", this.printSetup.getBorderColor());
        } else if (command.equals("font")) {
            String title = this.labels.getStringSafely("Choose_Font");
            this.tempFont = TSEFontChooser.showDialog(this.owner, title, this.tempFont != null ? this.tempFont : this.printSetup.getCaptionFont().getFont());
            this.updatePageNumber();
        } else if (command.equals("ok")) {
            this.setReturnValue(true);
            if (this.onApply()) {
                this.dispose();
            }
        } else if (command.equals("cancel")) {
            this.setReturnValue(false);
            this.dispose();
        } else if (command.equals("set default")) {
            TSEPrintSetup defaultSetup = this.getDefaultPrintSetup(this.printSetup);
            this.setValue(defaultSetup);
        } else if (command.equals("page setup")) {
            PrinterJob job = PrinterJob.getPrinterJob();
            this.tempPageFormat = this.tempPageFormat == null ? job.pageDialog(this.printSetup.getPageFormat()) : job.pageDialog(this.tempPageFormat);
            double top = this.tempPageFormat.getImageableY();
            double bottom = this.tempPageFormat.getHeight() - this.tempPageFormat.getImageableHeight() - this.tempPageFormat.getImageableY();
            double left = this.tempPageFormat.getImageableX();
            double right = this.tempPageFormat.getWidth() - this.tempPageFormat.getImageableWidth() - this.tempPageFormat.getImageableX();
            this.updatePageNumber();
        } else if (command.equals("update page number")) {
            this.updatePageNumber();
        }
    }

    public void updatePageNumber() {
        try {
            int oldMin;
            if (this.entireGraph.isSelected()) {
                this.tempPrintSetup.setExportRange(1);
            } else if (this.currentWindow.isSelected()) {
                this.tempPrintSetup.setExportRange(2);
            } else if (this.currentSelection.isSelected()) {
                this.tempPrintSetup.setExportRange(3);
            }
            if (this.byPages.isSelected()) {
                this.tempPrintSetup.setExportScale(4);
            } else if (this.byActualSize.isSelected()) {
                this.tempPrintSetup.setExportScale(5);
            } else if (this.byZoomLevel.isSelected()) {
                this.tempPrintSetup.setExportScale(6);
            }
            this.tempPrintSetup.setCaptionExported(this.printCaption.isSelected());
            Vector<String> captionVector = new Vector<String>();
            try {
                for (int i = 0; i < this.captionArea.getLineCount(); ++i) {
                    int start = this.captionArea.getLineStartOffset(i);
                    int length = TSSystem.isJVM14() && i == this.captionArea.getLineCount() - 1 ? this.captionArea.getLineEndOffset(i) - start : this.captionArea.getLineEndOffset(i) - start - 1;
                    captionVector.addElement(this.captionArea.getText(start, length));
                }
            }
            catch (BadLocationException e) {
                System.err.println("Bad location exception in caption area");
            }
            this.tempPrintSetup.setCaption(captionVector);
            if (this.tempFont != null) {
                this.tempPrintSetup.setCaptionFont(new TSEFont(this.tempFont));
            }
            if (this.tempPageFormat != null) {
                this.tempPrintSetup.setPageFormat(this.tempPageFormat);
            }
            int c = this.tempPrintSetup.getPageColumns();
            int r = this.tempPrintSetup.getPageRows();
            if (c < this.columnField.getMinimum()) {
                oldMin = this.columnField.getMinimum();
                this.columnField.setMinimum(c, false);
                this.columnField.setText(Integer.toString(c));
                this.columnField.setMinimum(oldMin, false);
            } else {
                this.columnField.setText(Integer.toString(this.tempPrintSetup.getPageColumns()));
            }
            if (r < this.rowField.getMinimum()) {
                oldMin = this.rowField.getMinimum();
                this.rowField.setMinimum(c, false);
                this.rowField.setText(Integer.toString(c));
                this.rowField.setMinimum(oldMin, false);
            } else {
                this.rowField.setText(Integer.toString(this.tempPrintSetup.getPageRows()));
            }
        }
        catch (TSLicenseRuntimeException exception) {
            this.callBack(exception);
            TSEPrintSetup defaultSetup = this.getDefaultPrintSetup(this.printSetup);
            this.setValue(defaultSetup);
        }
    }

    public TSEPrintSetup getDefaultPrintSetup(TSEPrintSetup p) {
        try {
            TSEPrintSetup pp = (TSEPrintSetup)p.getClass().newInstance();
            pp.setGraphWindow(p.getGraphWindow());
            return pp;
        }
        catch (Exception e) {
            return p;
        }
    }

    public TSEPrintSetup getPrintSetup() {
        return this.printSetup;
    }

    public boolean getReturnValue() {
        return this.rc;
    }

    public void setReturnValue(boolean rc) {
        this.rc = rc;
    }

    public void registerCallBackListener(TSDialogCallBackListener listener) {
        this.callBackListener = listener;
    }

    public Object callBack(Object object) {
        Object rc = null;
        if (this.callBackListener != null) {
            rc = this.callBackListener.uponCallBack(object);
        }
        return rc;
    }

    class ExDocumentListener
    implements DocumentListener {
        int lineCount = 0;

        ExDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.updatePrintSetup(e, "insert");
        }

        public void removeUpdate(DocumentEvent e) {
            this.updatePrintSetup(e, "remove");
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void updatePrintSetup(DocumentEvent e, String action) {
            Document doc = e.getDocument();
            String source = (String)doc.getProperty("name");
            if (action.equals("insert")) {
                if (source.equals("column field") && TSEPrintSetupDialog.this.columnField.isEnabled()) {
                    String s = TSEPrintSetupDialog.this.columnField.getText();
                    TSEPrintSetupDialog.this.tempPrintSetup.setPageColumns(Integer.parseInt(s));
                } else if (source.equals("row field") && TSEPrintSetupDialog.this.rowField.isEnabled()) {
                    String s = TSEPrintSetupDialog.this.rowField.getText();
                    TSEPrintSetupDialog.this.tempPrintSetup.setPageRows(Integer.parseInt(s));
                } else if (source.equals("caption area")) {
                    this.onCaptionAreaUpdate();
                }
            } else if (action.equals("remove") && source.equals("caption area")) {
                this.onCaptionAreaUpdate();
            }
        }

        public void onCaptionAreaUpdate() {
            int count = TSEPrintSetupDialog.this.captionArea.getLineCount();
            if (count != this.lineCount) {
                this.lineCount = count;
                TSEPrintSetupDialog.this.updatePageNumber();
            }
        }

        public void initializeLineCount(int count) {
            this.lineCount = count;
        }
    }

    class ExTextArea
    extends JTextArea {
        public boolean isManagingFocus() {
            return false;
        }
    }
}

