/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.event;

import com.tomsawyer.drawing.event.TSDEventManager;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.event.TSEModeChangeEvent;
import com.tomsawyer.editor.event.TSEModeChangeListener;
import com.tomsawyer.editor.event.TSEPreferenceChangeEvent;
import com.tomsawyer.editor.event.TSEPreferenceChangeListener;
import com.tomsawyer.editor.event.TSEPropertyChangeEvent;
import com.tomsawyer.editor.event.TSEPropertyChangeListener;
import com.tomsawyer.editor.event.TSESelectionChangeEvent;
import com.tomsawyer.editor.event.TSESelectionChangeListener;
import com.tomsawyer.editor.event.TSEVetoableSelectionChangeListener;
import com.tomsawyer.editor.event.TSEViewportChangeEvent;
import com.tomsawyer.editor.event.TSEViewportChangeListener;
import com.tomsawyer.event.TSEvent;
import com.tomsawyer.event.TSVetoableChangeListener;
import com.tomsawyer.service.event.TSConstraintChangeEvent;
import com.tomsawyer.service.event.TSConstraintChangeListener;
import com.tomsawyer.service.event.TSServiceInputChangeEvent;
import com.tomsawyer.service.event.TSServiceInputChangeListener;
import java.util.EventListener;

public class TSEEventManager
extends TSDEventManager {
    private static Class serviceInputChangeEventClass = new TSServiceInputChangeEvent(0L, null).getClass();
    private static Class constraintChangeEventClass = new TSConstraintChangeEvent(0L, null).getClass();
    private static Class viewportChangeEventClass = new TSEViewportChangeEvent(0L, null).getClass();
    private static Class selectionChangeEventClass = new TSESelectionChangeEvent(0L, null).getClass();
    private static Class propertyChangeEventClass = new TSEPropertyChangeEvent(0L, null).getClass();
    private static Class preferenceChangeEventClass = new TSEPreferenceChangeEvent(0L, null).getClass();
    private static Class modeChangeEventClass = new TSEModeChangeEvent(0L, null).getClass();

    public TSEEventManager() {
        this.registerEventClass(serviceInputChangeEventClass);
        this.registerEventClass(constraintChangeEventClass);
        this.registerEventClass(viewportChangeEventClass);
        this.registerEventClass(selectionChangeEventClass);
        this.registerEventClass(propertyChangeEventClass);
        this.registerEventClass(preferenceChangeEventClass);
        this.registerEventClass(modeChangeEventClass);
        this.setFireEvents(true);
        this.setFireVetoableEvents(true);
    }

    public void addViewportChangeListener(Object object, EventListener eventListener, long l) {
        this.addListener(object, eventListener, l, viewportChangeEventClass);
    }

    public void addViewportChangeListener(Object object, EventListener eventListener) {
        this.addViewportChangeListener(object, eventListener, -1L);
    }

    public void removeViewportChangeListener(Object object, EventListener eventListener, long l) {
        this.removeListener(object, eventListener, l, viewportChangeEventClass);
    }

    public void removeViewportChangeListener(Object object, EventListener eventListener) {
        this.removeViewportChangeListener(object, eventListener, -1L);
    }

    public void removeAllViewportChangeListeners(Object object) {
        this.removeAllViewportChangeListeners(object, -1L);
    }

    public void removeAllViewportChangeListeners(Object object, long l) {
        this.removeAllListeners(object, l, viewportChangeEventClass);
    }

    public void addSelectionChangeListener(Object object, EventListener eventListener, long l) {
        this.addListener(object, eventListener, l, selectionChangeEventClass);
    }

    public void addSelectionChangeListener(Object object, EventListener eventListener) {
        this.addSelectionChangeListener(object, eventListener, -1L);
    }

    public void removeSelectionChangeListener(Object object, EventListener eventListener, long l) {
        this.removeListener(object, eventListener, l, selectionChangeEventClass);
    }

    public void removeSelectionChangeListener(Object object, EventListener eventListener) {
        this.removeSelectionChangeListener(object, eventListener, -1L);
    }

    public void removeAllSelectionChangeListeners(Object object) {
        this.removeAllSelectionChangeListeners(object, -1L);
    }

    public void removeAllSelectionChangeListeners(Object object, long l) {
        this.removeAllListeners(object, l, selectionChangeEventClass);
    }

    public void addPropertyChangeListener(Object object, EventListener eventListener, long l) {
        this.addListener(object, eventListener, l, propertyChangeEventClass);
    }

    public void addPropertyChangeListener(Object object, EventListener eventListener) {
        this.addPropertyChangeListener(object, eventListener, -1L);
    }

    public void removePropertyChangeListener(Object object, EventListener eventListener, long l) {
        this.removeListener(object, eventListener, l, propertyChangeEventClass);
    }

    public void removePropertyChangeListener(Object object, EventListener eventListener) {
        this.removePropertyChangeListener(object, eventListener, -1L);
    }

    public void removeAllPropertyChangeListeners(Object object) {
        this.removeAllPropertyChangeListeners(object, -1L);
    }

    public void removeAllPropertyChangeListeners(Object object, long l) {
        this.removeAllListeners(object, l, propertyChangeEventClass);
    }

    public void addPreferenceChangeListener(Object object, EventListener eventListener, long l) {
        this.addListener(object, eventListener, l, preferenceChangeEventClass);
    }

    public void addPreferenceChangeListener(Object object, EventListener eventListener) {
        this.addPreferenceChangeListener(object, eventListener, -1L);
    }

    public void removePreferenceChangeListener(Object object, EventListener eventListener, long l) {
        this.removeListener(object, eventListener, l, preferenceChangeEventClass);
    }

    public void removePreferenceChangeListener(Object object, EventListener eventListener) {
        this.removePreferenceChangeListener(object, eventListener, -1L);
    }

    public void removeAllPreferenceChangeListeners(Object object) {
        this.removeAllPreferenceChangeListeners(object, -1L);
    }

    public void removeAllPreferenceChangeListeners(Object object, long l) {
        this.removeAllListeners(object, l, preferenceChangeEventClass);
    }

    public void addModeChangeListener(Object object, EventListener eventListener, long l) {
        this.addListener(object, eventListener, l, modeChangeEventClass);
    }

    public void addModeChangeListener(Object object, EventListener eventListener) {
        this.addModeChangeListener(object, eventListener, -1L);
    }

    public void removeModeChangeListener(Object object, EventListener eventListener, long l) {
        this.removeListener(object, eventListener, l, modeChangeEventClass);
    }

    public void removeModeChangeListener(Object object, EventListener eventListener) {
        this.removeModeChangeListener(object, eventListener, -1L);
    }

    public void removeAllModeChangeListeners(Object object) {
        this.removeAllModeChangeListeners(object, -1L);
    }

    public void removeAllModeChangeListeners(Object object, long l) {
        this.removeAllListeners(object, l, modeChangeEventClass);
    }

    protected void fireNotification(EventListener eventListener, TSEvent tSEvent) {
        if (eventListener instanceof TSEViewportChangeListener && tSEvent instanceof TSEViewportChangeEvent) {
            ((TSEViewportChangeListener)eventListener).viewportChanged((TSEViewportChangeEvent)tSEvent);
        } else if (eventListener instanceof TSESelectionChangeListener && tSEvent instanceof TSESelectionChangeEvent) {
            ((TSESelectionChangeListener)eventListener).selectionChanged((TSESelectionChangeEvent)tSEvent);
        } else if (eventListener instanceof TSEPropertyChangeListener && tSEvent instanceof TSEPropertyChangeEvent) {
            ((TSEPropertyChangeListener)eventListener).propertyChanged((TSEPropertyChangeEvent)tSEvent);
        } else if (eventListener instanceof TSEPreferenceChangeListener && tSEvent instanceof TSEPreferenceChangeEvent) {
            ((TSEPreferenceChangeListener)eventListener).preferenceChanged((TSEPreferenceChangeEvent)tSEvent);
        } else if (eventListener instanceof TSEModeChangeListener && tSEvent instanceof TSEModeChangeEvent) {
            ((TSEModeChangeListener)eventListener).modeChanged((TSEModeChangeEvent)tSEvent);
        } else if (eventListener instanceof TSServiceInputChangeListener && tSEvent instanceof TSServiceInputChangeEvent) {
            ((TSServiceInputChangeListener)eventListener).serviceInputChanged((TSServiceInputChangeEvent)tSEvent);
        } else if (eventListener instanceof TSConstraintChangeListener && tSEvent instanceof TSConstraintChangeEvent) {
            ((TSConstraintChangeListener)eventListener).constraintChanged((TSConstraintChangeEvent)tSEvent);
        } else {
            super.fireNotification(eventListener, tSEvent);
        }
    }

    protected boolean fireVeto(TSVetoableChangeListener tSVetoableChangeListener, TSEvent tSEvent) {
        if (tSVetoableChangeListener instanceof TSEVetoableSelectionChangeListener && tSEvent instanceof TSESelectionChangeEvent) {
            return ((TSEVetoableSelectionChangeListener)tSVetoableChangeListener).selectionChanging((TSESelectionChangeEvent)tSEvent);
        }
        return super.fireVeto(tSVetoableChangeListener, tSEvent);
    }

    public void eventSourceDiscarded(Object object) {
        TSEObjectUI tSEObjectUI;
        super.eventSourceDiscarded(object);
        if (object instanceof TSEObject && (tSEObjectUI = ((TSEObject)object).getUI()) != null) {
            super.eventSourceDiscarded(tSEObjectUI);
        }
    }

    public void addServiceInputChangeListener(Object object, EventListener eventListener, long l) {
        this.addListener(object, eventListener, l, serviceInputChangeEventClass);
    }

    public void addServiceInputChangeListener(Object object, EventListener eventListener) {
        this.addServiceInputChangeListener(object, eventListener, -1L);
    }

    public void removeServiceInputChangeListener(Object object, EventListener eventListener, long l) {
        this.removeListener(object, eventListener, l, serviceInputChangeEventClass);
    }

    public void removeServiceInputChangeListener(Object object, EventListener eventListener) {
        this.removeServiceInputChangeListener(object, eventListener, -1L);
    }

    public void removeAllServiceInputChangeListeners(Object object) {
        this.removeAllServiceInputChangeListeners(object, -1L);
    }

    public void removeAllServiceInputChangeListeners(Object object, long l) {
        this.removeAllListeners(object, l, serviceInputChangeEventClass);
    }

    public void addConstraintChangeListener(Object object, EventListener eventListener, long l) {
        this.addListener(object, eventListener, l, constraintChangeEventClass);
    }

    public void addConstraintChangeListener(Object object, EventListener eventListener) {
        this.addConstraintChangeListener(object, eventListener, -1L);
    }

    public void removeConstraintChangeListener(Object object, EventListener eventListener, long l) {
        this.removeListener(object, eventListener, l, constraintChangeEventClass);
    }

    public void removeConstraintChangeListener(Object object, EventListener eventListener) {
        this.removeConstraintChangeListener(object, eventListener, -1L);
    }

    public void removeAllConstraintChangeListeners(Object object) {
        this.removeAllConstraintChangeListeners(object, -1L);
    }

    public void removeAllConstraintChangeListeners(Object object, long l) {
        this.removeAllListeners(object, l, constraintChangeEventClass);
    }
}

