/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.dialog;

import com.tomsawyer.editor.dialog.gy;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class TSUnsignedIntegerField
extends JTextField
implements FocusListener,
KeyListener {
    protected String defaultString = "";
    protected boolean hasMin = false;
    protected int minimum;
    protected int maximum;
    NumberFormat format;

    public TSUnsignedIntegerField(int n, int n2) {
        this(null, n, n2);
    }

    public TSUnsignedIntegerField(String string, int n, int n2) {
        super(string, n);
        ((JTextComponent)this).setDocument(new gy(this, (int)Math.pow(10.0, n2) - 1));
        this.maximum = (int)Math.pow(10.0, n2) - 1;
        this.minimum = 0;
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public TSUnsignedIntegerField(int n, int n2, int n3) {
        this(null, n, n2, n3);
    }

    public TSUnsignedIntegerField(String string, int n, int n2, int n3) {
        super(string, n);
        ((JTextComponent)this).setDocument(new gy(this, n3));
        if (n2 > 0) {
            this.minimum = n2;
        } else {
            this.hasMin = false;
        }
        this.maximum = n3;
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMinimum(int n) {
        this.minimum = n;
        this.ensureValidValue();
    }

    public void setMinimum(int n, boolean bl) {
        this.minimum = n;
        if (bl) {
            this.ensureValidValue();
        }
    }

    public void setMaximum(int n) {
        this.maximum = n;
        ((gy)this.getDocument()).a = n;
        this.ensureValidValue();
    }

    public void setMaximum(int n, boolean bl) {
        this.maximum = n;
        ((gy)this.getDocument()).a = n;
        if (bl) {
            this.ensureValidValue();
        }
    }

    public String getOldValue() {
        return this.defaultString;
    }

    public void setOldValue(String string) {
        this.defaultString = string;
    }

    public void setText(String string, NumberFormat numberFormat) {
        this.format = numberFormat;
        if (this.isValueValid(string)) {
            super.setText(string);
            this.setOldValue(string);
        } else {
            String string2 = String.valueOf(this.findClosestValue(string));
            super.setText(string2);
            this.setOldValue(string2);
        }
    }

    public void setText(String string) {
        this.setText(string, null);
    }

    int findClosestValue(String string) {
        int n = 0;
        int n2 = 0;
        try {
            n = this.parse(string);
        }
        catch (Exception exception) {
            n = this.minimum;
            n2 = this.minimum;
        }
        n2 = n < this.minimum ? this.minimum : (n > this.maximum ? this.maximum : n);
        return n2;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.ensureValidValue();
    }

    public void keyTyped(KeyEvent keyEvent) {
        try {
            if (keyEvent.getKeyCode() == 10) {
                this.ensureValidValue();
            } else if (keyEvent.getKeyCode() == 38) {
                this.setText(String.valueOf(this.parse(this.getText()) + 1));
                this.selectAll();
            } else if (keyEvent.getKeyCode() == 40) {
                this.setText(String.valueOf(this.parse(this.getText()) - 1));
                this.selectAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    boolean isValueValid(String string) {
        int n = 0;
        boolean bl = true;
        if (string == null || string.equals("")) {
            return true;
        }
        try {
            n = this.parse(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl && (n < this.getMinimum() || n > this.getMaximum())) {
            bl = false;
        }
        return bl;
    }

    public void ensureValidValue() {
        String string = super.getText();
        String string2 = this.getOldValue();
        boolean bl = this.isValueValid(string);
        if (bl) {
            this.setOldValue(string);
        } else {
            this.setText(string2, this.format);
        }
    }

    public String getText() {
        this.ensureValidValue();
        return super.getText();
    }

    public int parse(String string) throws Exception {
        int n = this.format != null ? this.format.parse(string).intValue() : Integer.parseInt(string);
        return n;
    }
}

