/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.complexity.command;

import com.tomsawyer.complexity.TSComplexityManager;
import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.complexity.command.TSHideCommand;
import com.tomsawyer.diagramming.command.cs;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.complexity.TSEHidingManager;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.df;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class TSEHideCommand
extends TSHideCommand {
    TSEGraph graph;
    List graphList;
    boolean deep;
    List edgeLists;
    List affectedEdges;
    List nodeLists;
    List affectedNodes;
    boolean compressMetaEdges;
    boolean updateMetaEdges;
    List removedMetaEdges;
    List insertedMetaEdges;
    TSEGraphManager graphManager;
    cs adjustmentCommand;
    boolean geometricAdjustment = false;

    public TSEHideCommand(TSEGraph tSEGraph, boolean bl) {
        this.graph = tSEGraph;
        this.deep = bl;
        this.graphManager = (TSEGraphManager)tSEGraph.getOwnerGraphManager();
        this.compressMetaEdges = this.graphManager.getCompressMetaEdges();
        this.edgeLists = null;
        this.nodeLists = null;
        this.affectedEdges = new Vector();
        this.affectedNodes = new Vector();
        if (!bl) {
            this.graphList = null;
            this.edgeLists = new Vector(tSEGraph.selectedEdges());
            this.nodeLists = new Vector(tSEGraph.selectedNodes());
            this.affectedEdges.addAll(this.edgeLists);
            this.affectedNodes.addAll(this.nodeLists);
        } else {
            this.graphList = new df();
            TSNestingManager.buildAllNestedGraphList(tSEGraph, this.graphList, false);
            this.graphList.add(0, tSEGraph);
            ListIterator listIterator = this.graphList.listIterator();
            this.edgeLists = new Vector();
            this.nodeLists = new Vector();
            while (listIterator.hasNext()) {
                TSEGraph tSEGraph2 = (TSEGraph)listIterator.next();
                Vector vector = new Vector(tSEGraph2.selectedEdges());
                Vector vector2 = new Vector(tSEGraph2.selectedNodes());
                if (vector.size() != 0 || vector2.size() != 0) {
                    this.edgeLists.add(vector);
                    this.nodeLists.add(vector2);
                    this.affectedEdges.addAll(vector);
                    this.affectedNodes.addAll(vector2);
                    continue;
                }
                listIterator.remove();
            }
        }
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
    }

    public TSEHideCommand(List list, List list2) {
        TSSystem.tsAssert(list != null && list.size() > 0 || list2 != null && list2.size() > 0);
        if (list == null) {
            list = new df();
        } else if (list2 == null) {
            list2 = new df();
        }
        this.deep = false;
        this.nodeLists = list;
        this.edgeLists = list2;
        this.affectedEdges = new Vector();
        this.affectedNodes = new Vector();
        this.affectedEdges.addAll(list2);
        this.affectedNodes.addAll(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSENode tSENode = (TSENode)iterator.next();
            this.affectedEdges.addAll(tSENode.inEdges());
            this.affectedEdges.addAll(tSENode.outEdges());
        }
        this.graph = list.size() != 0 ? (TSEGraph)((TSENode)list.get(0)).getOwner() : (TSEGraph)((TSEEdge)list2.get(0)).getOwner();
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        this.graphManager = (TSEGraphManager)this.graph.getOwnerGraphManager();
        this.compressMetaEdges = this.graphManager.getCompressMetaEdges();
    }

    protected void init() {
        super.init();
        this.geometricAdjustment = ((TSEHidingManager)TSEHidingManager.getManager(this.graphManager)).isUsingGeometricAdjustment();
        if (this.geometricAdjustment) {
            this.adjustmentCommand = new cs(this.graphManager, this.affectedNodes, 4);
        }
    }

    protected void doAction() throws Throwable {
        Object object;
        Iterator iterator;
        TSEHidingManager tSEHidingManager = (TSEHidingManager)TSEHidingManager.getManager(this.graphManager);
        if (!this.deep) {
            this.preprocessLists(this.nodeLists, this.edgeLists, this.graphManager);
            this.graph.deselectAll();
            tSEHidingManager.hide(this.graph, this.nodeLists, this.edgeLists);
            this.nodeLists.clear();
            this.edgeLists.clear();
            this.nodeLists.addAll(tSEHidingManager.getResultNodeList());
            this.edgeLists.addAll(tSEHidingManager.getResultEdgeList());
        } else {
            iterator = this.graphList.listIterator();
            object = this.nodeLists.listIterator();
            ListIterator listIterator = this.edgeLists.listIterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                TSEGraph tSEGraph = (TSEGraph)iterator.next();
                List list = (List)listIterator.next();
                List list2 = (List)object.next();
                this.preprocessLists(list2, list, this.graphManager);
                boolean bl2 = !list2.isEmpty() || !list.isEmpty();
                boolean bl3 = bl = bl || bl2;
                if (!bl2) continue;
                tSEGraph.deselectAll();
                tSEHidingManager.hide(tSEGraph, list2, list);
                list2.clear();
                list.clear();
                list2.addAll(tSEHidingManager.getResultNodeList());
                list.addAll(tSEHidingManager.getResultEdgeList());
            }
            this.setAddToUndoStack(bl);
        }
        if (this.updateMetaEdges) {
            this.insertedMetaEdges = new Vector();
            this.removedMetaEdges = new Vector();
            this.graphManager.checkMetaEdges(this.insertedMetaEdges, this.removedMetaEdges);
            this.graphManager.updateMetaEdges(this.insertedMetaEdges, this.removedMetaEdges, this.insertedMetaEdges);
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                object = (TSEEdge)iterator.next();
                this.removeEdgeFromLists((TSEEdge)object);
            }
        }
        if (this.geometricAdjustment) {
            this.adjustmentCommand.execute();
        }
        tSEHidingManager.clearResultLists();
    }

    private void removeEdgeFromLists(TSEEdge tSEEdge) {
        if (!this.deep) {
            this.edgeLists.remove(tSEEdge);
        } else {
            Iterator iterator = this.edgeLists.iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                list.remove(tSEEdge);
            }
        }
    }

    protected void redoAction() throws Throwable {
        Object object;
        Iterator iterator;
        TSEGraphManager tSEGraphManager = (TSEGraphManager)this.graph.getOwner();
        TSEHidingManager tSEHidingManager = (TSEHidingManager)TSEHidingManager.getManager(tSEGraphManager);
        if (!this.deep) {
            tSEHidingManager.hide(this.graph, this.nodeLists, this.edgeLists);
        } else {
            iterator = this.graphList.listIterator();
            object = this.edgeLists.listIterator();
            ListIterator listIterator = this.nodeLists.listIterator();
            while (iterator.hasNext()) {
                TSEGraph tSEGraph = (TSEGraph)iterator.next();
                tSEHidingManager.hide(tSEGraph, (List)listIterator.next(), (List)object.next());
            }
        }
        if (this.updateMetaEdges) {
            iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                object = (TSEEdge)iterator.next();
                ((TSEdge)object).getOwnerGraph().insert((TSEdge)object);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                object = (TSEEdge)iterator.next();
                this.graphManager.remove((TSEdge)object);
            }
        }
        if (this.geometricAdjustment) {
            this.adjustmentCommand.redo();
        }
        tSEHidingManager.clearResultLists();
    }

    protected void undoAction() throws Throwable {
        Object object;
        Object object2;
        Iterator iterator;
        if (this.geometricAdjustment) {
            this.adjustmentCommand.undo();
        }
        if (this.updateMetaEdges) {
            iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                object2 = (TSEEdge)iterator.next();
                this.graphManager.remove((TSEdge)object2);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                object2 = (TSEEdge)iterator.next();
                object = (TSDGraph)((TSEdge)object2).getOwnerGraph();
                if (((TSDGraph)object).isHideGraph()) {
                    object = ((TSDGraph)object).hideFromGraph();
                }
                ((TSDGraph)object).insert((TSEdge)object2);
            }
        }
        iterator = (TSEGraphManager)this.graph.getOwner();
        object2 = (TSEHidingManager)TSEHidingManager.getManager((TSDGraphManager)((Object)iterator));
        if (!this.deep) {
            TSGraphMember tSGraphMember;
            ((TSHidingManager)object2).unhide(this.graph, this.nodeLists, this.edgeLists, false);
            this.graph.getGraphWindow().deselectAll(false);
            object = this.nodeLists.iterator();
            while (object.hasNext()) {
                TSEEdge tSEEdge;
                tSGraphMember = (TSENode)object.next();
                ((TSENode)tSGraphMember).setSelected(true);
                ((TSENode)tSGraphMember).setLabelsSelected(true);
                ((TSENode)tSGraphMember).setConnectorLabelsSelected(true);
                Iterator iterator2 = ((TSNode)tSGraphMember).buildIncidentIntergraphEdgeList(true, true, true, true).iterator();
                while (iterator2.hasNext()) {
                    tSEEdge = (TSEEdge)iterator2.next();
                    tSEEdge.setSelected(true);
                    tSEEdge.setLabelsSelected(true);
                }
                iterator2 = ((TSDNode)tSGraphMember).buildIncidentMetaEdgeList().iterator();
                while (iterator2.hasNext()) {
                    tSEEdge = (TSEEdge)iterator2.next();
                    tSEEdge.setSelected(true);
                    tSEEdge.setLabelsSelected(true);
                }
            }
            object = this.edgeLists.iterator();
            while (object.hasNext()) {
                tSGraphMember = (TSEEdge)object.next();
                ((TSEEdge)tSGraphMember).setSelected(true);
                ((TSEEdge)tSGraphMember).setLabelsSelected(true);
            }
        } else {
            object = this.graphList.listIterator();
            ListIterator listIterator = this.edgeLists.listIterator();
            ListIterator listIterator2 = this.nodeLists.listIterator();
            this.graph.getGraphWindow().deselectAll(false);
            while (object.hasNext()) {
                TSGraphMember tSGraphMember;
                TSEGraph tSEGraph = (TSEGraph)object.next();
                List list = (List)listIterator2.next();
                List list2 = (List)listIterator.next();
                ((TSHidingManager)object2).unhide(tSEGraph, list, list2, false);
                Iterator iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    TSEEdge tSEEdge;
                    tSGraphMember = (TSENode)iterator3.next();
                    ((TSENode)tSGraphMember).setSelected(true);
                    ((TSENode)tSGraphMember).setLabelsSelected(true);
                    ((TSENode)tSGraphMember).setConnectorLabelsSelected(true);
                    Iterator iterator4 = ((TSNode)tSGraphMember).buildIncidentIntergraphEdgeList(true, true, true, true).iterator();
                    while (iterator4.hasNext()) {
                        tSEEdge = (TSEEdge)iterator4.next();
                        tSEEdge.setSelected(true);
                        tSEEdge.setLabelsSelected(true);
                    }
                    iterator4 = ((TSDNode)tSGraphMember).buildIncidentMetaEdgeList().iterator();
                    while (iterator4.hasNext()) {
                        tSEEdge = (TSEEdge)iterator4.next();
                        tSEEdge.setSelected(true);
                        tSEEdge.setLabelsSelected(true);
                    }
                }
                iterator3 = list2.iterator();
                while (iterator3.hasNext()) {
                    tSGraphMember = (TSEEdge)iterator3.next();
                    ((TSEEdge)tSGraphMember).setSelected(true);
                    ((TSEEdge)tSGraphMember).setLabelsSelected(true);
                }
            }
        }
        ((TSComplexityManager)object2).clearResultLists();
    }

    public boolean isCoalesced() {
        return true;
    }

    public boolean isOrderPreservedInCoalescing() {
        return true;
    }

    public void setUpdateMetaEdges(boolean bl) {
        this.updateMetaEdges = bl;
    }
}

