/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.complexity;

import com.tomsawyer.complexity.TSExpandedNodeExtension;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.complexity.TSEExpandedNodeExtension;
import com.tomsawyer.editor.ui.TSEAnnotatedUI;
import com.tomsawyer.editor.ui.TSEChildGraphUI;
import com.tomsawyer.editor.ui.TSEDefaultNodeUI;
import com.tomsawyer.util.TSLicenseRuntimeException;
import java.util.Iterator;
import java.util.Vector;

public class TSENestingManager
extends TSNestingManager {
    public TSENestingManager(TSEGraphManager tSEGraphManager) {
        super(tSEGraphManager);
    }

    public static boolean expand(TSDNode tSDNode) {
        TSENode tSENode = (TSENode)tSDNode;
        TSConstPoint tSConstPoint = tSDNode.getLocalCenter();
        boolean bl = tSENode.getOwnerGraph().isFiringEvents();
        tSENode.getOwnerGraph().setFireEvents(false);
        boolean bl2 = false;
        try {
            bl2 = TSNestingManager.expand(tSENode);
        }
        catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
            tSENode.getOwnerGraph().setFireEvents(bl);
            throw tSLicenseRuntimeException;
        }
        if (bl2 && !(tSENode.getUI() instanceof TSEChildGraphUI)) {
            boolean bl3 = (tSENode.getResizability() & 0x1000000) != 0;
            tSENode.setResizability(tSENode.getResizability() | 0x1000000);
            if (tSENode.getOriginalUI() != null) {
                TSEObjectUI tSEObjectUI = tSENode.getUI();
                tSENode.setUI(tSENode.getOriginalUI());
                tSENode.setOriginalUI(tSEObjectUI);
            } else {
                tSENode.setOriginalUI(tSENode.getUI());
                tSENode.setUI(tSENode.newChildGraphUI());
            }
            tSENode.setLocalCenter(tSConstPoint);
            if (!bl3) {
                tSENode.setResizability(tSENode.getResizability() & ~0x1000000);
            }
        }
        tSENode.getOwnerGraph().setFireEvents(bl);
        if (bl2) {
            tSENode.getOwnerGraph().fireEvent(new TSComplexityChangeEvent(1L, new TSComplexityChangeEventData(tSENode, null, null)));
        }
        return bl2;
    }

    public TSExpandedNodeExtension newExpandedNodeExtension(TSDNode tSDNode) {
        return new TSEExpandedNodeExtension((TSENode)tSDNode, (TSEGraphManager)this.graphManager);
    }

    static void actAfterOnNestedGraphBoundsChange(TSENode tSENode, TSRect tSRect, TSRect tSRect2) {
        if (!tSRect.equals(tSRect2)) {
            TSEGraph tSEGraph = (TSEGraph)tSENode.getOwner();
            TSEGraphWindow tSEGraphWindow = tSEGraph.getGraphWindow();
            tSRect2.merge(tSRect);
            tSEGraphWindow.addInvalidRegion(tSRect2);
            tSEGraphWindow.addInvalidRegion(tSENode.inEdges());
            tSEGraphWindow.addInvalidRegion(tSENode.outEdges());
            tSEGraphWindow.addInvalidRegion(tSENode.buildIncidentIntergraphEdgeList(true, false, true, true));
        }
    }

    public void updateOnNestedGraphBoundsChange(TSENode tSENode) {
        TSEGraph tSEGraph = (TSEGraph)tSENode.getOwner();
        TSEGraphWindow tSEGraphWindow = tSEGraph.getGraphWindow();
        TSExpTransform tSExpTransform = tSEGraph.getLocalToMainDisplayGraphTransform();
        if (tSExpTransform == null || tSEGraphWindow == null) {
            super.updateOnNestedGraphBoundsChange(tSENode);
        } else {
            TSRect tSRect = new TSRect(tSENode.getUI().getInvalidRegion(tSEGraphWindow.getTransform(), tSExpTransform));
            super.updateOnNestedGraphBoundsChange(tSENode);
            TSRect tSRect2 = new TSRect(tSENode.getUI().getInvalidRegion(tSEGraphWindow.getTransform(), tSExpTransform));
            TSENestingManager.actAfterOnNestedGraphBoundsChange(tSENode, tSRect, tSRect2);
            if (tSENode.getUI() instanceof TSEAnnotatedUI && tSENode.getTag() != null) {
                ((TSEAnnotatedUI)tSENode.getUI()).onTextChanged(tSENode.getText());
            }
        }
    }

    public static boolean collapse(TSDNode tSDNode) {
        boolean bl = TSNestingManager.collapse(tSDNode);
        TSENode tSENode = (TSENode)tSDNode;
        if (bl && tSENode.getUI() instanceof TSEChildGraphUI) {
            boolean bl2 = tSENode.getOwnerGraph().isFiringEvents();
            tSENode.getOwnerGraph().setFireEvents(false);
            boolean bl3 = (tSENode.getResizability() & 0x1000000) != 0;
            tSENode.setResizability(tSENode.getResizability() | 0x1000000);
            TSConstPoint tSConstPoint = tSENode.getLocalCenter();
            if (tSENode.getOriginalUI() != null) {
                TSEObjectUI tSEObjectUI = tSENode.getUI();
                tSENode.setUI(tSENode.getOriginalUI());
                tSENode.setOriginalUI(tSEObjectUI);
            } else {
                tSENode.setOriginalUI(tSENode.getUI());
                tSENode.setUI(new TSEDefaultNodeUI());
            }
            tSENode.setLocalCenter(tSConstPoint);
            if (!bl3) {
                tSENode.setResizability(tSENode.getResizability() & ~0x1000000);
            }
            tSENode.getOwnerGraph().setFireEvents(bl2);
        }
        return bl;
    }

    public void expandSelected() {
        if (this.graphManager != null) {
            TSENode tSENode;
            Object object;
            Vector<TSENode> vector = new Vector<TSENode>();
            TSEGraph tSEGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
            Vector vector2 = new Vector();
            tSEGraph.buildAllChildGraphList(vector2);
            Iterator iterator = vector2.iterator();
            while (iterator.hasNext()) {
                object = (TSEGraph)iterator.next();
                if (!(((TSDGraph)object).getParent() instanceof TSENode) || !(tSENode = (TSENode)((TSDGraph)object).getParent()).isSelected() || tSENode.isExpanded()) continue;
                vector.add(tSENode);
            }
            object = vector.listIterator(vector.size());
            while (object.hasPrevious()) {
                tSENode = (TSENode)object.previous();
                TSENestingManager.expand(tSENode);
            }
        }
    }

    public void expandAll() {
        if (this.graphManager != null) {
            TSENode tSENode;
            Object object;
            Vector<TSENode> vector = new Vector<TSENode>();
            TSEGraph tSEGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
            Vector vector2 = new Vector();
            tSEGraph.buildAllChildGraphList(vector2);
            Iterator iterator = vector2.iterator();
            while (iterator.hasNext()) {
                object = (TSEGraph)iterator.next();
                if (!(((TSDGraph)object).getParent() instanceof TSENode) || (tSENode = (TSENode)((TSDGraph)object).getParent()).isExpanded()) continue;
                vector.add(tSENode);
            }
            object = vector.listIterator(vector.size());
            while (object.hasPrevious()) {
                tSENode = (TSENode)object.previous();
                TSENestingManager.expand(tSENode);
            }
        }
    }

    public void collapseSelected() {
        if (this.graphManager != null) {
            TSENode tSENode;
            Object object;
            Vector<TSENode> vector = new Vector<TSENode>();
            TSEGraph tSEGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
            Vector vector2 = new Vector();
            TSNestingManager.buildAllNestedGraphList(tSEGraph, vector2, false);
            Iterator iterator = vector2.iterator();
            while (iterator.hasNext()) {
                object = (TSEGraph)iterator.next();
                if (!(((TSDGraph)object).getParent() instanceof TSENode) || !(tSENode = (TSENode)((TSDGraph)object).getParent()).isSelected()) continue;
                vector.add(tSENode);
            }
            object = vector.iterator();
            while (object.hasNext()) {
                tSENode = (TSENode)object.next();
                TSENestingManager.collapse(tSENode);
            }
        }
    }

    public void collapseAll() {
        if (this.graphManager != null) {
            TSENode tSENode;
            Object object;
            Vector<TSENode> vector = new Vector<TSENode>();
            TSEGraph tSEGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
            Vector vector2 = new Vector();
            TSNestingManager.buildAllNestedGraphList(tSEGraph, vector2, false);
            Iterator iterator = vector2.iterator();
            while (iterator.hasNext()) {
                object = (TSEGraph)iterator.next();
                if (!(((TSDGraph)object).getParent() instanceof TSENode)) continue;
                tSENode = (TSENode)((TSDGraph)object).getParent();
                vector.add(tSENode);
            }
            object = vector.iterator();
            while (object.hasNext()) {
                tSENode = (TSENode)object.next();
                TSENestingManager.collapse(tSENode);
            }
        }
    }

    public static boolean hasSelectedExpandedNodes(TSEGraph tSEGraph) {
        boolean bl = false;
        if (tSEGraph != null) {
            Iterator iterator = tSEGraph.selectedNodes().iterator();
            while (!bl && iterator.hasNext()) {
                bl = ((TSENode)iterator.next()).isExpanded();
            }
        }
        return bl;
    }

    public static boolean hasSelectedCollapsedNodes(TSEGraph tSEGraph) {
        boolean bl = false;
        if (tSEGraph != null) {
            Iterator iterator = tSEGraph.selectedNodes().iterator();
            while (!bl && iterator.hasNext()) {
                bl = ((TSENode)iterator.next()).isCollapsed();
            }
        }
        return bl;
    }

    public boolean hasSelectedExpandedNodes() {
        Iterator iterator = ((TSEGraphManager)this.graphManager).reachableGraphList().iterator();
        while (iterator.hasNext()) {
            if (!TSENestingManager.hasSelectedExpandedNodes((TSEGraph)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectedCollapsedNodes() {
        Iterator iterator = ((TSEGraphManager)this.graphManager).reachableGraphList().iterator();
        while (iterator.hasNext()) {
            if (!TSENestingManager.hasSelectedCollapsedNodes((TSEGraph)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static TSNestingManager getManager(TSDGraphManager tSDGraphManager) {
        TSNestingManager tSNestingManager = TSNestingManager.hasManager(tSDGraphManager);
        if (tSNestingManager == null) {
            tSNestingManager = new TSENestingManager((TSEGraphManager)tSDGraphManager);
        }
        return tSNestingManager;
    }

    public boolean isUsingGeometricAdjustment() {
        boolean bl = false;
        TSEGraphWindow tSEGraphWindow = ((TSEGraphManager)this.graphManager).getGraphWindow();
        if (tSEGraphWindow != null) {
            bl = tSEGraphWindow.getPreferences().getBooleanValue("geometricAdjustment");
        }
        return bl;
    }

    public void setUsingGeometricAdjustment(boolean bl) {
        TSEGraphWindow tSEGraphWindow = ((TSEGraphManager)this.graphManager).getGraphWindow();
        if (tSEGraphWindow != null) {
            tSEGraphWindow.getPreferences().setValue((Object)"geometricAdjustment", bl);
        }
    }
}

