/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.util.command.TSCommand;

public class TSEViewParentGraphCommand
extends TSCommand {
    TSEGraph childGraph;
    TSEGraph parentGraph;
    TSEGraphWindow window;
    TSRect oldOriginalVisibleBounds;

    public TSEViewParentGraphCommand(TSEGraphWindow tSEGraphWindow, TSEGraph tSEGraph) {
        if (tSEGraphWindow == null || tSEGraph == null || !tSEGraph.isChildGraph() || tSEGraph.getOwner() != tSEGraphWindow.getGraphManager()) {
            throw new IllegalArgumentException();
        }
        this.childGraph = tSEGraph;
        TSEGraph tSEGraph2 = (TSEGraph)tSEGraph.getParent().getOwner();
        if (tSEGraph2.isIntergraph()) {
            TSEEdge tSEEdge = (TSEEdge)this.childGraph.getParent();
            this.parentGraph = (TSEGraph)tSEEdge.getTransformGraph();
        } else {
            this.parentGraph = (TSEGraph)tSEGraph.getParent().getOwner();
        }
        this.window = tSEGraphWindow;
        this.oldOriginalVisibleBounds = null;
    }

    protected void doAction() throws Throwable {
        boolean bl = this.window.getGraphManager().getCompressMetaEdges();
        if (this.window.getGraph().getOriginalVisibleBounds() != null) {
            this.oldOriginalVisibleBounds = new TSRect(this.window.getGraph().getOriginalVisibleBounds());
        }
        this.window.getGraph().setOriginalVisibleBounds(this.window.getTransform().getWorldBounds());
        this.window.setGraph(this.parentGraph, false);
        if (this.getParentGraph().getOriginalVisibleBounds() != null) {
            this.window.fitRectInWindow(this.getParentGraph().getOriginalVisibleBounds(), false);
        } else {
            this.window.fitInWindow(false);
        }
        this.window.getGraphManager().setCompressMetaEdges(bl);
    }

    protected void undoAction() throws Throwable {
        boolean bl = this.window.getGraphManager().getCompressMetaEdges();
        this.window.getGraph().setOriginalVisibleBounds(this.window.getTransform().getWorldBounds());
        this.window.setGraph(this.childGraph, false);
        if (this.getChildGraph().getOriginalVisibleBounds() != null) {
            this.window.fitRectInWindow(this.getChildGraph().getOriginalVisibleBounds(), false);
        }
        this.window.getGraph().setOriginalVisibleBounds(this.oldOriginalVisibleBounds);
        this.window.getGraphManager().setCompressMetaEdges(bl);
    }

    public TSEGraph getChildGraph() {
        return this.childGraph;
    }

    public TSEGraph getParentGraph() {
        return this.parentGraph;
    }

    public TSEGraphWindow getGraphWindow() {
        return this.window;
    }
}

