/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.util.command.TSCommand;

public class TSEViewChildGraphCommand
extends TSCommand {
    TSGraphMember graphMember;
    TSEGraphWindow window;
    TSEGraph oldRoot;
    TSRect oldOriginalVisibleBounds;

    public TSEViewChildGraphCommand(TSEGraphWindow tSEGraphWindow, TSGraphMember tSGraphMember) {
        if (tSEGraphWindow == null || tSGraphMember == null || !tSGraphMember.hasChildGraph() || tSGraphMember.getOwner().getOwner() != tSEGraphWindow.getGraphManager()) {
            throw new IllegalArgumentException();
        }
        this.graphMember = tSGraphMember;
        this.window = tSEGraphWindow;
        this.oldRoot = tSEGraphWindow.getGraph();
        this.oldOriginalVisibleBounds = null;
    }

    protected void doAction() throws Throwable {
        if (this.window.getGraph().getOriginalVisibleBounds() != null) {
            this.oldOriginalVisibleBounds = new TSRect(this.window.getGraph().getOriginalVisibleBounds());
        }
        this.window.getGraph().setOriginalVisibleBounds(this.window.getTransform().getWorldBounds());
        TSEGraph tSEGraph = (TSEGraph)this.graphMember.getChildGraph();
        this.window.setGraph(tSEGraph, false);
        if (tSEGraph.getOriginalVisibleBounds() != null) {
            this.window.fitRectInWindow(tSEGraph.getOriginalVisibleBounds(), false);
        } else {
            this.window.fitInWindow(false);
        }
    }

    protected void undoAction() throws Throwable {
        this.window.getGraph().setOriginalVisibleBounds(this.window.getTransform().getWorldBounds());
        this.window.setGraph(this.oldRoot, false);
        if (this.oldRoot.getOriginalVisibleBounds() != null) {
            this.window.fitRectInWindow(this.oldRoot.getOriginalVisibleBounds(), false);
        }
        this.oldRoot.setOriginalVisibleBounds(this.oldOriginalVisibleBounds);
    }

    public TSGraphMember getGraphMember() {
        return this.graphMember;
    }

    public TSEGraphWindow getGraphWindow() {
        return this.window;
    }
}

