/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceOutputData;
import com.tomsawyer.service.client.TSServiceProxy;
import com.tomsawyer.service.layout.client.TSApplyLayoutResults;
import com.tomsawyer.service.layout.client.TSLayoutInputFilter;
import com.tomsawyer.util.command.TSCommand;

public abstract class TSELayoutOperationCommand
extends TSCommand {
    TSEGraph graph;
    TSEGraphManager graphManager;
    TSEGraphWindow graphWindow;
    TSServiceProxy proxy;
    TSEAllOptionsServiceInputData inputData;
    TSServiceOutputData outputData;
    TSServiceOutputData currentOutputData;
    boolean singleGraph;

    public TSELayoutOperationCommand(TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        this(tSEGraphWindow.getGraphManager(), tSServiceProxy, tSEAllOptionsServiceInputData);
    }

    public TSELayoutOperationCommand(TSEGraphManager tSEGraphManager, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        this.graphManager = tSEGraphManager;
        this.proxy = tSServiceProxy;
        this.inputData = tSEAllOptionsServiceInputData;
        this.graphWindow = tSEGraphManager.getGraphWindow();
        this.graph = (TSEGraph)tSEGraphManager.getMainDisplayGraph();
        this.singleGraph = false;
    }

    public TSELayoutOperationCommand(TSEGraph tSEGraph, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        this.graph = tSEGraph;
        this.proxy = tSServiceProxy;
        this.inputData = tSEAllOptionsServiceInputData;
        this.graphWindow = tSEGraph.getGraphWindow();
        this.singleGraph = true;
    }

    protected void doAction() throws Throwable {
        this.inputData.setOption(null, "all:all:none:operation", this.getOperation());
        this.inputData.setOption(null, "all:all:none:graphManager", (Object)this.graphManager);
        TSLayoutInputFilter tSLayoutInputFilter = new TSLayoutInputFilter();
        TSServiceInputData tSServiceInputData = new TSServiceInputData();
        tSLayoutInputFilter.execute((TSServiceInputData)this.inputData, tSServiceInputData);
        this.outputData = new TSServiceOutputData();
        this.proxy.run(tSServiceInputData, this.outputData);
        TSApplyLayoutResults tSApplyLayoutResults = new TSApplyLayoutResults();
        this.currentOutputData = this.singleGraph ? tSApplyLayoutResults.generateOutputData((TSDGraph)this.graph) : tSApplyLayoutResults.generateOutputData((TSDGraphManager)this.graphManager, (TSServiceInputData)this.inputData);
        tSApplyLayoutResults.apply(tSServiceInputData, this.outputData);
        this.postLayout();
    }

    protected void postLayout() {
    }

    protected void undoAction() throws Throwable {
        TSApplyLayoutResults tSApplyLayoutResults = new TSApplyLayoutResults();
        tSApplyLayoutResults.apply((TSServiceInputData)this.inputData, this.currentOutputData);
    }

    protected void redoAction() throws Throwable {
        TSApplyLayoutResults tSApplyLayoutResults = new TSApplyLayoutResults();
        tSApplyLayoutResults.apply((TSServiceInputData)this.inputData, this.outputData);
    }

    public abstract int getOperation();

    public TSServiceProxy getServiceProxy() {
        return this.proxy;
    }
}

