/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.complexity.TSFoldingManager;
import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.diagramming.TSCutCopyPasteControl;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSNodeLabel;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSOptionData;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.f2;
import java.awt.datatransfer.Clipboard;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSEDuplicateCommand
extends TSCommand {
    Vector nodes;
    Vector edges;
    TSEGraphManager graphManager;
    TSOptionData serviceInputData;
    Vector ownerGraphsOfNodes;
    Vector ownerGraphsOfEdges;
    Vector connectorLabels;
    Vector ownerConnectorsOfConnectorLabels;
    Vector nodeLabels;
    Vector ownerNodesOfNodeLabels;
    Vector edgeLabels;
    Vector ownerEdgesOfEdgeLabels;
    boolean compressMetaEdges;
    List graphs;
    List margins;
    boolean updateMetaEdges;
    List removedMetaEdges;
    List insertedMetaEdges;

    public TSEDuplicateCommand(TSEGraphManager tSEGraphManager) {
        this(tSEGraphManager, null);
    }

    public TSEDuplicateCommand(TSEGraphManager tSEGraphManager, TSOptionData tSOptionData) {
        f2.a(f2.by);
        this.graphManager = tSEGraphManager;
        this.serviceInputData = tSOptionData;
        this.updateMetaEdges = true;
        this.insertedMetaEdges = null;
        this.removedMetaEdges = null;
        this.compressMetaEdges = tSEGraphManager.getCompressMetaEdges();
    }

    protected void doAction() throws Throwable {
        this.storeOldMargins();
        this.nodes = new Vector();
        this.edges = new Vector();
        this.nodeLabels = new Vector();
        this.connectorLabels = new Vector();
        this.edgeLabels = new Vector();
        this.ownerGraphsOfNodes = new Vector();
        this.ownerGraphsOfEdges = new Vector();
        this.ownerNodesOfNodeLabels = new Vector();
        this.ownerConnectorsOfConnectorLabels = new Vector();
        this.ownerEdgesOfEdgeLabels = new Vector();
        if (this.graphManager != null && this.graphManager.hasSelectedNodes() || this.graphManager.hasSelectedEdges(true) || this.graphManager.hasSelectedNodeLabels() || this.graphManager.hasSelectedConnectorLabels() || this.graphManager.hasSelectedEdgeLabels(true)) {
            TSCutCopyPasteControl tSCutCopyPasteControl = this.newCutCopyPasteControl();
            tSCutCopyPasteControl.duplicate(this.graphManager, this.serviceInputData, this.graphManager.selectedNodes(), this.graphManager.selectedEdges(true), this.graphManager.selectedNodeLabels(), this.graphManager.selectedConnectorLabels(), this.graphManager.selectedEdgeLabels(true), this.nodes, this.edges, this.nodeLabels, this.connectorLabels, this.edgeLabels, TSCutCopyPasteControl.shiftAmount);
            TSDGraphManager tSDGraphManager = tSCutCopyPasteControl.getClipboardGraphManager();
            TSNestingManager.discardManager(tSDGraphManager);
            TSHidingManager.discardManager(tSDGraphManager);
            TSFoldingManager.discardManager(tSDGraphManager);
            Iterator iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                this.ownerGraphsOfNodes.add(((TSENode)iterator.next()).getOwner());
            }
            iterator = this.edges.iterator();
            while (iterator.hasNext()) {
                this.ownerGraphsOfEdges.add(((TSEEdge)iterator.next()).getOwner());
            }
            iterator = this.nodeLabels.iterator();
            while (iterator.hasNext()) {
                this.ownerNodesOfNodeLabels.add(((TSENodeLabel)iterator.next()).getOwner());
            }
            iterator = this.connectorLabels.iterator();
            while (iterator.hasNext()) {
                this.ownerConnectorsOfConnectorLabels.add(((TSEConnectorLabel)iterator.next()).getOwner());
            }
            iterator = this.edgeLabels.iterator();
            while (iterator.hasNext()) {
                this.ownerEdgesOfEdgeLabels.add(((TSEEdgeLabel)iterator.next()).getOwner());
            }
            this.graphManager.selectAll(false);
            this.setSelection(true);
        }
        if (this.updateMetaEdges) {
            this.insertedMetaEdges = new Vector();
            this.removedMetaEdges = new Vector();
            this.graphManager.checkMetaEdges(this.insertedMetaEdges, this.removedMetaEdges);
            this.graphManager.updateMetaEdges(this.insertedMetaEdges, this.removedMetaEdges, this.insertedMetaEdges);
        }
    }

    protected void undoAction() throws Throwable {
        TSGraphObject tSGraphObject;
        TSGraphObject tSGraphObject2;
        Iterator iterator;
        if (this.updateMetaEdges) {
            iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSGraphObject2 = (TSEEdge)iterator.next();
                this.graphManager.remove((TSEdge)tSGraphObject2);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSGraphObject2 = (TSEEdge)iterator.next();
                ((TSEdge)tSGraphObject2).getOwnerGraph().insert((TSEdge)tSGraphObject2);
            }
        }
        this.setSelection(false);
        iterator = this.edges.iterator();
        while (iterator.hasNext()) {
            tSGraphObject2 = (TSEEdge)iterator.next();
            tSGraphObject = (TSEGraph)tSGraphObject2.getOwner();
            ((TSEGraph)tSGraphObject).remove((TSEdge)tSGraphObject2);
        }
        iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject2 = (TSENode)iterator.next();
            tSGraphObject = (TSEGraph)tSGraphObject2.getOwner();
            ((TSDGraph)tSGraphObject).remove((TSNode)tSGraphObject2);
        }
        iterator = this.nodeLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject2 = (TSENodeLabel)iterator.next();
            tSGraphObject = (TSENode)tSGraphObject2.getOwner();
            ((TSDNode)tSGraphObject).remove((TSLabel)tSGraphObject2);
        }
        iterator = this.connectorLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject2 = (TSEConnectorLabel)iterator.next();
            ((TSEConnector)tSGraphObject2.getOwner()).remove((TSLabel)tSGraphObject2);
        }
        iterator = this.edgeLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject2 = (TSEEdgeLabel)iterator.next();
            tSGraphObject = (TSEEdge)tSGraphObject2.getOwner();
            ((TSDEdge)tSGraphObject).remove((TSLabel)tSGraphObject2);
        }
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        TSGraphObject tSGraphObject;
        Iterator iterator;
        Iterator iterator2 = this.nodes.iterator();
        Iterator iterator3 = this.ownerGraphsOfNodes.iterator();
        while (iterator2.hasNext()) {
            iterator = (TSENode)iterator2.next();
            tSGraphObject = (TSEGraph)iterator3.next();
            ((TSDGraph)tSGraphObject).insert((TSNode)((Object)iterator));
            ((TSENode)((Object)iterator)).setSelected(true);
        }
        iterator2 = this.edges.iterator();
        iterator3 = this.ownerGraphsOfEdges.iterator();
        while (iterator2.hasNext()) {
            iterator = (TSEEdge)iterator2.next();
            tSGraphObject = (TSEGraph)iterator3.next();
            ((TSDGraph)tSGraphObject).insert((TSEdge)((Object)iterator));
        }
        iterator2 = this.nodeLabels.iterator();
        iterator3 = this.ownerNodesOfNodeLabels.iterator();
        while (iterator2.hasNext()) {
            iterator = (TSENodeLabel)iterator2.next();
            tSGraphObject = (TSENode)iterator3.next();
            ((TSDNode)tSGraphObject).insert((TSNodeLabel)((Object)iterator));
        }
        iterator2 = this.connectorLabels.iterator();
        iterator3 = this.ownerConnectorsOfConnectorLabels.iterator();
        while (iterator2.hasNext()) {
            iterator = (TSEConnectorLabel)iterator2.next();
            tSGraphObject = (TSEConnector)iterator3.next();
            ((TSConnector)tSGraphObject).insert((TSConnectorLabel)((Object)iterator));
        }
        iterator2 = this.edgeLabels.iterator();
        iterator3 = this.ownerEdgesOfEdgeLabels.iterator();
        while (iterator2.hasNext()) {
            iterator = (TSEEdgeLabel)iterator2.next();
            tSGraphObject = (TSEEdge)iterator3.next();
            ((TSDEdge)tSGraphObject).insert((TSEdgeLabel)((Object)iterator));
        }
        this.graphManager.selectAll(false);
        this.setSelection(true);
        if (this.updateMetaEdges) {
            iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEEdge)iterator.next();
                ((TSEdge)tSGraphObject).getOwnerGraph().insert((TSEdge)tSGraphObject);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEEdge)iterator.next();
                this.graphManager.remove((TSEdge)tSGraphObject);
            }
        }
    }

    private void setSelection(boolean bl) {
        Object object;
        Iterator iterator;
        Object object2;
        Iterator iterator2 = this.nodes.iterator();
        while (iterator2.hasNext()) {
            object2 = (TSENode)iterator2.next();
            ((TSENode)object2).setSelected(bl);
            iterator = ((TSDNode)object2).labels().iterator();
            while (iterator.hasNext()) {
                object = (TSENodeLabel)iterator.next();
                ((TSENodeLabel)object).setSelected(bl);
            }
            object = ((TSDNode)object2).connectors().iterator();
            while (object.hasNext()) {
                TSEConnector tSEConnector = (TSEConnector)object.next();
                tSEConnector.setSelected(bl);
                tSEConnector.setLabelsSelected(bl);
            }
        }
        iterator2 = this.edges.iterator();
        while (iterator2.hasNext()) {
            object2 = (TSEEdge)iterator2.next();
            if (((TSEdge)object2).isIntergraphEdge() && !((TSDEdge)object2).isViewable() && (object = (TSEEdge)this.graphManager.getMetaEdge((TSDEdge)object2)) != null) {
                object2 = object;
            }
            ((TSEEdge)object2).setSelected(bl);
            Iterator iterator3 = ((TSDEdge)object2).bendIterator();
            while (iterator3.hasNext()) {
                object = (TSEPNode)iterator3.next();
                ((TSEPNode)object).setSelected(bl);
            }
            iterator = ((TSDEdge)object2).labels().iterator();
            while (iterator.hasNext()) {
                object = (TSEEdgeLabel)iterator.next();
                ((TSEEdgeLabel)object).setSelected(bl);
            }
        }
        iterator2 = this.nodeLabels.iterator();
        while (iterator2.hasNext()) {
            object2 = (TSENodeLabel)iterator2.next();
            ((TSENodeLabel)object2).setSelected(bl);
        }
        iterator2 = this.connectorLabels.iterator();
        while (iterator2.hasNext()) {
            object2 = (TSEConnectorLabel)iterator2.next();
            ((TSEConnectorLabel)object2).setSelected(bl);
        }
        iterator2 = this.edgeLabels.iterator();
        while (iterator2.hasNext()) {
            object2 = (TSEEdgeLabel)iterator2.next();
            ((TSEEdgeLabel)object2).setSelected(bl);
        }
    }

    protected void undoCleanup() {
        Iterator iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            ((TSENode)iterator.next()).dispose();
        }
        iterator = this.edges.iterator();
        while (iterator.hasNext()) {
            ((TSEEdge)iterator.next()).dispose();
        }
        iterator = this.nodeLabels.iterator();
        while (iterator.hasNext()) {
            ((TSENodeLabel)iterator.next()).dispose();
        }
        iterator = this.connectorLabels.iterator();
        while (iterator.hasNext()) {
            ((TSEConnectorLabel)iterator.next()).dispose();
        }
        iterator = this.edgeLabels.iterator();
        while (iterator.hasNext()) {
            ((TSEEdgeLabel)iterator.next()).dispose();
        }
    }

    private void storeOldMargins() {
        if (this.graphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(this.graphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSEGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSEGraph tSEGraph = (TSEGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSEGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSEGraph.updateBounds();
            }
        }
    }

    public boolean isCoalesced() {
        return true;
    }

    public void setUpdateMetaEdges(boolean bl) {
        this.updateMetaEdges = bl;
    }

    protected TSCutCopyPasteControl newCutCopyPasteControl() {
        return new TSCutCopyPasteControl(new Clipboard("temp"));
    }
}

