/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.command.TSDeleteNodeCommand;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.util.f2;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSEDeleteNodeCommand
extends TSDeleteNodeCommand {
    boolean updateMetaEdges = true;
    List removedMetaEdges = null;
    List insertedMetaEdges = null;
    TSEGraphManager graphManager;

    public TSEDeleteNodeCommand(TSENode tSENode) {
        super(tSENode);
        this.graphManager = (TSEGraphManager)tSENode.getOwnerGraphManager();
        f2.a(f2.br);
    }

    protected void doAction() throws Throwable {
        super.doAction();
        if (this.updateMetaEdges) {
            this.insertedMetaEdges = new Vector();
            this.removedMetaEdges = new Vector();
            this.graphManager.checkMetaEdges(this.insertedMetaEdges, this.removedMetaEdges);
            this.graphManager.updateMetaEdges(this.insertedMetaEdges, this.removedMetaEdges, this.insertedMetaEdges);
        }
    }

    protected void undoAction() throws Throwable {
        Object object;
        Iterator iterator;
        if (this.updateMetaEdges) {
            iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                object = (TSEEdge)iterator.next();
                this.graphManager.remove((TSEdge)object);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                object = (TSEEdge)iterator.next();
                ((TSEdge)object).getOwnerGraph().insert((TSEdge)object);
            }
        }
        super.undoAction();
        ((TSENode)this.getNode()).setSelected(true);
        iterator = this.getNode().labels().iterator();
        while (iterator.hasNext()) {
            object = (TSENodeLabel)iterator.next();
            ((TSENodeLabel)object).setSelected(true);
        }
        object = this.getNode().connectors().iterator();
        while (object.hasNext()) {
            TSEConnector tSEConnector = (TSEConnector)object.next();
            tSEConnector.setSelected(true);
            tSEConnector.setLabelsSelected(true);
        }
    }

    protected void redoAction() throws Throwable {
        super.redoAction();
        if (this.updateMetaEdges) {
            TSEEdge tSEEdge;
            Iterator iterator = this.insertedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSEEdge = (TSEEdge)iterator.next();
                tSEEdge.getOwnerGraph().insert(tSEEdge);
            }
            iterator = this.removedMetaEdges.iterator();
            while (iterator.hasNext()) {
                tSEEdge = (TSEEdge)iterator.next();
                this.graphManager.remove(tSEEdge);
            }
        }
    }

    public void setUpdateMetaEdges(boolean bl) {
        this.updateMetaEdges = bl;
    }
}

