/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.command;

import com.tomsawyer.drawing.ct;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.ui.TSEConnectorUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.editor.ui.TSERectangularUI;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TSEChangeUICommand
extends TSCommand {
    private TSENode node;
    private TSEConnector connector;
    private TSERectangularUI newUI;
    private TSERectangularUI oldUI;
    private List oldClippingList = new LinkedList();

    public TSEChangeUICommand(TSENode tSENode, TSENodeUI tSENodeUI) {
        if (tSENode == null || tSENodeUI == null) {
            throw new IllegalArgumentException();
        }
        this.node = tSENode;
        this.newUI = tSENodeUI;
    }

    public TSEChangeUICommand(TSEConnector tSEConnector, TSEConnectorUI tSEConnectorUI) {
        if (tSEConnector == null || tSEConnectorUI == null) {
            throw new IllegalArgumentException();
        }
        this.connector = tSEConnector;
        this.newUI = tSEConnectorUI;
    }

    protected void doAction() throws Throwable {
        if (this.node != null && !this.node.isExpanded()) {
            this.storeOldClippings();
            this.oldUI = this.node.getNodeUI();
            this.node.setUI(this.newUI);
            this.node.adjustIncidentClippings();
        } else if (this.connector != null) {
            this.storeOldClippings();
            this.oldUI = this.connector.getConnectorUI();
            this.connector.setUI(this.newUI);
            this.connector.adjustIncidentClippings();
        }
    }

    protected void undoAction() throws Throwable {
        if (this.node != null && !this.node.isExpanded()) {
            this.node.setUI(this.oldUI);
            this.restoreOldClippings();
        } else if (this.connector != null) {
            this.connector.setUI(this.oldUI);
            this.restoreOldClippings();
        }
    }

    public List getAffectedObjects() {
        Vector<TSGraphObject> vector = new Vector<TSGraphObject>();
        List list = new Vector();
        if (this.node != null) {
            vector.add(this.node);
            list = this.node.buildInOutEdges(16);
        } else if (this.connector != null) {
            vector.add(this.connector);
            list = this.connector.buildIncidentEdges(16);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSEEdge tSEEdge = (TSEEdge)iterator.next();
            vector.addAll(tSEEdge.labels());
        }
        vector.addAll(list);
        return vector;
    }

    private void storeOldClippings() {
        Vector vector = new Vector();
        if (this.node != null) {
            vector.addAll(this.node.inEdges());
            vector.addAll(this.node.outEdges());
            vector.addAll(this.node.disconnectedEdges());
        } else if (this.connector != null) {
            vector.addAll(this.connector.incidentEdges());
            vector.addAll(this.connector.disconnectedEdges());
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            LinkedList<Object> linkedList;
            TSEEdge tSEEdge = (TSEEdge)iterator.next();
            if (this.node != null && tSEEdge.getSourceNode() == this.node || this.connector != null && tSEEdge.getSourceConnector() == this.connector) {
                linkedList = new LinkedList<Object>();
                linkedList.add(tSEEdge);
                linkedList.add(new ct(tSEEdge.getSourceClipping()));
                linkedList.add(new Boolean(true));
                this.oldClippingList.add(linkedList);
                continue;
            }
            if ((this.node == null || tSEEdge.getTargetNode() != this.node) && (this.connector == null || tSEEdge.getTargetConnector() != this.connector)) continue;
            linkedList = new LinkedList();
            linkedList.add(tSEEdge);
            linkedList.add(new ct(tSEEdge.getTargetClipping()));
            linkedList.add(new Boolean(false));
            this.oldClippingList.add(linkedList);
        }
    }

    private void restoreOldClippings() {
        Iterator iterator = this.oldClippingList.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            TSEEdge tSEEdge = (TSEEdge)list.get(0);
            ct ct2 = (ct)list.get(1);
            Boolean bl = (Boolean)list.get(2);
            if (bl.booleanValue()) {
                tSEEdge.setSourceClipping(ct2);
                continue;
            }
            tSEEdge.setTargetClipping(ct2);
        }
    }

    public TSENode getNode() {
        return this.node;
    }

    public TSEConnector getConnector() {
        return this.connector;
    }

    public TSERectangularUI getNewUI() {
        return this.newUI;
    }
}

