/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSBaseTransform;
import com.tomsawyer.util.TSSystem;
import java.awt.Dimension;
import java.awt.Rectangle;

public class TSTransform
extends TSBaseTransform {
    Rectangle deviceBounds;
    TSRect worldBounds;

    public TSTransform(Dimension dimension) {
        this(0, 0, dimension.width, dimension.height);
    }

    public TSTransform(int n, int n2, int n3, int n4) {
        this.init();
        this.setDeviceBounds(n, n2, n3, n4);
    }

    public TSTransform(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void init() {
        this.setOffsetX(0.0);
        this.setOffsetY(0.0);
        this.setScaleX(1.0);
        this.setScaleY(-1.0);
    }

    public void setDeviceBounds(int n, int n2, int n3, int n4) {
        TSSystem.tsAssert((double)n3 > 0.0);
        TSSystem.tsAssert((double)n4 > 0.0);
        if (this.deviceBounds == null) {
            this.deviceBounds = new Rectangle();
        }
        this.deviceBounds.setBounds(n, n2, n3, n4);
        if (this.worldBounds == null) {
            this.worldBounds = new TSRect(0.0, 0.0, n3, n4);
            this.centerWorldInDevice();
        } else {
            this.worldBounds.setRight(this.worldBounds.getLeft() + this.widthToWorld(this.deviceBounds.width));
            this.worldBounds.setBottom(this.worldBounds.getTop() - this.heightToWorld(this.deviceBounds.height));
        }
    }

    public void setDeviceSize(int n, int n2) {
        TSSystem.tsAssert(n > 0);
        TSSystem.tsAssert(n2 > 0);
        if (this.deviceBounds == null) {
            this.setDeviceBounds(0, 0, n, n2);
        } else {
            this.setDeviceBounds(this.deviceBounds.x, this.deviceBounds.y, n, n2);
        }
    }

    public TSConstRect getWorldBounds() {
        return this.worldBounds;
    }

    public Rectangle getDeviceBounds() {
        return this.deviceBounds;
    }

    public void moveWorldBy(double d, double d2) {
        this.worldBounds.moveBy(d, d2);
        this.centerWorldInDevice();
    }

    public void setWorldTopLeft(double d, double d2) {
        this.moveWorldBy(d - this.worldBounds.getLeft(), d2 - this.worldBounds.getTop());
    }

    public void setWorldBottomLeft(double d, double d2) {
        this.moveWorldBy(d - this.worldBounds.getLeft(), d2 - this.worldBounds.getBottom());
    }

    public void expandWorldBy(double d, double d2) {
        TSSystem.tsAssert(0.0 < d);
        TSSystem.tsAssert(0.0 < d2);
        this.setWorldSize(this.worldBounds.getWidth() * d, this.worldBounds.getHeight() * d2);
    }

    public void setWorldSize(double d, double d2) {
        TSSystem.tsAssert(d > 0.0);
        TSSystem.tsAssert(d2 > 0.0);
        this.worldBounds.setSize(d, d2);
        this.fitToDevice(this.worldBounds);
    }

    public void setZoomLevel(double d) {
        TSSystem.tsAssert(0.0 < d);
        this.setWorldSize((double)this.deviceBounds.width * d, (double)this.deviceBounds.height * d);
    }

    public void fitToDevice(TSConstRect tSConstRect) {
        TSSystem.tsAssert(tSConstRect != null);
        TSSystem.tsAssert(tSConstRect.getWidth() > 0.0);
        TSSystem.tsAssert(tSConstRect.getHeight() > 0.0);
        this.worldBounds.setBounds(tSConstRect);
        this.updateScaling();
        this.centerWorldInDevice();
    }

    void updateScaling() {
        double d;
        double d2 = (double)this.deviceBounds.height / this.worldBounds.getHeight();
        if (d2 < (d = (double)this.deviceBounds.width / this.worldBounds.getWidth())) {
            this.setScaleX(d2);
            this.setScaleY(-d2);
        } else {
            this.setScaleX(d);
            this.setScaleY(-d);
        }
    }

    public void centerWorldInDevice(TSConstRect tSConstRect) {
        this.worldBounds.setBounds(tSConstRect);
        this.centerWorldInDevice();
    }

    public void centerWorldInDevice() {
        this.setOffsetX(this.deviceBounds.getCenterX() - this.getScaleX() * this.worldBounds.getCenterX());
        this.setOffsetY(this.deviceBounds.getCenterY() - this.getScaleY() * this.worldBounds.getCenterY());
        if (this.widthToDevice(this.worldBounds.getWidth()) != this.deviceBounds.width) {
            this.worldBounds.setWidth(this.widthToWorld(this.deviceBounds.width));
        }
        if (this.heightToDevice(this.worldBounds.getHeight()) != this.deviceBounds.height) {
            this.worldBounds.setHeight(this.heightToWorld(this.deviceBounds.height));
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof TSTransform) {
            TSTransform tSTransform = (TSTransform)object;
            bl = this.deviceBounds.equals(tSTransform.getDeviceBounds()) && this.worldBounds.equals(tSTransform.getWorldBounds());
        }
        return bl;
    }

    public int hashCode() {
        return this.deviceBounds.hashCode() ^ this.worldBounds.hashCode();
    }

    public String toString() {
        return "deviceBounds = " + this.getDeviceBounds() + ", worldBounds = " + this.getWorldBounds();
    }

    public Object clone() {
        TSTransform tSTransform = (TSTransform)super.clone();
        tSTransform.deviceBounds = new Rectangle(this.deviceBounds);
        tSTransform.worldBounds = new TSRect(this.worldBounds);
        return tSTransform;
    }

    public void copy(Object object) {
        super.copy(object);
        TSTransform tSTransform = (TSTransform)object;
        this.deviceBounds.setBounds(tSTransform.deviceBounds);
        this.worldBounds.setBounds(tSTransform.worldBounds);
    }

    public static TSTransform compose(TSTransform tSTransform, TSExpTransform tSExpTransform) {
        TSTransform tSTransform2 = (TSTransform)tSTransform.clone();
        if (tSExpTransform != null) {
            tSTransform2.expandWorldBy(1.0 / tSExpTransform.getScaleX(), 1.0 / tSExpTransform.getScaleY());
            tSTransform2.moveWorldBy(-tSExpTransform.getOffsetX(), -tSExpTransform.getOffsetY());
        }
        return tSTransform2;
    }
}

