/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGEdge;
import com.tomsawyer.drawing.TSGNode;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectable;
import com.tomsawyer.editor.ui.TSELabelUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.editor.ui.TSERectangularUI;
import com.tomsawyer.editor.ui.dc;
import com.tomsawyer.graph.TSGraphObject;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;

public abstract class TSEWindowTool {
    static final int DEFAULT_SCROLLING_STEP = 10;
    Cursor defaultCursor;
    Cursor actionCursor;
    TSEWindowTool oldTool;
    TSEGraphWindow graphWindow;
    JComponent canvas;
    private double connectorHitTolerance = 10.0;
    int scrollingStep;
    String toolName;
    TSRect dirtyRegion;

    public TSEWindowTool() {
        this(null);
    }

    public TSEWindowTool(TSEWindowTool tSEWindowTool) {
        this.oldTool = tSEWindowTool;
        this.scrollingStep = 10;
        this.toolName = this.getClass().getName();
        this.defaultCursor = Cursor.getPredefinedCursor(0);
        this.actionCursor = Cursor.getPredefinedCursor(12);
    }

    protected void init() {
    }

    public void paint(TSEGraphics tSEGraphics) {
    }

    public TSEHitTesting getHitTesting() {
        return this.getGraphWindow().getHitTesting();
    }

    public TSENode getNodeAt(TSConstPoint tSConstPoint, TSEObject tSEObject) {
        return this.getNodeAt(tSConstPoint, tSEObject, this.getGraph());
    }

    public TSENode getNodeAt(TSConstPoint tSConstPoint, TSEObject tSEObject, TSEGraph tSEGraph) {
        return (TSENode)tSEGraph.getLastNodeTouchingBounds(new TSConstRect(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint.getX(), tSConstPoint.getY()), tSEObject);
    }

    public TSENodeLabel getNodeLabelAt(TSConstPoint tSConstPoint, TSEObject tSEObject) {
        return this.getNodeLabelAt(tSConstPoint, tSEObject, this.getGraph());
    }

    public TSENodeLabel getNodeLabelAt(TSConstPoint tSConstPoint, TSEObject tSEObject, TSEGraph tSEGraph) {
        return (TSENodeLabel)tSEGraph.getLastNodeLabelTouchingBounds(new TSConstRect(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint.getX(), tSConstPoint.getY()), tSEObject);
    }

    public TSEConnector getConnectorAt(TSConstPoint tSConstPoint, TSEObject tSEObject) {
        return this.getConnectorAt(tSConstPoint, tSEObject, this.getGraph());
    }

    public TSEConnector getConnectorAt(TSConstPoint tSConstPoint, TSEObject tSEObject, TSEGraph tSEGraph) {
        return (TSEConnector)tSEGraph.getLastConnectorTouchingBounds(new TSConstRect(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint.getX(), tSConstPoint.getY()), tSEObject);
    }

    public TSEConnectorLabel getConnectorLabelAt(TSConstPoint tSConstPoint, TSEObject tSEObject) {
        return this.getConnectorLabelAt(tSConstPoint, tSEObject, this.getGraph());
    }

    public TSEConnectorLabel getConnectorLabelAt(TSConstPoint tSConstPoint, TSEObject tSEObject, TSEGraph tSEGraph) {
        return (TSEConnectorLabel)tSEGraph.getLastConnectorLabelTouchingBounds(new TSConstRect(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint.getX(), tSConstPoint.getY()), tSEObject);
    }

    public TSEEdge getIntergraphEdgeAt(TSConstPoint tSConstPoint, TSEObject tSEObject, TSEGraph tSEGraph) {
        if (this.getGraphWindow().getGraphManager().intergraphEdges().isEmpty()) {
            return null;
        }
        double d = this.graphWindow.getHitTolerance() / 2;
        TSEEdge tSEEdge = (TSEEdge)tSEGraph.getLastIntergraphEdgeTouchingBounds(new TSConstRect(tSConstPoint.getX() - d, tSConstPoint.getY() - d, tSConstPoint.getX() + d, tSConstPoint.getY() + d), tSEObject);
        return tSEEdge;
    }

    public TSEEdge getEdgeAt(TSConstPoint tSConstPoint, TSEObject tSEObject) {
        return this.getEdgeAt(tSConstPoint, tSEObject, this.getGraph());
    }

    public TSEEdge getEdgeAt(TSConstPoint tSConstPoint, TSEObject tSEObject, TSEGraph tSEGraph) {
        double d = this.graphWindow.getHitTolerance() / 2;
        TSEEdge tSEEdge = (TSEEdge)tSEGraph.getLastEdgeTouchingBounds(new TSConstRect(tSConstPoint.getX() - d, tSConstPoint.getY() - d, tSConstPoint.getX() + d, tSConstPoint.getY() + d), tSEObject);
        return tSEEdge;
    }

    public TSEEdgeLabel getEdgeLabelAt(TSConstPoint tSConstPoint, TSEObject tSEObject) {
        return this.getEdgeLabelAt(tSConstPoint, tSEObject, this.getGraph());
    }

    public TSEEdgeLabel getEdgeLabelAt(TSConstPoint tSConstPoint, TSEObject tSEObject, TSEGraph tSEGraph) {
        return (TSEEdgeLabel)tSEGraph.getLastEdgeLabelTouchingBounds(new TSConstRect(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint.getX(), tSConstPoint.getY()), tSEObject);
    }

    public TSEPNode getPathNodeAt(TSConstPoint tSConstPoint, TSEObject tSEObject) {
        return this.getPathNodeAt(tSConstPoint, tSEObject, this.getGraph());
    }

    public TSEPNode getPathNodeAt(TSConstPoint tSConstPoint, TSEObject tSEObject, TSEGraph tSEGraph) {
        return (TSEPNode)tSEGraph.getLastPathNodeTouchingBounds(new TSConstRect(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint.getX(), tSConstPoint.getY()), tSEObject);
    }

    public TSPEdge getPathEdgeAt(TSConstPoint tSConstPoint, TSEObject tSEObject) {
        return this.getPathEdgeAt(tSConstPoint, tSEObject, this.getGraph());
    }

    public TSPEdge getPathEdgeAt(TSConstPoint tSConstPoint, TSEObject tSEObject, TSEGraph tSEGraph) {
        double d = this.graphWindow.getHitTolerance() / 2;
        return tSEGraph.getLastPathEdgeTouchingBounds(new TSConstRect(tSConstPoint.getX() - d, tSConstPoint.getY() - d, tSConstPoint.getX() + d, tSConstPoint.getY() + d), tSEObject);
    }

    public TSEConnector getClosestConnector(TSENode tSENode, TSConstPoint tSConstPoint) {
        if (tSENode == null || tSConstPoint == null) {
            return null;
        }
        List list = tSENode.connectors();
        TSEConnector tSEConnector = null;
        double d = this.getConnectorHitTolerance();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSEConnector tSEConnector2 = (TSEConnector)iterator.next();
            double d2 = tSConstPoint.distance(tSEConnector2.getCenterX(), tSEConnector2.getCenterY());
            if (!(d2 <= d)) continue;
            d = d2;
            tSEConnector = tSEConnector2;
        }
        return tSEConnector;
    }

    public double getConnectorHitTolerance() {
        return this.connectorHitTolerance;
    }

    public void setConnectorHitTolerance(double d) {
        if (d > 0.0) {
            this.connectorHitTolerance = d;
        }
    }

    public TSEObject getObjectAt(TSConstPoint tSConstPoint) {
        return this.getObjectAt(tSConstPoint, null);
    }

    public TSEObject getObjectAt(TSConstPoint tSConstPoint, TSEObject tSEObject) {
        return this.getObjectAt(tSConstPoint, tSEObject, this.getGraph());
    }

    public TSEObject getObjectAt(TSConstPoint tSConstPoint, TSEObject tSEObject, TSEGraph tSEGraph) {
        int n;
        int n2;
        ListIterator listIterator;
        Object object;
        TSEObject tSEObject2 = null;
        Object object2 = null;
        Object object3 = null;
        TSEConnector tSEConnector = null;
        TSEObject tSEObject3 = null;
        boolean bl = tSEObject == null;
        TSRect tSRect = new TSRect(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint.getX(), tSConstPoint.getY());
        tSEGraph.inverseExpandedTransformRect(tSRect);
        double d = this.graphWindow.getHitTolerance() / 2;
        TSRect tSRect2 = new TSRect(tSConstPoint.getX() - d, tSConstPoint.getY() - d, tSConstPoint.getX() + d, tSConstPoint.getY() + d);
        if (tSEGraph.getOwnerGraphManager().queryIntergraph() != null) {
            object = tSEGraph.getOwnerGraphManager().intergraphEdges();
            listIterator = object.listIterator(object.size());
            while (listIterator.hasPrevious()) {
                TSEEdge tSEEdge = (TSEEdge)listIterator.previous();
                if (tSEEdge.getTransformGraph() != tSEGraph) continue;
                if (tSEObject2 == null) {
                    tSEObject2 = (TSEObject)((Object)tSEEdge.getLocalLastLabelTouchingBounds(tSRect, tSEObject));
                }
                if (tSEObject2 == null && tSEObject3 == null && (tSEObject3 = (TSEPNode)tSEEdge.getLocalLastPathNodeTouchingBounds(tSRect, tSEObject)) != null) {
                    n2 = tSEEdge.pathEdges().indexOf(tSEEdge.getFirstDrawablePEdge());
                    n = tSEEdge.pathEdges().indexOf(tSEEdge.getLastDrawablePEdge());
                    int n3 = tSEEdge.pathNodes().indexOf(tSEObject3);
                    if (n3 < n2 || n3 >= n) {
                        tSEObject3 = null;
                    }
                }
                if (tSEObject2 != null || tSEObject3 != null || object3 != null || !tSEEdge.isVisible() || !tSEEdge.isViewable() || !tSEEdge.intersects(tSRect2)) continue;
                if (bl) {
                    object3 = tSEEdge;
                }
                bl = tSEEdge.equals(tSEObject);
            }
            if (tSEObject2 == null) {
                tSEObject2 = tSEObject3;
            }
            if (tSEObject2 == null) {
                tSEObject2 = object3;
            }
            tSEObject3 = null;
            object3 = null;
        }
        if (tSEObject2 == null) {
            listIterator = tSEGraph.edges().listIterator(tSEGraph.edges().size());
            tSEGraph.inverseExpandedTransformRect(tSRect2);
            while (listIterator.hasPrevious()) {
                object = (TSEEdge)listIterator.previous();
                if (tSEObject2 == null) {
                    tSEObject2 = (TSEObject)((Object)((TSDEdge)object).getLocalLastLabelTouchingBounds(tSRect, tSEObject));
                }
                if (tSEObject2 == null && tSEObject3 == null && (tSEObject3 = (TSEPNode)((TSDEdge)object).getLocalLastPathNodeTouchingBounds(tSRect, tSEObject)) != null) {
                    int n4 = ((TSDEdge)object).pathEdges().indexOf(((TSDEdge)object).getFirstDrawablePEdge());
                    n2 = ((TSDEdge)object).pathEdges().indexOf(((TSDEdge)object).getLastDrawablePEdge());
                    n = ((TSDEdge)object).pathNodes().indexOf(tSEObject3);
                    if (n < n4 || n >= n2) {
                        tSEObject3 = null;
                    }
                }
                if (tSEObject2 != null || tSEObject3 != null || object3 != null || !((TSDEdge)object).locallyIntersects(tSRect2)) continue;
                if (bl) {
                    object3 = object;
                }
                bl = object.equals(tSEObject);
            }
            if (tSEObject2 == null) {
                tSEObject2 = tSEObject3;
            }
            if (tSEObject2 == null) {
                tSEObject2 = object3;
            }
        }
        if (tSEObject2 == null) {
            listIterator = tSEGraph.nodes().listIterator(tSEGraph.nodes().size());
            while (listIterator.hasPrevious()) {
                object = (TSENode)listIterator.previous();
                if (tSEObject2 != null) continue;
                ListIterator listIterator2 = ((TSDNode)object).connectors().listIterator(((TSDNode)object).connectors().size());
                while (listIterator2.hasPrevious()) {
                    TSEConnector tSEConnector2 = (TSEConnector)listIterator2.previous();
                    if (tSEObject2 == null) {
                        tSEObject2 = (TSEObject)((Object)tSEConnector2.getLocalLastLabelTouchingBounds(tSRect, tSEObject));
                    }
                    if (tSEObject2 != null || tSEConnector != null || !tSEConnector2.isVisible() || !tSEConnector2.locallyIntersects(tSRect)) continue;
                    if (bl) {
                        tSEConnector = tSEConnector2;
                    }
                    bl = tSEConnector2.equals(tSEObject);
                }
                if (tSEObject2 == null) {
                    tSEObject2 = (TSEObject)((Object)((TSDNode)object).getLocalLastLabelTouchingBounds(tSRect, tSEObject));
                }
                if (tSEObject2 == null) {
                    tSEObject2 = tSEConnector;
                }
                if (tSEObject2 == null && object2 == null && ((TSDNode)object).isVisible() && ((TSGNode)object).locallyIntersects(tSRect)) {
                    if (bl) {
                        object2 = object;
                    }
                    bl = object.equals(tSEObject);
                }
                if (tSEObject2 == null) {
                    tSEObject2 = object2;
                }
                if (!this.getGraphWindow().isNestedGraphEditingEnabled() || object2 == null) continue;
                if (((TSDNode)object2).isExpanded()) {
                    TSEGraph tSEGraph2 = (TSEGraph)TSNestingManager.getNestedGraph((TSDNode)object2);
                    TSEObject tSEObject4 = this.getObjectAt(tSConstPoint, tSEObject, tSEGraph2);
                    if (tSEObject4 != null) {
                        return tSEObject4;
                    }
                    if (!((TSDNode)object2).intersectsNodeFrame(tSConstPoint)) {
                        return null;
                    }
                }
                return tSEObject2;
            }
        }
        return tSEObject2;
    }

    public int getGrappleAt(TSConstPoint tSConstPoint) {
        int n;
        TSExpTransform tSExpTransform;
        TSEInspectable tSEInspectable;
        Iterator iterator;
        TSEGraphManager tSEGraphManager = this.graphWindow.getGraphManager();
        Rectangle rectangle = new Rectangle(this.graphWindow.transform.xToDevice(tSConstPoint.getX()), this.graphWindow.transform.yToDevice(tSConstPoint.getY()), 1, 1);
        if (tSEGraphManager.hasSelectedNodes()) {
            iterator = tSEGraphManager.selectedNodes().iterator();
            while (iterator.hasNext()) {
                tSEInspectable = (TSENodeUI)((TSENode)iterator.next()).getUI();
                tSExpTransform = ((TSDGraph)((TSENodeUI)tSEInspectable).getOwnerNode().getOwnerGraph()).getLocalToMainDisplayGraphTransform();
                if (tSExpTransform == null || (n = ((TSERectangularUI)tSEInspectable).getGrappleTouchingBounds(rectangle, TSTransform.compose(this.graphWindow.getTransform(), tSExpTransform))) == 0) continue;
                return n;
            }
        }
        if (this.graphWindow.getGraphManager().hasSelectedEdgeLabels(true)) {
            iterator = this.graphWindow.getGraphManager().selectedEdgeLabels(true).iterator();
            while (iterator.hasNext()) {
                tSEInspectable = (TSELabelUI)((TSEEdgeLabel)iterator.next()).getUI();
                tSExpTransform = ((TSELabelUI)tSEInspectable).getOwnerLabel().getTransformGraph().getLocalToMainDisplayGraphTransform();
                if (tSExpTransform == null || (n = ((TSERectangularUI)tSEInspectable).getGrappleTouchingBounds(rectangle, TSTransform.compose(this.graphWindow.getTransform(), tSExpTransform))) == 0) continue;
                return n;
            }
        }
        if (this.graphWindow.getGraphManager().hasSelectedNodeLabels()) {
            iterator = this.graphWindow.getGraphManager().selectedNodeLabels().iterator();
            while (iterator.hasNext()) {
                tSEInspectable = (TSELabelUI)((TSENodeLabel)iterator.next()).getUI();
                tSExpTransform = ((TSDGraph)((TSELabelUI)tSEInspectable).getOwnerLabel().getOwnerGraph()).getLocalToMainDisplayGraphTransform();
                if (tSExpTransform == null || (n = ((TSERectangularUI)tSEInspectable).getGrappleTouchingBounds(rectangle, TSTransform.compose(this.graphWindow.getTransform(), tSExpTransform))) == 0) continue;
                return n;
            }
        }
        if (this.graphWindow.getGraphManager().hasSelectedConnectorLabels()) {
            iterator = this.graphWindow.getGraphManager().selectedConnectorLabels().iterator();
            while (iterator.hasNext()) {
                tSEInspectable = (TSELabelUI)((TSEConnectorLabel)iterator.next()).getUI();
                tSExpTransform = ((TSDGraph)((TSELabelUI)tSEInspectable).getOwnerLabel().getOwnerGraph()).getLocalToMainDisplayGraphTransform();
                if (tSExpTransform == null || (n = ((TSERectangularUI)tSEInspectable).getGrappleTouchingBounds(rectangle, TSTransform.compose(this.graphWindow.getTransform(), tSExpTransform))) == 0) continue;
                return n;
            }
        }
        if (tSEGraphManager.hasSelectedPathNodes(true)) {
            iterator = this.graphWindow.getGraphManager().selectedPathNodes(true).iterator();
            while (iterator.hasNext()) {
                int n2;
                tSEInspectable = (TSEPNode)iterator.next();
                tSExpTransform = null;
                TSDGraph tSDGraph = (TSDGraph)((TSGNode)((Object)tSEInspectable)).getTransformGraph();
                if (tSDGraph != null) {
                    tSExpTransform = tSDGraph.getLocalToMainDisplayGraphTransform();
                }
                if (tSExpTransform == null || (n2 = ((dc)((TSEPNode)tSEInspectable).getUI()).getGrappleTouchingBounds(rectangle, TSTransform.compose(this.graphWindow.getTransform(), tSExpTransform))) == 0) continue;
                return n2;
            }
        }
        return 0;
    }

    public TSESolidObject getOwnerOfGrappleAt(TSConstPoint tSConstPoint) {
        int n;
        TSExpTransform tSExpTransform;
        TSERectangularUI tSERectangularUI;
        TSGraphObject tSGraphObject;
        Iterator iterator;
        TSEGraphManager tSEGraphManager = this.graphWindow.getGraphManager();
        Rectangle rectangle = new Rectangle(this.graphWindow.transform.xToDevice(tSConstPoint.getX()), this.graphWindow.transform.yToDevice(tSConstPoint.getY()), 1, 1);
        if (tSEGraphManager.hasSelectedNodes()) {
            iterator = tSEGraphManager.selectedNodes().iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSENode)iterator.next();
                tSERectangularUI = (TSENodeUI)((TSENode)tSGraphObject).getUI();
                tSExpTransform = ((TSDGraph)((TSENodeUI)tSERectangularUI).getOwnerNode().getOwnerGraph()).getLocalToMainDisplayGraphTransform();
                if (tSExpTransform == null || (n = tSERectangularUI.getGrappleTouchingBounds(rectangle, TSTransform.compose(this.graphWindow.getTransform(), tSExpTransform))) == 0) continue;
                return tSGraphObject;
            }
        }
        if (this.graphWindow.getGraphManager().hasSelectedEdgeLabels(true)) {
            iterator = this.graphWindow.getGraphManager().selectedEdgeLabels(true).iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEEdgeLabel)iterator.next();
                tSERectangularUI = (TSELabelUI)((TSEEdgeLabel)tSGraphObject).getUI();
                tSExpTransform = ((TSELabelUI)tSERectangularUI).getOwnerLabel().getTransformGraph().getLocalToMainDisplayGraphTransform();
                if (tSExpTransform == null || (n = tSERectangularUI.getGrappleTouchingBounds(rectangle, TSTransform.compose(this.graphWindow.getTransform(), tSExpTransform))) == 0) continue;
                return tSGraphObject;
            }
        }
        if (this.graphWindow.getGraphManager().hasSelectedNodeLabels()) {
            iterator = this.graphWindow.getGraphManager().selectedNodeLabels().iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSENodeLabel)iterator.next();
                tSERectangularUI = (TSELabelUI)((TSENodeLabel)tSGraphObject).getUI();
                tSExpTransform = ((TSDGraph)((TSELabelUI)tSERectangularUI).getOwnerLabel().getOwnerGraph()).getLocalToMainDisplayGraphTransform();
                if (tSExpTransform == null || (n = tSERectangularUI.getGrappleTouchingBounds(rectangle, TSTransform.compose(this.graphWindow.getTransform(), tSExpTransform))) == 0) continue;
                return tSGraphObject;
            }
        }
        if (this.graphWindow.getGraphManager().hasSelectedConnectorLabels()) {
            iterator = this.graphWindow.getGraphManager().selectedConnectorLabels().iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEConnectorLabel)iterator.next();
                tSERectangularUI = (TSELabelUI)((TSEConnectorLabel)tSGraphObject).getUI();
                tSExpTransform = ((TSDGraph)((TSELabelUI)tSERectangularUI).getOwnerLabel().getOwnerGraph()).getLocalToMainDisplayGraphTransform();
                if (tSExpTransform == null || (n = tSERectangularUI.getGrappleTouchingBounds(rectangle, TSTransform.compose(this.graphWindow.getTransform(), tSExpTransform))) == 0) continue;
                return tSGraphObject;
            }
        }
        if (tSEGraphManager.hasSelectedPathNodes(true)) {
            iterator = tSEGraphManager.selectedPathNodes(true).iterator();
            while (iterator.hasNext()) {
                int n2;
                tSGraphObject = (TSEPNode)iterator.next();
                tSERectangularUI = (dc)((TSEPNode)tSGraphObject).getUI();
                tSExpTransform = null;
                TSDGraph tSDGraph = (TSDGraph)((TSGNode)tSGraphObject).getTransformGraph();
                if (tSDGraph != null) {
                    tSExpTransform = tSDGraph.getLocalToMainDisplayGraphTransform();
                }
                if (tSExpTransform == null || (n2 = tSERectangularUI.getGrappleTouchingBounds(rectangle, TSTransform.compose(this.graphWindow.getTransform(), tSExpTransform))) == 0) continue;
                return tSGraphObject;
            }
        }
        return null;
    }

    public int getResizeMode(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 9: {
                n2 = 9;
                break;
            }
            case 6: {
                n2 = 6;
                break;
            }
            case 10: {
                n2 = 10;
            }
        }
        return n2;
    }

    public void setCursor(Cursor cursor) {
        if (this.graphWindow != null) {
            this.graphWindow.setCursorOnCanvas(cursor);
        }
    }

    public boolean updateVisibleArea(TSConstPoint tSConstPoint, boolean bl) {
        TSTransform tSTransform = this.graphWindow.transform;
        if (tSTransform.getWorldBounds().contains(tSConstPoint)) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        TSConstRect tSConstRect = tSTransform.getWorldBounds();
        if (tSConstPoint.getX() < tSConstRect.getLeft()) {
            n = -Math.max(tSTransform.widthToDevice(tSConstRect.getLeft() - tSConstPoint.getX()) / 5, this.scrollingStep);
        } else if (tSConstPoint.getX() > tSConstRect.getRight()) {
            n = Math.max(tSTransform.widthToDevice(tSConstPoint.getX() - tSConstRect.getRight()) / 5, this.scrollingStep);
        }
        if (tSConstPoint.getY() < tSConstRect.getBottom()) {
            n2 = Math.max(tSTransform.heightToDevice(tSConstRect.getBottom() - tSConstPoint.getY()) / 5, this.scrollingStep);
        } else if (tSConstPoint.getY() > tSConstRect.getTop()) {
            n2 = -Math.max(tSTransform.heightToDevice(tSConstPoint.getY() - tSConstRect.getTop()) / 5, this.scrollingStep);
        }
        this.graphWindow.scrollBy(n, n2, bl);
        return true;
    }

    public void addDirtyRegion(TSConstRect tSConstRect) {
        if (tSConstRect != null && tSConstRect.intersects(this.getGraphWindow().getTransform().getWorldBounds())) {
            if (this.dirtyRegion == null) {
                this.dirtyRegion = new TSRect(tSConstRect);
            } else {
                this.dirtyRegion.merge(tSConstRect);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDirtyRegion(TSEObject tSEObject) {
        Cloneable cloneable;
        TSDGraph tSDGraph = null;
        if (tSEObject.getOwnerGraph() != null) {
            tSDGraph = (TSDGraph)tSEObject.getOwnerGraph();
            if (tSDGraph.isIntergraph()) {
                cloneable = tSEObject instanceof TSEEdge ? (TSEEdge)tSEObject : (TSEEdge)tSEObject.getOwner();
                if (!((TSDEdge)cloneable).isViewable()) return;
                tSDGraph = (TSEGraph)((TSGEdge)cloneable).getTransformGraph();
            } else if (tSDGraph.isHideGraph()) {
                tSDGraph = tSDGraph.hideFromGraph();
            }
        } else {
            tSDGraph = this.getGraph();
        }
        if (tSDGraph == null || (cloneable = tSDGraph.getLocalToMainDisplayGraphTransform()) == null) return;
        this.addDirtyRegion(tSEObject.getUI().getInvalidRegion(this.getGraphWindow().getTransform(), (TSExpTransform)cloneable));
    }

    public void addDirtyRegion(List list) {
        if (!list.isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof TSConstRect) {
                    this.addDirtyRegion((TSConstRect)e);
                    continue;
                }
                if (!(e instanceof TSEObject)) continue;
                this.addDirtyRegion((TSEObject)e);
            }
        }
    }

    public void addDirtyRegion(TSConstPoint tSConstPoint) {
        this.addDirtyRegion(tSConstPoint, 0.0);
    }

    public void addDirtyRegion(TSConstPoint tSConstPoint, double d) {
        if (tSConstPoint != null) {
            double d2 = tSConstPoint.getX();
            double d3 = tSConstPoint.getY();
            if (this.dirtyRegion == null) {
                this.dirtyRegion = new TSRect(d2 - d, d3 - d, d2 + d, d3 + d);
            } else {
                if (d2 - d < this.dirtyRegion.getLeft()) {
                    this.dirtyRegion.setLeft(d2 - d);
                } else if (d2 + d > this.dirtyRegion.getRight()) {
                    this.dirtyRegion.setRight(d2 + d);
                }
                if (d3 - d < this.dirtyRegion.getBottom()) {
                    this.dirtyRegion.setBottom(d3 - d);
                } else if (d3 + d > this.dirtyRegion.getTop()) {
                    this.dirtyRegion.setTop(d3 + d);
                }
            }
        }
    }

    public TSRect getDirtyRegion() {
        return this.dirtyRegion;
    }

    public void setDirtyRegion(TSRect tSRect) {
        this.dirtyRegion = tSRect;
    }

    public void paintDirtyRegion(boolean bl) {
        if (this.dirtyRegion != null) {
            TSTransform tSTransform = this.graphWindow.transform;
            this.graphWindow.canvas.repaint(tSTransform.xToDevice(this.dirtyRegion.getLeft()) - 5, tSTransform.yToDevice(this.dirtyRegion.getTop()) - 5, tSTransform.widthToDevice(this.dirtyRegion.getWidth()) + 10, tSTransform.heightToDevice(this.dirtyRegion.getHeight()) + 10);
            if (bl) {
                this.dirtyRegion = null;
            }
        } else {
            this.getGraphWindow().fastRepaint();
        }
    }

    public void cancelAction() {
    }

    public void finalizeTool() {
        this.setTool(this.oldTool);
    }

    public void resetTool() {
        this.setCursor(this.defaultCursor);
    }

    public void setTool(TSEWindowTool tSEWindowTool) {
        if (tSEWindowTool != null) {
            this.graphWindow.setCurrentTool(tSEWindowTool);
            tSEWindowTool.resetTool();
        }
    }

    public TSEWindowTool getParentTool() {
        return this.oldTool;
    }

    public Cursor getActionCursor() {
        return this.actionCursor;
    }

    public void setActionCursor(Cursor cursor) {
        this.actionCursor = cursor;
    }

    public Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public int getScrollingStep() {
        return this.scrollingStep;
    }

    public void setScrollingStep(int n) {
        this.scrollingStep = n;
    }

    protected TSEGraph getGraph() {
        return this.graphWindow.getGraph();
    }

    protected JComponent getCanvas() {
        return this.canvas;
    }

    public TSEEventManager getEventManager() {
        return (TSEEventManager)this.getGraphWindow().getGraphManager().getEventManager();
    }

    public TSEGraphWindow getGraphWindow() {
        return this.graphWindow;
    }

    protected void setGraphWindow(TSEGraphWindow tSEGraphWindow) {
        this.graphWindow = tSEGraphWindow;
        this.canvas = tSEGraphWindow.canvas;
        this.init();
    }

    public void setName(String string) {
        this.toolName = string;
    }

    public String getName() {
        return this.toolName;
    }

    public int getEventContext() {
        return 0;
    }
}

