/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.event.TSEPreferenceChangeEvent;
import com.tomsawyer.editor.event.TSEPreferenceChangeEventData;
import com.tomsawyer.event.TSChildEventSource;
import com.tomsawyer.util.TSProperty;
import com.tomsawyer.util.TSSystem;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TSEPreferences
implements TSChildEventSource {
    private TSEGraphWindow graphWindow;
    private Hashtable hashTable;
    public static final String UNDO_STACK_LIMIT = "undoStackSize";
    public static final String ENABLE_TOOLTIPS = "tooltipsEnabled";
    public static final String MINIMUM_ZOOM_LEVEL = "minimumZoomLevel";
    public static final String MINIMUM_ZOOM_PERCENT = "minimumZoomLevel";
    public static final String MAXIMUM_ZOOM_LEVEL = "maximumZoomLevel";
    public static final String MAXIMUM_ZOOM_PERCENT = "maximumZoomLevel";
    public static final String AUTO_HIDE_SCROLLBARS = "autoHideScrollbars";
    public static final String IN_PLACE_EDITING = "inPlaceEditing";
    public static final String PARTIAL_SELECTION = "partialSelection";
    public static final String HIT_TOLERANCE = "hitTolerance";
    public static final String HIT_TOLERANCE_THRESHOLD = "hitToleranceThreshold";
    public static final String EDGE_HIT_TOLERANCE = "hitTolerance";
    public static final String DRAW_INVISIBLE_ON_DRAGGING = "drawInvisibleOnDragging";
    public static final String DRAW_INVISIBLE = "drawInvisibleOnDragging";
    public static final String OPAQUE_MOVEMENT = "opaqueMovement";
    public static final String INTERACTIVE_ZOOM_SENSITIVITY = "interactiveZoomSensitivity";
    public static final String RECONNECT_EDGE_SENSITIVITY = "reconnectEdgeSensitivity";
    public static final String PANNING_SENSITIVITY = "panningSensitivity";
    public static final String EDGE_NAVIGATION_TRIP_DURATION = "edgeNavigationTripDuration";
    public static final String EDGE_NAVIGATION_BLINK_DURATION = "edgeNavigationBlinkDuration";
    public static final String EDGE_NAVIGATION_FRAME_COUNT = "edgeNavigationFrameCount";
    public static final String COMPRESS_META_EDGES = "compressMetaEdges";
    public static final String GEOMETRIC_ADJUSTMENT = "geometricAdjustment";
    public static final String PREVENT_RESIZE_INVERSION = "preventResizeInversion";

    public TSEPreferences(TSEGraphWindow tSEGraphWindow) {
        this.graphWindow = tSEGraphWindow;
        this.hashTable = new Hashtable(25);
        this.setDefaults();
    }

    public void setDefaults() {
        this.hashTable.put(UNDO_STACK_LIMIT, new TSProperty(UNDO_STACK_LIMIT, new Integer(this.getGraphWindow().getDefaultUndoLimit())));
        this.hashTable.put(ENABLE_TOOLTIPS, new TSProperty(ENABLE_TOOLTIPS, new Boolean(true)));
        this.hashTable.put("maximumZoomLevel", new TSProperty("maximumZoomLevel", new Double(50.0)));
        this.hashTable.put("minimumZoomLevel", new TSProperty("minimumZoomLevel", new Double(1.0E-4)));
        this.hashTable.put(AUTO_HIDE_SCROLLBARS, new TSProperty(AUTO_HIDE_SCROLLBARS, new Boolean(this.graphWindow.isAutoHidingScrollBarsByDefault())));
        this.hashTable.put(IN_PLACE_EDITING, new TSProperty(IN_PLACE_EDITING, new Boolean(this.graphWindow.isNestedGraphEditingEnabledByDefault())));
        this.hashTable.put(PARTIAL_SELECTION, new TSProperty(PARTIAL_SELECTION, new Boolean(true)));
        this.hashTable.put("hitTolerance", new TSProperty("hitTolerance", new Integer(2)));
        this.hashTable.put(HIT_TOLERANCE_THRESHOLD, new TSProperty(HIT_TOLERANCE_THRESHOLD, new Integer(10)));
        this.hashTable.put("drawInvisibleOnDragging", new TSProperty("drawInvisibleOnDragging", new Boolean(false)));
        this.hashTable.put(OPAQUE_MOVEMENT, new TSProperty(OPAQUE_MOVEMENT, new Boolean(true)));
        this.hashTable.put(INTERACTIVE_ZOOM_SENSITIVITY, new TSProperty(INTERACTIVE_ZOOM_SENSITIVITY, new Double(200.0)));
        this.hashTable.put(RECONNECT_EDGE_SENSITIVITY, new TSProperty(RECONNECT_EDGE_SENSITIVITY, new Double(2.0)));
        this.hashTable.put(PANNING_SENSITIVITY, new TSProperty(PANNING_SENSITIVITY, new Double(1.0)));
        this.hashTable.put(EDGE_NAVIGATION_TRIP_DURATION, new TSProperty(EDGE_NAVIGATION_TRIP_DURATION, new Integer(300)));
        this.hashTable.put(EDGE_NAVIGATION_BLINK_DURATION, new TSProperty(EDGE_NAVIGATION_BLINK_DURATION, new Integer(500)));
        this.hashTable.put(EDGE_NAVIGATION_FRAME_COUNT, new TSProperty(EDGE_NAVIGATION_FRAME_COUNT, new Integer(10)));
        this.hashTable.put(COMPRESS_META_EDGES, new TSProperty(COMPRESS_META_EDGES, new Boolean(true)));
        this.hashTable.put(GEOMETRIC_ADJUSTMENT, new TSProperty(GEOMETRIC_ADJUSTMENT, new Boolean(true)));
        this.hashTable.put(PREVENT_RESIZE_INVERSION, new TSProperty(PREVENT_RESIZE_INVERSION, new Boolean(false)));
        this.modifyDefaults();
    }

    protected void modifyDefaults() {
    }

    public void setValue(Object object, boolean bl) {
        this.setValue(object, new Boolean(bl));
    }

    public void setValue(Object object, int n) {
        this.setValue(object, new Integer(n));
    }

    public void setValue(Object object, double d) {
        this.setValue(object, new Double(d));
    }

    public void setValue(Object object, Object object2) {
        TSProperty tSProperty = (TSProperty)this.hashTable.get(object);
        if (tSProperty != null && !TSSystem.equals(object2, tSProperty.getValue())) {
            TSProperty tSProperty2 = new TSProperty(object.toString(), tSProperty.getValue());
            tSProperty.setValue(object2);
            this.getGraphWindow().onPreferenceChanged(tSProperty);
            this.getGraphWindow().getGraphManager().getEventManager().fireEvent(new TSEPreferenceChangeEvent(new TSEPreferenceChangeEventData(this, tSProperty2, tSProperty)));
        }
    }

    public void setValue(Object object, String string) {
        Object object2;
        TSProperty tSProperty = (TSProperty)this.hashTable.get(object);
        if (tSProperty != null && (object2 = tSProperty.getValue()) != null) {
            Object object3 = object2;
            try {
                if (object2 instanceof Integer) {
                    object3 = new Integer(Integer.parseInt(string));
                } else if (object2 instanceof Double) {
                    object3 = new Double(Double.parseDouble(string));
                } else if (object2 instanceof Boolean) {
                    object3 = Boolean.valueOf(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setValue(object, object3);
        }
    }

    public List getPreferenceList() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.hashTable.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            linkedList.add(this.hashTable.get(string));
        }
        return linkedList;
    }

    public Object getValue(Object object) {
        TSProperty tSProperty = (TSProperty)this.hashTable.get(object);
        Object object2 = null;
        if (tSProperty != null) {
            object2 = tSProperty.getValue();
        }
        return object2;
    }

    public int getIntValue(Object object) {
        return (Integer)this.getValue(object);
    }

    public double getDoubleValue(Object object) {
        return (Double)this.getValue(object);
    }

    public boolean getBooleanValue(Object object) {
        return (Boolean)this.getValue(object);
    }

    public TSEGraphWindow getGraphWindow() {
        return this.graphWindow;
    }

    public Object getParentEventSource() {
        return this.graphWindow;
    }
}

